

This may be useful for "micro-arch".




# file-tag.sh: print the tag of a project tree file
# 
################################################################
# Copyright (C) 2001, 2002 Tom Lord
# 
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.
# 

set -e 

################################################################
# special options
# 
# Some options are special:
# 
#       --version | -V
#       --help | -h
# 
if test $# -ne 0 ; then

  for opt in "$@" ; do
    case $opt in

      --version|-V) exec arch --version
                    ;;


      --help|-h)
                printf "print the tag of a project tree file\\n"
                printf "usage: file-tag [options] FILE ... \\n"
                printf "\\n"
                printf " -V --version                  print version info\\n"
                printf " -h --help                     display help\\n"
                printf "\\n"
                printf "Print the inventory tags of the indicated files.\\n"
                printf "\\n"
                exit 0
                ;;

      *)
                ;;
    esac
  done
fi

################################################################
# Ordinary Options
# 
# 

while test $# -ne 0 ; do

  case "$1" in 

    --)			shift
    			break
			;;
			
    -*)                 printf "file-tag: unrecognized option (%s)\\n" "$1" 1>&2
                        printf "try --help\\n" 1>&2
                        exit 1
                        ;;

    *)                  break
                        ;;
  esac

done



################################################################
# Ordinary Arguments
# 

if test $# -lt 1 ; then
  printf "usage: file-tag [options] file ...\\n" 1>&2
  printf "try --help\\n" 1>&2
  exit 1
fi

################################################################
# Sanity Check and Process Defaults
# 

method="`arch tagging-method`"

################################################################
# Process Arguments
# 

for file in "$@" ; do

  file="$1"
  shift

  case "$method" in

    names)	if test ! -e "$file" ; then
    		  printf "\\n" 1>&2
    		  printf "file-tag: file not found\\n" 1>&2
    		  printf "  file: %s\\n" "$file" 1>&2
    		  printf "\\n" 1>&2
		  exit 1
    		else
		  printf "?%s\\n" "$file"
		fi
    		;;

    explicit)	file-tag "$file" | awk '{ print $2 }'
    		;;

    implicit)	file-tag --implicit "$file" | awk '{ print $2 }'
    		;;

  esac

done


# tag: Tom Lord Sun Jan 20 01:52:52 2002 (inventory/file-tag.sh)
#
