
// some variable instances with default values 
// shared among different applications

#include "config.h"
#include "meta.h"
#include "acfg.h"

using namespace MYSTD;

namespace acfg {

#if defined(__CYGWIN32__) || defined(__CYGWIN__)
#warning FIXME: something is wrong with its regexp and the begining of the vfilepat pattern
#define VPATPREFIX "" 
#else
#define VPATPREFIX "(^|.*?/)"
#endif


// always the same
string cachedir("/var/tmp"), logdir("/var/tmp"), fifopath, pidfile, reportpage,
confdir, adminauth, bindaddr;

#define COMPRLIST "(gz|bz2|lzma|xz)"
#define COMPONENT_OPTIONAL "(-[a-z0-9-])"
#define PARANOIASOURCE "(\\.orig|\\.debian)"

string pfilepat(".*(\\.d?deb|\\.rpm|\\.dsc|\\.tar\\."COMPRLIST"(\\.gpg)?"
		"|\\.diff\\."COMPRLIST"|\\.jigdo|\\.template|changelog|copyright|"
		"\\.udeb|\\.diff/.*\\.gz|vmlinuz|initrd\\."COMPRLIST"|(Devel)?ReleaseAnnouncement(\\?.*)?"
")$");

string vfilepat( VPATPREFIX
		"(Index|Packages\\.bz2|Packages\\.gz|Packages|Release|Release\\.gpg|"
		"Sources\\.bz2|Sources\\.gz|Sources|release|index\\.db-.*\\.gz|Contents-[^/]*\\.gz|"
		"pkglist[^/]*\\.bz2|rclist[^/]*\\.bz2|/meta-release[^/]*|Translation[^/]*\\.bz2"
		"|((setup|setup-legacy)(\\.ini|\\.bz2)(\\.sig)?)"
		"|md5\\.sum|setup\\.hint|mirrors\\.lst"
		")$");

//string wfilepat( VPATPREFIX  "(Release|Release\\.gpg|release|meta-release|Translation[^/]*\\.bz2)$");
string wfilepat(vfilepat);

int offlinemode(false), verboselog(true), stupidfs(false), forcemanaged(false),
extreshhold(20), tpstandbymax(8), tpthreadmax(-1), dirperms(00755), fileperms(00664);

int dnscachetime(1800), dlbufsize(70000), exfailabort(1), exporigin(false), 
logxff(false), oldupdate(false), recompbz2(false), nettimeout(60), updinterval(0), forwardsoap(RESERVED_DEFVAL);

string agentname("Debian Apt-Cacher-NG/" ACVERSION);
string remoteport("80"), port("3142");
//string sUmask("0002");

#ifdef DEBUG
int debug(3), foreground(true);
//string cachedir("/var/cache/acng"), logdir("/var/log/acng"), fifopath, pidfile;
#else
int debug(0), foreground(false);
#endif

tHttpUrl proxy_info; // abuses path member for auth data

}
