
#ifndef __CONFIG_H_
#define __CONFIG_H_

#include "../acsyscap.h"

#define ACVERSION "0.5.1"

#define __STDC_FORMAT_MACROS
#include <inttypes.h>


// keep this consistently, for experiments with other STL implementations
#define MYSTD std
//#define MYSTD ustl
//#include <ustl.h>

#ifdef HAVE_TR1_MEMORY
#include <tr1/memory>
#define SMARTPTR_SPACE MYSTD::tr1
#elif defined HAVE_BOOST_SMARTPTR
#include <boost/smart_ptr.hpp>
#define SMARTPTR_SPACE boost
#else
#error Unable to find smart pointer implementation, install Boost or recent compiler and STL with TR1 features
#endif

#ifndef HAVE_ZLIB
#warning Zlib or its development files are not available. Install them (e.g. zlib1g-dev) and run "make clean". Gzip format support disabled.
#endif

#ifndef HAVE_LIBBZ2
#warning LibBz2 or its development files are not available. Install them (e.g. libbz2-dev) and run "make clean". Bzip2 format support disabled.
#endif

// make off_t be a 64 bit type
// added in Makefile... #define _FILE_OFFSET_BITS 64

#define SHARED_PTR SMARTPTR_SPACE::shared_ptr
#define INTRUSIVE_PTR SMARTPTR_SPACE::intrusive_ptr
#define WEAK_PTR SMARTPTR_SPACE::weak_ptr
#define SCOPED_PTR MYSTD::auto_ptr

#ifdef NO_EXCEPTIONS
#define MYTRY
#define MYCATCH(x) if(false)
#else
#define MYTRY try
#define MYCATCH catch
#endif


#define ENEMIESOFDOSFS "?[]\\=+<>:;#"

#endif // __CONFIG_H

