<?xml version="1.0" encoding="ISO-8859-1"?> <!-- -*- nxml -*- -->
<!--
 Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License as
 published by the Free Software Foundation; either version 2 of the
 License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful, but
 WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 02111-1307, USA.
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="text" encoding="ISO-8859-1"/>

<xsl:template name="replaceString">
  <xsl:param name="haystack"/>
  <xsl:param name="needle"/>
  <xsl:param name="replacement"/>
  <xsl:choose>
    <xsl:when test="contains($haystack, $needle)">
      <xsl:value-of select="substring-before($haystack, $needle)"/>
      <xsl:value-of select="$replacement"/>
      <xsl:call-template name="replaceString">
	<xsl:with-param name="haystack" 
			select="substring-after($haystack, $needle)"/>
	<xsl:with-param name="needle" select="$needle"/>
	<xsl:with-param name="replacement" select="$replacement"/>
      </xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="$haystack"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template name="processTags">
  <xsl:param name="tags"/>
  <xsl:if test="not($tags=string(''))">
    <xsl:choose>
      <xsl:when test="not(contains($tags, string('.')))">
	<xsl:choose>
	  <xsl:when test="$tags=string('*')">
	    <xsl:value-of select="string('{tags}*')"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:value-of select="string('&lt;')"/>
	    <xsl:value-of select="$tags"/>
	    <xsl:value-of select="string('&gt;')"/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:when>
      <xsl:when test="substring-before($tags, string('.'))=string('*')">
	<xsl:value-of select="string('{tags}*')"/>
	<xsl:call-template name="processTags">
	  <xsl:with-param name="tags" 
			  select="substring-after($tags, string('.'))"/>
	</xsl:call-template>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="string('&lt;')"/>
	<xsl:value-of select="substring-before($tags, string('.'))"/>
	<xsl:value-of select="string('&gt;')"/>
	<xsl:call-template name="processTags">
	  <xsl:with-param name="tags" 
			  select="substring-after($tags, string('.'))"/>
	</xsl:call-template>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:if>
</xsl:template>

<xsl:template name="macroSignature">
  <xsl:param name="nparams"/>
  <xsl:choose>
    <xsl:when test="$nparams=number(1)">
       <xsl:value-of select="string('int const p0')"/>
    </xsl:when>
    <xsl:when test="$nparams=number(0)"/>
    <xsl:otherwise>
       <xsl:call-template name="macroSignature">
         <xsl:with-param name="nparams" select="number($nparams)-number(1)"/>
       </xsl:call-template>
       <xsl:value-of select="string(', int const p')"/>
       <xsl:value-of select="number($nparams)-number(1)"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="call-macro">
  <xsl:value-of select="string('&#xA;&#xA;  transfer::macro::')"/>
  <xsl:value-of select="./@n"/>
  <xsl:value-of select="string('(')"/>
  <xsl:for-each select="./with-param">
    <xsl:value-of select="concat('p',(./@pos)-1)"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string(', ')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string(');&#xA;')"/>
</xsl:template>

<xsl:template match="and">
  <xsl:for-each select="./*">
    <xsl:value-of select="string('(')"/>
    <xsl:apply-templates select="."/>
    <xsl:value-of select="string(')')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string(' &amp;&amp; ')"/>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="or">
  <xsl:for-each select="./*">
    <xsl:value-of select="string('(')"/>
    <xsl:apply-templates select="."/>
    <xsl:value-of select="string(')')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string(' || ')"/>
    </xsl:if>
  </xsl:for-each>
</xsl:template>

<xsl:template match="not">
  <xsl:value-of select="string('!(')"/>
  <xsl:for-each select="./*">
    <xsl:apply-templates select="."/>
  </xsl:for-each>
  <xsl:value-of select="string(')')"/>
</xsl:template>

<xsl:template match="equal">
  <xsl:value-of select="string('transfer::equal(')"/>
  <xsl:for-each select="./*">
    <xsl:apply-templates select="."/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string(', ')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:if test="./@caseless=string('yes')">
    <xsl:value-of select="string(', true')"/>
  </xsl:if>
  <xsl:value-of select="string(')')"/>
</xsl:template>

<xsl:template match="in">
  <xsl:choose>
    <xsl:when test="./@caseless=string('yes')">
      <xsl:value-of select="string('transfer::')"/>
      <xsl:value-of select="./list/@n"/>
      <xsl:value-of select="string('.search(')"/>
      <xsl:apply-templates select="./*[position()=1]"/>
      <xsl:value-of select="string(', true)')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="string('transfer::')"/>
      <xsl:value-of select="./list/@n"/>
      <xsl:value-of select="string('.search(')"/>
      <xsl:apply-templates select="./*[position()=1]"/>
      <xsl:value-of select="string(')')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="clip">
  <xsl:value-of select="string('transfer::words[p')"/>
  <xsl:value-of select="(./@pos)-number('1')"/>
  <xsl:value-of select="string('].')"/>
  <xsl:choose>
    <xsl:when test="(./@side)=string('sl')">
      <xsl:value-of select="string('source(transfer::regex::')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="string('target(transfer::regex::')"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="./@part"/>
  <xsl:value-of select="string(')')"/>
</xsl:template>

<xsl:template match="lit">
  <xsl:value-of select="string('&quot;')"/>
  <xsl:value-of select="./@v"/>
  <xsl:value-of select="string('&quot;')"/>
</xsl:template>

<xsl:template match="lit-tag">
  <xsl:value-of select="string('&quot;&lt;')"/>
    <xsl:call-template name="replaceString">
      <xsl:with-param name="haystack" select="./@v"/>
      <xsl:with-param name="needle" select="string('.')"/>
      <xsl:with-param name="replacement" select="string('&gt;&lt;')"/>
    </xsl:call-template>
  <xsl:value-of select="string('&gt;&quot;')"/>
</xsl:template>

<xsl:template match="var">
  <xsl:value-of select="string('transfer::')"/>
  <xsl:value-of select="./@n"/>
</xsl:template>

<xsl:template match="let">
  <xsl:choose>
    <xsl:when test="name(./*[position()=1])=string('clip')">
      <xsl:for-each select="./*">
	<xsl:choose>
	  <xsl:when test="not(position()=last())">
	    <xsl:value-of select="string('transfer::words[p')"/>
	    <xsl:value-of select="(./@pos)-number('1')"/>
	    <xsl:value-of select="string('].set')"/>
	    <xsl:choose>
	      <xsl:when test="(./@side)=string('sl')">
		<xsl:value-of select="string('Source(transfer::regex::')"/>
	      </xsl:when>
	      <xsl:otherwise>
		<xsl:value-of select="string('Target(transfer::regex::')"/>
	      </xsl:otherwise>
	    </xsl:choose>
	    <xsl:value-of select="./@part"/>
	    <xsl:value-of select="string(', ')"/>
	  </xsl:when>
	  <xsl:otherwise>
	    <xsl:apply-templates select="."/>
	  </xsl:otherwise>
	</xsl:choose>
      </xsl:for-each>
      <xsl:value-of select="string(');')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:for-each select="./*">
	<xsl:apply-templates select="."/>
	<xsl:if test="not(position()=last())">
	  <xsl:value-of select="string(' = ')"/>
	</xsl:if>
      </xsl:for-each>
      <xsl:value-of select="string(';')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="test">
  <xsl:for-each select="./*">
    <xsl:apply-templates select="."/>
  </xsl:for-each>
</xsl:template>

<xsl:template match="get-case-from">
  <xsl:value-of select="string('transfer::copycase(transfer::words[p')"/>
  <xsl:value-of select="(./@pos)-1"/>
  <xsl:value-of select="string('].source(transfer::regex::lem), ')"/>
  <xsl:for-each select="./*">
    <xsl:if test="position()=last()">
      <xsl:apply-templates select="."/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string(')')"/>
</xsl:template>

<xsl:template match="b">
  <xsl:choose>
    <xsl:when test="not(count(./@*)=0)">
      <xsl:value-of select="string('transfer::blanks[p')"/>
      <xsl:value-of select="(./@pos)-1"/>
      <xsl:value-of select="string(']')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="string('&quot; &quot;')"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="mlu">
  {
    string buf = "";
    transfer::printOut("^");
  <xsl:for-each select="./*">
    <xsl:choose>
      <xsl:when test="name(.)=string('lu')">
	<xsl:for-each select="./*">     
    buf.append(<xsl:apply-templates select="."/>);</xsl:for-each>
        <xsl:if test="not(position()=1)">
    if(buf != "")
    {  
      transfer::printOut("+");
    }
	</xsl:if>
    transfer::printOut(buf);
    buf = "";
      </xsl:when>
      <xsl:otherwise>
	<xsl:for-each select="./*">
    transfer::printOut(<xsl:apply-templates select="."/>);</xsl:for-each>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
    transfer::printOut("$");
  }
</xsl:template>

<xsl:template match="lu">
  transfer::printOut("^");<xsl:for-each select="./*">
  transfer::printOut(<xsl:apply-templates select="."/>);</xsl:for-each>
  transfer::printOut("$");
</xsl:template>

<xsl:template match="out">
  <xsl:for-each select="./*">
    <xsl:choose>
      <xsl:when test="name(.)=string('b')">
        <xsl:choose>
          <xsl:when test="not(count(./@*)=0)">
  transfer::printOut(<xsl:apply-templates select="."/>);
          </xsl:when>
          <xsl:otherwise>
  transfer::printOut(" ");
          </xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>
        <xsl:apply-templates select="."/>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
</xsl:template>

<xsl:template match="case-of">
  <xsl:value-of select="string('transfer::caseOf(transfer::words[p')"/>
  <xsl:value-of select="(./@pos)-number('1')"/>
  <xsl:value-of select="string('].')"/>
  <xsl:choose>
    <xsl:when test="(./@side)=string('sl')">
      <xsl:value-of select="string('source(transfer::regex::')"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:value-of select="string('target(transfer::regex::')"/>
    </xsl:otherwise>
  </xsl:choose>
  <xsl:value-of select="./@part"/>
  <xsl:value-of select="string('))')"/>
</xsl:template>

<xsl:template match="modify-case">
  <xsl:choose>
    <xsl:when test="name(./*[position()=1])=string('clip')">
  transfer::words[p<xsl:value-of select="(./*[position()=1]/@pos)-number('1')"/>
      <xsl:value-of select="string('].')"/>
      <xsl:choose>
        <xsl:when test="(./@side)=string('sl')">
          <xsl:value-of select="string('setSource(transfer::regex::')"/>
        </xsl:when>
        <xsl:otherwise>
          <xsl:value-of select="string('setTarget(transfer::regex::')"/>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:value-of select="./*[position()=1]/@part"/>, transfer::copycase(<xsl:apply-templates select="./*[position()=2]"/>, <xsl:apply-templates select="./*[position()=1]"/>));
    </xsl:when>
    <xsl:otherwise>
  <xsl:apply-templates select="./*[position()=1]"/> = transfer::copycase(<xsl:apply-templates select="./*[position()=2]"/>, <xsl:apply-templates select="./*[position()=1]"/>);
    </xsl:otherwise>
  </xsl:choose>  
</xsl:template>

<xsl:template match="choose">
  <xsl:for-each select="./when">
    <xsl:choose>
      <xsl:when test="position()=1">
  if(<xsl:apply-templates select="./test"/>)
  {
  <xsl:for-each select="./*">
    <xsl:if test="not(name(.)=string('test'))">
      <xsl:apply-templates select="."/>
    </xsl:if>
  </xsl:for-each>
  }
      </xsl:when>
      <xsl:otherwise>
  else if(<xsl:apply-templates select="./test"/>)
  {
  <xsl:for-each select="./*">
    <xsl:if test="not(name(.)=string('test'))">
      <xsl:apply-templates select="."/>
    </xsl:if>
  </xsl:for-each>       
  }
      </xsl:otherwise>
    </xsl:choose>
  </xsl:for-each>
  <xsl:if test="not(string(./otherwise)=string(''))">
  else
  {
    <xsl:apply-templates select="./otherwise/*"/>
  }
  </xsl:if>
</xsl:template>

<xsl:template match="process">
  <xsl:apply-templates/>
</xsl:template>

<xsl:template match="transfer">
  <xsl:value-of select="string('blank&#x9;([ \n\t\r]|\[[^]]*\])*&#xA;')"/>
  <xsl:value-of select="string('unknown&#x9;&quot;^*&quot;[^$]+&quot;$&quot;&#xA;')"/>
  <xsl:value-of select="string('tags&#x9;(&lt;[a-zA-Z0-9]+&gt;)&#xA;')"/>
  <xsl:value-of select="string('stem&#x9;([^\x0-\x1f\x7f-\xa0$&lt;&gt;]|&quot;\\&lt;&quot;|&quot;\\&gt;&quot;|&quot;\\$&quot;)&#xA;')"/>
  <xsl:value-of select="string('notdollar&#x9;([^\x0-\x1f\x24\x3d\x7b\x7c\x7d\x7f-\xa0\xa4\xa6-\xa9\xac-\xb6\xb8-\xbe\xd7\xf7])&#xA;')"/> 
<!--  <xsl:value-of select="string('notdollar&#x9;[^$]&#xA;')"/> -->
  <xsl:for-each select="./section-def-cats/def-cat">
  <xsl:value-of select="./@n"/><xsl:value-of select="string('&#x9;\^(')"/>
  <xsl:for-each select="./cat-item">
    <xsl:choose>
      <xsl:when test="count(./@lemma)=1">
	<xsl:value-of select="string('&quot;')"/>
	<xsl:value-of select="./@lemma"/>
	<xsl:value-of select="string('&quot;')"/>
      </xsl:when>
      <xsl:otherwise>
	<xsl:value-of select="string('{stem}+')"/>
      </xsl:otherwise>
    </xsl:choose>
    <xsl:if test="count(./@tags)=1">
      <xsl:call-template name="processTags">
	<xsl:with-param name="tags" select="./@tags"/>
      </xsl:call-template>
    </xsl:if>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('|')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string(')\$&#xA;')"/> 
  </xsl:for-each>
  <xsl:value-of select="string('lema&#x9;\^{stem}+{tags}+\$')"/>
  
%{

#include &lt;cstdio&gt;
#include &lt;cstdlib&gt;
#include &lt;cstring&gt;
#include &lt;iostream&gt;
#include &lt;libgen.h&gt;
#include &lt;map&gt;
#include &lt;string&gt;
#include &lt;sys/types.h&gt;
#include &lt;unistd.h&gt;
#include &lt;vector&gt;

#include &lt;lttoolbox/FSTProcessor.H&gt;
#include &lt;lttoolbox/Locale.H&gt;
#include &lt;apertium/TransferWord.H&gt;
#include &lt;apertium/TransferWordList.H&gt;

using namespace std;

namespace transfer  
{<xsl:for-each select="./section-def-vars/def-var">
string <xsl:value-of select="./@n"/>;</xsl:for-each>

vector&lt;TransferWord&gt; words;
vector&lt;string&gt; blanks;
FSTProcessor fstp;

namespace regex
{
  static char const *lem = "(([^&lt;]|\"\\&lt;\")+)";
  static char const *lemq = "(#[ _][^&lt;]+)";
  static char const *lemh = "(([^&lt;#]|\"\\&lt;\"|\"\\#\")+)";
  static char const *whole = ".+";<xsl:for-each select="./section-def-attrs/def-attr">
  static char const *<xsl:value-of select="./@n"/> = "(<xsl:for-each select="./attr-item">
  <xsl:value-of select="string('&lt;')"/>
  <xsl:call-template name="replaceString">
    <xsl:with-param name="haystack" select="./@tags"/>
    <xsl:with-param name="needle" select="string('.')"/>
    <xsl:with-param name="replacement" select="string('&gt;&lt;')"/>
  </xsl:call-template>
  <xsl:value-of select="string('&gt;')"/>
  <xsl:if test="not(position()=last())">
    <xsl:value-of select="string('|')"/>
  </xsl:if>
</xsl:for-each>)";</xsl:for-each>

 
}
<xsl:for-each select="./section-def-lists/def-list">
  TransferWordList <xsl:value-of select="./@n"/>;
</xsl:for-each>

void init_wordlists()
{
<xsl:for-each select="./section-def-lists/def-list">
  <xsl:for-each select="./list-item">
  <xsl:value-of select="../@n"/>.addWord("<xsl:value-of select="./@v"/>");
</xsl:for-each>
</xsl:for-each>
}

string caseOf(string const &amp;input)
{
  if(input.size() &gt; 1)
  {
    if(!isupper(input[0]))
    {
      return "aa";
    }
    else if(!isupper(input[input.size()-1]))
    {
      return "Aa";
    }
    else
    {
      return "AA";
    }
  }
  else if(input.size() == 1)
  {
    if(!isupper(input[0]))
    {
      return "aa";
    }
    else
    {
      return "Aa";
    }
  }
  else
  {
    return "aa";
  }
}

bool
equal(string const &amp;str1, string const &amp;str2, bool caseless = false)
{
  if(!caseless)
  {
    return str1 == str2;
  }
  else
  {
    return !strcasecmp(str1.c_str(), str2.c_str());
  }
}

string
copycase(string const &amp;source_word, string const &amp;target_word)
{
  string result = target_word;

  bool firstupper = isupper(source_word[0]);
  bool uppercase = firstupper &amp;&amp; isupper(source_word[source_word.size()-1]);
  bool sizeone = source_word.size() == 1;


  if(!uppercase || (sizeone &amp;&amp; uppercase))
  {
    for(unsigned int i = 0; i &lt; target_word.size(); i++)
    {
      result[i] = tolower(target_word[i]);
    }
  }
  else
  {
    for(unsigned int i = 0; i &lt; target_word.size(); i++)
    {
      result[i] = toupper(target_word[i]);
    }
  }
  
  if(firstupper)
  {
    result[0] = toupper(result[0]);
  }
   
  return result;
}

void getWordsAndBlanks(string const &amp;input)
{
  unsigned int current = 0;
  words.clear();
  blanks.clear();  

  // search for $
  while(true)
  {
    if(input[current] == '\\')
    {
      current++;
    }
    else if(input[current] == '$')
    {
      break;
    }
    current++;
  }

  TransferWord w(input.substr(1, current-1), 
          fstp.biltrans(input.substr(1, current-1), false));
  words.push_back(w);

  current++;
  while(current &lt; input.size())
  {
    string b ="";

    // search for '^'
    while(true)
    {
      if(input[current] == '\\')
      {
        b += input[current];
        current++;
      }
      else if(input[current] == '^')
      {
        blanks.push_back(b);
        break;
      }  
      b += input[current];  
      current++;
    }

    unsigned int beg = current;
     
    // search for '$'
    while(true)
    {
      if(input[current] == '\\')
      {
        current++;
      }
      else if(input[current] == '$')
      {
        break;
      }
      current++;
    }

    // store word
    TransferWord w(input.substr(beg+1, current-beg-1), 
            fstp.biltrans(input.substr(beg+1, current-beg-1), false));
    words.push_back(w);
    current++;
  }
}

void printOut(string const &amp;str)
{
  fputs_unlocked(str.c_str(), yyout);
}  

namespace macro
{
<xsl:for-each select="./section-def-macros/def-macro">
void <xsl:value-of select="./@n"/>(<xsl:call-template name="macroSignature">
  <xsl:with-param name="nparams" select="./@npar"/>
</xsl:call-template>)
{
  <xsl:for-each select="./*">
    <xsl:apply-templates select="."/>
  </xsl:for-each>
}
</xsl:for-each>
}
}
%}

%option caseless
%option nounput
%option noyywrap
%%
<xsl:for-each select="./section-rules/rule">
  <xsl:for-each select="./pattern/pattern-item">
    <xsl:value-of select="string('{')"/>
    <xsl:value-of select="./@n"/>
    <xsl:value-of select="string('}')"/>
    <xsl:if test="not(position()=last())">
      <xsl:value-of select="string('{blank}')"/>
    </xsl:if>
  </xsl:for-each>
  <xsl:value-of select="string('&#x9;{')"/>
  // variable declaration
  <xsl:for-each select="./pattern/pattern-item">int const p<xsl:value-of select="position()-1"/> = <xsl:value-of select="position()-1"/>;
  </xsl:for-each>
  // separate words and blanks
  transfer::getWordsAndBlanks(yytext);  
  <xsl:apply-templates select="./action/*"/>
}
</xsl:for-each>
{lema}&#x9;{
  string trad = transfer::fstp.biltrans(yytext);
  if(trad != "^$")
  {
    transfer::printOut(trad);
  }
}
{blank}&#x9;{
  transfer::printOut(yytext);
}
%%

void error(char *progname)
{
  cout &lt;&lt; "USAGE: " &lt;&lt; basename(progname) &lt;&lt; " transducer_file [input_file [output_file]" &lt;&lt; ']' &lt;&lt; endl;
  exit(EXIT_FAILURE);
}

int main(int argc, char *argv[])
{
  Locale::tryToSetLocale();
  transfer::init_wordlists();

  if(argc > 2)
  {
    error(argv[0]);
  }  

  FILE *transducer = fopen(argv[1], "r");  
  if(!transducer)
  {
    error(argv[0]); 
  }
  transfer::fstp.load(transducer);
  fclose(transducer);
  transfer::fstp.initBiltrans();

  if(argc == 2)
  {
    yyin = stdin;
    yyout = stdout;
  }
  else if (argc == 3)
  {
    yyin = fopen(argv[1], "r");
    if(!yyin)
    {
      error(argv[0]);
    }
    yyout = stdout;
  }
  else
  {
    yyin = fopen(argv[1], "r");
    yyout = fopen(argv[2], "w");
    if(!yyin || !yyout)
    {
      error(argv[0]); 
    }
  }

  yylex();

  fclose(yyin);
  fclose(yyout);

  return EXIT_SUCCESS;
}

</xsl:template>

</xsl:stylesheet>
