/*
 * Copyright (C) 2005 Universitat d'Alacant / Universidad de Alicante
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#ifndef _LEXWRAPPER_
#define _LEXWRAPPER_

#include <cstdio>

using namespace std;

struct yy_buffer_state;

typedef int (*likeyylex)();
typedef void (*likeyyflush)(yy_buffer_state *);
typedef yy_buffer_state * (*likeyycreate)(FILE *, int); 

class LexWrapper
{
private:
  static FILE **input;
  static FILE **output;
  static likeyylex my_nt;
  static char **my_t;
  static likeyyflush my_flusher; 
  static likeyycreate my_create_buffer;
  static likeyyflush my_switcher; 
  static likeyyflush my_destroyer; 
  static int my_buf_size;

  yy_buffer_state * mybuffer;
  FILE * myinput;
  FILE * myoutput;

  void destroy();
  
public:
  LexWrapper(FILE *input, FILE *output);
  ~LexWrapper();
  static void initClass(FILE **yyinptr, FILE **yyoutptr, 
			likeyylex nt, char **t, likeyyflush flusher, 
			likeyycreate create_buffer, likeyyflush switcher, 
			likeyyflush destroyer, int buf_size);                      
  void flush();
  int yylex();
  char * yytext();
};

#endif
