Feature: W0109

  W0703 detects that a function-call is performed before declaring the target
  function.

  Scenario: calling function is not declared
    Given a target source named "W0109.c" with:
      """
      int main(void)
      {
          return foo(); /* W0109 */
      }
      """
    When I successfully run `adlint W0109.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W0109 | 3    | 15     |

  Scenario: calling function is forward declared
    Given a target source named "W0109.c" with:
      """
      extern int foo(void);

      int main(void)
      {
          return foo(); /* OK */
      }
      """
    When I successfully run `adlint W0109.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W0118 | 1    | 12     |

  Scenario: calling function is backward declared
    Given a target source named "W0109.c" with:
      """
      int main(void)
      {
          return foo(); /* W0109 */
      }

      extern int foo(void);
      """
    When I successfully run `adlint W0109.c` on noarch
    Then the output should exactly match with:
      | mesg  | line | column |
      | W0109 | 3    | 15     |
      | W0118 | 6    | 12     |

# vim:ts=2:sw=2:sts=2:et:
