/***************************************************************************/
/* 		This code is part of Nscache - viewer of Netscape(tm)	   */
/*		browsers disc cache					   */
/*		Copyright (c) 1999,2000 Ondrejicka Stefan		   */
/*		(ondrej@idata.sk)					   */
/*		Distributed under GPL 2 or later			   */
/***************************************************************************/

#ifndef _indexdb_h_
#define _indexdb_h_

#ifdef HAVE_DB185_H
#include <db_185.h>
#else
#ifdef HAVE_DB1_H
#include <db1/db.h>
#else
#include <db.h>
#endif
#endif

#include <gtk/gtk.h>

typedef unsigned char	bool;
typedef gint32		int32;
typedef guint32		uint32;

typedef struct {
	int32		size;
	int32		version;
	time_t		last_modified;
	time_t		last_accessed;
	time_t		expires;
	uint32		content_length;
	bool		is_netsite;
	time_t		lock_date;
	char 		*filename;
	int32		filename_len;
	bool		is_relative_path;
	int32		security_on;
	unsigned char	*sec_info;
	int32		method;
	char		*address;
	uint32		post_data_size;
	char		*post_data;
	char		*post_headers;
	char		*content_type;
	char		*content_encoding;
	char		*charset;
	bool		incomplete_file;
	uint32		total_content_length;
	char		*page_services_url;
	char		*etag;
	char		*urlstr;
	guint		list_row;
	GtkCTreeNode	*tree_node;
} ns_cache_record;

extern void ns_cache_gen_key(DBT *, char *);
extern ns_cache_record *ns_cache_dbt_to_record(DBT *);
extern int ns_cache_open_db(char *);
extern void ns_cache_close_db();
extern GSList *ns_cache_read_db();
extern void ns_cache_free_record(ns_cache_record *);
extern char *ns_cache_get_db_name();
extern int ns_cache_del_rec(char *);
extern void ns_cache_dump(int);

#endif
