/* GSnes9x -- util.h
 * Copyright (C) 1999 Canek Pelez Valds <canek@abulafia.fciencias.unam.mx>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef GSNES9X_UTIL_H
#define GSNES9X_UTIL_H

void         rom_get_defaults            (ROMInfo *rom, GlobalPrefs *prefs);

GSnes9xData* gsnes9x_data_new            ();
GList*       get_roms_list               ();
gchar**      get_command_line            (ROMInfo *rom_info, GlobalPrefs *prefs);
GList*       get_codes_for_rom           (const gchar* name, GSnes9xCheatCodes cc);
gchar*       get_default_roms_dir        ();
gchar*       get_default_snap_dir        (); 
gboolean     check_rom_info              (GtkWidget **entry);

#endif

/* util.h ends here. */
