 /************************************************************************/
 /*                                                                      */
 /*                Centre for Speech Technology Research                 */
 /*                     University of Edinburgh, UK                      */
 /*                       Copyright (c) 1996,1997                        */
 /*                        All Rights Reserved.                          */
 /*                                                                      */
 /*  Permission to use, copy, modify, distribute this software and its   */
 /*  documentation for research, educational and individual use only, is */
 /*  hereby granted without fee, subject to the following conditions:    */
 /*   1. The code must retain the above copyright notice, this list of   */
 /*      conditions and the following disclaimer.                        */
 /*   2. Any modifications must be clearly marked as such.               */
 /*   3. Original authors' names are not deleted.                        */
 /*  This software may not be used for commercial purposes without       */
 /*  specific prior written permission from the authors.                 */
 /*                                                                      */
 /*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK       */
 /*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING     */
 /*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT  */
 /*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE    */
 /*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES   */
 /*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN  */
 /*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,         */
 /*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF      */
 /*  THIS SOFTWARE.                                                      */
 /*                                                                      */
 /************************************************************************/
 /*                 Author: Richard Caley (rjc@cstr.ed.ac.uk)            */
 /*                   Date: Tue May 27 1997                              */
 /************************************************************************/
 /*                                                                      */
 /* Definitions of the contour types.                                    */
 /*                                                                      */
 /************************************************************************/

#include "EST_TNamedEnum.h"
#include "EST_ContourType.h"

typedef struct Info {
  const char *description;
} Info;

static EST_TValuedEnumDefinition<EST_ContourType, const char *,Info> definition[] =

{
  {ct_illegal,		{"illegal"},
		{"illegal contour type"}},
  {ct_f0,		{"f0", "F0"},		
		{ "fundamental frequency" }},
  {ct_diff_f0,		{"diff_f0",},
		{ "derivative of fundamental frequency" }},
  {ct_lpc,		{"lpc",},
		{ "lpc coefficients" }},
  {ct_reflection,	{"rfc","rfl","reflection"},
		{ "reflection coefficients" }},
  {ct_lsf,		{"lsf",},
		{ "line spectral frequencies" }},
  {ct_cepstrum,		{"cepstrum","cep"},
		{ "cepstral coefficients" }},
  {ct_area,		{"area",},
		{ "true area" }},
  {ct_logarea,		{"logarea",},
		{ "log area" }},
  {ct_power,		{"power",},
		{ "power" }},
  {ct_energy,		{"energy",},
		{ "energy" }},
  {ct_difference,	{"difference",},
		{ "difference" }},
  {ct_pitchmarks,	{"pitchmarks","pm", "pms"},
		{ "pitchmarks" }},
  {ct_other,		{"unknown", "other"},
		{ "unknown contour type" }},
  {ct_illegal,		{NULL}},
  };

static  EST_TNamedEnumI<EST_ContourType,  Info> map(definition);

EST_ContourType EST_Contour::type(const char *name)
{
  return map.token(name);
}

EST_String EST_Contour::name(EST_ContourType type)
{
  return map.name(type);
}

EST_String EST_Contour::description(EST_ContourType type)
{
  return map.info(type).description;
}

EST_String EST_Contour::options_supported(void)
{
  EST_String s("Available contour types:\n");

  for(int n=0; n< map.n() ; n++)
    {
      const char *nm = map.name(map.token(n));
      const char *d = map.info(map.token(n)).description;

      s += EST_String::cat("        ", nm, EST_String(" ")*(12-strlen(nm)), d, "\n");
    }
  return s;
}

EST_String EST_Contour::options_short(void)
{
  EST_String s("");

  for(int n=0; n< map.n() ; n++)
    {
      const char *nm = map.name(map.token(n));

      if (s != "")
	s += ", ";

      s += nm;

    }
  return s;
}



#if defined(INSTANTIATE_TEMPLATES)

#include "../base_class/EST_TNamedEnum.cc"

template class EST_TValuedEnumDefinition<EST_ContourType, const char *,Info>;
// template class EST_TNamedEnum<EST_ContourType>;
template class EST_TNamedEnumI<EST_ContourType, Info>;
// template class EST_TValuedEnum<EST_ContourType, const char *>;
template class EST_TValuedEnumI<EST_ContourType, const char *, Info>;


#endif
