/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                      Copyright (c) 1995,1996                          */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*                   Author :  Alan W Black                              */
/*                   Date   :  May 1998                                  */
/*-----------------------------------------------------------------------*/
/*  Content part of a linguistic item, normall only referenced from      */
/*  EST_Item                                                        */
/*                                                                       */
/*=======================================================================*/
#include <stdlib.h>
#include <stdio.h>
#include <fstream.h>
#include "ling_class/EST_Item_Content.h"
#include "ling_class/EST_Item.h"

void EST_Item_Content::copy(const EST_Item_Content &x)
{
    f = x.f;
    // don't copy the relations as they have relation dependencies
}

EST_Item_Content::~EST_Item_Content()
{
    if (relations.length() != 0)
    {   // Shouldn't get here,  but just in case.
	cerr << "EST_Contents: contents still referenced by Relations" << endl;
    }
}

int EST_Item_Content::unref_relation(const EST_String &relname)
{
    // Unreference this item from this relation.  Returns TRUE
    // if no one else is relferencing it, FALSE otherwise
    if (this != 0)
    {
	if (relations.present(relname))
	    relations.remove_item(relname);
	else
	    printf("failed to find %s in %s at %g\n",
		   (const char *)relname,
		   (const char *)name(),
		   f.F("end"));
	if (relations.length() == 0)
	    return TRUE;
    }
    return FALSE;
}

int EST_Item_Content::unref_and_delete()
{
    // Unreference from all relations and delete
    EST_Litem *p,*np;

    for (p=relations.list.head(); p; p=np)
    {
	np = next(p);
	delete relations.list(p).v;
    }
    // When the last relation is deleted this contents itself will be
    // delete too, from underneath us.
    return 0;
}

EST_Item *EST_Item_Content::Relation(const char *name)
{
    // Because so many access are from char* literals we all access
    // directly rather than requiring the creation of an EST_String
    EST_Litem *p;

    for (p=relations.list.head(); p; p=next(p))
    {
	if (relations.list(p).k == name)
	    return relations.list(p).v;
    }
    return 0;
}

EST_Item_Content &EST_Item_Content::operator=(const EST_Item_Content &x)
{
    copy(x);
    return *this;
}

ostream& operator << (ostream &s, const EST_Item_Content &a)
{
    s << a.name() << " ; ";
    s << a.f;
    s << "Relations";
    for (EST_Litem *p = a.relations.list.head(); p; p=next(p))
	s << " " << a.relations.list(p).k;
    s << endl;
    return s;
}

    


