/*************************************************************************/
/*                                                                       */
/*                Centre for Speech Technology Research                  */
/*                     University of Edinburgh, UK                       */
/*                         Copyright (c) 1996                            */
/*                        All Rights Reserved.                           */
/*                                                                       */
/*  Permission to use, copy, modify, distribute this software and its    */
/*  documentation for research, educational and individual use only, is  */
/*  hereby granted without fee, subject to the following conditions:     */
/*   1. The code must retain the above copyright notice, this list of    */
/*      conditions and the following disclaimer.                         */
/*   2. Any modifications must be clearly marked as such.                */
/*   3. Original authors' names are not deleted.                         */
/*  This software may not be used for commercial purposes without        */
/*  specific prior written permission from the authors.                  */
/*                                                                       */
/*  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        */
/*  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      */
/*  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   */
/*  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     */
/*  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    */
/*  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   */
/*  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          */
/*  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       */
/*  THIS SOFTWARE.                                                       */
/*                                                                       */
/*************************************************************************/
/*    Authors:  Paul Taylor, Simon King, Alan Black, Richard Caley       */
/*                Date   :  June 1994-March 1997                         */
/*-----------------------------------------------------------------------*/
/*           Edinburgh Speech Tools General Header File                  */
/*                                                                       */
/*=======================================================================*/
#ifndef __EST_H__
#define __EST_H__

// Standard include files.
#include "EST_system.h"
#include <stdlib.h>

#include "EST_String.h"
#include "EST_string_aux.h"
#include "EST_types.h"

// Utilities
#include "EST_util_class.h"

#include "EST_cutils.h"
#include "EST_io_aux.h"

// Audio
#include "EST_play_audio.h"

// Speech Classes
#include "EST_speech_class.h"

// Linguistic Classes
#include "EST_ling_class.h"

// Signal Processing
#include "EST_sigpr.h"

// Grammar
#include "EST_grammar.h"

// Stats
#include "EST_stats.h"

// Stats
#include "EST_asr.h"

#endif /* __EST_H__ */
