 ###########################################################################
 ##                                                                       ##
 ##                Centre for Speech Technology Research                  ##
 ##                     University of Edinburgh, UK                       ##
 ##                         Copyright (c) 1996                            ##
 ##                        All Rights Reserved.                           ##
 ##                                                                       ##
 ##  Permission to use, copy, modify, distribute this software and its    ##
 ##  documentation for research, educational and individual use only, is  ##
 ##  hereby granted without fee, subject to the following conditions:     ##
 ##   1. The code must retain the above copyright notice, this list of    ##
 ##      conditions and the following disclaimer.                         ##
 ##   2. Any modifications must be clearly marked as such.                ##
 ##   3. Original authors' names are not deleted.                         ##
 ##  This software may not be used for commercial purposes without        ##
 ##  specific prior written permission from the authors.                  ##
 ##                                                                       ##
 ##  THE UNIVERSITY OF EDINBURGH AND THE CONTRIBUTORS TO THIS WORK        ##
 ##  DISCLAIM ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING      ##
 ##  ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT   ##
 ##  SHALL THE UNIVERSITY OF EDINBURGH NOR THE CONTRIBUTORS BE LIABLE     ##
 ##  FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES    ##
 ##  WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN   ##
 ##  AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,          ##
 ##  ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF       ##
 ##  THIS SOFTWARE.                                                       ##
 ##                                                                       ##
 ###########################################################################
 ##                                                                       ##
 ##                 Author: Richard Caley (rjc@cstr.ed.ac.uk)             ##
 ##                   Date: Wed Oct  1 1997                               ##
 ## --------------------------------------------------------------------  ##
 ##                                                                       ##
 ## Extend the compiler options depending on the behaviour requested.     ##
 ##                                                                       ##
 ###########################################################################

###########################################################################
## Look for directory specific options


DIRNAME_AS_FILE := $(subst /,_,$(DIRNAME))

ifneq ($(origin OPTIMISE_$(DIRNAME_AS_FILE)),undefined)
	OPTIMISE := $(OPTIMISE_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin WARN_$(DIRNAME_AS_FILE)),undefined)
	WARN := $(WARN_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin VERBOSE_$(DIRNAME_AS_FILE)),undefined)
	VERBOSE := $(VERBOSE_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin DEBUG_$(DIRNAME_AS_FILE)),undefined)
	DEBUG := $(DEBUG_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin PROFILE_$(DIRNAME_AS_FILE)),undefined)
	PROFILE := $(PROFILE_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin SHARED_$(DIRNAME_AS_FILE)),undefined)
	SHARED := $(SHARED_$(DIRNAME_AS_FILE))
endif

ifneq ($(origin STATIC_$(DIRNAME_AS_FILE)),undefined)
	STATIC := $(STATIC_$(DIRNAME_AS_FILE))
endif

###########################################################################
## Now set the compile options as requested

ifdef DEBUG
ifneq ($(DEBUG),0)
ifneq ($(OPTIMISE),4)
    CFLAGS    += $(DEBUG_CCFLAGS)
    CXXFLAGS  += $(DEBUG_CXXFLAGS)
    JAVAFLAGS += $(DEBUG_JAVAFLAGS)
    JAVAC      = $(DEBUG_JAVAC)
    JAVAH      = $(DEBUG_JAVAH)
    LINKFLAGS += $(DEBUG_LINKFLAGS)
endif
endif
endif

ifdef PROFILE
ifneq ($(PROFILE),0)
ifndef PROFILE_$(PROFILE)_CCFLAGS
    PROFILE := $(PROFILE_DEFAULT)
endif
    CFLAGS    += $(PROFILE_$(PROFILE)_CCFLAGS)
    CXXFLAGS  += $(PROFILE_$(PROFILE)_CXXFLAGS)
    LINKFLAGS += $(PROFILE_$(PROFILE)_LINKFLAGS)
endif
endif

ifdef OPTIMISE
ifneq ($(OPTIMISE),0)
    CFLAGS    += $(OPTIMISE_CCFLAGS)
    CXXFLAGS  += $(OPTIMISE_CXXFLAGS)
    JAVAFLAGS += $(OPTIMISE_JAVAFLAGS)
    LINKFLAGS += $(OPTIMISE_LINKFLAGS)
endif
endif

ifdef SHARED
ifneq ($(SHARED),0)
    CFLAGS    += $(SHARED_CCFLAGS)
    CXXFLAGS  += $(SHARED_CXXFLAGS)
    LINKFLAGS += $(SHARED_LINKFLAGS)
endif
endif

ifdef WARN
ifneq ($(WARN),0)
    CFLAGS    += $(WARN_CCFLAGS)
    CXXFLAGS  += $(WARN_CXXFLAGS)
    JAVAFLAGS += $(WARN_JAVAFLAGS)
    LINKFLAGS += $(WARN_LINKFLAGS)
endif
endif

ifdef VERBOSE
ifneq ($(VERBOSE),0)
    CFLAGS    += $(VERBOSE_CCFLAGS)
    CXXFLAGS  += $(VERBOSE_CXXFLAGS)
    JAVAFLAGS += $(VERBOSE_JAVAFLAGS)
    LINKFLAGS += $(VERBOSE_LINKFLAGS)
endif
endif

ifdef STATIC
ifneq ($(STATIC),0)
    CFLAGS    += $(STATIC_CCFLAGS)
    CXXFLAGS  += $(STATIC_CXXFLAGS)
    LINKFLAGS += $(STATIC_LINKFLAGS)
endif
endif

