/*
 File handling for reading and writing MP3-TAG, a format by Damaged 
 Cybernetics.
 * 
 Source by Thorvald Natvig
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "mp3info.h"
#include <unistd.h>

/* This one includes the table of the genres. Autogenerated */
#include "genre.h"

void safecopy(char *to,char *from, int maxlen) {
   int where;
   strncpy(to,from,maxlen);
   to[maxlen]=0;
   for ( where=maxlen-1 ; ((where>=0) && (to[where]==' ')) ; where-- ) {
      to[where]=0 ;
   }
}

void spacecopy(char *to,char *from, int maxlen) {
   int where;
   strncpy(to,from,maxlen);
   for ( where=maxlen-1 ; ((where>=0) && (to[where]==0)) ; where--) {
      to[where]=' ';
   }
}

bool Tag::wipe(FILE *file, size_t filesize) {
   int temp;
   char buffer[4];
   fseek(file,-128,SEEK_END);
   temp=fread(&buffer,3,1,file);
   if (! strncmp(buffer,"TAG",3)) {
      fseek(file,0,SEEK_SET);
      if(ftruncate(fileno(file),filesize-128)==0)
	return(1);
      else return(0);
   } else {
      return(1);
   }
}

bool Tag::get(FILE *file) {
   int temp;
   tag song;
   fseek(file, -128, SEEK_END) ;
   temp=fread(&song, 128,1,file);
   
   if (! strncmp(song.tag,"TAG",3)) {
      safecopy(title,song.title,30);
      safecopy(artist,song.artist,30);
      safecopy(album,song.album,30);
      safecopy(year,song.year,4);
      safecopy(comment,song.comment,30);
      gennum= song.genre & 0xFF;
      if ((gennum<0) || (gennum >= GENRE_LARGEST)) {
	 gennum = GENRE_LARGEST;
      }
      strcpy(genre,genres[gennum]);
      return(1);
   } else {
      return(0);
   }
}

Tag::Tag() {
  title[0]=0;
  artist[0]=0;
  album[0]=0;
  year[0]=0;
  comment[0]=0;
  genre[0]=0;
  gennum=-1;
}

void Tag::copy(Tag *from) {
   if (from->title[0]) strncpy(title,from->title,30);
   if (from->artist[0]) strncpy(artist,from->artist,30);
   if (from->album[0]) strncpy(album,from->album,30);
   if (from->year[0]) strncpy(year,from->year,4);
   if (from->comment[0]) strncpy(comment,from->comment,30);
   if (from->gennum != -1 ) gennum=from->gennum;
   if ((gennum<0) || (gennum >= GENRE_LARGEST)) {
      gennum=0;
   }
   strcpy(genre,genres[gennum]);
}

bool Tag::set(FILE *file) {
   size_t temp;
   tag song;
   
   spacecopy(song.title,title,30);
   spacecopy(song.artist,artist,30);
   spacecopy(song.album,album,30);
   spacecopy(song.year,year,4);
   spacecopy(song.comment,comment,30);
   
   if (gennum >= GENRE_LARGEST) {
      song.genre=0;
   } else {
      temp=gennum;
      song.genre=(unsigned char)temp;
   }
   
   fseek(file, -128, SEEK_END) ;
   temp=fread(&song,3,1,file) ;
   if (! strncmp(song.tag,"TAG",3)) {
      fseek(file, -128, SEEK_END) ;
   } else {
      fseek(file, 0 , SEEK_END) ;
   }

   strncpy(song.tag,"TAG",3);
   temp=fwrite(&song,128,1,file);
   if (temp==1) {
      return (true) ;
   } else {
      return (false) ;
   }
}

void Tag::printgenres(int format) {
  int i;
  int c=0;
  if (format==0) {
    for (i=0; i<=GENRE_LARGEST;i++) {
      printf("%2i %-20s",i,genres[i]);
      c=(c+1)%3;
      if (c==0) printf("\n");
    }
    if (c!=0) printf("\n");
  } else if (format==1) {
    for (i=0; i<=GENRE_LARGEST;i++) {
      printf("%2i %s\n",i,genres[i]);
    }
  } else if (format>0) {
    for (i=0; i<=GENRE_LARGEST;i++) {
      printf("%s\n",genres[i]);
    }
  } else {
    c=-(format+1);
    for (i=0; i<GENRE_LARGEST;i++) {
      printf(" \"%i\" \"%s\" \"%s\"",i,genres[i],(i==c) ? "On" : "Off");
    }
  }
}
