/* ***************************************************************** */
/* ******** Program to import pvoc files from tabular format. ****** */
/* ***************************************************************** */

/* ***************************************************************** */
/* John ffitch 1995 Jun 17                                           */
/* ***************************************************************** */
     
#include <stdio.h>
#include <stdlib.h>
#include "pvoc.h"

void usage(int);
float getnum(FILE*, char *);

int main(int argc, char **argv)
{
    PVSTRUCT pv;
    FILE *inf;
    FILE *outf;
    int i;
    float *data;

    if (argc!= 3)
	usage(argc);
    inf = fopen(argv[1], "rb");
    if (inf == NULL) {
	fprintf(stderr, "Cannot open input file %s\n", argv[1]);
	exit(1);
    }
    outf = fopen(argv[2], "w");
    if (inf == NULL) {
	fprintf(stderr, "Cannot open output file %s\n", argv[2]);
	exit(1);
    }
    fscanf(inf, "ByteOffset,DataSize,dFormat,Rate,Channels,FrameSize,FrameInc,BSize,frameFormat,MinFreq,MaxFreq,LogLin\n");
    fscanf(inf, "%ld,%ld,%ld,%g,%ld,%ld,%ld,%ld,%ld,%g,%g,%ld\n",
	    &pv.headBsize, &pv.dataBsize, &pv.dataFormat, &pv.samplingRate,
	    &pv.channels, &pv.frameSize, &pv.frameIncr, &pv.frameBsize,
	    &pv.frameFormat, &pv.minFreq, &pv.maxFreq, &pv.freqFormat);
    i = pv.dataBsize/pv.frameBsize;
    pv.magic = PVMAGIC;
    
    fwrite(&pv, (size_t)1, (size_t)sizeof(pv), outf);
    for (; i!=0; i--) {
	int j;
	for (j = 0; j<pv.frameBsize/sizeof(float); j ++) {
	    char term;
	    float data = getnum(inf, &term);
	    fwrite(&data, (size_t)1, (size_t)sizeof(float),outf);
	    if (term!=',' && term!='\n') fprintf(stderr, "Sync error\n");
	}
    }
    fclose(inf);
    fclose(outf);
    return 0;
}

float getnum(FILE* inf, char *term)
{
    char buff[100];
    int  cc;
    int p = 0;
    while ((cc=getc(inf))!=',' && cc!='\n') buff[p++] = cc;
    buff[p]='\0';
    *term = cc;
    return (float)atof(buff);
}

void usage(int argc)
{
    fprintf(stderr, "pv_import usage: commafile pvfile\n");
    fprintf(stderr, "argc=%d\n", argc);
    exit(1);
}
