/****************************************************************************/
/*                                                                          */
/* IMG* Image Processing Tools Library                                      */
/* Program:   imgCpxToFlt2.c                                                */
/* Author:    Simon A.J. Winder                                             */
/* Date:      Thu Oct 20 20:45:34 1994                                      */
/* Copyright (C) 1994 Simon A.J. Winder                                     */
/*                                                                          */
/****************************************************************************/

#include "tools.h"

#define PRGNAME "CpxToFlt2"
#define ERROR(e) imgError(e,PRGNAME)

int main(int argc,char **argv)
{
  it_image *in1,*out1;
  int width,height,x,y;
  it_float *flt_ptr;
  it_complex *cpx_ptr;
  double min,max,val;

  IFHELP
    {
      fprintf(stderr,"img%s - Convert complex image into 2 x Float\n",
	      PRGNAME);
      fprintf(stderr,"  stdin: Complex\n");
      fprintf(stderr,"  stdout: Float\n");
      exit(0);
    }
  imgStart(PRGNAME);

  do {
    if((in1=i_read_image_file(stdin,IT_COMPLEX,IM_FRAGMENT))==NULL)
      ERROR("can't import image file");
    width=in1->width;
    height=in1->height;
    if((out1=i_create_image(width,height,IT_FLOAT,IM_FRAGMENT))==NULL)
      ERROR("out of memory");

    imgInitMinMax(min,max);
    /* Copy real part across */
    for(y=0;y<height;y++)
      {
	cpx_ptr=im_complex_row(in1,y);
	flt_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++)
	  {
	    val=(cpx_ptr++)->Re;
	    *flt_ptr++=val;
	    if(val>max)
	      max=val;
	    if(val<min)
	      min=val;
	  }
      }
    out1->valid_x=in1->valid_x;
    out1->valid_y=in1->valid_y;
    out1->valid_width=in1->valid_width;
    out1->valid_height=in1->valid_height;
    out1->min_value=min;
    out1->max_value=max;
    i_write_image_file(stdout,out1,IF_BINARY);

    imgInitMinMax(min,max);
    /* Copy imaginary part across */
    for(y=0;y<height;y++)
      {
	cpx_ptr=im_complex_row(in1,y);
	flt_ptr=im_float_row(out1,y);
	for(x=0;x<width;x++)
	  {
	    val=(cpx_ptr++)->Im;
	    *flt_ptr++=val;
	    if(val>max)
	      max=val;
	    if(val<min)
	      min=val;
	  }
      }
    out1->min_value=min;
    out1->max_value=max;
    i_write_image_file(stdout,out1,IF_BINARY);
    
    i_destroy_image(in1);
    i_destroy_image(out1);
  } while(!feof(stdin));

  imgFinish(PRGNAME);
  return(0);
}
/* Version 1.0 (Oct 1994) */
/* Version 1.1 (Nov 1994) */
