#ifndef __INTERFACE_H
#define __INTERFACE_H

#include "feature.h"
#include "display.h"

int interface();			/* interact with user */

int selection(feature * what);

int main_pre_key(void); void main_do_key(void); int main_post_key(void);
int sel_pre_key(void);  void sel_do_key(void);  int sel_post_key(void);
int opt_pre_key(void);  void opt_do_key(void);  int opt_post_key(void);
int cred_pre_key(void); void cred_do_key(void); int cred_post_key(void);
int cd_pre_key(void);   void cd_do_key(void);   int cd_post_key(void);

int stat_pre_key(void);
int help_pre_key(void);

typedef enum {
    IM_main = 0,
    IM_selection = 1,
    IM_options = 2,
    IM_credits = 3,
    IM_panel = 4,
    IM_status = 5,
    IM_main_help = 6
} interface_mode_t;


typedef struct {
    int key;
    interface_mode_t mode; 
} int_var_t;
extern int_var_t int_var;

extern text_t * main_text;
extern text_t * msg_text;
extern text_t * credits_text;

#endif
