#include "cthugha.h"
#include "information.h"
#include "options.h"
#include "display.h"
#include "sound.h"
#include "action.h"
#include "translate.h"
#include "keys.h"
#include "interface.h"
#include "waves.h"

#include <unistd.h>
#include <stdio.h>

/*****************************************************************************/
		
/* Modifications to update status "interactively" by 
 * Christopher L. Platt  (croutons%crunchy.uucp@dartmouth.edu)
 * modified by Harald
 */

/* 
 *Generate status-information-string
 */
int stat_pre_key() {
    static char s[2000];

    sprintf(s, 
	    "Wave    : %s (%s) - %d\n"
	    "Flame   : %s%s%s%s"    "%s%s%s%s%s"	"\n"
	    "Display : %s (%s)\n"
	    "Palette : %s (%s)\n"
	    "Transl. : %s (%s)\n"
	    "Next PCX: %s (%s)\n"
	    "Object  : %s\n"
	    "Table   : %d\n"
	    "Massage : %d\n"
	    "Channels: %s\n"
	    "Rate    : %d\n"
	    "%s%s%s%s\n"
	    "Frames/s: %2.2f\n",

	    waves.entries[waves.current].name,
	    waves.entries[waves.current].desc,
	    wave_scale,

	    flame_rgb ? "" : flames.entries[flames.current].name,
	    flame_rgb ? "" : " (",
	    flame_rgb ? "" : flames.entries[flames.current].desc,
	    flame_rgb ? "" : ")",

	    flame_rgb ? flames_rgb[0].entries[flames_rgb[0].current].name : "",
	    flame_rgb ? "," : "",
	    flame_rgb ? flames_rgb[1].entries[flames_rgb[1].current].name : "",
	    flame_rgb ? "," : "",
	    flame_rgb ? flames_rgb[2].entries[flames_rgb[2].current].name : "",

	    screens.entries[screens.current].name,
	    screens.entries[screens.current].desc,

	    palettes.entries[palettes.current].name,
	    palettes.entries[palettes.current].desc,

	    translations.entries[max(translations.current,0)].name,
	    translations.entries[max(translations.current,0)].desc,

	    pcxs.entries[max(pcxs.current,0)].name,
	    pcxs.entries[max(pcxs.current,0)].desc,

	    objects.entries[objects.current].name,

	    active_table,
	    sound_massage_style,

	    (sound_options->channels == 2) ? "Stereo" : "Mono",
	    sound_options->speed,
	    action_lock ? "LOCKED " : "",
	    sound_FFT ? "FFT " : "",
	    sound_flashlight ? "Flash " : "",
	    flame_rgb ? "RGB " : "",

	    fps);

    main_text = display_reprint(main_text, s, 0, 'l', 0, TEXT_COLOR_NORMAL);
    return 0;
}		


/*****************************************************************************/

const char * help_text = 
"f/F  Chg Flame     w    Chg Wave         \n"
"d/D  Chg Display   b/B  Chg Table        \n"
"t/T  Chg Transl.   m/M  Chg Snd-massage  \n"
"p/P  Chg Palette   s    Toggle flashlight\n"
"e    Toggle FFT    h/v  Toggle mirroring \n"
"l    Lock          i    Information      \n"
"BS   Undo Change   W    Chg Wave Scale   \n"
"x/X  show PCX      +/-  Sample-Rate       \n"
"*    mono/stereo   </>  Minnoise          \n"
"F1/? This Help     F2   Select Display    \n"
"F3   Select Wave   F4   Select Flame      \n"
"F5   Select Trans. F6   Select Palette    \n"
"F7   Select PCX    g    Chg. gen. flame   \n"
"o    Optioms       c    Sound/CD Control  \n"   
"a    write ini-file with current sel.    \n"
"n    reconnect to cthugha-server         \n"
"q/ESC  Exit        #    Print screen      \n";


