// QWeb - An SGML Web Browser
// Copyright (C) 1997  Sean Vyain
// svyain@mail.tds.net
// smvyain@softart.com
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#include "Renderer.h"
#include "StyleSheet.h"

Rect::Rect()
        : _x1( 0 ),
          _y1( 0 ),
          _x2( 0 ),
          _y2( 0 )
{
}

Rect::Rect( int x, int y, int w, int h )
        : _x1( x ),
          _y1( y ),
          _x2( x + w ),
          _y2( y + h )
{
}

bool Rect::intersects( const Rect& r ) const
{
    int maxx = _x1 > r._x1 ? _x1 : r._x1;
    int maxy = _y1 > r._y1 ? _y1 : r._y1;
    int minx = _x2 < r._x2 ? _x2 : r._x2;
    int miny = _y2 < r._y2 ? _y2 : r._y2;

    return ( maxx <= minx ) && ( maxy <= miny );
}

Rect Rect::intersect( const Rect& r )
{
    Rect rect;
    rect._x1 = _x1 > r._x1 ? _x1 : r._x1;
    rect._y1 = _y1 > r._y1 ? _y1 : r._y1;
    rect._x2 = _x2 < r._x2 ? _x2 : r._x2;
    rect._y2 = _y2 < r._y2 ? _y2 : r._y2;

    return rect;
}

bool Rect::contains( int x, int y ) const
{
    return ( x >= _x1 ) && ( x <= _x2 ) && ( y >= _y1 ) && ( y <= _y2 );
}

Renderer::Renderer( Canvas*     canvas,
                    int         clipWidth,
                    QObject*    parent,
                    const char* name )
        : QObject( parent, name ),
          _canvas( canvas ),
          _clipWidth( clipWidth ),
          _minimumWidth( 0 ),
          _maximumWidth( 0 ),
          _needRedraw( FALSE )
{
    setRect( 0, 0, 0, 0 );
}

Renderer::~Renderer()
{
}

void Renderer::needRedraw()
{
    _needRedraw = TRUE;
}

void Renderer::widthChanged( int w )
{
    if ( _clipWidth != w ) {
        _clipWidth = w;
        needRedraw();
    }
}

void Renderer::resize( int w, int h )
{
    if ( ( w != width() ) || ( h != height() ) ) {
        setSize( w, h );
        emit resized();
    }
}

void Renderer::move( int x, int y )
{
    moveTopLeft( x, y );
}

void Renderer::childSizeChanged()
{
    needRedraw();
}

void Renderer::repaint( QPainter&, const Rect& )
{
}

bool Renderer::redraw()
{
    return FALSE;
}
