// crossbox.C
//
// This program is free software. See the file COPYING for details.
// Author: Mattias Engdegrd, 1997, 1998

// This is a variation on QCheckBox (inherited), with more obvious check
// boxes instead of the ugly Motif bumps and depressions. It behaves exactly
// like QCheckBox in WindowsStyle.
// Controls such as these should really be localized if you are serious about
// i18n, since interpretations of images are culturally dependent

#include <qbrush.h>
#include <qdrawutl.h>
#include "crossbox.h"

CrossBox::CrossBox(const char *text, QWidget *parent, const char *name)
         : QCheckBox(text, parent, name)
{}

void CrossBox::drawButton(QPainter *p)
{
    // only do this if we're in Motif mode
    if(style() == MotifStyle) {
	int y = height() / 2 - 6;
	QColorGroup g = colorGroup();
	QBrush fill(isDown() ? g.background() : g.base());
	qDrawShadePanel(p, 0, y, 12, 13, g, TRUE, 1, &fill);
	if(isChecked()) {
	    p->drawLine(2, y + 2, 9, y + 9);
	    p->drawLine(2, y + 3, 9, y + 10);
	    p->drawLine(2, y + 9, 9, y + 2);
	    p->drawLine(2, y + 10, 9, y + 3);
	}
	drawButtonLabel(p);
    } else {
	// otherwise, behave like QCheckBox
	QCheckBox::drawButton(p);
    }
}



