/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "globals.pas" */


#include "cfuncs.h"


#define GLOBALS_G
#include "globals.h"


char durations[ndurs + 1] = "90248136";
char terminators[256] = ".x";
char choice = ' ';
short verbose = 0;
boolean ignore = false, dochords = true, dotext = true, dolyrics = true,
	split_dots = false, set_names = false, pedantic = true,
	unbeam_if_vocal = true, extended_dots = false, private_pmx = false,
	newslurs = false, tonic_solfa = false, no_uptext_for_rests = false,
	outfile_open = false;
char texdir[256] = "";
char old_meter_word[256] = "";
short outlen = 0;
boolean ignore_input = false;

#ifndef STRINGS_H

#endif


void cancel(short *num, short *denom, short lowest)
{
  while (((*num) & 1) == 0 && *denom > lowest) {
    *num /= 2;
    *denom /= 2;
  }
}


char *meterWord(char *Result, short num, short denom, short pnum,
		short pdenom)
{
  char STR1[256], STR2[256], STR4[256], STR5[256];

  sprintf(Result, "m%s/%s/%s/%s",
	  toString(STR1, num), toString(STR2, denom), toString(STR4, pnum),
	  toString(STR5, pdenom));
  return Result;
}


char *meterChange(char *Result, short n1, short n2, boolean blind)
{
  short f = 64;
  short l;

  if (!blind)
    return (meterWord(Result, n1, n2, 0, 0));
  l = n1 * (64 / n2);
  cancel(&l, &f, meterdenom);
  meterWord(Result, l, f, 0, 0);
  if (meternum > 0)
    printf("Blind meter change to %d/%d on line %d\n", l, f, line_no);
  return Result;
}


void setSpace(char *line_)
{
  char line[256];
  short i = 0;
  char word[256];

  strcpy(line, line_);
  while (i < ninstr) {
    GetNextWord(word, line, blank, dummy);
    if (*word == '\0')
      return;
    i++;
    getNum(word, &nspace[i-1]);
  }
}


boolean endsWith(char *s1_, char *s2)
{
  char s1[256];
  short l1, l2;

  strcpy(s1, s1_);
  l1 = strlen(s1);
  l2 = strlen(s2);
  if (l1 < l2)
    return false;
  predelete(s1, l1 - l2);
  return (strcmp(s1, s2) == 0);
}


void setMeter(char *line_)
{
  char line[256];
  char meter[256];

  strcpy(line, line_);
  GetNextWord(meter, line, blank, dummy);
  if (!strcmp(meter, "C/")) {
    meternum = 2;
    meterdenom = 2;
    pmdenom = 5;
    pmnum = 0;
  } else if (!strcmp(meter, "C")) {
    meternum = 4;
    meterdenom = 4;
    pmdenom = 6;
    pmnum = 0;
  } else
    readMeter(meter, &meternum, &meterdenom, &pmnum, &pmdenom);
  setDefaultDuration(meterdenom);
}


static void onumber(char *s, short *j, short *n1)
{
  if (s[*j - 1] == 'o')
    *n1 = 1;
  else if (s[*j - 1] == '1') {
    *n1 = digit(s[*j]) + 10;
    (*j)++;
  } else
    *n1 = digit(s[*j - 1]);
  (*j)++;
}


static void extractNumber(char *s, short *k)
{
  char w[256];

  GetNextWord(w, s, '/', dummy);
  getNum(w, k);
}


void readMeter(char *meter_, short *meternum, short *meterdenom, short *pmnum,
	       short *pmdenom)
{
  char meter[256];
  short j;

  strcpy(meter, meter_);
  if (meter[0] == 'm') {
    if (pos1('/', meter) == 0) {
      j = 2;
      onumber(meter, &j, meternum);
      onumber(meter, &j, meterdenom);
      onumber(meter, &j, pmnum);
      onumber(meter, &j, pmdenom);
    } else {
      predelete(meter, 1);
      extractNumber(meter, meternum);
      extractNumber(meter, meterdenom);
      extractNumber(meter, pmnum);
      extractNumber(meter, pmdenom);
    }
  } else {
    getTwoNums(meter, meternum, meterdenom);
    *pmnum = *meternum;
    *pmdenom = *meterdenom;
  }
  if (*meterdenom == 0)
    error("Meter denominator must be nonzero", print);
}


boolean startsWithBracedWord(char *P_)
{
  char P[256];
  char w[256];

  strcpy(P, P_);
  GetNextWord(w, P, blank, dummy);
  return (w[0] == '{' && w[strlen(w) - 1] == '}');
}


void trim(char *s)
{
  short k;

  k = posNot(blank, s);
  if (k > 1)
    predelete(s, k - 1);
  else if (k == 0)
    *s = '\0';
}


short whereInParagraph(short l)
{
  short Result = 0;
  short j, FORLIM;

  FORLIM = para_len;
  for (j = 1; j <= FORLIM; j++) {
    if (orig_line_no[j-1] == l)
      return j;
  }
  return Result;
}


void fatalerror(char *message)
{
  ignore = false;
  error(message, !print);
}


void error(char *message, boolean printLine)
{
  short j;

  if (line_no == 0)
    line_no = 10000;
  printf("%s: ERROR on line %d\n", message, line_no);
  j = whereInParagraph(line_no);
  if (j > 0 && printLine)
    puts(P[j-1]);
  if (ignore)
    return;
  if (!outfile_open)
    _Escape(line_no);
  if (outfile != NULL)
    fclose(outfile);
  outfile = NULL;
  outfile = fopen(outfile_NAME, "w");
  if (outfile == NULL)
    _EscIO2(FileNotFound, outfile_NAME);
  fclose(outfile);
  outfile = NULL;
  _Escape(line_no);
}


void warning(char *message, boolean printLine)
{
  short j;

  if (line_no <= 0) {
    printf("%s: WARNING in preamble\n", message);
    return;
  }
  printf("%s: WARNING on line %d\n", message, line_no);
  if (!printLine)
    return;
  j = whereInParagraph(line_no);
  if (j > 0)
    puts(P[j-1]);
}


short wordCount(char *s)
{
  short i, n, FORLIM;

  if (*s == '\0')
    return 0;
  if (s[0] == blank)
    n = 0;
  else
    n = 1;
  FORLIM = strlen(s);
  for (i = 1; i <= FORLIM - 1; i++) {
    if (s[i-1] == blank && s[i] != blank)
      n++;
  }
  return n;
}


char *GetNextWord(char *Result, char *s, char Delim, char Term)
{
  /* A delimiter is a character that separates words, but forms no part
     of them.  A terminator is a character that appears at the end of
     a word. */
  short n = 1;
  short start, last;

  last = strlen(s);
  while (n <= last && s[n-1] == Delim)
    n++;
  start = n;
  while (n <= last && s[n-1] != Term && s[n-1] != Delim)
    n++;
  if (n <= last && s[n-1] == Term)
    n++;
  substr_(Result, s, start, n - start);
  while (n <= last && s[n-1] == Delim)
    n++;
  predelete(s, n - 1);
  return Result;
}


char *NextWord(char *Result, char *s_, char Delim, char Term)
{
  char s[256];

  strcpy(s, s_);
  return (GetNextWord(Result, s, Delim, Term));
}


char *plural(char *Result, short n)
{
  if (n == 1)
    return strcpy(Result, "");
  else
    return strcpy(Result, "s");
}


short curtail(char *s, char c)
{
  short Result = 0;
  short l;

  l = strlen(s);
  if (s[l-1] == c) {
    shorten(s, l - 1);
    return l;
  }
  return Result;
}


char *toString(char *Result, short n)
{
  char s[256];

  sprintf(s, "%d", n);
  return strcpy(Result, s);
}


short digit(char c)
{
  return (c - '0');
}


boolean equalsIgnoreCase(char *s1_, char *s2_)
{
  char s1[256], s2[256];

  strcpy(s1, s1_);
  strcpy(s2, s2_);
  toUpper(s1);
  toUpper(s2);
  return (strcmp(s1, s2) == 0);
}


boolean startsWithIgnoreCase(char *s1_, char *s2_)
{
  char s1[256], s2[256];

  strcpy(s1, s1_);
  strcpy(s2, s2_);
  toUpper(s1);
  toUpper(s2);
  return (startsWith(s1, s2));
}


short PMXinstr(short stave)
{
  return (ninstr - instr[stave-1] + 1);
}


void setDefaultDuration(short meterdenom)
{
  switch (meterdenom) {

  case 2:
    default_duration = '2';
    break;

  case 4:
    default_duration = '4';
    break;

  case 8:
    default_duration = '8';
    break;

  case 16:
    default_duration = '1';
    break;

  case 32:
    default_duration = '3';
    break;

  case 64:
    default_duration = '6';
    break;
  }
}




/* End. */
