#ifndef StilDialog_h
#define StilDialog_h

#include <stdlib.h>

#include <qdialog.h>
#include <qlabel.h>
#include <qscrollview.h>
#include <qstring.h>

#include "HVSCconfig.h"
#include "GlobalIcon.h"

class StilDialog : public QDialog
{
    Q_OBJECT

 public:

    StilDialog(QWidget* parent = NULL, const char* name = NULL);

    const HVSCconfig& getConfig() const;
    void setLabels(const char*, const char*, const char*);
    void clearLabels();

 public slots:

    void setConfig(const HVSCconfig&);

 protected:

    virtual void resizeEvent(QResizeEvent*);

    QScrollView* tmpQScrollView;

    QLabel* globalLabel;
    QString globalString;

    QLabel* stilLabel;
    QString stilString;

    QLabel* bugLabel;
    QString bugString;

    HVSCconfig config;
};

#endif  // StilDialog_h
