#include "forms.h"
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <stdlib.h>
#include "xmysqladmin.h"
#include "xmysqladmin2.h"
#include "mysql.h"
/* #define GDEBUG */

extern struct setup Setup;
extern struct stat Stat;
/* FD_createtable *f_createtable;
** struct createTable *ct;
*/
extern struct fields * ccomkey_fieldIndex(struct edittable *it, char *nom);
extern void altertable_init(struct edittable *it);
extern void altertableFree(struct edittable *it);
void createtable_setactive(struct edittable *it);
void createtable_freeList(struct edittable *it);
void createtable_setCT(struct edittable *it);
void createtable_setFieldBrowser(struct edittable *it);
char *createtable_indexToType(int type);
void createtable_varToObj(struct edittable *it);
int createtableNameExist(struct edittable *it, char *nom);
int createtableKeyExist(struct edittable *it, char *nom);
void createtable_copyfield(struct fields *dest, struct fields *src);
int createtable_typeToIndex(char *type);
void createtable_setBounds(struct edittable *it);

void createtable_copyfield(struct fields *dest, struct fields *src)
{
  dest->index = src->index;
  strcpy(dest->name, src->name);
  dest->type = src->type;
  dest->length = src->length;
  dest->decimales = src->decimales;
  strcpy(dest->fdefault, src->fdefault);
  dest->notNull = src->notNull;
  dest->zeroFill = src->zeroFill;
  dest->funsigned = src->funsigned;
  dest->autoIncrement = src->autoIncrement;
  dest->keyType = src->keyType;
  dest->keySize = src->keySize;
  strcpy(dest->keyName, src->keyName);
}

void createtable_setCT(struct edittable *it)
{
  struct fields *cur;

  it->ct->qtKeys = 0;
  it->ct->primary = 0;
  cur = it->firstf;
  while(cur)
  {
    if(cur->keyType == 'P')
    {
      it->ct->primary = 1;
    }
    if(cur->keyType)
    {
      it->ct->qtKeys++;
    }
    cur = cur->next;
  }

  {
    struct compoundkey *ck;
    
    ck = it->firstc;
    while(ck)
    {
      if(ck->type == 'P')
      {
	it->ct->primary = 1;
      }
      it->ct->qtKeys++;

      ck = ck->next;
    }
  }
}


void createtable_freeList(struct edittable *it)
{
  {
    struct fields *cur;
    cur = it->firstf;
    while(cur)
    {
      it->firstf = it->firstf->next;
      free(cur);
      cur = it->firstf;
    }
  }

  {
    struct compoundkey *cur;
    struct partkey *part;
    
    cur = it->firstc;
    while(cur)
    {
      part = cur->first;
      while(part)
      {
	cur->first = cur->first->next;
	free(part);
	part = cur->first;
      }
      
      it->firstc = it->firstc->next;
      free(cur);
      cur = it->firstc;
    }
  }

  it->firstc = it->lastc = NULL; 
  it->firstf = it->lastf = NULL; 
}


/* set les champs actifs selon ce qu'il y a dans      */
/* les champs database, nom de table et (type si vide */
void createtable_setactive(struct edittable *it)
{
   fl_freeze_form(it->f_createtable->createtable);

   /* dans tous les cas, je desactive tous les champs */
   /* sauf le champ exit                              */
   /* les champs necessaires seront actives selon     */
   /* le contenu de la structure pointee par it->buff      */
   g_deactivate_object(it->f_createtable->fieldmode);
   g_activate_object(it->f_createtable->exit);
   if(it->modeAlter)
   {
      g_activate_object(it->f_createtable->alterTable);
   }

   /* pas de database d'indique */
   if(!it->ct->database[0])
   {
      if(it->modeAlter)
      {
	 g_deactivate_object(it->f_createtable->tableToAlter);
	 g_deactivate_object(it->f_createtable->alterTable);
      }
      else
      {
	 g_deactivate_object(it->f_createtable->tableName);
      }
   }
   else
   {
      /* database indiquee mais pas de nom de table */
      if(!it->ct->table[0])
      {
	 if(it->modeAlter)
	 {
	    g_activate_object(it->f_createtable->tableToAlter);
	 }
	 else
	 {
	    g_activate_object(it->f_createtable->tableName);
	 }
      }
      else
      {
	 /* database et nom de table indique */
	 /* mais pas de type                 */
	 if(!it->buff->type)
	 {
	    if(it->modeAlter)
	    {
	       g_activate_object(it->f_createtable->tableToAlter);
	       g_activate_object(it->f_createtable->alterTable);
	    }
	    else
	    {
	       g_activate_object(it->f_createtable->tableName);
	    }
	    g_activate_object(it->f_createtable->fieldType);
	 }
	 else
	 {
	    /*-----------------------------------------------*/
	    /* si un element du browser des champs est actif */
	    /* active les boutons modifier et effacer        */
	    /* selon element actif, active les fleches       */
	    /* si browser a au moins 1 element, active le    */
	    /*-----------------------------------------------*/
	    int brwField;
	    int brwLines;

	    brwField = fl_get_browser(it->f_createtable->browserFields);
	    brwLines = fl_get_browser_maxline(it->f_createtable->browserFields);
	    if(brwField)
	    {
	       g_activate_object(it->f_createtable->modField);
	       g_activate_object(it->f_createtable->delField);

	       if(brwField > 1)
	       {
		  g_activate_object(it->f_createtable->switchUp);
	       }
	       if(brwField < brwLines)
	       {
		  g_activate_object(it->f_createtable->switchDown);
	       }
	    }
	    if(brwLines)
	    {
	       g_activate_object(it->f_createtable->browserFields);
	       /* s'il y a au moins un element dans la liste */
	       /* active le bouton de creation de table      */
	       g_activate_object(it->f_createtable->createTable);
	       if(brwLines > 1)
	       {
		  g_activate_object(it->f_createtable->compoundKeyMode);
	       }
	    }

	    /*------------------------------------*/
	    /* si le minimum d'elements est saisi */
	    /* active boutons d'addition          */
	    /*------------------------------------*/
	    if(fl_get_input(it->f_createtable->fieldName) != NULL  && it->buff->type)
	    {
	       g_activate_object(it->f_createtable->addField);
	    }


	    /*---------------------*/
	    /* pour tous les types */
	    /*---------------------*/
	    g_activate_object(it->f_createtable->fieldName);
	    g_activate_object(it->f_createtable->fieldLength);
	    g_activate_object(it->f_createtable->fieldNotNull);
	    g_activate_object(it->f_createtable->fieldType);

	    /*--------------------------------------*/
	    /* database, nom table et types definis */
	    /* active les champs selon de type      */
	    /*--------------------------------------*/
	    switch(it->buff->type)
	    {
	       case 2: /* tinyint */
	       case 3: /* smallint */
	       case 4: /* mediumint */
	       case 5: /* integer */
	       case 6: /* big integer */
	       {
		  g_activate_object(it->f_createtable->fieldDefault);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldAutoIncrement);
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     g_activate_object(it->f_createtable->keyOnOff);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }

		  }
		  g_activate_object(it->f_createtable->fieldZeroFill);
		  g_activate_object(it->f_createtable->fieldUnsigned);
	       }
	       break;
	       case 7: /* float */
	       case 8: /* double */
	       {
		  g_activate_object(it->f_createtable->fieldDecimals);
		  g_activate_object(it->f_createtable->fieldDefault);
		  g_activate_object(it->f_createtable->fieldNotNull);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldAutoIncrement);
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
		  g_activate_object(it->f_createtable->fieldZeroFill);
	       }
	       break;
	       case 9: /* decimal */
	       {
		  g_activate_object(it->f_createtable->fieldDecimals);
		  g_activate_object(it->f_createtable->fieldDefault);
		  g_activate_object(it->f_createtable->fieldNotNull);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldAutoIncrement);
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keySize);
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
		  g_activate_object(it->f_createtable->fieldZeroFill);
	       }
	       break;
	       case 10: /* char */
	       case 11: /* varchar */
	       {
		  g_activate_object(it->f_createtable->fieldNotNull);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keySize);
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
	       }
	       break;
	       case 12: /* tinyblob */
	       case 13: /* blob */
	       case 14: /* mediumblob */
	       case 15: /* longblob */
	       case 22: /* text */
	       {
		  g_activate_object(it->f_createtable->fieldNotNull);
		  g_deactivate_object(it->f_createtable->fieldLength);
	       }
	       break;
	       case 16: /* timestamp */
	       {
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
	       }
	       break;
	       case 17: /* date */
	       case 21: /* datetime */
	       {
		  g_deactivate_object(it->f_createtable->fieldLength);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
	       }
	       break;
	       case 18: /* time */
	       {
		  g_deactivate_object(it->f_createtable->fieldLength);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
	       }
	       break;
	       case 19: /* enum */
	       case 20: /* set  */
	       {
		  g_activate_object(it->f_createtable->fieldDefault);
		  g_activate_object(it->f_createtable->fieldNotNull);
		  if(it->ct->qtKeys < 16)
		  {
		     if(!it->ct->primary)
		     {
			g_activate_object(it->f_createtable->fieldPrimary);
		     }
		     g_activate_object(it->f_createtable->fieldMulti);
		     g_activate_object(it->f_createtable->fieldUnique);
		     if(!fl_get_button(it->f_createtable->keyOnOff))
		     {
			g_activate_object(it->f_createtable->keyName);
		     }
		     g_activate_object(it->f_createtable->keyOnOff);
		  }
	       }
	       break;
	    }
	 } /* fin du si le type est valide */
      }
   }
   fl_unfreeze_form(it->f_createtable->createtable);
}


void main_createtable(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  
  it = (struct edittable *) calloc(1, sizeof(struct edittable));
  it->alter = (struct edittable *) calloc(1, sizeof(struct edittable));  
  /*--------------------------------------------------*/
  /* reserve la memoire des structure de travail      */
  /* place les pointeurs de la liste de champs a null */
  /*--------------------------------------------------*/
  it->ct = (struct createTable *) calloc(1, sizeof(struct createTable));
  it->buff= (struct fields *) calloc(1, sizeof(struct fields));
  it->firstf = it->lastf = NULL;
  it->firstc = it->lastc = NULL;
  it->alter->firstf = it->alter->lastf = NULL;
  it->alter->firstc = it->alter->lastc = NULL;
  
  /*-----------------------------------*/
  /* cree et montre la forme de saisie */
  /*-----------------------------------*/
  it->f_createtable = create_form_createtable();
  it->f_createtable->vdata = (struct edittable *) it;
  fl_show_form(it->f_createtable->createtable, FL_PLACE_MOUSE, FL_TRANSIENT, "XmysqlAdmin createtable");

  fl_freeze_form(it->f_createtable->createtable);

  /*-------------------------------------------*/
  /* hide les boutons selon si alter ou create */
  /*-------------------------------------------*/
  if(data == 1000L)
  {
    fl_hide_object(it->f_createtable->createTable);
    fl_hide_object(it->f_createtable->tableName);
    it->modeAlter = 1;
  }
  else
  {
    fl_hide_object(it->f_createtable->tableToAlter);
    fl_hide_object(it->f_createtable->alterTable);
  }
  
  /*--------------------------------------*/
  /* limite la longueur des champs input  */
  /*--------------------------------------*/
  fl_set_input_maxchars(it->f_createtable->tableName, 32);
  fl_set_input_maxchars(it->f_createtable->fieldName, 32);
  fl_set_input_maxchars(it->f_createtable->fieldDefault, 511);
  fl_set_input_maxchars(it->f_createtable->keyName, 32);

  /*
   *  fl_set_input_return(it->f_createtable->tableName, FL_RETURN_END);
   *  fl_set_input_return(it->f_createtable->fieldName, FL_RETURN_END);
   *  fl_set_input_return(it->f_createtable->fieldDefault, FL_RETURN_END);
   *  fl_set_input_return(it->f_createtable->keyName, FL_RETURN_END);
   */

  /*--------------------------------------*/
  /* setup choice du champ types de champ */
  /*--------------------------------------*/
  fl_addto_choice(it->f_createtable->fieldType, "Select a field type");
  fl_addto_choice(it->f_createtable->fieldType, "TINYINT   (1 byte)");
  fl_addto_choice(it->f_createtable->fieldType, "SMALLINT  (2 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "MEDIUMINT (3 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "INTEGER   (4 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "BIGINT    (8 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "FLOAT     (4 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "DOUBLE    (8 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "DECIMAL (length,dec)");
  fl_addto_choice(it->f_createtable->fieldType, "CHAR    (1<=num<=255)");
  fl_addto_choice(it->f_createtable->fieldType, "VARCHAR (1<=num<=255)");
  fl_addto_choice(it->f_createtable->fieldType, "TINYBLOB   (num<=255)");
  fl_addto_choice(it->f_createtable->fieldType, "BLOB       (num<=65535)");
  fl_addto_choice(it->f_createtable->fieldType, "MEDIUMBLOB (num<=16777216)");
  fl_addto_choice(it->f_createtable->fieldType, "LONGBLOB   (num<=2**32)");
  fl_addto_choice(it->f_createtable->fieldType, "TIMESTAMP (4 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "DATE      (4 bytes)");
  fl_addto_choice(it->f_createtable->fieldType, "TIME      (3 bytes)");
#if MYSQL_VERSION == 321
  fl_addto_choice(it->f_createtable->fieldType, "ENUM");
  fl_addto_choice(it->f_createtable->fieldType, "SET");    
  fl_addto_choice(it->f_createtable->fieldType, "DATETIME");
  fl_addto_choice(it->f_createtable->fieldType, "TEXT");
#endif

  /*--------------------------------------*/
  /* change le font du browser des champs */
  /*--------------------------------------*/
  fl_set_browser_fontstyle(it->f_createtable->browserFields, FL_FIXED_STYLE);
  fl_set_browser_fontsize(it->f_createtable->browserFields, FL_NORMAL_SIZE);

  /*----------------------*/
  /* desactive les objets */
  /*----------------------*/
  createtable_setactive(it);

  /*------------------------------------------*/
  /* retrouve la liste de banques de donnees  */
  /* pour les placer dans le champs des choix */
  /*------------------------------------------*/
  choice_getDatabases(it->f_createtable->choiceDbf);

  fl_unfreeze_form(it->f_createtable->createtable);
}

void createtable_exit(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;
  
  createtable_freeList(it);
  free(it->ct);
  free(it->buff);
  fl_hide_form(it->f_createtable->createtable);
  fl_free_form(it->f_createtable->createtable);
  free(it->f_createtable);
  altertableFree(it);
  free(it->alter);
  free(it);
}


void createtable_inputtablename(FL_OBJECT *obj, long data)
{
  char nom[33];
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;


  strcpy(nom, fl_get_input(obj));

  /*----------------------------------------------------------*/
  /* verifie si le nom de la table est valide dans sa syntaxe */
  /*----------------------------------------------------------*/
  {
    char *p;


    p = nom;
    while(*p)
    {
      if(isspace(*p) || ispunct(*p) || iscntrl(*p))
      {
        fl_set_input(obj, it->ct->table);
        return;
      }
      p++;
    }
  }

  /*------------------------------------------------*/
  /* verifie si la table existe deja dans la banque */
  /*------------------------------------------------*/
  if(tableExist(it->ct->database, nom))
  {
    fl_show_alert("Table already exist",it->ct->database, nom, 0);
    it->ct->table[0] = '\0';
    fl_set_input(obj, it->ct->table);
    return;
  }

  strcpy(it->ct->table, nom);
  createtable_setactive(it);
}

void createtable_choiceDbf(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->ct->database[0] = '\0';

  if(fl_get_choice(obj) > 1)
  {
    if(strcmp(fl_get_choice_text(obj), "mysql"))
    {
      strcpy(it->ct->database, fl_get_choice_text(obj));
    }
  }

  /*------------------------------------------*/
  /* verifie si le nom de la table est valide */
  /* pour la nouvelle banque de donnees       */
  /*------------------------------------------*/
  /*---------------------------------------------------*/
  /* appelle la fonction d'initialisation d'alteration */
  /*---------------------------------------------------*/
  if(it->modeAlter)
  {
    altertable_init(it);
  }
  else
  {
    if(it->ct->table[0] && it->ct->database[0])
    {
      if(tableExist(it->ct->database, it->ct->table))
      {
	fl_show_alert("Table already exist",it->ct->database, it->ct->table,0);
	it->ct->table[0] = '\0';
	fl_set_input(it->f_createtable->tableName, it->ct->table);
      }
    }
    else
    {
      /* set active est appele par createtable_inputtablename() */
      /* inutile donc de l'appeler une deuxieme fois            */
      createtable_setactive(it);
    }
  }
}

void createtable_browserfields(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct fields *cur;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_createtable->browserFields);
  i = 1;

  cur = it->firstf;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /*--------------------------------------------*/
  /* copie l'element de la liste dans le buffer */
  /*--------------------------------------------*/
  memcpy(it->buff, cur, sizeof(struct fields));

  createtable_varToObj(it);
  createtable_setactive(it);
}
void createtable_fieldname(FL_OBJECT *obj, long data)
{
  char nom[33];
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  strcpy(nom, fl_get_input(obj));
  trim(nom);

  /* si c'est le meme nom que la cle, refuse */
  if(!stricmp(nom, it->buff->keyName))
  {
    fl_set_input(obj, "");
  }

  /*-------------------------------------------------------*/
  /* verifie si le nom du champ est valide dans sa syntaxe */
  /*-------------------------------------------------------*/
  {
    char *p;
    p = nom;
    while(*p)
    {
      if(isspace(*p) || (ispunct(*p) && *p != '_') || iscntrl(*p))
      {
        fl_set_input(obj, it->buff->name);
        return;
      }
      p++;
    }
  }



  /*----------------------------------------------*/
  /* si le nom du champ existe deja dans la liste */
  /* refuse le champ                              */
  /*----------------------------------------------*/
  if(createtableNameExist(it, nom))
  {
    fl_set_input(obj, it->buff->name);
    return;
  }
  

  strcpy(it->buff->name, nom);
  createtable_setactive(it);
}

int createtableNameExist(struct edittable *it, char *nom)
{
  /* verification dans les champs et index normaux */
  {
    struct fields *cur;
    cur = it->firstf;
    while(cur)
    {
      if(!stricmp(nom, cur->name))
      {
	break;
      }
      cur = cur->next;
    }
    if(cur)
    {
      return 1;
    }
  }
  
  return 0;
}

int createtableKeyExist(struct edittable *it, char *nom)
{
  /* verification dans les champs et index normaux */
  {
    struct fields *cur;
    cur = it->firstf;
    while(cur)
    {
      if(!stricmp(nom, cur->keyName))
      {
	break;
      }
      cur = cur->next;
    }
    if(cur)
    {
      return 1;
    }
  }
  
  /* verification dans les compounds keys */
  {
    struct compoundkey *cur;
    cur = it->firstc;
    while(cur)
    {
      if(!strcmp(nom, cur->nom))
      {
	break;
      }
      cur = cur->next;
    }
    if(cur)
    {
      return 1;
    }
  }
  
  return 0;
}

void createtable_fieldtype(FL_OBJECT *obj, long data)
{
   struct edittable *it;
   FD_createtable *fd;
   fd = (FD_createtable *) obj->form->fdui;
   it = (struct edittable *) fd->vdata;

   it->buff->type = fl_get_choice(obj);
   if(it->buff->type < 2)
   {
      it->buff->type = 0;
   }

   it->buff->notNull  = '\0';
   it->buff->zeroFill = '\0';
   it->buff->funsigned= '\0';
   it->buff->autoIncrement = '\0';
   it->buff->keyType = '\0';
   it->buff->keySize = 0;
   it->buff->keyName[0] = '\0';
   it->buff->decimales = 0;
   it->buff->fdefault[0] = '\0';
   it->buff->name[0] = '\0';
   it->buff->keyName[0] = '\0';
  
   /*----------------------------------------------*/
   /* assigne les valeurs aux champs selon le type */
   /*----------------------------------------------*/
   switch(it->buff->type)
   {
      case 2: /* tinyint */
      {
	 it->buff->length = 3;
      }
      break;
      case 3: /* smallint */
      {
	 it->buff->length = 5;
      }
      break;
      case 4: /* mediumint */
      {
	 it->buff->length = 8L;
      }
      break;
      case 5: /* integer */
      {
	 it->buff->length = 10L;
      }
      break;
      case 6: /* big integer */
      {
	 it->buff->length = 20L;
      }
      break;
      case 7: /* float */
      {
	 it->buff->length = 10L;
	 it->buff->decimales = 2;
      }
      break;
      case 8: /* double */
      {
	 it->buff->length = 10L;
	 it->buff->decimales = 4;
      }
      break;
      case 9: /* decimal */
      {
	 it->buff->length = 10L;
	 it->buff->decimales = 2;
	 it->buff->keySize = 10;
      }
      break;
      case 10: /* char */
      {
	 it->buff->length = 20L;
	 it->buff->keySize = 20;
      }
      break;
      case 11: /* varchar */
      {
	 it->buff->length = 60L;
	 it->buff->keySize = 20;
      }
      break;
      case 12: /* tinyblob */
      {
	 it->buff->length = 0L;
      }
      break;
      case 13: /* blob */
      case 22: /* text */
      {
	 it->buff->length = 0L;
      }
      break;
      case 14: /* mediumblob */
      {
	 it->buff->length = 0L;
      }
      break;
      case 15: /* longblob */
      {
	 it->buff->length = 0L;
      }
      break;
      case 16: /* timestamp */
      case 21: /* datetime */
      {
	 it->buff->length = 14L;
      }
      break;
      case 17: /* date */
      {
	 it->buff->length = 0L;
      }
      break;
      case 18: /* time */
      {
	 it->buff->length = 0L;
      }
      break;
      case 19: /* enum */
      case 20: /* set */
      {
	 it->buff->length = 0L;
      }
      break;

   }

   createtable_setBounds(it);
   createtable_varToObj(it);
   createtable_setactive(it);
}

void createtable_setBounds(struct edittable *it)
{
   switch(it->buff->type)
   {
      case 2: /* tinyint */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 3.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 1.0);
      }
      break;
      case 3: /* smallint */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 5.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 2.0);
      }
      break;
      case 4: /* mediumint */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 8.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 4.0);
      }
      break;
      case 5: /* integer */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 10.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0,5.0);
      }
      break;
      case 6: /* big integer */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 20.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0,5.0);
      }
      break;
      case 7: /* float */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 20.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 4.0);
	 fl_set_counter_bounds(it->f_createtable->fieldDecimals, 0.0, 4.0);
      }
      break;
      case 8: /* double */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 20.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 5.0);
	 fl_set_counter_bounds(it->f_createtable->fieldDecimals, 0.0, 8.0);
      }
      break;
      case 9: /* decimal */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 20.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 2.0);
	 fl_set_counter_bounds(it->f_createtable->fieldDecimals, 0.0, 8.0);
      }
      break;
      case 10: /* char */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 1.0, 255.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 5.0);
      }
      break;
      case 11: /* varchar */
      case 22: /* text */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 255.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 10.0);
      }
      break;
      case 12: /* tinyblob */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 255.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 10.0);
      }
      break;
      case 13: /* blob */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 65535.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 1024.0);
      }
      break;
      case 14: /* mediumblob */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 16777216.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1024.0, 10240.0);
      }
      break;
      case 15: /* longblob */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 4294967296.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1024.0, 10240.0);
      }
      break;
      case 16: /* timestamp */
      case 21: /* datetime */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 2.0, 14.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 2.0, 4.0);
      }
      break;
      case 17: /* date */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 0.0, 10.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 2.0);
      }
      break;
      case 18: /* time */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 0.0, 8.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 2.0);
      }
      break;
      case 19:  /* enum */
      case 20:  /* set  */
      {
	 fl_set_counter_bounds(it->f_createtable->fieldLength, 0.0, 80.0);
	 fl_set_counter_step(it->f_createtable->fieldLength, 1.0, 10.0);
      }
   }
}

void createtable_fieldlength(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->length = (long) fl_get_counter_value(obj);
  it->buff->decimales = (int) fl_get_counter_value(it->f_createtable->fieldDecimals);
  it->buff->keySize = (int) fl_get_counter_value(it->f_createtable->keySize);

  if(it->buff->decimales >= it->buff->length)
  {
    it->buff->decimales = (int) (it->buff->length - 1L);
    fl_set_counter_value(it->f_createtable->fieldDecimals, (double) it->buff->decimales);
  }
  if(it->buff->keySize > it->buff->length)
  {
    it->buff->keySize = (int) it->buff->length;
    fl_set_counter_value(it->f_createtable->keySize, (double) it->buff->keySize);
  }
}

void createtable_fielddecimals(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->length =   (long) fl_get_counter_value(it->f_createtable->fieldLength);
  it->buff->decimales = (int) fl_get_counter_value(it->f_createtable->fieldDecimals);
  if(it->buff->decimales > (int) (it->buff->length - 1L))
  {
    it->buff->length++;
    fl_set_counter_value(it->f_createtable->fieldLength, (double) it->buff->length);
  }
}
void createtable_fielddefault(FL_OBJECT *obj, long data)
{
   int lg;
   int invalid = 0;
   char string[512];
   char *pt;
   struct edittable *it;
   FD_createtable *fd;
   fd = (FD_createtable *) obj->form->fdui;
   it = (struct edittable *) fd->vdata;

   lg = strlen(fl_get_input(it->f_createtable->fieldDefault));
   if(lg > 0)
   {
      /* copie le string dans la memoire de travail */
      strcpy(string, fl_get_input(it->f_createtable->fieldDefault));
      /* le string de travail est limite a la longueur du champ */
      /* sauf pour l'enum et le set */
      if(lg > (int) it->buff->length && it->buff->type != 19 && it->buff->type != 20)
      {
	 string[it->buff->length] = '\0';
	 fl_set_input(it->f_createtable->fieldDefault, string);
      }

      /*-----------------------------------------------*/
      /* verifie si le defaut est valide selon le type */
      /*-----------------------------------------------*/
      pt = string;
      while(*pt)
      {
	 switch(it->buff->type)
	 {
	    case 2: /* tinyint */
	    case 3: /* smallint */
	    case 4: /* mediumint */
	    case 5: /* integer */
	    case 6: /* big integer */
	    {
	       if(it->buff->funsigned)
	       {
		  if(!isdigit(*pt)) invalid++;
	       }
	       else
	       {
		  if(!isdigit(*pt) && *pt != '-' && *pt != '+') invalid++;
	       }
	    }
	    break;
	    case 7: /* float */
	    case 8: /* double */
	    case 9: /* decimal */
	    {
	       if(!isdigit(*pt) && *pt != '-' && *pt != '+' && *pt != '.')
	       {
		  invalid++;
	       }
	    }
	    break;
	    case 10: /* char */
	    case 11: /* varchar */
	    case 12: /* tinyblob */
	    case 13: /* blob */
	    case 14: /* mediumblob */
	    case 15: /* longblob */
	    case 22: /* text */
	    it->buff->fdefault[0] = '\0';
	    string[0] = '\0';
	    fl_set_input(it->f_createtable->fieldDefault, string);
	    break;
	    case 16: /* timestamp */
	    case 21: /* datetime */
	    {
	       if(!isdigit(*pt) && *pt != '-' && *pt != ':') invalid++;
	    }
	    break;
	    case 17: /* date */
	    {
	       if(!isdigit(*pt) && *pt != '-') invalid++;
	    }
	    break;
	    case 18: /* time */
	    {
	       if(!isdigit(*pt) && *pt != ':') invalid++;
	    }
	    break;
	    case 19: /* enum */
	    case 20: /* set  */
	    {
	       if(*pt == '"' || *pt == '\'') invalid++;
	    }
	    break;
	 } /* endCase */
	 pt++;
      } /* endWhile */
      if(invalid)
      {
	 fl_set_input(it->f_createtable->fieldDefault, "");
      }
      else
      {
	 fl_set_input(it->f_createtable->fieldDefault, string);
	 strcpy(it->buff->fdefault, string);
	 it->buff->notNull = 1;
	 createtable_setactive(it);
      }
   } /* end if strlen > 0 */
   else
   {
      it->buff->fdefault[0] = '\0';
      string[0] = '\0';
      fl_set_input(it->f_createtable->fieldDefault, string);
   }
}
void createtable_notnull(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->notNull = (char) fl_get_button(obj);
}
void createtable_autoincrement(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->autoIncrement = (char) fl_get_button(obj);

  if(it->buff->autoIncrement == 1)
  {
    it->buff->keyType = 'P';
    fl_set_button(it->f_createtable->fieldPrimary, 1);
  }
  else
  {
    it->buff->keyType = '\0';
    fl_set_button(it->f_createtable->keyOnOff, 1);
  }
  createtable_setactive(it);
}

void createtable_callback(FL_OBJECT *obj, long data)
{
  ;
}
void createtable_multi(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->autoIncrement = '\0';
  fl_set_button(it->f_createtable->fieldAutoIncrement, 0);
  it->buff->keyType = 'M';
  createtable_setactive(it);
}
void createtable_unique(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->autoIncrement = '\0';
  fl_set_button(it->f_createtable->fieldAutoIncrement, 0);
  it->buff->keyType = 'U';
  createtable_setactive(it);
}
void createtable_primary(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->keyType = 'P';
  strcpy(it->buff->keyName, "PRIMARY");

  createtable_setactive(it);
}
void createtable_keysize(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->keySize = (int) fl_get_counter_value(obj);
  if(it->buff->keySize > (int) it->buff->length)
  {
    it->buff->keySize = it->buff->length;
    fl_set_counter_value(it->f_createtable->keySize, (double) it->buff->keySize);
  }
}
void createtable_zerofill(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->zeroFill = (char) fl_get_button(obj);
}

void createtable_unsigned(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->funsigned = (char) fl_get_button(obj);
  if(it->buff->funsigned && it->buff->fdefault[0])
  {
    if(it->buff->fdefault[0] == '-')
    {
      it->buff->fdefault[0] = '\0';
      fl_set_input(it->f_createtable->fieldDefault, "");
    }
  }
}

void createtable_keyname(FL_OBJECT *obj, long data)
{
  char nom[33];
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  strcpy(nom, fl_get_input(obj));
  trim(nom);

  /* si c'est le meme nom que le champ, refuse */
  if(!stricmp(nom, it->buff->name))
  {
    fl_set_input(obj, "");
  }

  /*-------------------------------------------------------*/
  /* verifie si le nom du champ est valide dans sa syntaxe */
  /*-------------------------------------------------------*/
  {
    char *p;
    p = nom;
    while(*p)
    {
      if(isspace(*p) || (ispunct(*p) && *p != '_') || iscntrl(*p))
      {
        fl_set_input(obj, it->buff->keyName);
        return;
      }
      p++;
    }
  }

  strcpy(it->buff->keyName, nom);

  /*----------------------------------------------*/
  /* si le nom du champ existe deja dans la liste */
  /* efface le nom                                */
  /*----------------------------------------------*/
  if(createtableKeyExist(it, nom))
  {
    fl_set_input(obj, "");
    it->buff->keyName[0] = '\0';
    return;
  }
}

void createtable_keyOnOff(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  it->buff->autoIncrement = '\0';
  fl_set_button(it->f_createtable->fieldAutoIncrement, 0);
  it->buff->keyType = '\0';
  it->buff->keyName[0] = '\0';
  fl_set_input(it->f_createtable->keyName, "");
  createtable_setactive(it);
}

void createtable_addfield(FL_OBJECT *obj, long data)
{
  int item = 1;
  struct fields *cur;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /*------------------------------------------------*/
  /* si le nom du champ courant != nom dans l'input */
  /* process l'input                                */
  /*------------------------------------------------*/
  if(strcmp(it->buff->name, fl_get_input(it->f_createtable->fieldName)))
  {
    createtable_fieldname(it->f_createtable->fieldName, 0L);
  }
  /*--------------------------------------------------*/
  /* si le nom de la clee courant != nom dans l'input */
  /* process l'input                                  */
  /*--------------------------------------------------*/
  if(strcmp(it->buff->keyName, fl_get_input(it->f_createtable->keyName)))
  {
    createtable_keyname(it->f_createtable->keyName, 0L);
  }
  /*----------------------------------------------------------*/
  /* si le nom de la valeur par defaut != valeur dans l'input */
  /* process l'input                                          */
  /*----------------------------------------------------------*/
  if(it->buff->fdefault[0])
  {
    if(strcmp(it->buff->fdefault, fl_get_input(it->f_createtable->fieldDefault)))
    {
      createtable_fielddefault(it->f_createtable->fieldDefault, 0L);
    }
  }

  /*----------------------------*/
  /* le nom du champ est requis */
  /*----------------------------*/
  if(!it->buff->name[0])
  {
    fl_show_alert("Column name is required","","",1);
    return;
  }
  /*-----------------------------------------------*/
  /* si le champ est indexe et pas de nom d'index, */
  /* le programme en genere un                     */
  /*-----------------------------------------------*/
  if(it->buff->keyType && !it->buff->keyName[0])
  {
    sprintf(it->buff->keyName, "k_%s", it->buff->name);
    fl_set_input(it->f_createtable->keyName, it->buff->keyName);
  }

  /*-----------------------------------------------*/
  /* si le nom de la clee existe deja              */
  /* abandonne la creation                         */
  /*-----------------------------------------------*/
  if(it->buff->keyName[0])
  {
    cur = it->firstf;
    while(cur)
    {
      if(!stricmp(it->buff->keyName, cur->keyName))
      {
        fl_show_alert("This key name already exist in another column",
                      it->buff->keyName,
                      "Correct the key name and retry",
                      0);
        return;
      }
      cur = cur->next;
    }
  }

  /*-----------------------------------------------*/
  /* si le nom du champ existe deja dans la liste, */
  /* offre de le modifier                          */
  /*-----------------------------------------------*/
  cur = it->firstf;
  while(cur)
  {
    if(!stricmp(it->buff->name, cur->name))
    {
      break;
    }
    item++;
    cur = cur->next;
  }

  /* le nom du champ est dans la liste ou le browser */
  if(cur)
  {
    if(fl_show_question("A column with that name already exist.\nDo you want to modify it?\n(Otherwise i will abort the creation)",
                        0) == 0)
    {
      return;
    }
    else
    {
      /* modifie le champ */
      fl_select_browser_line(it->f_createtable->browserFields, item);
      createtable_modfield(obj, data);
      return;
    }
  }


  if(!it->buff->keyType || it->buff->length == (long) it->buff->keySize)
  {
     it->buff->keySize = 0;
  }

  /*---------------------------------------------*/
  /* si 16 clees existent, empeche nouvelle clee */
  /*---------------------------------------------*/
  if(it->ct->qtKeys >= 16)
  {
    it->buff->keyType = '\0';
    it->buff->keySize = 0;
    it->buff->keyName[0] = '\0';
    it->buff->autoIncrement = '\0';
  }
  else
  {
    /*-----------------------------------------------------*/
    /* si deja un clee primaire, transforme en clee unique */
    /*-----------------------------------------------------*/
    if(it->ct->primary && it->buff->keyType == 'P')
    {
      it->buff->keyType = 'U';
      it->buff->autoIncrement = '\0';
    }
  }

  createtable_varToObj(it);


  /*-------------------------------*/
  /* ajoute le champ dans la liste */
  /*-------------------------------*/
  cur = (struct fields *) calloc(1, sizeof(struct fields));
  if(!it->firstf)
  {
    it->firstf = it->lastf = cur;
  }
  else
  {
    it->lastf->next = cur;
    cur->prev = it->lastf;
    it->lastf = cur;
  }

  /*--------------------------------*/
  /* copie les informations saisies */
  /*--------------------------------*/
  createtable_copyfield(cur, it->buff);
  cur->index = 1000;
  
  /*---------------------------------------------------*/
  /* reload le browser et selectionne le dernier champ */
  /*---------------------------------------------------*/
  createtable_setFieldBrowser(it);
  fl_select_browser_line(it->f_createtable->browserFields, fl_get_browser_maxline(it->f_createtable->browserFields));
  createtable_setCT(it);
  createtable_setactive(it);
}
void createtable_modfield(FL_OBJECT *obj, long data)
{
  int index;
  int indexCur;
  struct fields *cur, *bcur, *bbuf, *scan;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_createtable->browserFields);
  indexCur = 1;

  cur = it->firstf;
  while(cur && indexCur < index)
  {
    indexCur++;
    cur = cur->next;
  }

  if(!cur) return;

  /*-----------------------------------------*/
  /* prend un backup de l'information de cur */
  /* et de it->buff                    */
  /*-----------------------------------------*/
  bcur = (struct fields *) calloc(1, sizeof(struct fields));
  bbuf = (struct fields *) calloc(1, sizeof(struct fields));
  memcpy(bcur, cur, sizeof(struct fields));
  memcpy(bbuf, it->buff, sizeof(struct fields));

  /*--------------------------------------*/
  /* efface l'information pointee par cur */
  /* afin de faire le bon compte setCT    */
  /*--------------------------------------*/
  cur->name[0] = '\0';
  cur->keyName[0] = '\0';
  createtable_setCT(it);

  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /* verifie si la fiche modifiee est valide */
  /*-----------------------------------------*/
  /*-----------------------------------------*/
  /*------------------------------------------------*/
  /* si le nom du champ courant != nom dans l'input */
  /* process l'input                                */
  /*------------------------------------------------*/
  if(strcmp(it->buff->name, fl_get_input(it->f_createtable->fieldName)))
  {
    createtable_fieldname(it->f_createtable->fieldName, 0L);
  }

  /*--------------------------------------------------*/
  /* si le nom de la clee courant != nom dans l'input */
  /* process l'input                                  */
  /*--------------------------------------------------*/
  if(strcmp(it->buff->keyName, fl_get_input(it->f_createtable->keyName)))
  {
    createtable_keyname(it->f_createtable->keyName, 0L);
  }

  /*----------------------------------------------------------*/
  /* si le nom de la valeur par defaut != valeur dans l'input */
  /* process l'input                                          */
  /*----------------------------------------------------------*/
  if(it->buff->fdefault[0])
  {
    if(strcmp(it->buff->fdefault, fl_get_input(it->f_createtable->fieldDefault)))
    {
      createtable_fielddefault(it->f_createtable->fieldDefault, 0L);
    }
  }

  /*----------------------------*/
  /* le nom du champ est requis */
  /*----------------------------*/
  if(!it->buff->name[0])
  {
    fl_show_alert("Column name is required","","",1);
    memcpy(cur, bcur, sizeof(struct fields));
    memcpy(it->buff, bbuf, sizeof(struct fields));
    free(bcur);
    free(bbuf);
    createtable_setCT(it);
    return;
  }


  /*-----------------------------------------------*/
  /* si le champ est indexe et pas de nom d'index, */
  /* le programme en genere un                     */
  /*-----------------------------------------------*/
  if(it->buff->keyType && !it->buff->keyName[0])
  {
    sprintf(it->buff->keyName, "k_%s", it->buff->name);
    fl_set_input(it->f_createtable->keyName, it->buff->keyName);
  }


  /*-----------------------------------------------*/
  /* si le nom de la clee existe deja              */
  /* abandonne la creation                         */
  /*-----------------------------------------------*/
  if(it->buff->keyName[0])
  {
    scan = it->firstf;
    while(scan)
    {
      if(!stricmp(it->buff->keyName, scan->keyName))
      {
        fl_show_alert("This key name already exist in another column",
                      it->buff->keyName,
                      "Correct the key name and retry",
                      0);

        memcpy(cur, bcur, sizeof(struct fields));
        memcpy(it->buff, bbuf, sizeof(struct fields));
        free(bcur);
        free(bbuf);
        createtable_setCT(it);
        return;
      }
      scan = scan->next;
    }
  }

  /*-----------------------------------------------*/
  /* si le nom du champ existe deja dans la liste, */
  /* offre de le modifier                          */
  /*-----------------------------------------------*/
  scan = it->firstf;
  while(scan)
  {
    if(!stricmp(it->buff->name, scan->name))
    {
      break;
    }
    scan = scan->next;
  }

  /* le nom du champ est dans la liste ou le browser */
  if(scan)
  {
    fl_show_alert("This column name already exist in another column",
                  it->buff->name,
                  "Correct the column name and retry",
                  0);
    memcpy(cur, bcur, sizeof(struct fields));
    memcpy(it->buff, bbuf, sizeof(struct fields));
    free(bcur);
    free(bbuf);
    createtable_setCT(it);
    return;
  }


  if(!it->buff->keyType || it->buff->length == (long) it->buff->keySize)
  {
     it->buff->keySize = 0;
  }

  /*---------------------------------------------*/
  /* si 16 clees existent, empeche nouvelle clee */
  /*---------------------------------------------*/
  if(it->ct->qtKeys >= 16)
  {
    it->buff->keyType = '\0';
    it->buff->keySize = 0;
    it->buff->keyName[0] = '\0';
    it->buff->autoIncrement = '\0';
  }
  else
  {
    /*-----------------------------------------------------*/
    /* si deja un clee primaire, transforme en clee unique */
    /*-----------------------------------------------------*/
    if(it->ct->primary && it->buff->keyType == 'P')
    {
      it->buff->keyType = 'U';
      it->buff->autoIncrement = '\0';
    }
  }


  /*-------------------------------*/
  /* tout est ok, modifie l'entree */
  /*-------------------------------*/
  createtable_copyfield(cur, it->buff);
  free(bcur);
  free(bbuf);

  createtable_varToObj(it);
  createtable_setFieldBrowser(it);
  createtable_setCT(it);
  fl_select_browser_line(it->f_createtable->browserFields, indexCur);
  createtable_setactive(it);
}

void createtable_delfield(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct fields *cur, *cp, *cn;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_createtable->browserFields);
  i = 1;

  cur = it->firstf;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /*------------------------------*/
  /* detache le champ de la liste */
  /*------------------------------*/
  cp = cur->prev;
  cn = cur->next;
  if(!cn && !cp)
  {
    it->firstf = it->lastf = NULL;
  }
  else
  {
    if(!cn)
    {
      cp->next = NULL;
      it->lastf = cp;
    }
    else
    {
      if(!cp)
      {
        cn->prev = NULL;
        it->firstf = cn;
      }
      else
      {
        cn->prev = cp;
        cp->next = cn;
      }
    }
  }

  /* efface l'element de la liste */
  free(cur);

  /* efface l'affichage courant de l'element */
  memset(it->buff, '\0', sizeof(struct fields));

  createtable_varToObj(it);
  createtable_setFieldBrowser(it);
  createtable_setCT(it);
  createtable_setactive(it);

}

extern void start_ccompound(struct edittable *it);
void createtable_compoundkeymode(FL_OBJECT *obj, long data)
{
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  g_deactivate_object(it->f_createtable->fieldmode);
  g_deactivate_object(it->f_createtable->tableName);
  g_deactivate_object(it->f_createtable->exit);
  g_deactivate_object(it->f_createtable->choiceDbf);
  start_ccompound(it);
}

void createtable_createtable(FL_OBJECT *obj, long data)
{
  struct fields *cur;
  char *sql;
  char str[512];
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  sql = (char *) malloc(16384);
  if(!sql)
  {
    fl_show_alert("Out of memory error","","",1);
    return;
  }

  sql[0] = '\0';
  sprintf(sql, "create table %s (\n", it->ct->table);

  /*------------------------------*/
  /* boucle de creation des champs*/
  /*------------------------------*/
  cur = it->firstf;
  while(cur)
  {
    /*****  nom du champ *****/
    strcat(sql, cur->name);
    strcat(sql, " ");

    /*****  type de champ *****/
    strcat(sql, createtable_indexToType(cur->type));

    /***** longueur du champ *****/
    if(cur->type != 12 && cur->type != 13 && cur->type != 14 && cur->type != 15 
       && cur->type != 17 && cur->type != 18 && cur->type != 21 && cur->type != 22
       && cur->type != 19 && cur->type != 20)
    {
      strcat(sql, "(");
      sprintf(str, "%ld", cur->length);
      strcat(sql,str);

      if(cur->decimales)
      {
	sprintf(str, ",%d) ",cur->decimales);
	strcat(sql, str);
      }
      else
      {
	strcat(sql, ") ");
      }
    }
    else
    {
      strcat(sql, " ");
    }


    /* definition pour enum et set */
    if(cur->fdefault[0] && (cur->type == 19 || cur->type == 20))
    {
       int i = 0;
       char *pt;

       strcat(sql, "(");
       /* place les mots du champs defaut dans la liste enum ou set */
       while((pt = getSSubstr(cur->fdefault, ",'() ", i)))
       {
	  if(!pt || pt[0] == '\0') break;
	  i++;
	  strcat(sql, "'");
	  strcat(sql, pt);
	  strcat(sql, "',");
       }
       sql[strlen(sql) - 1] = ')';
       strcat(sql, " ");
    }

    /**** unsigned *****/
    if(cur->funsigned)
    {
      strcat(sql, "unsigned ");
    }

    /***** zero fill *****/
    if(cur->zeroFill)
    {
      strcat(sql, "zerofill ");
    }

    /***** null ou not null *****/
    if(cur->notNull)
    {
      strcat(sql, "not null ");
    }
    else
    {
      strcat(sql, "null ");
    }

    /***** default, valeur par defaut du champ *****/
    if(cur->fdefault[0] && cur->type != 19 && cur->type != 20)
    {
      strcat(sql, "default ");
      strcat(sql, cur->fdefault);
      strcat(sql, " ");
    }

    /***** si auto increment *****/
    if(cur->autoIncrement)
    {
      strcat(sql, "auto_increment primary key");
    }

    /***** champs separes par une virgule et un newline *****/
    if(cur->next)
    {
      strcat(sql, ",\n");
    }

    cur = cur->next;
  }
  /*------------------------------*/
  /* boucle de creation des index */
  /*------------------------------*/
  if(it->ct->qtKeys > 1 || (!it->ct->primary && it->ct->qtKeys))
  {

    cur = it->firstf;
    while(cur)
    {
      /***** si clee indiquee et sans autoincrement *****/
      if(cur->keyType && !cur->autoIncrement)
      {
        strcat(sql, ",\n");
        switch(cur->keyType)
        {
        case 'M': /* multi key */
        {
          strcat(sql, "index ");
        }
        break;
        case 'U': /* index unique */
        {
          strcat(sql, "unique ");
        }
        }

        strcat(sql, cur->keyName);
        strcat(sql, "(");
        strcat(sql, cur->name);
        if(cur->keySize)
        {
          sprintf(str, "(%d)) ", cur->keySize);
          strcat(sql, str);
        }
        else
        {
          strcat(sql, ") ");
        }
      }

      cur = cur->next;
    }
  }

  /*---------------------------------------*/
  /* boucle de creation des index composes */
  /*---------------------------------------*/
  {
    struct compoundkey *ck;
    struct partkey *pk;
    int qt;
    struct fields *fd;
    
    ck = it->firstc;
    while(ck)
    {
      /* verifie si au moins deux champs dans les parties */
      qt = 0;
      pk = ck->first;
      while(pk)
      {
	qt++;
	pk = pk->next;
      }
      
      /* si compound key valide */
      if(qt > 1)
      {
        strcat(sql, ",\n");
        switch(ck->type)
        {
        case 'M': /* multi key */
        {
          strcat(sql, "index ");
        }
        break;
        case 'U': /* index unique */
        {
          strcat(sql, "unique ");
        }
	break;
	case 'P': /* primary key */
	{
	  strcat(sql, "primary key ");
        }
	} /* end case */
	

	strcat(sql, ck->nom);
	strcat(sql, "(");
      
	pk = ck->first;
	while(pk)
	{
	  strcat(sql, pk->nomField);
	  fd = ccomkey_fieldIndex(it, pk->nomField);

	  if(pk->size && pk->size != (int) fd->length )
	  {
	    sprintf(str, "(%d)", pk->size);
	    strcat(sql, str);
	  }
	  if(pk->next)
	  {
	    strcat(sql, ",");
	  }
	  pk = pk->next;
	}
	strcat(sql, ")");
      } /* endif qt > 1 */
      
      ck = ck->next;
    }
  }
  
  
  strcat(sql, ")\n");

  /*---------------------------------------------------------*/
  /* creation de la table en envoyant la commande au serveur */
  /*---------------------------------------------------------*/
  {
    MYSQL connection;
    if(g_mysql_connect(&connection, Setup.host, Setup.user, Setup.password))
    {
      MYSQL_RES *result;
      char *error;
      
      mysql_select_db(&connection, it->ct->database);
      if(!mysql_query(&connection, sql))
      {
	result = mysql_store_result(&connection);
	mysql_free_result(result);
	fl_show_message("Success!", it->ct->table, "has been created.");
      }
      else
      {
	error = mysql_error(&connection);
	fl_show_alert(error, "on creation of", it->ct->table, 1);
      }
      mysql_close(&connection);

    }
  }

  free(sql);
}

void createtable_switchup(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct fields *cur;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_createtable->browserFields);
  i = 1;

  cur = it->firstf;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct fields *cp, *cn, *cpp;

    cp = cur->prev;
    cpp= cur->prev->prev;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cn)
    {
      cn->prev = cp;
    }
    else
    {
      it->lastf = cp;
    }
    cp->next = cn;

    /* rattache courant */
    cur->next = cp;
    cur->prev = cpp;
    cp->prev = cur;
    if(cpp)
    {
      cpp->next = cur;
    }
    else
    {
      it->firstf = cur;
    }
  }

  createtable_setFieldBrowser(it);
  index--;
  fl_select_browser_line(it->f_createtable->browserFields, index);
  createtable_setactive(it);

}
void createtable_switchdown(FL_OBJECT *obj, long data)
{
  int index;
  int i;
  struct fields *cur;
  struct edittable *it;
  FD_createtable *fd;
  fd = (FD_createtable *) obj->form->fdui;
  it = (struct edittable *) fd->vdata;

  /* trouve la position dans la liste */
  index = fl_get_browser(it->f_createtable->browserFields);
  i = 1;

  cur = it->firstf;
  while(cur && i < index)
  {
    i++;
    cur = cur->next;
  }

  if(!cur) return;

  /* effectue le deplacement */
  {
    struct fields *cp, *cn, *cnn;

    cp = cur->prev;
    cnn= cur->next->next;
    cn = cur->next;

    /* rarrache precedent avec suivant */
    if(cp)
    {
      cp->next = cn;
    }
    else
    {
      it->firstf = cn;
    }
    cn->prev = cp;

    /* rattache courant */
    cur->next = cnn;
    cur->prev = cn;
    cn->next = cur;
    if(cnn)
    {
      cnn->prev = cur;
    }
    else
    {
      it->lastf = cur;
    }
  }

  createtable_setFieldBrowser(it);
  index++;
  fl_select_browser_line(it->f_createtable->browserFields, index);
  createtable_setactive(it);
}


void createtable_setFieldBrowser(struct edittable *it)
{
  char *string;
  char *temp;
  char fNameType[31];
  struct fields *cur;

  fl_freeze_form(it->f_createtable->createtable);


  if(fl_get_browser_maxline(it->f_createtable->browserFields))
    fl_clear_browser(it->f_createtable->browserFields);

  string = (char *) malloc(2048);
  temp   = (char *) malloc(256);

  /*---------------------------*/
  /* format du nom et du type  */
  /*---------------------------*/
  {
    int lg, lgName, lgType, lglg;
    cur = it->firstf;
    lgName = lgType = lglg = 0;
    while(cur)
    {
      lg = strlen(cur->name);
      if(lg > lgName) lgName = lg;
      lg = strlen(createtable_indexToType(cur->type));
      if(lg > lgType) lgType = lg;
      sprintf(temp,"%ld", cur->length);
      lg = strlen(temp);
      if(lg > lglg) lglg = lg;
      cur = cur->next;
    }
    sprintf(fNameType, "%c%ds|%c%ds(%c%dd", '%',lgName,'%',lgType, '%',lglg);
  }

  cur = it->firstf;
  while(cur)
  {
    sprintf(string, fNameType, cur->name,
            createtable_indexToType(cur->type), cur->length);

    if(cur->decimales)
    {
      sprintf(temp, ",%d)|", cur->decimales);
      strcat(string,temp);
    }
    else
    {
      strcat(string, ")  |");
    }

    if(cur->notNull)
    {
      strcat(string, "not");
    }
    else
    {
      strcat(string, "   ");
    }
    strcat(string, " null|");

    {
      char size[12];
      if(cur->keySize)
      {
        sprintf(size, "(%3d) ", cur->keySize);
      }
      else
      {
        strcpy(size, "      ");
      }
      switch(cur->keyType)
      {
      case 'P': strcat(string, "primary "); strcat(string, size); break;
      case 'U': strcat(string, " unique "); strcat(string, size); break;
      case 'M': strcat(string, "  multi "); strcat(string, size); break;
      default : strcat(string, "        "); strcat(string, size);
      }
    }
    if(cur->autoIncrement)
    {
      strcat(string, "autoIncrement|");
    }
    else
    {
      strcat(string, "             |");
    }
    if(cur->funsigned)
    {
      strcat(string, "unsigned, ");
    }
    else
    {
      strcat(string, "          ");
    }
    if(cur->zeroFill)
    {
      strcat(string, "zero fill|");
    }
    else
    {
      strcat(string, "         |");
    }

    if(cur->keyName[0])
    {
      strcat(string, "key name:");
      strcat(string, cur->keyName);
    }
    if(cur->fdefault[0])
    {
      strcat(string, " default:");
      strcat(string, cur->fdefault);
    }

    fl_addto_browser(it->f_createtable->browserFields, string);

    cur = cur->next;
  }

  fl_unfreeze_form(it->f_createtable->createtable);
  free(string); free(temp);
}

char *createtable_indexToType(int type)
{
  switch(type)
  {
     case 2:  return "tinyint";
     case 3:  return "smallint";
     case 4:  return "mediumint";
     case 5:  return "integer";
     case 6:  return "bigint";
     case 7:  return "float";
     case 8:  return "double";
     case 9:  return "decimal";
     case 10: return "char";
     case 11: return "varchar";
     case 12: return "tinyblob";
     case 13: return "blob";
     case 14: return "mediumblob";
     case 15: return "longblob";
     case 16: return "timestamp";
     case 17: return "date";
     case 18: return "time";
     case 19: return "enum";
     case 20: return "set";
     case 21: return "datetime";
     case 22: return "text";
     default: return "* ERROR *";
  } /* endCase */
}

int createtable_typeToIndex(char *type)
{
  if(!stricmp(type, "tinyint"))    return 2;
  if(!stricmp(type, "smallint"))   return 3;
  if(!stricmp(type, "mediumint"))  return 4;
  if(!stricmp(type, "integer"))    return 5;
  if(!stricmp(type, "int"))        return 5;
  if(!stricmp(type, "bigint"))     return 6;
  if(!stricmp(type, "float"))      return 7;
  if(!stricmp(type, "real"))       return 7;
  if(!stricmp(type, "double"))     return 8;
  if(!stricmp(type, "decimal"))    return 9;
  if(!stricmp(type, "char"))       return 10;
  if(!stricmp(type, "varchar"))    return 11;
  if(!stricmp(type, "tinyblob"))   return 12;
  if(!stricmp(type, "blob"))       return 13;
  if(!stricmp(type, "mediumblob")) return 14;
  if(!stricmp(type, "longblob"))   return 15;
  if(!stricmp(type, "timestamp"))  return 16;
  if(!stricmp(type, "date"))       return 17;
  if(!stricmp(type, "time"))       return 18;
  if(!stricmp(type, "enum"))       return 19;
  if(!stricmp(type, "set"))        return 20;
  if(!stricmp(type, "datetime"))   return 21;
  if(!stricmp(type, "text"))       return 22;

  return 0;
}

/*------------------------------------------------------------*/
/* place les champs et bouttons selon la valeur des variables */
/* pour le groupe fields                                      */
/*------------------------------------------------------------*/
void createtable_varToObj(struct edittable *it)
{
   fl_freeze_form(it->f_createtable->createtable);
   createtable_setBounds(it);

   if(!it->buff->name)
   {
      fl_set_input(it->f_createtable->fieldName, "");
   }
   else
   {
      fl_set_input(it->f_createtable->fieldName, it->buff->name);
   }
   if(!it->buff->type)
   {
      it->buff->type = 1;
   }
   fl_set_choice(it->f_createtable->fieldType, it->buff->type);

   fl_set_counter_value(it->f_createtable->fieldLength, (double) it->buff->length);
   fl_set_counter_value(it->f_createtable->fieldDecimals, (double) it->buff->decimales);
   if(it->buff->fdefault[0])
   {
      fl_set_input(it->f_createtable->fieldDefault, it->buff->fdefault);
   }
   else
   {
      fl_set_input(it->f_createtable->fieldDefault, "");
   }
   fl_set_button(it->f_createtable->fieldNotNull, (int) it->buff->notNull);
   fl_set_button(it->f_createtable->fieldAutoIncrement, (int) it->buff->autoIncrement);
   fl_set_button(it->f_createtable->fieldZeroFill, (int) it->buff->zeroFill);
   fl_set_button(it->f_createtable->fieldUnsigned, (int) it->buff->funsigned);
   switch(it->buff->keyType)
   {
      case 'P': fl_set_button(it->f_createtable->fieldPrimary, 1); break;
      case 'U': fl_set_button(it->f_createtable->fieldUnique, 1);  break;
      case 'M': fl_set_button(it->f_createtable->fieldMulti, 1);   break;
      default : fl_set_button(it->f_createtable->keyOnOff, 1);     break;
   }

   fl_set_counter_value(it->f_createtable->keySize, (double) it->buff->keySize);
   fl_set_input(it->f_createtable->keyName, it->buff->keyName);
   fl_unfreeze_form(it->f_createtable->createtable);
}


