#ifndef ILUGSSNS_ANONYMOUS_H
#define ILUGSSNS_ANONYMOUS_H

/*
 * ilugssns_anonymous.h -- internal data structures for representing GSS anonymous names
 */

/* OID is {2(joint-iso-ccitt) 16(country) 840(US(ANSI)) 1(organizations) 113687(OpenVision) 1(security) 2(nametypes) 1(anonymous-name)} */

#define ILUGSSNS_ANONYMOUS_OID	{10, "\x60\x86\x48\x01\x86\xf8\x17\x01\x02\x01"}

extern gss_OID_desc ilugssns_anonymous_OID[];

/* initialize routine: */
void ilugssns_anonymous_initialize(void);

/* fetch the only name in the namespace */
gss_name_t ilugssns_anonymous_default_name(void);

#endif /* ndef ILUGSSNS_RFC822_H */
