/********************************************************************************
* Copyright (c) Erik Kunze 1996 - 1998
*
* Permission to use, distribute, and sell this software and its documentation
* for any purpose is hereby granted without fee, provided that the above
* copyright notice appear in all copies and that both that copyright notice and
* this permission notice appear in supporting documentation, and that the name
* of the copyright holder not be used in advertising or publicity pertaining to
* distribution of the software without specific, written prior permission.  The
* copyright holder makes no representations about the suitability of this
* software for any purpose.  It is provided "as is" without express or implied
* warranty. THE CODE MAY NOT BE MODIFIED OR REUSED WITHOUT PERMISSION!
*
* THE COPYRIGHT HOLDER DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
* INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
* EVENT SHALL THE COPYRIGHT HOLDER BE LIABLE FOR ANY SPECIAL, INDIRECT OR
* CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
* DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
* TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
* PERFORMANCE OF THIS SOFTWARE.
*
* Author: Erik Kunze
*******************************************************************************/
#ifdef HAVE_CONFIG_H
# include "config.h"
#endif
#if defined(HPUX) && !defined(NAS_AUDIO) && !defined(OSS_AUDIO)
#ifndef lint
static char rcsid[] = "$Id: hpux.c,v 1.3 1999/03/16 11:35:38 erik Rel $";
#endif
#include <sys/types.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <signal.h>
#include <sys/audio.h>
#include "debug.h"
#include "resource.h"
#include "util.h"
#include "audio.h"
#define SOUND_BUFSIZE_BITS	7
#define SOUND_NUM_OF_BUFS	16
static int audioFd = -1;
static sigset_t blockingSet;
int
OsdOpenAudioDevice(char *device, int sample)
{
int i;
if ((audioFd = open(device, O_WRONLY | O_NONBLOCK)) < 0)
{
Msg(M_PERR, "couldn't open audio device <%s> for writing", device);
return -1;
}
if (ioctl(audioFd, AUDIO_SET_DATA_FORMAT, AUDIO_FORMAT_LINEAR8BIT) < 0)
{
Msg(M_PERR, "couldn't set sample resolution to 8 bit");
goto error;
}
if (ioctl(audioFd, AUDIO_SET_SAMPLE_RATE, sample) < 0)
{
Msg(M_PERR, "couldn't set sample rate to %d Hz", sample);
goto error;
}
if (ioctl(audioFd, AUDIO_SET_CHANNELS, 1) < 0)
{
Msg(M_PERR, "couldn't set mono output");
goto error;
}
i = (1 << SOUND_BUFSIZE_BITS) * SOUND_NUM_OF_BUFS;
if (ioctl(audioFd, AUDIO_SET_TXBUFSIZE, &i) < 0)
{
Msg(M_PERR, "couldn't setbuffer size to %d bytes", i);
goto error;
}
sigemptyset(&blockingSet);
sigaddset(&blockingSet, SIGALRM);
return i;
error:
(void)close(audioFd);
audioFd = -1;
return -1;
}
void
OsdCloseAudioDevice(void)
{
if (audioFd != -1)
{
(void)close(audioFd);
audioFd = -1;
}
}
int
OsdDrainAudioDevice(void)
{
return 0;
}
size_t
OsdGetAudioFreespace(void)
{
struct audio_status astat;
if (ioctl(audioFd, AUDIO_GET_STATUS, &astat) < 0)
{
Msg(M_PERR, "couldn't get audio freespace");
return (size_t)-1;
}
return (size_t)astat.transmit_buffer_count;
}
size_t
OsdPlayAudioBuffer(unsigned char *buf, size_t len)
{
sigset_t oldSet;
size_t written, remain;
(void)sigprocmask(SIG_BLOCK, &blockingSet, &oldSet);
for  (remain = len; remain; remain -= written)
{
if ((written = write(audioFd, buf, len)) < 0)
{
Msg(M_PERR, "couldn't write to audio device");
break;
}
}
if (!sigismember(&oldSet, SIGALRM))
{
(void)sigprocmask(SIG_UNBLOCK, &blockingSet, NULL);
}
return (len - remain);
}
#endif
