/* $Id: lock.c,v 1.4 1996/10/15 08:42:31 proff Exp
 * $Copyright$
 */

#include "nglobal.h"
#include "lock.h"

EXPORT int lockex (int fd)
{
	int ret;
#ifdef LOCK_EX
	ret = flock (fd, LOCK_EX);
#else
#ifdef F_LOCK
	ret = lockf (fd, F_LOCK, 0);
#else
#error no locking style for this system
#endif
#endif
	return ret;
}

EXPORT int locksh (int fd)
{
	int ret;
#ifdef LOCK_EX
	ret = flock (fd, LOCK_SH);
#else
#ifdef F_LOCK
	ret = lockf (fd, F_LOCK, 0);
#else
#error no locking style for this system
#endif
#endif
	return ret;
}

EXPORT int lockun (int fd)
{
	int ret;
#ifdef LOCK_UN
	ret = flock (fd, LOCK_UN);
#else
#ifdef F_ULOCK
	ret = lockf (fd, F_ULOCK, 0);
#else
#error no locking style for this system
#endif
#endif
	return ret;
}
