/*
 * proxy_unix.c
 * Written by Michael Kellner
 * Copyright 1999 by Apple Computer, Inc., all rights reserved.
 *
 * $Log: /StreamingServers/proxy3/proxy_unix/proxy_unix.c $
		
		5     4/2/99 6:20 PM Mike Kellner
		check_ip_cache => check_IP_cache
		
		4     4/2/99 2:50 PM Mike Kellner
		name_to_ip_num now takes a return parameter and and async request. Do
		Async name resolution.
		
		3     3/5/99 12:50 PM Mike Kellner
		Add get_local_address
		
		2     3/1/99 11:09 AM Mike Kellner
		added term_network
		
		1     2/26/99 10:37 AM Mike Kellner
		Adding subproject 'proxy3' to '$/StreamingServers'
		
		8     2/19/99 4:13 PM Mike Kellner
		don't exit if we can't resolve the name
		
		7     2/17/99 1:46 PM Mike Kellner
		add textual support for ui
		
		6     2/17/99 10:48 AM Mike Kellner
		add status display
		
		5     2/16/99 10:52 AM Mike Kellner
		change win32 to WIN32
		
		4     2/15/99 2:20 PM Mike Kellner
		use more plat independent stuff for error checking
		
		3     2/12/99 2:49 PM Mike Kellner
		compile and run on unix
		
		2     2/12/99 11:46 AM Mike Kellner
		split out platform specific code
 *
 */
 
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/time.h>

#include <netinet/in.h>
#include <netdb.h>

#include <sys/resource.h>
#include <sys/signal.h>
#include <sys/socket.h>

#include "util.h"
#include "proxy_plat.h"

#include "pthread.h"

char *gConfigFilePath = "/etc/qts_proxy.conf";
char *gOptionsString = "-c:-p:-d-v-h-s";
char gOptionsChar = '-';

extern int gMaxPorts;
/**********************************************/
int init_network() {
}

/**********************************************/
#define kKILL_THREAD -3
int term_network() {
	int	send = kKILL_THREAD;
	name_to_ip_num("", &send, true);
}

/**********************************************/
typedef struct ghpb_rec {
	char	name[256];
	int		*result;
} ghpb_rec, *ghpb;

void *gethostthread(void *param) {
	struct hostent *hent;
	ghpb	pb = (ghpb)param;
	int		id;
	pthread_t	tid;

	if (*pb->result == kKILL_THREAD)
		exit(0);
	tid = pthread_self();
again:
	hent = gethostbyname(pb->name);
	if (hent == NULL) {
		if (h_errno == TRY_AGAIN)
			goto again;
		*pb->result = -1;
//		pthread_kill(tid, 0);
		pthread_exit(NULL);
	}
	id = ntohl(*(long*)(hent->h_addr_list[0]));
	*pb->result = id;
	free(pb);
//	pthread_kill(tid, 0);
	pthread_exit(NULL);

}
/**********************************************/
int name_to_ip_num(char *name, int *ip, int async)
{
	int	ret;
	ghpb pb = NULL;
	pthread_t	tid;
	struct hostent *hent;
	
	if (check_IP_cache(name, &ret) != -1)
		{
		*ip = ret;
		return 0;
		}

	if (async) {
		*ip = kPENDING_ADDRESS;
		pb = (ghpb)malloc(sizeof(ghpb_rec));
		strcpy(pb->name, name);
		pb->result = ip;
		pthread_create(&tid, NULL, gethostthread, (void*)pb);
		pthread_detach(tid);
		return 1;
	}

again:
	hent = gethostbyname(name);
	if (hent == NULL) {
		if (h_errno == TRY_AGAIN)
			goto again;
		add_to_IP_cache(name, -1);
		return -1;
	}
	*ip = ntohl(*(long*)(hent->h_addr_list[0]));
	add_to_IP_cache(name, *ip);
	return 0;
}


/**********************************************/
int get_remote_address(int skt, int *port) {
#if !defined(sparc) && !defined(SGI) && !defined(WIN32)
	unsigned
#endif
		int nAddrSize = sizeof(struct sockaddr_in);
	struct sockaddr_in  remAddr;
	int  status;
	remAddr.sin_addr.s_addr = INADDR_ANY;
	status = getpeername(skt, (struct sockaddr*)&remAddr, &nAddrSize);
	if (status >= 0) {
		if (port)
			*port = ntohs(remAddr.sin_port);
		return ntohl(remAddr.sin_addr.s_addr);
	}
	return -1;
}

/**********************************************/
int get_local_address(int skt, int *port) {
#if !defined(sparc) && !defined(SGI) && !defined(WIN32)
	unsigned
#endif
		int nAddrSize = sizeof(struct sockaddr_in);
	struct sockaddr_in  remAddr;
	int  status;
	remAddr.sin_addr.s_addr = INADDR_ANY;
	status = getsockname(skt, (struct sockaddr*)&remAddr, &nAddrSize);
	if (status >= 0) {
		if (port)
			*port = ntohs(remAddr.sin_port);
		return ntohl(remAddr.sin_addr.s_addr);
	}
	return -1;
}

/**********************************************/
static int __local_ip_address = -1;

int get_local_ip_address() {
	char buf[256];
	struct hostent *hent;

	if (__local_ip_address != -1)
		return __local_ip_address;
	
	if (gethostname(buf, 256) < 0)
		return -1;
again:
	hent = gethostbyname(buf);
	if (hent == NULL) {
		if (h_errno == TRY_AGAIN)
			goto again;
		return -1;
	}
	__local_ip_address = ntohl(*(long *)hent->h_addr);
	return __local_ip_address;
}

/**********************************************/
void make_socket_nonblocking(int socket)
{
	int	flag;
	flag = fcntl(socket, F_GETFL, 0);
	fcntl(socket, F_SETFL, flag | O_NONBLOCK);
}

/**********************************************/
void sleep_milliseconds(int ms)
{
	struct timeval  tv;

	tv.tv_sec = ms / 1000;
	tv.tv_usec = (ms - (tv.tv_sec * 1000) ) * 1000;
	select(0, NULL, NULL, NULL, &tv);
}

/**********************************************/
unsigned long microseconds()
{
	static bool us_initted = false;
	static struct timeval us_time_zero;
	struct timeval  tv, t;
	struct timezone tz;

	gettimeofday(&tv, &tz);
	if (us_initted == false) {
		us_initted = true;
		us_time_zero = tv;
		return 0;
	}
	else {
		timer_sub(tv, us_time_zero, t);
		return (((unsigned long)t.tv_sec * USEC_PER_SEC) + (unsigned long)t.tv_usec);
	}
}

/**********************************************/
bool isReadable(int fd)
{
	fd_set  set;
	struct  timeval tv;
	int     err;

	if (fd == INVALID_SOCKET)
		return false;
	tv.tv_sec = 0; tv.tv_usec = 0;
	FD_ZERO(&set);
	FD_SET(fd, &set);
	err = select(fd+1, &set, NULL, NULL, &tv);
	if (err > 0)
		if (FD_ISSET(fd, &set))
			return true;
	return false;
}

/**********************************************/
bool isWritable(int fd)
{
	fd_set  set;
	struct  timeval tv;
	int     err;

	if (fd == INVALID_SOCKET)
		return false;
	tv.tv_sec = 0; tv.tv_usec = 0;
	FD_ZERO(&set);
	FD_SET(fd, &set);
	err = select(fd+1, NULL, &set, NULL, &tv);
	if (err > 0)
		if (FD_ISSET(fd, &set))
			return true;
	return false;
}

/**********************************************/
int new_socket_udp(void)
{
	int ret;
	ret = socket(PF_INET, SOCK_DGRAM, 0);
	gMaxPorts++;
//	set_socket_max_buf(ret);
	return ret;
}

/**********************************************/
int new_socket_tcp(int is_listener)
{
	int ret;
	ret = socket(PF_INET, SOCK_STREAM, IPPROTO_TCP);
	gMaxPorts++;
	return ret;
}

/**********************************************/
void set_socket_reuse_address(int skt)
{
	int i = 1;
	setsockopt(skt, SOL_SOCKET, SO_REUSEADDR, (char*)&i, sizeof(i));
}

/**********************************************/
void set_socket_max_buf(int skt)
{
	int i = 1, len;
	len = sizeof(i);
	getsockopt(skt, SOL_SOCKET, SO_SNDBUF, (char*)&i, &len);
fprintf(stderr, "sndbuf for socket %d was %d\n", skt, i);
	i *= 2;
	setsockopt(skt, SOL_SOCKET, SO_SNDBUF, (char*)&i, len);
getsockopt(skt, SOL_SOCKET, SO_SNDBUF, (char*)&i, &len);
fprintf(stderr, "sndbuf for socket %d is now %d\n", skt, i);
	getsockopt(skt, SOL_SOCKET, SO_RCVBUF, (char*)&i, &len);
fprintf(stderr, "rcvbuf for socket %d was %d\n", skt, i);
	i *= 2;
	setsockopt(skt, SOL_SOCKET, SO_RCVBUF, (char*)&i, len);
getsockopt(skt, SOL_SOCKET, SO_RCVBUF, (char*)&i, &len);
fprintf(stderr, "rcvbuf for socket %d is now %d\n", skt, i);
}

/**********************************************/
int bind_socket_to_address(int skt, int address, int port, int is_listener)
{
	struct sockaddr_in sin;
	
	if (address == -1)
		address = INADDR_ANY;
		
	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = htonl(address);
	return bind(skt, (struct sockaddr*)&sin, sizeof(sin));
}

/**********************************************/
void close_socket(int skt)
{
	if (skt != INVALID_SOCKET) {
		gMaxPorts--;
		close(skt);
	}
}

/**********************************************/
int listen_to_socket(int skt)
{
	return listen(skt, 5);
}

/**********************************************/
int call_is_waiting(int skt, int *incoming_skt)
{
	int ret;
	ret = isReadable(skt);
	if (ret) {
		*incoming_skt = accept(skt, 0, 0);
		if (*incoming_skt <= 0) {
			fprintf(stderr, "Couldn't accept incoming connection (%d)\n", GetLastSocketError(skt));
			ret = 0;
		}
		else
			gMaxPorts++;
	}
	return ret;
}

/**********************************************/
int accept_connection(int from, int *to)
{
//	return accept(from, 0, 0);
	return *to;
}

/**********************************************/
int connect_to_address(int skt, int address, int port)
{
	struct sockaddr_in sin;
	
	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = htonl(address);;
	return connect(skt, (struct sockaddr*)&sin, sizeof(sin));
}

/**********************************************/
int recv_udp(int socket, char *buf, int amt, int *fromip, int *fromport)
{
	struct sockaddr_in	sin;
	int	ret, len;

	len = sizeof(sin);
	memset(&sin, 0, sizeof(sin));
//	if (!isReadable(socket)) {
//		errno = EAGAIN;
//		return -1;
//	}
	ret = recvfrom(socket, buf, amt, 0, (struct sockaddr*)&sin, &len);
	if (ret != -1) {
		if (fromip)
			*fromip = ntohl(sin.sin_addr.s_addr);
		if (fromport)
			*fromport = ntohs(sin.sin_port);
	}
	return ret;
}

/**********************************************/
int send_udp(int skt, char *buf, int amt, int address, int port)
{
	struct sockaddr_in sin;
	
	memset(&sin, 0, sizeof(sin));
	sin.sin_family = AF_INET;
	sin.sin_port = htons(port);
	sin.sin_addr.s_addr = htonl(address);
	return sendto(skt, buf, amt, 0, (struct sockaddr*)&sin, sizeof(sin));
}

/**********************************************/
int recv_tcp(int socket, char *buf, int amt)
{
	return read(socket, buf, amt);
}

/**********************************************/
int send_tcp(int socket, char *buf, int amt)
{
	return write(socket, buf, amt);
}

/**********************************************/
int GetLastSocketError(int skt)
{
	return errno;
}

/**********************************************/
int init_ui()
{
}

/**********************************************/
int service_ui(int sleep_time)
{
}

/**********************************************/
void DoStats(stats_chunk *stats)
{
	printf("\033[2J\033[H");
	printf("Elapsed Time (seconds) : %d\n", stats->elapsedSeconds);
	printf("Number of clients      : %d\n", stats->numClients);
	printf("bps Received           : %d\n", stats->bpsReceived);
	printf("bps Sent               : %d\n", stats->bpsSent);
	printf("Total Packets Received : %d\n", stats->totalPacketsReceived);
	printf("Total Packets Sent     : %d\n", stats->totalPacketsSent);
	printf("pps Received           : %d\n", stats->ppsReceived);
	printf("pps Sent               : %d\n", stats->ppsSent);
	printf("number of ports used   : %d\n", stats->numPorts);
}

/**********************************************/
void ErrorString(char *string)
{
	fprintf(stderr, string);
}

/**********************************************/
void ErrorString1(char *string, int d)
{
	fprintf(stderr, string, d);
}

/**********************************************/
void ErrorStringS(char *string, char *arg)
{
	fprintf(stderr, string, arg);
}

