#include "alloc.h"
#include "strerr.h"
#include "fmt.h"
#include "str.h"
#include "ip.h"
#include "env.h"
extern struct hostent *gethostbyname();

void usage()
{
  strerr_die1x(100,"antirbl: usage: antirbl domain program [ arg ... ]");
}

char *domain;
struct ip_address ip;

void check()
{
  char *x;
  int numenv;
  char **newenv;
  int i;

  if (env_get("RBLSMTPD")) return;

  x = env_get("TCPREMOTEIP");
  if (!x) return;
  if (!*x) return;
  if (x[ip_scan(x,&ip)]) return;

  x = alloc(100 + str_len(domain));
  if (!x) return;
  i = 0;
  i += fmt_ulong(x + i,(unsigned long) ip.d[3]); x[i++] = '.';
  i += fmt_ulong(x + i,(unsigned long) ip.d[2]); x[i++] = '.';
  i += fmt_ulong(x + i,(unsigned long) ip.d[1]); x[i++] = '.';
  i += fmt_ulong(x + i,(unsigned long) ip.d[0]); x[i++] = '.';
  i += fmt_str(x + i,domain);
  x[i] = 0;

  if (!gethostbyname(x)) return;

  for (numenv = 0;environ[numenv];++numenv) ;
  newenv = (char **) alloc((numenv + 2) * sizeof(char *));
  if (!newenv) return;
  for (i = 0;i < numenv;++i) newenv[i] = environ[i];
  newenv[numenv++] = "RBLSMTPD=";
  newenv[numenv] = 0;
  environ = newenv;
}

void main(argc,argv)
int argc;
char **argv;
{
  if (!argv[1]) usage();
  if (!argv[2]) usage();

  domain = argv[1];
  check();
  execvp(argv[2],argv + 2);
  strerr_die4sys(111,"antirbl: fatal: ","unable to run ",argv[2],": ");
}
