;;; Flags for open(2) and fcntl(2).
;;; Copyright (c) 1993 by Olin Shivers.
;;; Copyright (c) 1994 by Brian D. Carlstrom.

(define-enum-constants open
  (read			#o000)
  (write		#o001)
  (read+write		#o002)
  (append		#o00010)
  (create		#o01000)
  (exclusive		#o04000)
  (no-control-tty	#o20000000)
  (non-blocking		#o4000000)
  (truncate		#o2000)
;;; Not POSIX.
  (no-delay		#o0004)
  (sync			#o100000)
;  (blkinuse     	#o10000)
;  (blkandset    	(bitwise-ior #o10000 #o20000)) 
  (termio		#o10000000)
  )

(define open/access-mask
  (bitwise-ior open/read
	       (bitwise-ior open/write open/read+write)))

;;; fcntl() commands

(define-enum-constants fcntl
  (dup-fdes 			0)      ; F_DUPFD
  (get-fdes-flags 		1)      ; F_GETFD
  (set-fdes-flags 		2)      ; F_SETFD
  (get-status-flags 		3)      ; F_GETFL
  (set-status-flags 		4)      ; F_SETFL
  (get-record-lock 		7)	; F_GETLK
  (set-record-lock-no-block	8)	; F_SETLK
  (set-record-lock 		9))	; F_SETLKW

;;; fcntl fdes-flags (F_GETFD)

(define fdflags/close-on-exec 		1)

;;; fcntl status-flags (F_GETFL)
;;; Mostly, these are OPEN/... flags, like OPEN/APPEND.
;;; (define fdstatus/... ...)

;;; fcntl lock values.

(define-enum-constants lock
  (read 	1)	; F_RDLCK
  (write 	2)	; F_WRLCK
  (release 	3))	; F_UNLCK
