// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1996
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        mutexlock.h
// 
// Purpose:     
// 
// Created:     19 Nov 1996   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: mutexlock.h,v 1.2 1996/12/30 16:38:43 jfasch Exp $
// 
// $Log: mutexlock.h,v $
// Revision 1.2  1996/12/30 16:38:43  jfasch
// oops
//
// Revision 1.1  1996/12/06 13:36:50  root
// Initial revision
//
// 
// </file> 
#ifndef hg_dc_threads_mutexlock_h
#define hg_dc_threads_mutexlock_h

#include "verbose.h"

#ifdef Solaris
#  include <thread.h>
#endif

class HWMutexLock {
public:
   class Guard {
   public:
      Guard (HWMutexLock&) ;
      ~Guard() ;
   private:
      HWMutexLock& lock_ ;
   } ;

public:
   HWMutexLock() ;
   ~HWMutexLock() ;

   bool ok() const { return !error(); }
   operator void*() const { return (void*)ok(); }
   bool operator !() const { return !ok(); }
   int error() const { return error_; }
   
   void lock() ;
   void unlock() ;

private:
   friend class HWCondition ; // to have access to lock_
#ifdef Solaris
   mutex_t mutex_ ;
#endif
   int error_ ;

private:
   HWMutexLock (const HWMutexLock&) {}
   HWMutexLock& operator = (const HWMutexLock&) { return *this; }

public:
   static Verbose verbose ;
   static const char* version1 ;
} ;
static const char* hg_utils_mutexlock_version = HWMutexLock::version1 ;


#endif
