/* 
   testdav, a test wrapper for the HTTP-DAV client routines
   Copyright (C) 1998, Joe Orton <joe@orton.demon.co.uk>
                                                                     
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   $Id: testdav.c,v 1.4.2.1 1999/08/06 13:36:55 joe Exp $
*/

#include "config.h"

/* Compile with 'make testdav' then run ./testdav for options */
#include <stdio.h>
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_STRINGS_H
#include <strings.h>
#endif 

#include "basename.h"

#include "common.h"
#include "frontend.h"
#include "httpdav.h"

char *progname;


void fe_transfer_progress(size_t a,size_t b) {}
void fe_connection( fe_conn_status c ) {}
void get_body( http_req_t *req );
void usage( void );

void usage( void ) {
    printf( "Usage: %s <hostname> <port> <action>\n"
	    "Where action is one of:\n"
	    "\tput localfile dest-path\n"
	    "\tdelete dest-path\n"
	    "\tmove from-dest-path to-dest-path\n"
	    "\tmkcol dest-path\n"
	    "\toptions dest-path\n"
	    "\thead dest-path\n"
	    "\tpropfind dest-path < body-data\n"
	    "\tproppatch dest-path < body-data\n"
	    "\ttrace n   -- performs n TRACE's\n", progname );
    exit(-1);
}

void get_body( http_req_t *req ) {
    char *body;
    int buflen = BUFSIZ, n;
    strcat( req->headers, "Content-Type: text/xml\r\n"  );
    printf( "Enter %s body now:\n", req->method );
    body = malloc( buflen );
    do {
	n = read( STDIN_FILENO, body + buflen - BUFSIZ, BUFSIZ - 1);
	if( n < 0 ) {
	    perror( "read" );
	    exit( -1 );
	} else if( n > 0 ) {
	    body = realloc( body, buflen + n );
	    buflen += n;
	}
    } while( n != 0 );
    body[buflen-BUFSIZ-1] = '\0';
    req->body = http_body_buffer;
    req->body_buffer = body;
}

int main( int argc, char **argv ) {
    http_req_t req;
    char *random_headers = 
	"Foo: Bar\r\n"
	"Another: here\r\n"
	"Third: Header\r\n"
	"Fourth: Header header header header header header header header\r\n";
    struct proto_host_t server;
    char *cmd = argv[3];

    /* We want to see HTTP and socket debugging messages */
    debug_mask = DEBUG_HTTP | DEBUG_SOCKET;
    
    progname = base_name( argv[0] );

    if( argc < 4 ) {
	usage( );
    }
    
    server.hostname = argv[1];
    server.port = atoi(argv[2]);
    server.username = "";
    server.password = "";

    /* Turn off the initial HEAD */
    http_init_checks = false;
    http_init( "/", &server, NULL );
    http_webdav_server = true;

    if( argc == 6 ) {
	if( strcasecmp( cmd, "move" ) == 0 ) {
	    dav_move( argv[4], argv[5] );
	} else if( strcasecmp( cmd, "put" ) == 0 ) {
	    http_put( argv[4], argv[5], false );
	} else {
	    http_finish( );
	    usage( );
	}
    } else if( argc == 5 ) {
	if( strcasecmp( cmd, "head" ) == 0 ) {
	    http_head( argv[4] );
	} else if( strcasecmp( cmd, "delete" ) == 0 ) {
	    http_delete( argv[4] );
	} else if( strcasecmp( cmd, "mkcol" ) == 0 ) {
	    dav_mkcol( argv[4] );
	} else if( strcasecmp( cmd, "trace" ) == 0 ) {
	    int n, total;
	    http_request_init( &req, "TRACE", "/" );
	    strcat( req.headers, random_headers );
	    total = atoi( argv[4] );
	    if( total < 1 ) { printf( "d'oh\n" ); exit(-1); }
	    for( n = 1; n<=total; n++ ) {
		DEBUG( DEBUG_HTTP, "*** Trace #%d\n", n );
		http_request( &req );
	    }
	} else if( strcasecmp( cmd, "propfind" ) == 0 ) {
	    http_request_init( &req, "PROPFIND", argv[4] );
	    get_body( &req );
	    http_request( &req );
	} else if( strcasecmp( cmd, "proppatch" ) == 0 ) {
	    http_request_init( &req, "PROPPATCH", argv[4] );
	    get_body( &req );
	    http_request( &req );
	} else if( strcasecmp( cmd, "options" ) == 0 ) {
	    http_options( argv[4] );
	} else {
	    http_finish( );
	    usage( );
	}
    } else {
	http_finish( );
	usage( );
    }

    http_finish( );

    return 0;
}
	    
