/* Bluefish HTML Editor
 *
 * Copyright (C) 1998 Olivier Sessink
 * 
 * part of this code is similar to the code in gnotepad, 
 * Copyright (C) 1998 Andy C. Kahn <kahn@zk3.dec.com>
 * http://ack.netpedia.net/gnp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __UNDO_H_
#define __UNDO_H_

#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gtk/gtkeditable.h>

typedef enum
  {
    UndoDelete = 1, UndoInsert
  }
undo_op_t;

void undo_list_add (filestruct * d, char *text, int start, int end,
		    undo_op_t op);

void doc_insert_text_cb(GtkEditable *editable, const char *text, int len, int *pos, gpointer d);
void doc_delete_text_cb(GtkEditable *editable, int start, int end, gpointer d);
void redo_cb(GtkWidget *wgt, gpointer cbdata);
void undo_cb(GtkWidget *wgt, gpointer cbdata);
void undo_all_cb(GtkWidget *wgt, gpointer cbdata);
void redo_all_cb(GtkWidget *wgt, gpointer cbdata);

#endif	/* __UNDO_H_ */

