/* Bluefish HTML Editor
 * callbacks.h - callback prototypes
 *
 * Copyright (C) 1998 Olivier Sessink and Chris Mazuc
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __CALLBACKS_H_
#define __CALLBACKS_H_

#include <glib.h>
#include <gtk/gtkwidget.h>

extern void file_close (GtkWidget * widget, gpointer data);
extern void file_open (GtkWidget * widget, gpointer data);
extern void files_open (GtkWidget * widget, gpointer data);
extern void file_insert (GtkWidget * widget, gpointer data);
extern void file_new (GtkWidget * widget, gpointer data);
extern void file_save (GtkWidget * widget, gpointer data);
extern void file_save_as (GtkWidget * widget, gpointer data);
extern void file_close_all (GtkWidget * widget, gpointer data);
extern void file_save_all (GtkWidget * widget, gpointer data);
extern void project_open (GtkWidget * widget, gpointer data);
extern void project_close (GtkWidget * widget, gpointer data);
extern void project_save (GtkWidget * widget, gpointer data);
extern void project_save_as (GtkWidget * widget, gpointer data);
extern void project_add_document (GtkWidget * widget, gpointer data);
extern void project_edit (GtkWidget * widget, gpointer data);
extern void project_from_file (void);
extern void project_to_file (void);
extern void view_in_netscape (GtkWidget * widget, gpointer data);
extern void run_weblint (GtkWidget * widget, gpointer data);
extern void open_from_web ();
extern void open_from_web_callback ();
extern void key_press_callback (GtkWidget * widget, GdkEventKey * event, gpointer
			 data);
extern void error_dialog (gchar * window_title, gchar * error_string);
extern void go_to_line_win(GtkWidget *widget, gpointer data);

#endif	/* __CLALLBACKS_H_ */

