/*								-*- C++ -*-
 * $Id: WIN_choice.h,v 1.2 1997-01-15 14:57:57+01 mho Exp $
 *
 * Purpose: choice panel item
 *
 * Authors: Markus Holzem and Julian Smart
 *
 * Copyright: (C) 1995, AIAI, University of Edinburgh (Julian)
 * Copyright: (C) 1995, GNU (Markus)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Additionally everyone using this library has to announce it with:
 *
 *   This software uses the wxWindows-Xt GUI library
 *   (C) Markus Holzem, available via
 *       ftp://ftp.aiai.ed.ac.uk/pub/packages/wxwin/ports/xt
 */

#ifndef Choice_h
#define Choice_h

#ifdef __GNUG__
#pragma interface
#endif

class wxPanel;
typedef void wxChoiceItem;

// Choice item
class wxChoice : public wxItem {
DECLARE_DYNAMIC_CLASS(wxChoice)
public:
    wxChoice(void);
    wxChoice(wxPanel *panel, wxFunction func, Const char *label,
	     int x = -1, int y = -1, int width = -1, int height = -1,
	     int n = 0, char **choices = NULL,
	     long style = 0, Constdata char *name = wxChoiceNameStr);
    ~wxChoice(void);

    Bool Create(wxPanel *panel, wxFunction func, Const char *label,
		int x = -1, int y = -1, int width = -1, int height = -1,
		int n = 0, char **choices = NULL,
		long style = 0, Constdata char *name = wxChoiceNameStr);

    void  Append(char *item);
    void  Clear(void);
    int   FindString(char *s);
    int   GetSelection(void) { return selection; }
    int   Number(void) { return num_choices; }
    char  *GetString(int n);
    char  *GetStringSelection(void);
    void  SetSelection(int n);
    void  SetStringSelection(char *s);

    // can't handle them
    int   GetColumns(void) { return 1; }
    void  SetColoumns(int WXUNUSED(n=1)) {};
private:
    #ifdef Have_Xt_Types
    static void EventCallback(Widget, XtPointer, XtPointer);
    #endif
    wxChoiceItem* top;
    wxChoiceItem* last;
    int           num_choices;
    int           selection;
};

#endif // Choice_h
