/*
    SDL - Simple DirectMedia Layer
    Copyright (C) 1997, 1998, 1999  Sam Lantinga

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    Sam Lantinga
    slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL.c,v 1.5 1999/11/23 19:01:39 hercules Exp $";
#endif

/* Initialization code for SDL */

#include "SDL.h"
#include "SDL_endian.h"
#include "SDL_fatal.h"
#include "SDL_leaks.h"

/* Initialization/Cleanup routines */
#ifndef DISABLE_VIDEO
extern int  SDL_VideoInit(Uint32 flags);
extern void SDL_VideoQuit(void);
#endif
#ifndef DISABLE_CDROM
extern int  SDL_CDROMInit(void);
extern void SDL_CDROMQuit(void);
#endif
#ifndef DISABLE_TIMERS
extern void SDL_StartTicks(void);
extern int  SDL_TimerInit(void);
extern void SDL_TimerQuit(void);
#endif

/* The current SDL version */
static SDL_version version = 
	{ SDL_MAJOR_VERSION, SDL_MINOR_VERSION, SDL_PATCHLEVEL };

/* The initialized subsystems */
Uint32 initialized = 0;

#ifdef CHECK_LEAKS
int surfaces_allocated = 0;
#endif

int SDL_Init(Uint32 flags)
{
#ifndef DISABLE_TIMERS
	/* Initialize the timer subsystem */
	SDL_StartTicks();
	if ( (flags & SDL_INIT_TIMER) && !(initialized & SDL_INIT_TIMER) ) {
		if ( SDL_TimerInit() < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_TIMER;
	}
#else
	if ( flags & SDL_INIT_TIMER ) {
		SDL_SetError("SDL not built with timer support");
		return(-1);
	}
#endif

#ifndef DISABLE_VIDEO
	/* Initialize the video/event subsystem */
	if ( (flags & SDL_INIT_VIDEO) && !(initialized & SDL_INIT_VIDEO) ) {
		if ( SDL_VideoInit(flags&SDL_INIT_EVENTTHREAD) < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_VIDEO;
	}
#else
	if ( flags & SDL_INIT_VIDEO ) {
		SDL_SetError("SDL not built with video support");
		return(-1);
	}
#endif

#ifndef DISABLE_CDROM
	/* Initialize the CD-ROM subsystem */
	if ( (flags & SDL_INIT_CDROM) && !(initialized & SDL_INIT_CDROM) ) {
		if ( SDL_CDROMInit() < 0 ) {
			return(-1);
		}
		initialized |= SDL_INIT_CDROM;
	}
#else
	if ( flags & SDL_INIT_CDROM ) {
		SDL_SetError("SDL not built with cdrom support");
		return(-1);
	}
#endif

	/* Everything is initialized */
	if ( !(flags & SDL_INIT_NOPARACHUTE) ) {
		SDL_InstallParachute();
	}
	return(0);
}

void SDL_Quit(void)
{
	/* Shut down all initialized subsystems */
#ifndef DISABLE_CDROM
	if ( initialized & SDL_INIT_CDROM ) {
		SDL_CDROMQuit();
		initialized &= ~SDL_INIT_CDROM;
	}
#endif
#ifndef DISABLE_VIDEO
	if ( initialized & SDL_INIT_VIDEO ) {
		SDL_VideoQuit();
		initialized &= ~SDL_INIT_VIDEO;
	}
#endif
#ifndef DISABLE_TIMERS
	if ( initialized & SDL_INIT_TIMER ) {
		SDL_TimerQuit();
		initialized &= ~SDL_INIT_TIMER;
	}
#endif
	SDL_ClearError();

#ifdef CHECK_LEAKS
	if ( surfaces_allocated != 0 ) {
		fprintf(stderr, "SDL Warning: %d SDL surfaces extant\n", 
							surfaces_allocated);
	}
#endif
}

/* Return the library version number */
const SDL_version * SDL_Linked_Version(void)
{
	return(&version);
}

