'\"
'\" Copyright (c) 1995 DSC Technologies Corporation
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
'\" @(#) finddialog.n 1.21 94/12/17 16:04:44
'/" 
.so man.macros
.HS finddialog iwid
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
finddialog \- Create and manipulate a find dialog widget
.SH SYNOPSIS
\fBfinddialog\fI \fIpathName \fR?\fIoptions\fR?
.SH "INHERITANCE"
itk::Toplevel <- Shell <- Dialogshell <- Finddialog
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBactiveBackground\fR	\fBactiveForeground\fR	\fBbackground\fR	\fBborderWidth\fR
\fBcursor\fR	\fBdisabledForeground\fR	\fBfont\fR	\fBforeground\fR
\fBhighlightColor\fR	\fBhighlightThickness\fR	\fBinsertBackground\fR	\fBinsertBorderWidth\fR
\fBinsertOffTime\fR	\fBinsertOnTime\fR	\fBinsertWidth\fR	\fBselectBackground\fR
\fBselectBorderWidth\fR	\fBselectColor\fR	\fBselectForeground\fR
.fi
.LP
See the "options" manual entry for details on the standard options.
.SH "ASSOCIATED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBselectColor\fR
.fi
.LP
See the "checkbutton" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBselectColor\fR
.fi
.LP
See the "entryfield" widget manual entry for details on the above
associated options.
.LP
.nf
.ta 4c 8c 12c
\fBlabelFont\fR	
.fi
.LP
See the "labeledwidget" widget manual entry for details on the above
associated options.
.SH "INHERITED OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBbuttonBoxPadX\fR	\fBbuttonBoxPadY\fR 	\fBbuttonBoxPos\fR	\fBpadX\fR
\fBpadY\fR	\fBseparator\fR	\fBthickness\fR
.fi
.LP
See the "dialogshell" widget  manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBheight\fR	\fBmaster\fR	\fBmodality\fR	\fBwidth\fR
.fi
.LP
See the "shell" widget  manual entry for details on the above
inherited options.
.LP
.nf
.ta 4c 8c 12c
\fBtitle\fR 
.fi
.LP
See the "Toplevel" widget  manual entry for details on the above
inherited options.
.SH "WIDGET-SPECIFIC OPTIONS"
.LP
.nf
Name:	\fBclearCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-clearcommand\fR
.fi
.IP
Specifies a command to be invoked following a clear operation. 
The option is meant to be used as means of notification that the
clear has taken place and allow other actions to take place such
as disabling a find again menu.
.LP
.nf
Name:	\fBmatchCommand\fR
Class:	\fBCommand\fR
Command-Line Switch:	\fB-matchcommand\fR
.fi
.IP
Specifies a command to be invoked following a find operation. 
The command is called with a match point as an argument which identifies
where exactly where in the text or scrolledtext widget that the match
is located.  Should a match not be found the match point is {}.  The
option is meant to be used as a means of notification that the
find operation has completed and allow other actions to take place
such as disabling a find again menu option if the match point was {}.
.LP
.nf
Name:	\fBpatternBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-patternbackground\fR
.fi
.IP
Specifies the background color of the text matching the search
pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is gray44.
.LP
.nf
Name:	\fBpatternForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-patternforeground\fR
.fi
.IP
Specifies the foreground color of the text matching the search
pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is white.
.LP
.nf
Name:	\fBsearchBackground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-searchbackground\fR
.fi
.IP
Specifies the background color of the line containing the matching 
the search pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is gray77.
.LP
.nf
Name:	\fBsearchForeground\fR
Class:	\fBBackground\fR
Command-Line Switch:	\fB-searchforeground\fR
.fi
.IP
Specifies the foreground color of the line containing the matching 
the search pattern.  It may have any of the forms accepted by Tk_GetColor.
The default is black.
.LP
.nf
Name:	\fBtextWidget\fR
Class:	\fBTextWidget\fR
Command-Line Switch:	\fB-textwidget\fR
.fi
.IP
Specifies the text or scrolledtext widget to be searched.
.BE

.SH DESCRIPTION
.PP
The \fBfinddialog\fR command creates a find dialog that works in
conjunction with a text or scrolledtext widget to provide a means
of performing search operations.  The user is prompted for a text 
pattern to be found in the text or scrolledtext widget.  The 
search can be for all occurances, by regular expression, considerate
of the case, or backwards.

.SH "METHODS"
.PP
The \fBfinddialog\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.DS C
\fIpathName option \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for finddialog widgets:
.SH "INHERITED METHODS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBbuttonconfigure\fR	\fBdefault\fR	\fBhide\fR
\fBinvoke\fR	\fBshow\fR	
.fi
.LP
See the "buttonbox" widget manual entry for details on the above
inherited methods.
.LP
.nf
.ta 4c 8c 12c
\fBactivate\fR	\fBcenter\fR	\fBdeactivate\fR
.fi
.LP
See the "shell" widget manual entry for details on the above
inherited methods.
.SH "WIDGET-SPECIFIC METHODS"
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBfinddialog\fR
command.
.TP
\fIpathName \fBclear\fR
Clears the pattern in the entry field and the pattern matchin 
indicators in the text or scrolledtext widget.
.TP
\fIpathName\fR \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBfinddialog\fR
command.
.TP
\fIpathName \fBfind\fR
Search for a specific text string in the text widget given by
the -textwidget option.  This method is the standard callback
for the Find button.  It is made available such that it can be 
bound to a find again action.

.SH "COMPONENTS"
.LP
.nf
Name:	\fBall\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The all component specifies that all the matches of the pattern should be
found when performing the search.  See the "checkbutton" widget manual 
entry for details on the all component item.
.LP
.nf
Name:	\fBbackwards\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The backwards component specifies that the search should continue in
a backwards direction towards the beginning of the text or scrolledtext
widget.  See the "checkbutton" widget manual entry for details on the 
backwards component item.
.LP
.nf
Name:	\fBcase\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The case component specifies that the case of the pattern should be
taken into consideration when performing the search.  See the 
"checkbutton" widget manual entry for details on the case component item.
.LP
.nf
Name:	\fBpattern\fR
Class:	\fBEntryfield\fR
.fi
.IP
The pattern component provides the pattern entry field.  See the 
"entryfield" widget manual entry for details on the pattern component item.
.LP
.nf
Name:	\fBregexp\fR
Class:	\fBCheckbutton\fR
.fi
.IP
The regexp component specifies that the pattern is a regular expression.
See the "checkbutton" widget manual entry for details on the regexp 
component item.
.fi

.SH EXAMPLE
.DS
 scrolledtext .st
 pack .st
 .st insert end "Now is the time for all good men\\n" 
 .st insert end "to come to the aid of their country"

 finddialog .fd -textwidget .st
 .fd center .st
 .fd activate
.DE
.SH AUTHOR
Mark L. Ulferts
.SH KEYWORDS
finddialog, dialogshell, shell, widget

