/********************************************************************************
*                                                                               *
*                        F i l e    L i s t   W i d g e t                       *
*                                                                               *
*********************************************************************************
* Copyright (C) 1997 by Jeroen van der Zijp.   All Rights Reserved.             *
*********************************************************************************
* This library is free software; you can redistribute it and/or                 *
* modify it under the terms of the GNU Library General Public                   *
* License as published by the Free Software Foundation; either                  *
* version 2 of the License, or (at your option) any later version.              *
*                                                                               *
* This library is distributed in the hope that it will be useful,               *
* but WITHOUT ANY WARRANTY; without even the implied warranty of                *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU             *
* Library General Public License for more details.                              *
*                                                                               *
* You should have received a copy of the GNU Library General Public             *
* License along with this library; if not, write to the Free                    *
* Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.            *
*********************************************************************************
* $Id: FXOldFileList.h,v 1.2 1999/09/21 13:30:03 jeroen Exp $                   *
********************************************************************************/
#ifndef FXOLDFILELIST_H
#define FXOLDFILELIST_H


//////////////////////  THIS WIDGET HAS BEEN DEPRECATED  ////////////////////////


// File List options
enum FXOldFileListStyle {
  OLDFILELIST_SHOWHIDDEN  = 0x10000000   // Show hidden files or directories
  };
  

struct FXFileAssoc;                   // File association
class  FXFileDict;                    // Dictionary of file associations


enum FXOldFileItemState {
  OLDFILEITEM_CURRENT    = OLDICONITEM_CURRENT,   // Current item
  OLDFILEITEM_SELECTED   = OLDICONITEM_SELECTED,  // Has been selected
  OLDFILEITEM_HISTORY    = OLDICONITEM_HISTORY,   // Was selected
  OLDFILEITEM_MARK       = OLDICONITEM_MARK,      // Marked selection state
  OLDFILEITEM_DRAGGABLE  = OLDICONITEM_DRAGGABLE, // Draggable item
  OLDFILEITEM_DIRECTORY  = 32,                    // Directory item
  OLDFILEITEM_EXECUTABLE = 64,                    // Executable item
  OLDFILEITEM_SYMLINK    = 128,                   // Symbolic linked item
  OLDFILEITEM_CHARDEV    = 256,                   // Character special item
  OLDFILEITEM_BLOCKDEV   = 512,                   // Block special item
  OLDFILEITEM_FIFO       = 1024,                  // FIFO item
  OLDFILEITEM_SOCK       = 2048                   // Socket item
  };


struct FXOldFileItem : public FXOldIconItem {
  FXOldFileItem  *iprev;                    // Previous insertion order node
  FXOldFileItem  *inext;                    // Next insertion order node
  FXFileAssoc *assoc;                       // File association record
  long         size;                        // File size
#ifndef WIN32
  long         date;                        // File time
#else
  FILETIME    *date;
#endif
  };




// File List object
class FXAPI FXOldFileList : public FXOldIconList {
  FXDECLARE(FXOldFileList)
protected:
  FXString    directory;              // Current directory
  FXString    pattern;                // Pattern of file names
  FXFileDict *associations;           // Association table
  FXOldFileItem *list;                   // Items in insertion order
  FXTimer    *refresh;                // Refresh timer
  FXint       timestamp;              // Time when last refreshed
  FXuint      matchmode;              // File wildcard match mode
  FXGIFIcon  *big_folder;             // Fallback icons
  FXGIFIcon  *mini_folder;
  FXGIFIcon  *big_doc;
  FXGIFIcon  *mini_doc;
  FXGIFIcon  *big_app;
  FXGIFIcon  *mini_app;
protected:
  FXOldFileList();
  virtual FXOldIconItem* createItem();
  virtual void deleteItem(FXOldIconItem*);
  FXbool listDirectory();
  FXOldIconItem* getFilenameItem(const FXString& file) const;
private:
  FXOldFileList(const FXOldFileList&);
  FXOldFileList &operator=(const FXOldFileList&);
public:
  long onRefresh(FXObject*,FXSelector,void*);
  long onDNDEnter(FXObject*,FXSelector,void*);
  long onDNDLeave(FXObject*,FXSelector,void*);
  long onDNDMotion(FXObject*,FXSelector,void*);
  long onDNDDrop(FXObject*,FXSelector,void*);
  long onDNDRequest(FXObject*,FXSelector,void*);
  long onSelectionRequest(FXObject*,FXSelector,void* ptr);
  long onBeginDrag(FXObject*,FXSelector,void*);
  long onEndDrag(FXObject*,FXSelector,void*);
  long onDragged(FXObject*,FXSelector,void*);
  long onCmdSetValue(FXObject*,FXSelector,void*);
  long onCmdGetStringValue(FXObject*,FXSelector,void*);
  long onCmdSetStringValue(FXObject*,FXSelector,void*);
  long onCmdDirectoryUp(FXObject*,FXSelector,void*);
  long onUpdDirectoryUp(FXObject*,FXSelector,void*);
  long onCmdDirectoryNew(FXObject*,FXSelector,void*);
  long onUpdDirectoryNew(FXObject*,FXSelector,void*);
  long onCmdSortByName(FXObject*,FXSelector,void*);
  long onUpdSortByName(FXObject*,FXSelector,void*);
  long onCmdSortByType(FXObject*,FXSelector,void*);
  long onUpdSortByType(FXObject*,FXSelector,void*);
  long onCmdSortBySize(FXObject*,FXSelector,void*);
  long onUpdSortBySize(FXObject*,FXSelector,void*);
  long onCmdSortByTime(FXObject*,FXSelector,void*);
  long onUpdSortByTime(FXObject*,FXSelector,void*);
  long onCmdSortByUser(FXObject*,FXSelector,void*);
  long onUpdSortByUser(FXObject*,FXSelector,void*);
  long onCmdSortByGroup(FXObject*,FXSelector,void*);
  long onUpdSortByGroup(FXObject*,FXSelector,void*);
  long onCmdSortReverse(FXObject*,FXSelector,void*);
  long onUpdSortReverse(FXObject*,FXSelector,void*);
  long onCmdSetPattern(FXObject*,FXSelector,void*);
  long onUpdSetPattern(FXObject*,FXSelector,void*);
  long onCmdSetDirectory(FXObject*,FXSelector,void*);
  long onUpdSetDirectory(FXObject*,FXSelector,void*);
  long onCmdToggleHidden(FXObject*,FXSelector,void*);
  long onUpdToggleHidden(FXObject*,FXSelector,void*);
  long onCmdShowHidden(FXObject*,FXSelector,void*);
  long onUpdShowHidden(FXObject*,FXSelector,void*);
  long onCmdHideHidden(FXObject*,FXSelector,void*);
  long onUpdHideHidden(FXObject*,FXSelector,void*);
public:
  static FXbool cmpFName(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpFType(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpFSize(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpFTime(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpFUser(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpFGroup(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRName(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRType(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRSize(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRTime(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRUser(const FXOldIconItem* a,const FXOldIconItem* b);
  static FXbool cmpRGroup(const FXOldIconItem* a,const FXOldIconItem* b);
public:
  enum {
    ID_SORT_BY_NAME=FXOldIconList::ID_LAST,
    ID_SORT_BY_TYPE,
    ID_SORT_BY_SIZE,
    ID_SORT_BY_TIME,
    ID_SORT_BY_USER,
    ID_SORT_BY_GROUP,
    ID_SORT_REVERSE,
    ID_DIRECTORY_UP,
    ID_DIRECTORY_NEW,
    ID_SET_PATTERN,
    ID_SET_DIRECTORY,
    ID_SHOW_HIDDEN,
    ID_HIDE_HIDDEN,
    ID_TOGGLE_HIDDEN,
    ID_REFRESH,
    ID_LAST
    };
public:
  FXOldFileList(FXComposite *p,FXObject* tgt=NULL,FXSelector sel=0,FXuint opts=0,FXint x=0,FXint y=0,FXint w=0,FXint h=0);
  virtual void create();
  virtual void detach();
  virtual void destroy();
  void setCurrentFile(const FXString& file);
  FXString getCurrentFile() const;
  void setDirectory(const FXString& path);
  FXString getDirectory() const { return directory; }
  void setPattern(const FXString& ptrn);
  FXString getPattern() const { return pattern; }
  FXbool isItemDirectory(const FXOldIconItem* item) const;
  FXbool isItemFile(const FXOldIconItem* item) const;
  FXbool isItemExecutable(const FXOldIconItem* item) const;
  FXString getItemFilename(const FXOldIconItem* item) const;
  FXString getItemPathname(const FXOldIconItem* item) const;
  FXFileAssoc* getItemAssoc(const FXOldIconItem* item) const;
  FXuint getMatchMode() const { return matchmode; }
  void setMatchMode(FXuint mode);
  FXbool showHiddenFiles() const;
  void showHiddenFiles(FXbool shown);
  void setAssociations(FXFileDict* assoc);
  FXFileDict* getAssociations() const { return associations; }
  virtual void save(FXStream& store) const;
  virtual void load(FXStream& store);
  virtual ~FXOldFileList();
  };


#endif
