#!../src/bltwish

package require BLT
# --------------------------------------------------------------------------
# Starting with Tcl 8.x, the BLT commands are stored in their own 
# namespace called "blt".  The idea is to prevent name clashes with
# Tcl commands and variables from other packages, such as a "table"
# command in two different packages.  
#
# You can access the BLT commands in a couple of ways.  You can prefix
# all the BLT commands with the namespace qualifier "blt::"
#  
#    blt::graph .g
#    blt::table . .g -resize both
# 
# or you can import all the command into the global namespace.
#
#    namespace import blt::*
#    graph .g
#    table . .g -resize both
#
# --------------------------------------------------------------------------
if { $tcl_version >= 8.0 } {
    namespace import blt::*
    namespace import -force blt::tile::*
}

source scripts/demo.tcl

set graph .graph

source scripts/stipples.tcl

set visual [winfo screenvisual .]
if { $visual != "staticgray" && $visual != "grayscale" } {
    option add *Button.Background	red
    option add *TextMarker.Foreground	black
    option add *TextMarker.Background	yellow
    option add *LineMarker.Foreground	black
    option add *LineMarker.Background	yellow
    option add *PolyMarker.Fill		yellow2
    option add *PolyMarker.Outline	""
    option add *PolyMarker.Stipple	bdiagonal1
    option add *activeLine.Color	red4
    option add *activeLine.Fill		red2
    option add *Element.Color		purple
}
source scripts/graph2.tcl

if { [file exists xtestImg.jpg] } {
   image create photo someImage 
   winop readjpeg testImg.jpg someImage 
   puts stderr [time { 
     $graph marker create image -image someImage \
	-coords "-360.0 -1.0 360.0 1.0" \
 	-under yes -mapx degrees -name fred 
   }]
} 

$graph postscript configure -maxpect yes -landscape yes
$graph configure -width 5i -height 5i
set unique 0

$graph axis configure x -title "X Axis"

table . \
    0,0 $graph -fill both 

bind $graph <Control-ButtonPress-3> { MakeSnapshot }
bind $graph <Shift-ButtonPress-3> { %W print }

proc MakeSnapshot {} {
    update idletasks
    global unique
    set top ".snapshot[incr unique]"
    set im [image create photo]
    $graph snap $im 210 150

    toplevel $top
    wm title $top "Snapshot \#$unique of \"[$graph cget -title]\""
    label $top.lab -image $im 
    button $top.but -text "Dismiss" -command "DestroySnapshot $top"
    table $top $top.lab
    table $top $top.but -pady 4 
    focus $top.but
}

proc DestroySnapshot { win } {
    set im [$win.lab cget -image]
    $im write test.ppm
    image delete $im
    destroy $win
    exit
}

if 0 {
    if { $tcl_platform(platform) == "windows" } {
	set printer [printer open [lindex [printer names] 0]]
	printer getattrs $printer attrs
	set attrs(Orientation) landscape
	printer setattrs $printer attrs
	after 2000 {
	    .graph print2 $printer
	    printer close $printer
	}
    }
}
