//---------------------------------------------------------------------------
// Copyright (c) 1995-1999 Ohio Board of Regents and the University of
// Cincinnati.  All Rights Reserved.

// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

//---------------------------------------------------------------------------

#ifndef ENUMERATIONTYPE_HH
#define ENUMERATIONTYPE_HH

#include "TypeInfo.hh"
#include "ScalarType.hh"

class SavantstringType;
class IntegerType;

class EnumerationType: public ScalarType {
public:
  EnumerationType() : ScalarType() {}
  EnumerationType(ObjectBase::ObjectType);
  EnumerationType(ObjectBase::ObjectType, const UniversalInteger&);
  EnumerationType(ObjectBase::ObjectType, const IntegerType&);
  EnumerationType(ObjectBase::ObjectType, const EnumerationType&);
  EnumerationType(bool, const EnumerationType&);
  EnumerationType(const EnumerationType&);

  // The new constructors 
  EnumerationType(ObjectBase::ObjectType, const enumInfo&);
  EnumerationType(ObjectBase::ObjectType, const TypeInfo&);
  EnumerationType(ObjectBase::ObjectType, const UniversalInteger&, const enumInfo&);
  EnumerationType(ObjectBase::ObjectType, const EnumerationType&, const enumInfo&);
  EnumerationType(const EnumerationType&, const enumInfo&);
  EnumerationType(bool, const EnumerationType&, const enumInfo&);
  
  virtual ~EnumerationType();
  
  EnumerationType& operator = (const EnumerationType&);
  
  Type get_kind() const;
  virtual const VHDLData& leftValue();
  
  //The attributes of Enumeration Types
  
  static EnumerationType  LEFT (const enumInfo&);
  static EnumerationType  RIGHT(const enumInfo&);
  static EnumerationType  HIGH (const enumInfo&);
  static EnumerationType  LOW  (const enumInfo&);
  static EnumerationType  ASCENDING (const enumInfo&);
  static EnumerationType  SUCC      (const EnumerationType&);
  static EnumerationType  PRED      (const EnumerationType&);
  static EnumerationType  LEFTOF    (const EnumerationType&);
  static EnumerationType  RIGHTOF   (const EnumerationType&);
  static SavantstringType IMAGE     (const EnumerationType&); 
  static EnumerationType  VALUE     (const SavantstringType&, const enumInfo&);
  static IntegerType      POS       (const EnumerationType&, const enumInfo&);
  static IntegerType      POS       (const EnumerationType&);
  static EnumerationType  VAL       (const IntegerType&, const enumInfo&);

  TypeInfo& getTypeInfo() const;
  
public:
  enumInfo range;
};

extern ostream& operator<<(ostream &, const EnumerationType &);

bool operator == (const EnumerationType&, const EnumerationType&);

EnumerationType savantAnd(const EnumerationType&, const EnumerationType&);
EnumerationType savantOr(const EnumerationType&, const EnumerationType&);
EnumerationType savantNot(const EnumerationType&);
EnumerationType savantNand(const EnumerationType&, const EnumerationType&);
EnumerationType savantNor(const EnumerationType&, const EnumerationType&);
EnumerationType savantXor(const EnumerationType&, const EnumerationType&);
EnumerationType savantXnor(const EnumerationType&, const EnumerationType&);

extern const EnumerationType ENUMERATION_ZERO;
extern const EnumerationType ENUMERATION_ONE;

#define ENUMERATION_FALSE ENUMERATION_ZERO
#define ENUMERATION_TRUE  ENUMERATION_ONE
#endif

