/*$Id: d_logicmod.cc,v 15.13 1999/10/18 05:40:26 al Exp $ -*- C++ -*-
 * logic model and device.
 * netlist syntax:
 * device:  mxxxx vdd out in1 in2 ... family gatetype
 * model:   .model mname LOGIC <args>
 */
#include "ap.h"
#include "d_logic.h"
/*--------------------------------------------------------------------------*/
//		MODEL_LOGIC::MODEL_LOGIC();
//	void	MODEL_LOGIC::parse(CS& cmd);
// 	void	MODEL_LOGIC::print(int,int)const;
/*--------------------------------------------------------------------------*/
int MODEL_LOGIC::_count = -1; // there is one in e_node.cc
/*--------------------------------------------------------------------------*/
MODEL_LOGIC::MODEL_LOGIC()
  :MODEL_CARD(),
   delay  (1e-9),
   vmax   (5.),
   vmin	  (0.),
   unknown((vmax+vmin)/2),
   range  (vmax - vmin),
   rise   (delay / 2),
   fall   (delay / 2),
   rs     (100.),
   rw     (1e9),
   th1    (.75),
   th0    (.25),
   mr     (5.),
   mf     (5.),
   over   (.1)
{
  ++_count;
}
/*--------------------------------------------------------------------------*/
void MODEL_LOGIC::parse(CS& cmd)
{
  cmd.skiparg();		/* skip known ".model" */
  parse_label(cmd);
  cmd.skiparg();		/* skip known "logic" */
  cmd.skiplparen();
  cmd.stuck();
  do{
    cmd.get("DElay",	&delay,	mPOSITIVE);
    cmd.get("RIse",	&rise,	mPOSITIVE);
    cmd.get("FAll",	&fall,	mPOSITIVE);
    cmd.get("RS",	&rs,	mPOSITIVE);
    cmd.get("RW",	&rw,	mPOSITIVE);
    cmd.get("THH",	&th1);
    cmd.get("THL",	&th0);
    cmd.get("MR",	&mr,	mPOSITIVE);
    cmd.get("MF",	&mf,	mPOSITIVE);
    cmd.get("OVer",	&over,	mPOSITIVE);
    cmd.get("VMAx",	&vmax);
    cmd.get("VMIn",	&vmin);
    cmd.get("Unknown",	&unknown);
  }while (cmd.more() && !cmd.stuck());
  cmd.skiprparen();
  cmd.check(bWARNING, "what's this?");
  range = vmax - vmin;
}
/*--------------------------------------------------------------------------*/
void MODEL_LOGIC::print(OMSTREAM where, int)const
{
  where.setfloatwidth(7)
    << ".model " << short_label() << " logic ("
    <<   "delay="  << delay
    << "  rise="   << rise
    << "  fall="   << fall
    << "  rs="     << rs
    << "  rw="     << rw
    << "  thh="    << th1
    << "  thl="    << th0
    << "  mr="     << mf
    << "  mf="     << mr
    << "  over="   << over
    << "  vmax="   << vmax
    << "  vmin="   << vmin
    << "  unknown="<< unknown
    << ")\n";
}
/*--------------------------------------------------------------------------*/
/*--------------------------------------------------------------------------*/
