#ifndef _FIXUPS_H
#define _FIXUPS_H

/*
 * Copyright (c) 1993-2000 Eric Youngdale, Peter MacDonald, David Engel
 * and Hongjiu Lu.
 *
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. The name of the above contributors may not be
 *    used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* Notice of general intent:
 *
 * The linux operating system generally contains large amounts of code
 * that fall under the GNU General Public License, or GPL for short.
 * This file contains source code that by it's very nature would always
 * be linked with an application program, and because of this a GPL type
 * of copyright on this file would place restrictions upon the
 * distribution of binary-only commercial software.  Since the goal of the
 * Linux project as a whole is not to discourage the development and
 * distribution of commercial software for Linux, this file has been placed
 * under a more relaxed BSD-style of copyright.
 *
 * It is the general understanding of the above contributors that a
 * program executable linked to a library containing code that falls
 * under the GPL or GLPL style of license is not subject to the terms of
 * the GPL or GLPL license if the program executable(s) that are supplied
 * are linked to a shared library form of the GPL or GLPL library, and as long
 * as the form of the shared library is such that it is possible for
 * the end user to modify and rebuild the library and use it in
 * conjunction with the program executable.
 */

/* This list is generated by the linker - it corresponds to the SETD
   list generated in conjunction with the variable __SHARABLE_CONFLICTS__.
   The linker does not do anything special with this symbol - it simply
   puts together the pieces that are needed.  The list of fixups to local
   variables is generated internally by the linker, and ld fills in this
   one field as a special case before writing the image.  The array size
   is listed as 1, but it would actually be  ->size - 2.  __load.c will
   pick up this pointer and pass it to __dynamic_resolve() and __do_fixups().
*/

struct fixuplist {  /* This list is generated by the linker */
  int size;
  unsigned * magic;  /* Used for verification purposes */
  struct image_fixuplist * list;  /* Fixups to local variables */
  struct fixuplist *** shrlib_list[1];  /* One for each sharable
	        library this program is linked to.  The sharable libraries
		are linked to other sharable libraries, so we have to walk
		this tree and resolve all of the fixups. */
};			

/* This is a linker-generated list of fixups.  The linker essentially
   watches for	multiple definitions of symbols, and if there is a
   __GOT__ symbol then it does not flag an error condition.  Instead, it
   adds a fixup to the fixuplist which will correct the __GOT__ that 
   appears later on the link command line.  The number of pointer pairs
   is always specified by the size field, and after the last pointer pair
   is the pointer to the builtin_fixups.
   */

struct image_fixuplist {
  int size;
  struct elemental_fixup {
    union {
      int  newaddr;
      struct builtin_fixup* bifu;
    }un;
    int * fixaddr;
  } fix[1];
};

/* Each link image (sharable libraries are each considered a sharable
   link image) will have a list of builtin fixups as well, as many as one
   for each source file that went into the link image.  These lists
   are generated by jumpas as needed (perhaps one per source file), and a SETD
   symbol __BUILTIN_FIXUPS__.  These will never appear in a user program -
   only in a shared library.  This structure contains a series of pointers
   to these different lists, and we need to walk through and apply all
   of the fixups.  The array size is listed as 1, but it can be any number
 */

struct builtin_fixup {
	int len;
	struct file_fixup * fixpnt[1];  /* Potentially one for every source
					    file that was linked */
};

/* Each source file can potentially have one of these beasts.  There
   are a series of pointer pairs, terminated by a NULL.  The idea here is
   that we are supposed to copy the number out of gotaddr  and store it at
   fixaddr.  This is the list that is generated by the jumpas tool.
   This is listed with an array size of 1, but it can be any number.
 */

struct file_fixup {
  struct builtin_elemental_fixup {
    int * gotaddr;
    int * fixaddr;
  } fixup[1];
};

int __reset_magic(struct fixuplist * xpnt);
int __do_fixups(struct fixuplist * xpnt, int flag);
int __dynamic_resolve(struct fixuplist * xpnt);

void ldpreload (char *name, int ldd, char **libs, int num, char *argv0);

#endif /* _FIXUPS_H */
