/* Nestra fb.c */
/* Framebuffer/pixmap rendering */
/* Public Domain */

#include <stdio.h>
#include "mapper.h"
#include "globals.h"

/* globals: */
void(*drawimage)();
unsigned int depth;

/* pallette and fb are allocated as 32-bit arrays,                          */
/* however, they contain 8, 16, or 32-bit data depending on the colordepth. */
/* Hopefully all the typecasts are not too confusing to the reader.         */
int palette_alloc[25];
void *palette=palette_alloc;
int fb_alloc[256*240];
void *fb=fb_alloc;

unsigned int vline=0;
unsigned int vscan=0;        
unsigned int frameskip=0;
unsigned int vwrap=0;
unsigned int scanpage=0;

#define DEPTH 8
#include "pixels.c"

#undef DEPTH

#define DEPTH 16
#include "pixels.c"

#undef DEPTH

#define DEPTH 32
#include "pixels.c"

fbinit()
{
  /* Assign the drawimage function to the      */
  /* correct version for the color depth used: */
  if(depth==8) drawimage=drawimage8;
  else if(depth==16) drawimage=drawimage16;
  else if(depth==24) drawimage=drawimage32;
  else if(depth==32) drawimage=drawimage32;
  else {fprintf(stderr,"Don't know how to handle color depth %d\n",depth);fflush(stderr);exit(1);}
  /*printf("depth %d\n",depth);*/
}
