\name{Math.polynomial}
\title{Math Functions with Polynomial Arguments}
\usage{
Math.polynomial(x, digits)
}
\arguments{
\item{x}{An object of class polynomial}
\item{digits}{Precision, as required by \code{round()} or \code{signif()}}
}
\description{
Group method for functions in the Math group.

Most math group functions are disallowed with polynomial arguments.  The
only exceptions are \code{round()} and \code{signif()} which may be used
to transform the coefficients accordingly.
}
\value{
A polynomial with transformed coefficients.
}
\seealso{
Ops.polynomial, Summary.polynomial
}
\examples{
p <- poly.from.values(1:4, (2:5)^2)
p
# 1 + 2.00000000000001*x + x^2 
p <- round(p)
p
# 1 + 2*x + x^2 
}
