/* ### Modified by P.Saratxaga on 12 Sep 1995 ###
 * - some hacking to handle non standard MSGID's
 * - PUDDLE_GATE repairs the Newsgroups lines from the gate used at
 *   puddle.fidonet.org, which puts spaces in Newsgroups header
 * - Added PCBOARD_GATE
 * - added ALLOW_CONTROL and charset handling
 * - added FORCE_REPYLTO_LOCAL
 * - added charset support (see Changelog for details)
 * - corrected a bug about ^aRFCID
 * - added recognition for "^aMSGID <localid@some.where.org> 0124587" created
 *   by fidogate.
 * - No "X-Comment-To: " is generated if the value is "All"
 * - added #ifdef RNEWSB; when compiled with it, the result of ifnews -N is an
 *   rnews readable file.
 * - REFERENCES_MSC96 to compile whith Marc Schaeffer's ref_interface.h
 */
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <time.h>
#include <ctype.h>
#include "lutil.h"
#include "xutil.h"
#include "mkrfcmsg.h"
#include "ftnmsg.h"
#include "rfcmsg.h"
#include "areas.h"
#include "falists.h"
#include "config.h"
#include "needed.h"
#include "charset.h"
#include "charconv.h"
#include "mime.h"
#ifdef REFERENCES_MSC96
#include "ref_interface.h"
extern ref_private_t *ref_dbase;
#endif

#define BOUNDARY 79
#define MAXPATH 73

#ifndef LEVEL
#define LEVEL	1
#endif

int num_echo=0,num_mail=0;
extern char *version;
extern FILE *nb;
extern faddr pktfrom;
extern int notransports;

extern char *rfcdate(time_t);
extern unsigned INT32 sequencer(void);
extern unsigned INT16 crc(char*);
extern char *lookup(char *);
extern char *backalias(faddr *);
#ifdef GATEBAU_MSGID
extern unsigned long crcgatebau(char*);
char *gatebaudate(time_t);
#endif

extern FILE *expipe(char*,char*,char*);
extern int exclose(FILE*);
extern char *compose_flags(int,char *);
extern int pgpsigned;
#ifdef DIRTY_CHRS
extern int dirtyoutcode;
#endif

#ifdef GATEBAU_MSGID
char *rfcmsgid(msgid,bestaka,mode)
char *msgid;
faddr *bestaka;
int mode; /* 0=ifmail-style, 1=gatebau-style */
#else
char *rfcmsgid(msgid,bestaka)
char *msgid;
faddr *bestaka;
#endif
{
	static char *buf,*p,*q,*r;
#ifdef REFERENCES_MSC96
	char buf2[1024];
#endif
	unsigned long id=0L;
	faddr *ta=NULL;

/* +40 for the additionnal stuff we need to write, should be enough */
	buf=xmalloc(strlen(msgid)+40);

	if ((r=strrchr(msgid,'\n'))) *r='\0'; 
/* sometimes there is "^aMSGID: 1:23/45@@domain 152ad589" */
	if ((p = strstr(msgid, "@@"))) {
#ifdef GATEBAU_MSGID
		if (mode==1) {
			sprintf(buf,"<MSGID_%s@fidonet.org>",
				qp_encode(msgid,1));
			*r='\n';
			return buf;
		} else {
#endif
			*p='\0';
			strcat(msgid, p+1);
#ifdef GATEBAU_MSGID
		}
#endif
	}
/* other times there is "^aMSGID: 1:23/45@ 152ad589" */
	else if ((p = strstr(msgid,"@ "))) {
#ifdef GATEBAU_MSGID
		if (mode==1) {
			sprintf(buf,"<MSGID_%s@fidonet.org>",
				qp_encode(msgid,1));
			*r='\n';
			return buf;
		} else {
#endif
			*p='\0';
			strcat(msgid,p+1);
#ifdef GATEBAU_MSGID
		}
#endif
	}
/* here we have a parseable address */
	if ((p=strrchr(msgid,' ')))
	{
		*p='\0';
		sscanf(p+1,"%lx",&id);
		ta=parsefnode(msgid);
		*p=' ';
	}
	if (id != 0L)
	{
#ifdef GATEBAU_MSGID
		/* if we only check for (ta) a Message-ID like
		 * <123456.7890@internet.domain> will be recognized as
		 * a fidonet one (ta->node=123456, ta->point=7890,
		 * ta->domain="internet", but ta->net=0) which obviously
		 * isn't the case. By cheking also (ta->net) we avoid that
		 */
		if ((ta) && (ta->net) && (mode==1))
		{
			if (((ta->zone) > 0) && ((ta->zone) < 7))
				sprintf(buf,"<MSGID_%s@fidonet.org>",
					qp_encode(msgid,1));

			else sprintf(buf,"<MSGID_%s@%s.ftn>",
					qp_encode(msgid,1),
					(bestaka->domain)?bestaka->domain:"nodomain");
		}
		else
#endif
		/* if we only check for (ta) a Message-ID like
		 * <123456.7890@internet.domain> will be recognized as
		 * a fidonet one (ta->node=123456, ta->point=7890,
		 * ta->domain="internet", but ta->net=0) which obviously
		 * isn't the case. By cheking also (ta->net) we avoid that
		 */
		if ((ta) && (ta->net))
		{
			sprintf(buf,"<%lu@%s.ftn>",id,ascinode(ta,0x1f));
#ifdef REFERENCES_MSC96
			if (refdbm)
			{
				sprintf(buf2,"%s",buf);
				ref_get(ref_dbase,buf2,buf,1024);
			}
#endif
		}
		else
		{
			p=xstrcpy(msgid);
			if ((q=strchr(p,' '))) *q='\0';
/* ### Modified by P.Saratxaga on 18 Aug 1995 */
			if (strstr(p,"@")) {
	/* "mid__<local@domain>" are generated by gigo */
				if (!strncmp(p,"mid__<",6))
				{
					sprintf(buf,"%s",p+6);
					while ((q=strstr(buf,">_<")))
						*(q+1)=' ';
				}
	/* "mid__local@domain" are also generated by gigo */
				else if (!strncmp(p,"mid__",5))
					sprintf(buf,"<%s>",p+5);
	/* "wgmid$<local@domain>" */
				else if (!strncmp(p,"wgmid$<",7))
					sprintf(buf,"%s",p+6);
	/* in case we have "<local@domain>" */
			        else if (!strncmp(p,"<",1))
					sprintf(buf,"%s",p);
	/* or "local@domain" */
				else sprintf(buf,"<%s>",p);
				while ((q = strchr(buf, '@')) != strrchr(buf, '@'))
				{
					/* we (still) have more than one @ */
					*q = '%';
				}
			}
			else
			{
				sprintf(buf,"<%lu@%s>",id,p);
#ifdef REFERENCES_MSC96
				if (refdbm)
				{
					sprintf(buf2,"%s",buf);
					ref_get(ref_dbase,buf2,buf,1024);
				}
#endif
			}
			free(p);
		}
	}
#ifdef GATEBAU_MSGID
	else if (mode==1)
	{
		sprintf(buf,"<MSGID_%s@fidonet.org>",
			qp_encode(msgid,1));
	}
#endif
	else
	{
		sprintf(buf,"<%lu@%s.ftn>",(unsigned long)sequencer(),
			ascinode(bestaka,0x1f));
	}
	tidy_faddr(ta);
	if (r) *r='\n';
	return buf;
}

/* check address for localness, substitute alises and replace it *in place* */

void substitute(buf)
char *buf;
{
	faddr *fa;
	char *l,*r,*p=NULL;
	int inquotes,inbrackets;

	debug(6,"to address before subst: \"%s\"",buf);
	if ((l=strchr(buf,'<')) && (r=strchr(buf,'>')) && (l < r))
	{
		l++;
		*r='\0';
	}
	else l=buf;
	while (*l == ' ') l++;
	for (r=l,inquotes=0,inbrackets=0;*r;r++) switch (*r)
	{
	case '"':	inquotes=(!inquotes); break;
	case ',':
	case ' ':	if (!inquotes && !inbrackets) *r='\0'; break;
	case '(':	if (!inquotes) inbrackets++; break;
	case ')':	if (!inquotes && inbrackets) inbrackets--; break;
	default:	break;
	}
	if ((fa=parsefaddr(l)))
	{
		debug(6,"it is an ftn address: %s",ascfnode(fa,0x7f));
		if (is_local(fa))
		{
			debug(6,"it is local");
			sprintf(buf,"%s",fa->name);
			if (!strchr(buf,'@') && (p=strrchr(buf,'%')))
				*p='@';
			if (!strchr(buf,'@'))
			{
				if ((p=lookup(buf)))
					strcpy(buf,p);
				else for (p=buf;*p;p++)
					if (*p == ' ') *p='.';
			}
			if (!strcasecmp(buf,"sysop")) strcpy(buf,"postmaster");
		}
		else
		{
			debug(6,"it is not local");
			sprintf(buf,"%s",ascinode(fa,0x7f));
		}
		tidy_faddr(fa);
	}
	else 
	{
		debug(6,"it is not ftn address");
		for (r=buf;*l;l++,r++) *r=*l;
		*r='\0';
	}
	if (buf[0] == '\0') strcpy(buf,"postmaster");
	debug(6,"to address after  subst: \"%s\"",buf);
	return;
}

/* from, to, subj, orig, mdate, flags, file, offset, kluges */

int mkrfcmsg(f,t,subj,orig,mdate,flags,fp,endoff,kmsg)
faddr *f,*t;
char *subj,*orig;
time_t mdate;
int flags;
FILE *fp;
off_t endoff;
rfcmsg *kmsg;
{
	char buf[BUFSIZ];
	char *p,*q,*l,*r,*b;
	char *newsgroup=NULL,*distribution=NULL;
	int incode, outcode;
	char *moderator=NULL;
	int modtype=0;
	char c;
	int count,rrq;
	rfcmsg *msg=NULL,*tmsg;
	FILE *pip;
	struct stat stbuf;
	int newsmode,pass,rc;
	faddr *ta,*bestaka;
	fa_list *ftnpath=NULL,*tfa,*rlist;
	time_t now;
	int lines;
	char lineshdr[16];
	moderator_list *tmpml;
#ifdef GATEBAU_MSGID
	int gatebaumode=0;
#endif

	incode = outcode = CHRS_NOTSET;

/*	if ((magicname == NULL) ||
	    ((t->name) && (strcasecmp(magicname,t->name) == 0))) */
		msg=parsrfc(fp);
	bestaka=bestaka_s(f);

	p=hdr("CHRS",kmsg);
	if (p == NULL) p=hdr("CHARSET",kmsg);
	if (p == NULL) p=hdr("CODEPAGE",kmsg);
	if (p) outcode=readchrs(p);
	else
	{
		p=hdr("Content-Type",msg);
		if (p == NULL) p=hdr("RFC-Content-Type",kmsg);
		if (p == NULL) p=hdr("Content-Type",kmsg);
		if (p) outcode=readcharset(p);
#ifndef JE
		else if ((hdr("Message-ID",msg)) ||
			 (hdr("RFC-Message-ID",kmsg)) ||
			 (hdr("Message-ID",kmsg)) ||
			 (hdr("RFCID",kmsg)) ||
			 (hdr("ORIGID",kmsg)) ||
			 ((hdr("MSGID",kmsg)) &&
#ifdef GATEBAU_MSGID
			  (!chkftnmsgid(rfcmsgid(hdr("MSGID",kmsg),bestaka,gatebaumode)))))
#else
			  (!chkftnmsgid(rfcmsgid(hdr("MSGID",kmsg),bestaka)))))
#endif
				outcode=defaultrfcchar;
		else outcode=defaultftnchar;
#endif
	}
#ifdef TERMAIL_HACK
	p=hdr("PID",kmsg);
	if ((p) && (!strncmp(p,"TerMail",7)) && (outcode==defaultrfcchar))
		outcode=defaultftnchar;
#endif
#ifdef DIRTY_CHRS
	if (dirtyoutcode != CHRS_NOTSET)
		outcode=dirtyoutcode;
#endif

	if (pgpsigned) incode=outcode;
/*	else incode=getincode(outcode); */
	                                
	if (kmsg && !strcmp(kmsg->key,"AREA"))
	{
		ngdist(kmsg->val,&newsgroup,&distribution,&moderator,&modtype);
#ifdef JE
		if (!pgpsigned) areacharset(kmsg->val, &incode, &outcode);
#endif
#ifdef GATEBAU_MSGID
		gatebaumode=areagatebau(kmsg->val);
#endif
		if (!newsgroup)
		{
			tidyrfc(msg);
			return 0;
		}
		newsmode=1;
		if ((modtype==1) &&
		    (!hdr("Approved",msg)) &&
		    (!hdr("RFC-Approved",kmsg)) &&
		    (!hdr("Approved",kmsg))) 
			newsmode=0;
	}
	else newsmode=0;
	debug(5,"Got %s message",newsmode?"echo":"netmail");
	if (outcode==CHRS_NOTSET)
	{
		if ((hdr("Message-ID",msg)) ||
		    (hdr("RFC-Message-ID",kmsg)) ||
		    (hdr("Message-ID",kmsg)) ||
		    (hdr("RFCID",kmsg)) ||
		    (hdr("ORIGID",kmsg)) ||
		    ((hdr("MSGID",kmsg)) &&
#ifdef GATEBAU_MSGID
		     (!chkftnmsgid(rfcmsgid(hdr("MSGID",kmsg),bestaka,gatebaumode)))))
#else
		     (!chkftnmsgid(rfcmsgid(hdr("MSGID",kmsg),bestaka)))))
#endif
			outcode=defaultrfcchar;
		 else outcode=defaultftnchar;
	}
	if (pgpsigned) incode=outcode;
	else if (incode==CHRS_NOTSET) incode=getincode(outcode);

	/* fsc-0038 defines "^aDOMAIN: othernet 99:12/34 fidonet 2:293/2219" */
	if ((p=hdr("DOMAIN",kmsg)) && (!strchr(p,'@')))
	{
		strncpy(buf,p,sizeof(buf)-1);
		buf[sizeof(buf)-1]='\0';
		l=strtok(buf," \n");
		p=strtok(NULL," \n");
		r=strtok(NULL," \n");
		q=strtok(NULL," \n");
		if ((ta=parsefnode(p)))
		{
			t->point=ta->point;
			t->node=ta->node;
			t->net=ta->net;
			t->zone=ta->zone;
			tidy_faddr(ta);
		}
		t->domain=xstrcpy(l);
		if ((ta=parsefnode(q)))
		{
			f->point=ta->point;
			f->node=ta->node;
			f->net=ta->net;
			f->zone=ta->zone;
			tidy_faddr(ta);
		}
		f->domain=xstrcpy(r);
	}
	else if ((p=hdr("INTL",kmsg)))
	{
		strncpy(buf,p,sizeof(buf)-1);
		buf[sizeof(buf)-1]='\0';
		l=strtok(buf," \n");
		r=strtok(NULL," \n");
		if ((ta=parsefnode(l)))
		{
			t->point=ta->point;
			t->node=ta->node;
			t->net=ta->net;
			t->zone=ta->zone;
			if (ta->domain)
			{
				if (t->domain) free(t->domain);
				t->domain=ta->domain;
				ta->domain=NULL;
			}
			tidy_faddr(ta);
		}
		if ((ta=parsefnode(r)))
		{
			f->point=ta->point;
			f->node=ta->node;
			f->net=ta->net;
			f->zone=ta->zone;
			if (ta->domain)
			{
				if (f->domain) free(f->domain);
				f->domain=ta->domain;
				ta->domain=NULL;
			}
			tidy_faddr(ta);
		}
	}

        /* fidogate generates "^aDOMAIN: Z2@fidonet" */
        if ((f->domain==NULL) && ((p=hdr("DOMAIN",kmsg)) && (q=strchr(p,'@'))))
        {
                *q='\0';
             /* f->zone=atoi(p+1); */
                f->domain=xstrcpy(q+1);
                *q='@';
        }

	if ((p=hdr("FMPT",kmsg))) f->point=atoi(p);
	if ((p=hdr("TOPT",kmsg))) t->point=atoi(p);

	debug(5,"final from: %s",ascfnode(f,0x1f));
	debug(5,"final   to: %s",ascfnode(t,0x1f));

	if (!newsmode)
	{
		p=hdr("Resent-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if (p == NULL) p=hdr("RFC-Resent-To",kmsg);
		if (p == NULL) p=hdr("RFC-To",kmsg);
	/*	if (p && is_local(t)) */
		if ((p) && (is_local(t)) && ((magicname == NULL) ||
		        ((t->name) && (strcasecmp(magicname,t->name) == 0))))
		{
			while (*p == ' ') p++;
			strncpy(buf,p,sizeof(buf)-1);
			if (*(p=buf+strlen(buf)-1) == '\n') *p='\0';
		}
		else if (modtype==1)  sprintf(buf,"%s",moderator);
		else sprintf(buf,"%s",ascinode(t,0x7f));
		substitute(buf);
		loginf("mail from %s to %s",ascfnode(f,0x7f),buf);
	}

	if ((newsmode) && (nb == NULL))
	{
		if (notransports)
		{
			nb=fopen(tempnam("/tmp/ifmail","N."),"w");
#ifndef RNEWSB
			fprintf(nb,"#!/bin/sh\n%s <<__EOF__\n",S(rnews));
#endif
		}
		else nb=expipe(rnews,NULL,NULL);
		if (nb == NULL)
		{
			logerr("$Could non open (pipe) output for news");
			tidyrfc(msg);
			return 2;
		}
	}

	if (newsmode)
	{
		if ((pip=tmpfile()) == NULL)
		{
			logerr("$Cannot open second temporary file");
			tidyrfc(msg);
			return 3;
		}
	}
	else
	{
#ifdef ALLOW_RETURNPATH
		p=hdr("Return-Path",msg);
		if (p == NULL) p=hdr("RFC-Return-Path",kmsg);
		if (p == NULL) p=hdr("Return-Path",kmsg);
		if (p)
		debug(2,"expipe(\"%s\",\"%s\",\"%s\")",
			S(sendmail),p,buf);
		else
#endif
		debug(2,"expipe(\"%s\",\"%s\",\"%s\")",
			S(sendmail),ascinode(f,0x7f),buf);
		if (notransports)
		{
			pip=fopen(tempnam("/tmp/ifmail","M."),"w");
#ifdef ALLOW_RETURNPATH
		if (p)
			fprintf(pip,"#!/bin/sh\nF=%s\nT=%s\n%s <<__EOF__\n",
				p,buf,S(sendmail));
		else
#endif
			fprintf(pip,"#!/bin/sh\nF=%s\nT=%s\n%s <<__EOF__\n",
				ascinode(f,0x7f),buf,S(sendmail));
		}
#ifdef ALLOW_RETURNPATH
		else if (p)
			pip=expipe(sendmail,p,buf);	
#endif
		else pip=expipe(sendmail,ascinode(f,0x7f),buf);
		if (pip == NULL)
		{
			logerr("$Could non open (pipe) output for mail");
			tidyrfc(msg);
			return 2;
		}
		if (modtype==1) newsmode=1;
	}

	if (newsmode)
	{
		num_echo++;
		if ((p=hdr("Path",msg)) == NULL)
			p=hdr("RFC-Path",kmsg);
		rlist=NULL;
		fill_rlist(&rlist,p);
		for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
			if (strcasecmp(tmsg->key,"SPTH") == 0)
				fill_list(&ftnpath,tmsg->val,&rlist);
		for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
			if (strcasecmp(tmsg->key,"PATH") == 0)
				fill_list(&ftnpath,tmsg->val,&rlist);
		tidy_falist(&rlist);

		fprintf(pip,"Path: ");
/* ### Modified by P.Saratxaga on 7 Aug 1995 */
/* I comment out this line, to avoid the repetition of my machine name 
   (is the news server that has to add it) */
	/*	fprintf(pip,"%s!",ascinode(bestaka,0x07)); */
/* ### */
		fprintf(pip,"%s!",ascinode(&pktfrom,0x07));
		if (ftnpath)
			for (tfa=ftnpath->next;tfa;tfa=tfa->next)
				fprintf(pip,"%s!",ascinode(tfa->addr,0x1f));
		tidy_falist(&ftnpath);

		if (p)
		{
			while (isspace(*p)) p++;
			fprintf(pip,"%s",p);
		}
		else fprintf(pip,"not-for-mail\n");

#ifdef PUDDLE_GATE
		if ((p=hdr("Newsgroups",msg)))
/* The gate at puddle.fidonet.org put spaces in Newsgroups header */
		{
		if ((strstr(p,", ")))
			{
			while ((r = strchr(p, ' ')))
                	        {
					*r = '\0';
					strcat(p,r+1);
                	        }
			fprintf(pip,"Newsgroups: %s",p);
			}
		else fprintf(pip,"Newsgroups:%s",p);
		}
#else
		if ((p=hdr("Newsgroups",msg))) fprintf(pip,"Newsgroups:%s",p);
#endif
		else if ((p=hdr("RFC-Newsgroups",kmsg))) fprintf(pip,"Newsgroups: %s",p);
		else if ((p=hdr("Newsgroups",kmsg))) fprintf(pip,"Newsgroups: %s",p);
		else fprintf(pip,"Newsgroups: %s\n",newsgroup);

		if ((p=hdr("Distribution",msg))) fprintf(pip,"Distribution:%s",p);
		else if ((p=hdr("RFC-Distribution",kmsg))) fprintf(pip,"Distribution: %s",p);
		else if ((p=hdr("Distribution",kmsg))) fprintf(pip,"Distribution: %s",p);
		else if (distribution) fprintf(pip,"Distribution: %s\n",distribution);

		p=hdr("Comment-To",msg);
		if (p == NULL) p=hdr("X-Comment-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if ((p) && (strcasecmp(p,"All\n")))
			fprintf(pip,"X-Comment-To:%s",hdrconv(p,outcode,incode));
		else
		{
			if (p == NULL) p=hdr("RFC-X-Comment-To",kmsg);
			if (p == NULL) p=hdr("RFC-Comment-To",kmsg);
			if (p == NULL) p=hdr("RFC-To",kmsg);
			if ((p) && (strcasecmp(p,"All\n")))
 				fprintf(pip,"X-Comment-To: %s",hdrconv(p,outcode,incode));
			else if ((t->name) && (strcasecmp(t->name,"All")))
				fprintf(pip,"X-Comment-To: %s\n",hdrconv(t->name,outcode,incode));
		}


		for (tmpml=approve;tmpml;tmpml=tmpml->next) {
			if ((strncmp(newsgroup,tmpml->prefix,
					strlen(tmpml->prefix)) == 0)) {
				modtype=2;
				moderator=xstrcpy(tmpml->address);
				break;
			}
		}

		if ((p=hdr("Approved",msg))) fprintf(pip,"Approved:%s",p);
		else if ((p=hdr("RFC-Approved",kmsg))) fprintf(pip,"Approved: %s",p);
		else if ((p=hdr("Approved",kmsg))) fprintf(pip,"Approved: %s",p);
		else if (modtype==2) fprintf(pip,"Approved: %s\n",moderator);
	}
	else
	{
		num_mail++;
		time(&now);
#ifdef NEED_UUCPFROM
		fprintf(pip,"From %s!",ascinode(f,0x3f));
		fprintf(pip,"%s %s",ascinode(f,0x40),ctime(&mdate));
#endif
#if (LEVEL > 1)
		fprintf(pip,"Received: from %s ",ascinode(f,0x3f));
		fprintf(pip,"by %s\n",ascinode(bestaka,0x3f));
		fprintf(pip,"\twith FTN (ifmail v.%s) id AA%u; %s\n",
			version,getpid(),rfcdate(now));
#endif

		for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
			if (!strcasecmp(tmsg->key,"RFC-Received"))
				fprintf(pip,"%s: %s",tmsg->key+4,tmsg->val);
		for (tmsg=msg;tmsg;tmsg=tmsg->next)
			if (!strcasecmp(tmsg->key,"Received"))
				fprintf(pip,"%s:%s",tmsg->key,tmsg->val);

		if ((p=hdr("Apparently-To",msg))) fprintf(pip,"Apparently-To:%s",p);
		else if ((p=hdr("RFC-Apparently-To",kmsg))) fprintf(pip,"Apparently-To: %s",p);
		else if ((p=hdr("Apparently-To",kmsg))) fprintf(pip,"Apparently-To: %s",p);
		else if ((is_local(t))) fprintf(pip,"Apparently-To: %s\n",buf);

		if (flags & FLG_RRQ) rrq=1;
		else rrq=0;
		if (rrq && !hdr("RFC-Return-Receipt-To",kmsg) &&
		    !hdr("Return-Receipt-To",msg) &&
		    !hdr("RFC-Notice-Requested-Upon-Delivery-To",kmsg) &&
		    !hdr("Notice-Requested-Upon-Delivery-To",msg))
		{
                        fprintf(pip,"Notice-Requested-Upon-Delivery-To: %s\n",buf);
		}


		if (t->name == NULL) t->name=xstrcpy("Postmaster");
		p=hdr("Resent-To",msg);
		if (p == NULL) p=hdr("To",msg);
		if (p)
			fprintf(pip,"To:%s",p);
		else
		{
			if (p == NULL) p=hdr("RFC-Resent-To",kmsg);
			if (p == NULL) p=hdr("RFC-To",kmsg);
			if (p) fprintf(pip,"To: %s",p);
			else if (modtype==1) fprintf(pip,"To: %s\n",moderator);
			else fprintf(pip,"To: %s\n",ascinode(t,0xff));
		}
	}

	if ((p=hdr("From",msg))) fprintf(pip,"From:%s",hdrconv(p,outcode,incode));
	else if ((p=hdr("RFC-From",kmsg))) fprintf(pip,"From: %s",hdrconv(p,outcode,incode));
	else if ((p=hdr("From",kmsg))) fprintf(pip,"From: %s",hdrconv(p,outcode,incode));
#ifdef PCBOARD_GATE
	else if ((p=hdr("X-PcBoard-FROM",msg)))
		if (f->name) {
			while (isspace(*p)) p++;
			p[strlen(p)-1]='\0';
			fprintf(pip,"From: %s <%s>\n",
				hdrconv(f->name,outcode,incode),
				p);
		}
		else fprintf(pip,"From:%s",p);
#endif
	else if ((hdr("REPLYADDR",kmsg)) && (p=xstrcpy(hdr("REPLYADDR",kmsg))))
	{
		if (*(r=p+strlen(p)-1) == '\n') *(r--)='\0';
		while (isspace(*r)) *(r--)='\0';
		q=xstrcpy(hdr("X-RealName",msg));
		if (q == NULL) q=xstrcpy(hdr("RealName",msg));
		if (q == NULL) q=xstrcpy(hdr("X-RealName",kmsg));
		if (q == NULL) q=xstrcpy(hdr("RealName",kmsg));
		if (q)
		{
			if (*(r=q+strlen(q)-1) == '\n') *(r--)='\0';
			while (isspace(*r)) *(r--)='\0';
			for (l=q;isspace(*l);) l++;
			if ((*l == '\"') && (*r == '\"'))
			{
				l++;
				*r--='\0';
			}
			fprintf(pip,"From: \"%s\" <%s>\n",hdrconv(l,outcode,incode),p);
			free(q);
		}
		else if (f->name) fprintf(pip,"From: \"%s\" <%s>\n",hdrconv(f->name,outcode,incode),p);
		else fprintf(pip,"From: %s\n",p);
		free(p);
	}
	if (p) fprintf(pip,"X-FTN-Sender: %s\n",hdrconv(ascinode(f,0xff),outcode,incode));
	else fprintf(pip,"From: %s\n",hdrconv(ascinode(f,0xff),outcode,incode));

	if ((p=hdr("Reply-To",msg))) fprintf(pip,"Reply-To:%s",p);
	else if ((p=hdr("RFC-Reply-To",kmsg))) fprintf(pip,"Reply-To: %s",p);
	else if ((p=hdr("Reply-To",kmsg))) fprintf(pip,"Reply-To: %s",p);
	else if (((p=backalias(f))) && myfqdn)
		fprintf(pip,"Reply-To: %s@%s\n",p,myfqdn);
	else if ((p=hdr("REPLYADDR",kmsg))) fprintf(pip,"Reply-To: %s",p);
	else if ((p=hdr("REPLYTO",kmsg))) fprintf(pip,"Reply-To: %s\n",ascinode(parsefaddr(p),0xff));

	if ((p=hdr("Date",msg))) fprintf(pip,"Date:%s",p);
	else if ((p=hdr("RFC-Date",kmsg))) fprintf(pip,"Date: %s",p);
	else if ((p=hdr("Date",kmsg))) fprintf(pip,"Date: %s",p);
	else if (newsmode) {
#ifdef RESTAMP_FUTURE_POSTINGS
		if(mdate > time(&now)) {
			loginf("Future posting: %s", rfcdate(mdate));
			fprintf(pip,"Date: %s\n", rfcdate(now));
			fprintf(pip,"X-Origin-Date: %s\n", rfcdate(mdate));
		} else
#endif
#ifdef RESTAMP_OLD_POSTINGS
		if((mdate < time(&now)-14*24*60*60) &&
		   (mdate > time(&now)-RESTAMP_OLD_POSTINGS*24*60*60)) {
			loginf("Article too old, restamped: %s", rfcdate(mdate));
			fprintf(pip,"Date: %s\n", rfcdate(now));
			fprintf(pip,"X-Origin-Date: %s\n", rfcdate(mdate));
		} else
#endif
		fprintf(pip,"Date: %s\n",rfcdate(mdate));
	}
	else fprintf(pip,"Date: %s\n",rfcdate(mdate));

	if ((p=hdr("Subject",msg))) fprintf(pip,"Subject:%s",hdrconv(p,outcode,incode));
	else if ((p=hdr("RFC-Subject",kmsg))) fprintf(pip,"Subject: %s",hdrconv(p,outcode,incode));
	else if ((p=hdr("Subject",kmsg))) fprintf(pip,"Subject: %s",hdrconv(p,outcode,incode));
#ifdef PCBOARD_GATE
	else if ((p=hdr("X-PcBoard-SUBJECT",msg))) fprintf(pip,"Subject:%s",hdrconv(p,outcode,incode));
#endif /* PCBOARD_GATE */
	else if (subj && (strspn(subj," \t\n\r") != strlen(subj)))
		fprintf(pip,"Subject: %s\n",hdrconv(subj,outcode,incode));
	else fprintf(pip,"Subject: <none>\n");

	if ((p=hdr("Message-ID",msg)))
		fprintf(pip,"Message-ID:%s",p);
	else if ((p=hdr("RFC-Message-ID",kmsg)))
		fprintf(pip,"Message-ID: %s",p);
	else if ((p=hdr("Message-ID",kmsg)))
		fprintf(pip,"Message-ID: %s",p);
	else if ((p=hdr("RFCID",kmsg)))
		if ((p[0]=='<')) {
			/* "^aRFCID: <local@machine>" */
			if ((p[strlen(p)-2]=='>'))
				fprintf(pip,"Message-ID: %s",p);
			/* "^aRFCID: <local@machine" */
			/* I saw it on some IntToss gated articles
			 * it seems to be a bug on the program or something
			 * like that, because in the majority of IntToss gated
			 * articles it is "^aRFCID: local@machine"
			 */
			else { p[strlen(p)-1]='\0';
				fprintf(pip,"Message-ID: %s>\n",p);
			}
		}
		/* "^aRFCID: local@machine" */
		else { 
			p[strlen(p)-1]='\0'; 
			fprintf(pip,"Message-ID: <%s>\n",p);
		}
	else if ((p=hdr("ORIGID",kmsg)))
		fprintf(pip,"Message-ID: %s",p);
	else if ((p=hdr("MSGID",kmsg)))
#ifndef GATEBAU_MSGID
		fprintf(pip,"Message-ID: %s\n",rfcmsgid(p,bestaka));
#else
		fprintf(pip,"Message-ID: %s\n",rfcmsgid(p,bestaka,gatebaumode));
	else if (gatebaumode==1)
	{
		strcpy(buf,f->name);
		if ((p=strrchr(buf,'\n'))) *p='\0';
		strcat(buf,t->name);
		if ((p=strrchr(buf,'\n'))) *p='\0';
		strcat(buf,subj);
		if ((p=strrchr(buf,'\n'))) *p='\0';
		if (((f->zone) > 0) && ((f->zone) < 7))
			fprintf(pip,"Message-ID: <NOMSGID_%d=3A%d=2F%d.%d_%s_%08lx@fidonet.org>\n",
				f->zone,f->net,f->node,f->point,
				gatebaudate(mdate),
				crcgatebau(buf));

		else fprintf(pip,"Message-ID: <NOMSGID_%d=3A%d=2F%d.%d_%s_%08lx@%s.ftn>\n",
			f->zone,f->net,f->node,f->point,
			gatebaudate(mdate),
			crcgatebau(buf),
			(f->domain)?f->domain:"nodomain");
	}
#endif
	else fprintf(pip,"Message-ID: <%lu@%s.ftn>\n",
			mdate^(subj?crc(subj):0L),
			ascinode(f,0x1f));

	if (newsmode)
	{
		if ((p=hdr("References",msg)))
			fprintf(pip,"References:%s",p);
		else if ((p=hdr("RFC-References",kmsg)))
			fprintf(pip,"References: %s",p);
		else if ((p=hdr("References",kmsg)))
			fprintf(pip,"References: %s",p);
		else if ((p=hdr("ORIGREF",kmsg)))
			fprintf(pip,"References: %s",p);
		else if ((p=hdr("REPLY",kmsg)))
#ifndef GATEBAU_MSGID
			fprintf(pip,"References: %s\n",rfcmsgid(p,bestaka));
#else
			fprintf(pip,"References: %s\n",rfcmsgid(p,bestaka,gatebaumode));
#endif
	}
	else
	{
		if ((p=hdr("In-Reply-To",msg)))
			fprintf(pip,"In-Reply-To:%s",p);
		else if ((p=hdr("RFC-In-Reply-To",kmsg)))
			fprintf(pip,"In-Reply-To: %s",p);
		else 
		{
			if ((p=hdr("REPLY",kmsg)))
				fprintf(pip,"In-Reply-To: %s\n",
#ifndef GATEBAU_MSGID
					rfcmsgid(p,bestaka));
#else
					rfcmsgid(p,bestaka,gatebaumode));
#endif
		}
	}

	if ((p=hdr("Organization",msg)))
		fprintf(pip,"Organization:%s",hdrconv(p,outcode,incode));
	else if ((p=hdr("RFC-Organization",kmsg)))
		fprintf(pip,"Organization: %s",hdrconv(p,outcode,incode));
	else if ((p=hdr("Organization",kmsg)))
		fprintf(pip,"Organization: %s",hdrconv(p,outcode,incode));
	else if (orig) 
		fprintf(pip,"Organization: %s\n",hdrconv(orig,outcode,incode));

	if ((p=hdr("Supersedes",msg)))
		fprintf(pip,"Supersedes:%s",p);
	else if ((p=hdr("RFC-Supersedes",kmsg)))
		fprintf(pip,"Supersedes: %s",p);
	else if ((p=hdr("Supersedes",kmsg)))
		fprintf(pip,"Supersedes: %s",p);
	else if ((p=hdr("ACUPDATE",kmsg)) && (strstr(p,"MODIFY")))
#ifndef GATEBAU_MSGID
			fprintf(pip,"Supersedes: %s\n",rfcmsgid(p+8,bestaka));
#else
			fprintf(pip,"Supersedes: %s\n",rfcmsgid(p+8,bestaka,gatebaumode));
#endif

#ifdef ALLOW_CONTROL
	if ((p=hdr("Control",msg)))
                fprintf(pip,"Control:%s",p);
        else if ((p=hdr("RFC-Control",kmsg)))
                fprintf(pip,"Control: %s",p);
        else if ((p=hdr("Control",kmsg)))
                fprintf(pip,"Control: %s",p);
        else if ((p=hdr("ACUPDATE",kmsg)) && (strstr(p,"DELETE")))
#ifndef GATEBAU_MSGID
                        fprintf(pip,"Control: cancel %s\n",rfcmsgid(p+8,bestaka));
#else
			fprintf(pip,"Control: cancel %s\n",rfcmsgid(p+8,bestaka,gatebaumode));
#endif
#endif
        writechrs(incode,pip,0);
	if (incode != outcode) writechrs(outcode,pip,2);
	writecharset(incode,pip,msg,kmsg);

	if (newsmode) {
        if ((p=hdr("X-Newsreader",msg)))
                fprintf(pip,"X-Newsreader: %s",p);
        else if ((p=hdr("RFC-X-Newsreader",kmsg)))
                fprintf(pip,"X-Newsreader: %s",p);
        else if ((p=hdr("X-Newsreader",kmsg)))
                fprintf(pip,"X-Newsreader: %s",p);
        else if ((p=hdr("PID",kmsg)))
                        fprintf(pip,"X-Newsreader: %s",p);

	} else {
        if ((p=hdr("X-Mailer",msg)))
                fprintf(pip,"X-Mailer:%s",p);
        else if ((p=hdr("RFC-X-Mailer",kmsg)))
                fprintf(pip,"X-Mailer: %s",p);
        else if ((p=hdr("X-Mailer",kmsg)))
                fprintf(pip,"X-Mailer: %s",p);
        else if ((p=hdr("PID",kmsg)))
                        fprintf(pip,"X-Mailer: %s",p);
	}


#ifdef GATEBAU_MSGID
	if (gatebaumode==1)
#ifdef XGATEWAY_STRICT
	if ((p=hdr("X-GATEWAY",kmsg)))
	{
		if ((q=strchr(p,'\n'))) *q='\0';
		fprintf(pip,"X-Gateway: %s, FIDO .. %s [ifmail %s]\n",
			p,myfqdn,version);
		if (q) *q='\n';
	}
#else
	fprintf(pip,"X-Gateway: FIDO .. %s [ifmail %s]\n",myfqdn,version);
#endif
#endif

	for (tmsg=msg;tmsg;tmsg=tmsg->next)
	{
		if (strcasecmp(tmsg->key,"X-Body-Start") &&
#ifdef PCBOARD_GATE
		    strcasecmp(tmsg->key,"X-PcBoard-FROM") &&
		    strcasecmp(tmsg->key,"X-PcBoard-SUBJECT") &&
		    strcasecmp(tmsg->key,"X-PcBoard-PACKOUT") &&
#endif
#ifdef ALLOW_CONTROL
		    strcasecmp(tmsg->key,"Control") &&
#endif
		    strcasecmp(tmsg->key,"Supersedes") &&
		    strcasecmp(tmsg->key,"Mime-Version") &&
		    strcasecmp(tmsg->key,"Content-Type") &&
		    strcasecmp(tmsg->key,"Content-Lenght") &&
		    strcasecmp(tmsg->key,"Content-Transfer-Encoding") &&
		    strcasecmp(tmsg->key,"Lines") &&
		    strcasecmp(tmsg->key,"Path") &&
		    strcasecmp(tmsg->key,"Received") &&
		    strcasecmp(tmsg->key,"From") &&
		    strcasecmp(tmsg->key,"To") &&
		    strcasecmp(tmsg->key,"Comment-To") &&
		    strcasecmp(tmsg->key,"X-Comment-To") &&
		    strcasecmp(tmsg->key,"Date") &&
		    strcasecmp(tmsg->key,"Subject") &&
		    strcasecmp(tmsg->key,"Reply-To") &&
		    strcasecmp(tmsg->key,"In-Reply-To") &&
		    strcasecmp(tmsg->key,"References") &&
		    strcasecmp(tmsg->key,"Organization") &&
		    strcasecmp(tmsg->key,"X-Mailer") &&
		    strcasecmp(tmsg->key,"X-Newsreader") &&
		    (strcasecmp(tmsg->key,"Newsgroups") || !newsmode) &&
		    strcasecmp(tmsg->key,"Apparently-To") &&
		    strcasecmp(tmsg->key,"Distribution") &&
		    strcasecmp(tmsg->key,"Approved") &&
		    strcasecmp(tmsg->key,"Message-ID"))
			fprintf(pip,"%s:%s",tmsg->key,hdrconv(tmsg->val,outcode,incode));
	}

	if ((p=compose_flags(flags,hdr("FLAGS",kmsg))))
	{
		fprintf(pip,"X-FTN-FLAGS:%s\n",p);
		free(p);
	}

	for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
	{
		if (strcasecmp(tmsg->key,"INTL") &&
		    strcasecmp(tmsg->key,"FMPT") &&
		    strcasecmp(tmsg->key,"TOPT") &&
		    strcasecmp(tmsg->key,"FLAGS") &&
		    strcasecmp(tmsg->key,"CHARSET") &&
		    strcasecmp(tmsg->key,"CHRS") &&
                    strcasecmp(tmsg->key,"CODEPAGE") &&
		    strcasecmp(tmsg->key,"ORIGCHRS") &&
#ifdef FORCE_REPLYTO_LOCAL
		    strcasecmp(tmsg->key,"REPLYTO") &&
		    strcasecmp(tmsg->key,"REPLYADDR") &&
#endif
	/* RFC: is used by fidogate to tell how completly RFC headers were
	gated (0=no headers at all; 1=some headers; 2=all headers) */
		    strcasecmp(tmsg->key,"RFC") &&  
		    strcasecmp(tmsg->key,"RFCID") &&
		    strcasecmp(tmsg->key,"ORIGID") &&
		    strcasecmp(tmsg->key,"ORIGREF") &&
		    strcasecmp(tmsg->key,"X-GATEWAY") &&
		    strcasecmp(tmsg->key,"Lines") &&
	/*	    strcmp(tmsg->key,"Path") &&		*/
		    strcasecmp(tmsg->key,"PATH") &&
		    strcasecmp(tmsg->key,"Received") &&
		    strcasecmp(tmsg->key,"From") &&
		    strcasecmp(tmsg->key,"To") &&
		    strcasecmp(tmsg->key,"Comment-To") &&
		    strcasecmp(tmsg->key,"X-Comment-To") &&
		    strcasecmp(tmsg->key,"Date") &&
		    strcasecmp(tmsg->key,"Subject") &&
		    strcasecmp(tmsg->key,"Reply-To") &&
		    strcasecmp(tmsg->key,"In-Reply-To") &&
		    strcasecmp(tmsg->key,"References") &&
		    strcasecmp(tmsg->key,"Organization") &&
		    strcasecmp(tmsg->key,"X-Mailer") &&
		    strcasecmp(tmsg->key,"X-Newsreader") &&
		    (strcasecmp(tmsg->key,"Newsgroups") || !newsmode) &&
		    strcasecmp(tmsg->key,"Apparently-To") &&
		    strcasecmp(tmsg->key,"Message-ID") &&
		    strcasecmp(tmsg->key,"Mime-Version") &&
		    strcasecmp(tmsg->key,"Content-Type") &&
		    strcasecmp(tmsg->key,"Content-Lenght") &&
		    strcasecmp(tmsg->key,"Content-Transfer-Encoding") &&
#ifdef ALLOW_CONTROL
		    strcasecmp(tmsg->key,"RFC-Control") &&
#endif
		    strcasecmp(tmsg->key,"RFC-Supersedes") &&
		    strcasecmp(tmsg->key,"RFC-Mime-Version") &&
		    strcasecmp(tmsg->key,"RFC-Content-Type") &&
		    strcasecmp(tmsg->key,"RFC-Content-Lenght") &&
		    strcasecmp(tmsg->key,"RFC-Content-Transfer-Encoding") &&
		    strcasecmp(tmsg->key,"RFC-Lines") &&
		    strcasecmp(tmsg->key,"RFC-Path") &&
		    strcasecmp(tmsg->key,"RFC-Received") &&
		    strcasecmp(tmsg->key,"RFC-From") &&
		    strcasecmp(tmsg->key,"RFC-To") &&
		    strcasecmp(tmsg->key,"RFC-Comment-To") &&
		    strcasecmp(tmsg->key,"RFC-X-Comment-To") &&
		    strcasecmp(tmsg->key,"RFC-Date") &&
		    strcasecmp(tmsg->key,"RFC-Subject") &&
		    strcasecmp(tmsg->key,"RFC-Reply-To") &&
		    strcasecmp(tmsg->key,"RFC-In-Reply-To") &&
		    strcasecmp(tmsg->key,"RFC-References") &&
		    strcasecmp(tmsg->key,"RFC-Organization") &&
		    strcasecmp(tmsg->key,"RFC-X-Mailer") &&
		    strcasecmp(tmsg->key,"RFC-X-Newsreader") &&
		    (strcasecmp(tmsg->key,"RFC-Newsgroups") || !newsmode) &&
		    strcasecmp(tmsg->key,"RFC-Apparently-To") &&
		    strcasecmp(tmsg->key,"RFC-Distribution") &&
		    strcasecmp(tmsg->key,"RFC-Approved") &&
		    strcasecmp(tmsg->key,"RFC-Message-ID"))
			if (!strncmp(tmsg->key,"RFC-",4))
				fprintf(pip,"%s: %s",tmsg->key+4,hdrconv(tmsg->val,outcode,incode));
			else if ((!strncasecmp(tmsg->key,"X-",2)) ||
				 (!strncasecmp(tmsg->key,"NNTP-",5)))
				fprintf(pip,"%s: %s",tmsg->key,hdrconv(tmsg->val,outcode,incode));
			else if ((!strncasecmp(tmsg->key,"ZC-",3)))
				fprintf(pip,"X-%s: %s",tmsg->key,tmsg->val);
			else if ((!strcasecmp(tmsg->key,"Origin")) ||
				 (!strcasecmp(tmsg->key,"MOOD"))) 
				fprintf(pip,"X-FTN-%s: %s",tmsg->key,hdrconv(tmsg->val,outcode,incode));
			else
				fprintf(pip,"X-FTN-%s: %s",tmsg->key,tmsg->val);
	}

	if (newsmode)
	{
		fa_list *tmpl,*ptl=NULL;
		char sbe[16];
		int seenlen=0,oldnet;

		for (tmsg=kmsg;tmsg;tmsg=tmsg->next)
		if (!strcmp(tmsg->key,"PATH"))
		{
			fill_path(&ptl,tmsg->val);
		}
		sprintf(sbe,"%s",ascfnode(bestaka,0x06));
		fill_path(&ptl,sbe);
		uniq_list(&ptl);

		/* ensure it will not match for the first entry */
		oldnet=ptl->addr->net-1;
		fprintf(pip,"X-FTN-PATH:");
		for (tmpl=ptl;tmpl;tmpl=tmpl->next)
		{
			if (tmpl->addr->net == oldnet)
				sprintf(sbe," %u",tmpl->addr->node);
			else
				sprintf(sbe," %u/%u",tmpl->addr->net,
					tmpl->addr->node);
			oldnet=tmpl->addr->net;
			seenlen+=strlen(sbe);
			if (seenlen > MAXPATH)
			{
				seenlen=0;
				fprintf(pip,"\nX-FTN-PATH:");
				sprintf(sbe," %u/%u",tmpl->addr->net,
					tmpl->addr->node);
				seenlen=strlen(sbe);
			}
			fprintf(pip,"%s",sbe);
		}
		fprintf(pip,"\n");

	/*	fprintf(pip,"X-FTN-PATH: %s\n",ascfnode(bestaka,0x06)); */
		if ((hdr("X-FTN-SPTH",msg)))
			fprintf(pip,"X-FTN-SPTH: %s\n",ascfnode(bestaka,0x1f));
	}

	fprintf(pip,"\n");
	lines=0;
	if ((p=hdr("X-Body-Start",msg)))
	{
		lines++;
		fputs(strkconv(p, outcode, incode), pip);
	}
	pass=1;
	count=0;
	while(fgets(buf,sizeof(buf)-1,fp) && pass)
	{
		if (ftell(fp) > endoff)
		{
			debug(5,"line \"%s\" past message end %ld",
				buf,(long)endoff);
			pass=0;
		}
		if (pass)
		{
			p=buf;
			b=NULL;
			while ((c=*p++))
			{
				switch (c)
				{
				case ' ':	b=p-1; break;
				case '\n':	b=NULL; count=0; lines++; break;
				}
				if ((count++ > BOUNDARY) && (!pgpsigned))
				{
					if (b) 
					{
						*b='\n';
						p=b+1;
						b=NULL;
						lines++;
						count=0;
					}
				}
			}
			fputs(strkconv(buf, outcode, incode), pip);
		}
	}

	if ((modtype==1) &&
	    (!hdr("Approved",msg)) &&
	    (!hdr("RFC-Approved",kmsg)) &&
	    (!hdr("Approved",kmsg)))
		newsmode=0;

	if (newsmode)
	{
		sprintf(lineshdr,"Lines: %d\n",lines);
		rewind(pip);
		fstat(fileno(pip),&stbuf);
		fprintf(nb,"#! rnews %lu\n",
			(unsigned long)stbuf.st_size+strlen(lineshdr));
		while (fgets(buf,sizeof(buf)-1,pip) && (buf[0] != '\n'))
			fputs(buf,nb);
		fputs(lineshdr,nb);
		fputs(buf,nb);
		while (fgets(buf,sizeof(buf)-1,pip))
			fputs(buf,nb);
	}
	if ((
	     (notransports || newsmode)?(rc=fclose(pip)):(rc=exclose(pip))
	   ))
	{
		logerr("$close of transport pipe or tmp file returned %d",rc);
	}
	tidyrfc(msg);
	if (rc < 0) rc=-rc;
	return rc;
}

#ifdef GATEBAU_MSGID
/* converts the date to a string "YYMMDD_HHMMSS" */
char *gatebaudate(now)
time_t now;
{
	static char buf[40];
	struct tm ptm;

	if (!now) time(&now);
	ptm=*localtime(&now);

	sprintf(buf,"%02d%02d%02d_%02d%02d%02d",
		ptm.tm_year%100,(ptm.tm_mon)+1,ptm.tm_mday,
		ptm.tm_hour,ptm.tm_min,ptm.tm_sec);
	return(buf);
}
#endif
