# include "stdio.h"
# define U(x) ((x)&0377)
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern unsigned char yytext[];
int yymorfg;
extern unsigned char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * parser.l -- lex parser of algebraic chess moves for XBoard
 * $Id: parser.l,v 1.33 1997/07/24 02:17:57 mann Exp $
 *
 * Copyright 1991 by Digital Equipment Corporation, Maynard, Massachusetts.
 * Enhancements Copyright 1992-95 Free Software Foundation, Inc.
 *
 * The following terms apply to Digital Equipment Corporation's copyright
 * interest in XBoard:
 * ------------------------------------------------------------------------
 * All Rights Reserved
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of Digital not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
 * ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
 * DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
 * ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
 * SOFTWARE.
 * ------------------------------------------------------------------------
 *
 * The following terms apply to the enhanced version of XBoard distributed
 * by the Free Software Foundation:
 * ------------------------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * ------------------------------------------------------------------------
 */

/* This parser handles all forms of promotion.
 * The parser resolves ambiguous moves by searching and check-testing.
 * It also parses comments of the form [anything] or (anything).
 */

#include <config.h>

#define NO_CONSTRAINT	-1
#undef YYLMAX
#define YYLMAX			4096
#define UNPUT_BUF_SIZE		YYLMAX

#ifdef FLEX_SCANNER
/* yytext is probably a char*, but could be a char[].  yy_text is set
   in YY_DECL below, because if yytext is a char*, its value is not
   constant. */
char *yy_text;
#else /*!FLEX_SCANNER*/
/* yytext is definitely a char[], so yy_text can be set here, statically. */
char *yy_text = (char *) yytext;
#endif

#ifdef FLEX_SCANNER
/* This is flex */
#undef YY_INPUT
#define YY_INPUT(buf, result, max_size) my_yy_input(buf, &result, max_size)
#undef YY_DECL
#define YY_DECL                     \
    int _yylex YY_PROTO((void));    \
    int yylex YY_PROTO((void))      \
    {                               \
	int result = _yylex();      \
	yy_text = (char *) yytext;  \
	return(result);             \
    }                               \
    int _yylex YY_PROTO((void))
#else
/* This is lex */
#undef input
#undef output
#undef unput
#endif

/* The includes must be here, below the #undef input */

#include <ctype.h>

#if STDC_HEADERS
# include <stdlib.h>
# include <string.h>
#else /* not STDC_HEADERS */
# if HAVE_STRING_H
#  include <string.h>
# else /* not HAVE_STRING_H */
#  include <strings.h>
# endif /* not HAVE_STRING_H */
#endif /* not STDC_HEADERS */

#if HAVE_UNISTD_H
# include <unistd.h>
#endif

#if defined(_amigados)
# include <errno.h>
# if HAVE_FCNTL_H
#  include <fcntl.h>    /*  isatty() prototype  */
# endif /*  HAVE_FCNTL_H        */
#endif  /*  defined(_amigados)  */

#include "common.h"
#include "backend.h"
#include "frontend.h"
#include "parser.h"
#include "moves.h"

extern int PosFlags P((int));

extern Board	boards[MAX_MOVES];
int		yyboardindex;
int             yyskipmoves = FALSE;
char		currentMoveString[YYLMAX];
#ifndef FLEX_SCANNER
char		unputBuffer[UNPUT_BUF_SIZE];
int		unputCount = 0;
#endif

#ifdef FLEX_SCANNER
void my_yy_input P((char *buf, int *result, int max_size));
#else /*!FLEX_SCANNER*/
static int input P((void));
static void output P((int ch));
static void unput P((int ch));
int yylook P((void));
int yyback P((int *, int));
#endif
#undef yywrap
int yywrap P((void));
extern void CopyBoard P((Board to, Board from));

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{
    /*
     * Fully-qualified algebraic move, possibly with promotion
     */
    int skip1 = 0, skip2 = 0;
    ChessSquare piece;
    ChessMove result;
    
    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the / */
    if (yytext[1] == '/') skip1 = 1;
    
    /* remove the [xX:-] */
    if ((yytext[3+skip1] == 'x') || (yytext[3+skip1] == 'X') ||
	(yytext[3+skip1] == '-') || (yytext[3+skip1] == ':')) skip2 = 1;
    
    currentMoveString[0] = yytext[1+skip1];
    currentMoveString[1] = yytext[2+skip1];
    currentMoveString[2] = yytext[3+skip1+skip2];
    currentMoveString[3] = yytext[4+skip1+skip2];
    currentMoveString[4] = NULLCHAR;
    
    if (yyleng-skip1-skip2 > 5) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    piece = boards[yyboardindex]
      [currentMoveString[1] - '1'][currentMoveString[0] - 'a'];
    if (ToLower(yytext[0]) != ToLower(PieceToChar(piece)))
      return (int) BadMove;

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 2:
{
    /*
     * Simple algebraic move, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X') ||
	(yytext[2] == '-') || (yytext[2] == ':')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[1] = yytext[1];
    currentMoveString[2] = yytext[2+skip];
    currentMoveString[3] = yytext[3+skip];
    currentMoveString[4] = NULLCHAR;

    if (yyleng-skip > 4) {
	if (yytext[yyleng-1] == ')') {
	    currentMoveString[4] = ToLower(yytext[yyleng-2]);
	} else {
	    currentMoveString[4] = ToLower(yytext[yyleng-1]);
	}
	currentMoveString[5] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    return (int) result;
}
break;
case 3:
{
    /*
     * Pawn move, possibly with promotion
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the =() */
    if (yytext[2] == '=') skip++;
    if (yytext[2+skip] == '(') skip++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = yytext[1] - '1';
    cl.ftIn = yytext[0] - 'a';
    cl.promoCharIn = yytext[2+skip];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 4:
{
    /*
     * Pawn capture, possibly with promotion, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip1 = 0, skip2 = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] and =() */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip1 = 1;
    if (yytext[2+skip1] == '=') skip2++;
    if (yytext[2+skip1+skip2] == '(') skip2++;

    cl.pieceIn = WhiteOnMove(yyboardindex) ? WhitePawn : BlackPawn;
    cl.rfIn = -1;
    cl.ffIn = yytext[0] - 'a';
    cl.rtIn = -1;
    cl.ftIn = yytext[1+skip1] - 'a';
    cl.promoCharIn = yytext[2+skip1+skip2];
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 5:
{
    /*
     * unambiguously abbreviated Pawn capture, possibly with promotion
     */
    int skip = 0;
    ChessMove result;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    currentMoveString[0] = yytext[0];
    currentMoveString[2] = yytext[1+skip];
    currentMoveString[3] = yytext[2+skip];
    if (WhiteOnMove(yyboardindex)) {
	if (yytext[2+skip] == '1') return (int) BadMove;
	currentMoveString[1] = yytext[2+skip] - 1;
    } else {
	if (yytext[2+skip] == '8') return (int) BadMove;
	currentMoveString[1] = yytext[2+skip] + 1;
    }
    if (yyleng-skip > 3) {
	if (yytext[yyleng-1] == ')')
	  currentMoveString[4] = ToLower(yytext[yyleng-2]);
	else
	  currentMoveString[4] = ToLower(yytext[yyleng-1]);
	currentMoveString[5] = NULLCHAR;
    } else {
	currentMoveString[4] = NULLCHAR;
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (currentMoveString[4] == NULLCHAR &&
	(result == WhitePromotionQueen || result == BlackPromotionQueen)) {
	currentMoveString[4] = 'q';
	currentMoveString[5] = NULLCHAR;
    }

    if (result != BadMove) return (int) result;

    /* Special case: improperly written en passant capture */
    if (WhiteOnMove(yyboardindex)) {
	if (currentMoveString[3] == '5') {
	    currentMoveString[1] = '5';
	    currentMoveString[3] = '6';
	} else {
	    return (int) BadMove;
	}
    } else {
	if (currentMoveString[3] == '4') {
	    currentMoveString[1] = '4';
	    currentMoveString[3] = '3';
	} else {
	    return (int) BadMove;
	}
    }

    result = LegalityTest(boards[yyboardindex],
			  PosFlags(yyboardindex), EP_UNKNOWN,
			  currentMoveString[1] - '1',
			  currentMoveString[0] - 'a',
			  currentMoveString[3] - '1',
			  currentMoveString[2] - 'a',
			  currentMoveString[4]);

    if (result == WhiteCapturesEnPassant || result == BlackCapturesEnPassant)
      return (int) result;
    else
      return (int) BadMove;
}
break;
case 6:
 {
    /*
     * piece move, possibly ambiguous
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[1] == 'x') || (yytext[1] == 'X')
	|| (yytext[1] == ':') || (yytext[1] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    cl.rfIn = -1;
    cl.ffIn = -1;
    cl.rtIn = yytext[2+skip] - '1';
    cl.ftIn = yytext[1+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 7:
{
    /*
     * piece move with rank or file disambiguator
     */
    DisambiguateClosure cl;
    int skip = 0;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    /* remove the [xX:-] */
    if ((yytext[2] == 'x') || (yytext[2] == 'X')
	|| (yytext[2] == ':') || (yytext[2] == '-')) skip = 1;

    if (WhiteOnMove(yyboardindex)) {
	cl.pieceIn = CharToPiece(ToUpper(yytext[0]));
    } else {
	cl.pieceIn = CharToPiece(ToLower(yytext[0]));
    }
    if (isalpha(yytext[1])) {
	cl.rfIn = -1;
	cl.ffIn = yytext[1] - 'a';
    } else {
	cl.rfIn = yytext[1] - '1';
	cl.ffIn = -1;
    }
    cl.rtIn = yytext[3+skip] - '1';
    cl.ftIn = yytext[2+skip] - 'a';
    cl.promoCharIn = NULLCHAR;
    Disambiguate(boards[yyboardindex],
		 PosFlags(yyboardindex), EP_UNKNOWN, &cl);

    currentMoveString[0] = cl.ff + 'a';
    currentMoveString[1] = cl.rf + '1';
    currentMoveString[2] = cl.ft + 'a';
    currentMoveString[3] = cl.rt + '1';
    currentMoveString[4] = cl.promoChar;
    currentMoveString[5] = NULLCHAR;

    return (int) cl.kind;
}
break;
case 8:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1f1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e1c1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 2;
	}
    } else{ 
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8f8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 5;
	} else {
	    strcpy(currentMoveString, "e8c8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 2;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 9:
{
    int rf, ff, rt, ft;

    if (yyskipmoves) return (int) AmbiguousMove; /* not disambiguated */

    if (WhiteOnMove(yyboardindex)) {
	if (boards[yyboardindex][0][3] == WhiteKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d1b1");
	    rf = 0;
	    ff = 3;
	    rt = 0;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e1g1");
	    rf = 0;
	    ff = 4;
	    rt = 0;
	    ft = 6;
	}
    } else {
	if (boards[yyboardindex][7][3] == BlackKing) {
	    /* ICS wild castling */
	    strcpy(currentMoveString, "d8b8");
	    rf = 7;
	    ff = 3;
	    rt = 7;
	    ft = 1;
	} else {
	    strcpy(currentMoveString, "e8g8");
	    rf = 7;
	    ff = 4;
	    rt = 7;
	    ft = 6;
	}
    }
    return (int) LegalityTest(boards[yyboardindex],
			      PosFlags(yyboardindex), EP_UNKNOWN,
			      rf, ff, rt, ft, NULLCHAR);
}
break;
case 10:
{
    /* Bughouse piece drop.  No legality checking for now. */
    currentMoveString[0] = ToUpper(yytext[0]);
    currentMoveString[1] = '@';
    currentMoveString[2] = yytext[2];
    currentMoveString[3] = yytext[3];
    currentMoveString[4] = NULLCHAR;
    return (int) (WhiteOnMove(yyboardindex) ? WhiteDrop : BlackDrop);
}
break;
case 11:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 12:
 {
    return (int) BlackWins;
}
break;
case 13:
 {
    return (int) WhiteWins;
}
break;
case 14:
{
    return (int) GameUnfinished;
}
break;
case 15:
 {
    return (int) GameIsDrawn;
}
break;
case 16:
 {
    return (int) GameIsDrawn;
}
break;
case 17:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 18:
 {
    if (WhiteOnMove(yyboardindex))
      return (int) BlackWins;
    else
      return (int) WhiteWins;
}
break;
case 19:
 {
    return (int) GameIsDrawn;
}
break;
case 20:
{
    return (int) GameIsDrawn;
}
break;
case 21:
 {
    return (int) GameIsDrawn;
}
break;
case 22:
{ 
    return (int) WhiteWins;
}
break;
case 23:
{ 
    return (int) BlackWins;
}
break;
case 24:
{ 
    return (int) BlackWins;
}
break;
case 25:
{ 
    return (int) WhiteWins;
}
break;
case 26:
{ 
    return (int) WhiteWins;
}
break;
case 27:
{ 
    return (int) BlackWins;
}
break;
case 28:
{
    return (int) GameIsDrawn;
}
break;
case 29:
{
    return (int) GameUnfinished;
}
break;
case 30:
   {
    /* move numbers */
    if ((yyleng == 1) && (yytext[0] == '1'))
      return (int) MoveNumberOne;
}
break;
case 31:
{
    /* elapsed time indication, e.g. (0:12) */ 
    return (int) ElapsedTime;
}
break;
case 32:
{
    /* position diagram enclosed in [-- --] */
    return (int) PositionDiagram;
}
break;
case 33:
{
    /* position diagram enclosed in {-- --} */
    return (int) PositionDiagram;
}
break;
case 34:
{
    return (int) PGNTag;
}
break;
case 35:
{
    return (int) GNUChessGame;
}
break;
case 36:
{
    return (int) XBoardGame;
}
break;
case 37:
{        			/* anything in {} */
    return (int) Comment; 
}
break;
case 38:
{                                          /* ; to end of line */
    return (int) Comment;
}
break;
case 39:
{        			/* anything in [] */
    return (int) Comment; 
}
break;
case 40:
 { 	  	/* nested () */
    return (int) Comment; 
}
break;
case 41:
  { 				/* >=2 chars in () */
    return (int) Comment; 
}
break;
case 42:
 {
        /* Skip mail headers */
}
break;
case 43:
		{
        /* Skip random words */
}
break;
case 44:
			{
        /* Skip everything else */
}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */


static char *StringToLex;

#ifndef FLEX_SCANNER
static FILE *lexFP;

static int input()
{
    int ret;
    
    if (StringToLex != NULL) {
	ret = *StringToLex;
	if (ret == NULLCHAR)
	  ret = EOF;
	else
	  StringToLex++;
    } else if (unputCount > 0) {
	ret = unputBuffer[--unputCount];
    } else {
	ret = fgetc(lexFP);
    }    

    if (ret == EOF) 
      return 0;
    else
      return ret;
}

/*
 * Return offset of next pattern within current file
 */
int yyoffset()
{
    int offset = ftell(lexFP) - unputCount;

    if (offset < 0) {
	offset = 0;
    }
    return(offset);
}
 
static void output(ch)
     int ch;
{
    fprintf(stderr, "PARSER BUG: unmatched character '%c' (0%o)\n",
	    ch, ch);
}

static void unput(ch)
     int ch;
{
    if (ch == 0) return;
    if (StringToLex != NULL) {
	StringToLex--;
    } else {
	if (unputCount >= UNPUT_BUF_SIZE)
	  fprintf(stderr, "PARSER BUG: unput buffer overflow '%c' (0%o)\n",
		  ch, ch);
	unputBuffer[unputCount++] = ch;
    }
}

/* Get ready to lex from a new file.  Kludge below sticks
   an artificial newline at the front of the file, which the
   above grammar ignores, but which makes ^ at start of pattern
   match at the real start of the file.
*/
void yynewfile(f)
     FILE *f;
{
    lexFP = f;
    StringToLex = NULL;
    unputCount = 0;
    unput('\n'); /* kludge */
}

/* Get ready to lex from a string.  ^ at start of pattern WON'T
   match at the start of the string!
*/
void yynewstr(s)
     char *s;
{
    lexFP = NULL;
    StringToLex = s;
    unputCount = 0;
}
#endif /*!FLEX_SCANNER*/

#ifdef FLEX_SCANNER
void my_yy_input(buf, result, max_size)
     char *buf;
     int *result;
     int max_size;
{
    int count;

    if (StringToLex != NULL) {
	count = 0;
	while (*StringToLex != NULLCHAR) {
	    *buf++ = *StringToLex++;
	    count++;
	}
	*result = count;
	return;
    } else {
	count = fread(buf, 1, max_size, yyin);
	if (count == 0) {
	    *result = YY_NULL;
	} else {
	    *result = count;
	}
	return;
    }    
}

static YY_BUFFER_STATE my_file_buffer = NULL;

/*
    Return offset of next pattern in the current file.
*/
int yyoffset()
{
    int pos = yy_c_buf_p - yy_current_buffer->yy_ch_buf;

    return(ftell(yy_current_buffer->yy_input_file) -
         yy_n_chars + pos);
}


void yynewstr(s)
     char *s;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = s;
    my_file_buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}

void yynewfile(f)
     FILE *f;
{
    if (my_file_buffer != NULL)
      yy_delete_buffer(my_file_buffer);
    StringToLex = NULL;
    my_file_buffer = yy_create_buffer(f, YY_BUF_SIZE);
    yy_switch_to_buffer(my_file_buffer);
}
#endif /*FLEX_SCANNER*/

int yywrap()
{
    return TRUE;
}

/* Parse a move from the given string s */
/* ^ at start of pattern WON'T work here unless using flex */
ChessMove yylexstr(boardIndex, s)
     int boardIndex;
     char *s;
{
    ChessMove ret;
    char *oldStringToLex;
#ifdef FLEX_SCANNER
    YY_BUFFER_STATE buffer, oldBuffer;
#endif
    
    yyboardindex = boardIndex;
    oldStringToLex = StringToLex;
    StringToLex = s;
#ifdef FLEX_SCANNER
    buffer = yy_create_buffer(stdin, YY_BUF_SIZE);
    oldBuffer = YY_CURRENT_BUFFER;
    yy_switch_to_buffer(buffer);
#endif /*FLEX_SCANNER*/

    ret = (ChessMove) yylex();

#ifdef FLEX_SCANNER
    if (oldBuffer != NULL) 
      yy_switch_to_buffer(oldBuffer);
    yy_delete_buffer(buffer);
#endif /*FLEX_SCANNER*/
    StringToLex = oldStringToLex;

    return ret;
}
int yyvstop[] = {
0,

44,
0,

43,
44,
0,

44,
0,

29,
44,
0,

44,
0,

43,
44,
0,

43,
44,
-30,
0,

43,
44,
-30,
0,

44,
-38,
0,

23,
43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

22,
43,
44,
0,

44,
0,

43,
44,
0,

23,
43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

44,
0,

44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
-30,
0,

43,
44,
-30,
0,

44,
-38,
0,

23,
43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

22,
43,
44,
0,

43,
44,
0,

23,
43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

43,
44,
0,

44,
0,

43,
0,

18,
0,

43,
0,

9,
43,
0,

43,
0,

43,
-30,
0,

30,
43,
0,

-38,
0,

38,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

39,
0,

43,
0,

3,
43,
0,

43,
0,

43,
0,

4,
43,
0,

43,
0,

3,
43,
0,

43,
0,

4,
43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

37,
0,

43,
0,

42,
0,

43,
0,

9,
43,
0,

42,
0,

43,
0,

43,
-30,
0,

42,
0,

30,
43,
0,

-38,
0,

43,
0,

43,
0,

42,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

3,
43,
0,

42,
0,

43,
0,

43,
0,

4,
43,
0,

43,
0,

3,
43,
0,

42,
0,

43,
0,

4,
43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

16,
0,

9,
43,
0,

27,
43,
0,

27,
0,

8,
43,
0,

30,
0,

26,
43,
0,

26,
0,

28,
0,

43,
0,

43,
0,

43,
0,

43,
0,

6,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

4,
43,
0,

43,
0,

3,
43,
0,

43,
0,

3,
43,
0,

4,
0,

5,
43,
0,

4,
43,
0,

4,
43,
0,

43,
0,

43,
0,

3,
43,
0,

4,
0,

4,
43,
0,

5,
6,
43,
0,

4,
43,
0,

9,
43,
0,

37,
0,

9,
43,
0,

27,
43,
0,

8,
43,
0,

27,
42,
0,

26,
43,
0,

26,
42,
0,

38,
0,

-38,
0,

43,
0,

43,
0,

42,
0,

43,
0,

42,
0,

43,
0,

6,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

9,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

4,
43,
0,

43,
0,

42,
0,

3,
43,
0,

43,
0,

3,
43,
0,

4,
42,
0,

5,
43,
0,

4,
43,
0,

4,
43,
0,

43,
0,

42,
0,

43,
0,

3,
43,
0,

4,
42,
0,

4,
43,
0,

5,
6,
43,
0,

4,
43,
0,

9,
43,
0,

41,
0,

41,
0,

40,
0,

29,
0,

29,
0,

43,
0,

6,
43,
0,

7,
43,
0,

6,
0,

10,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

21,
43,
0,

43,
0,

17,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

39,
0,

3,
0,

3,
0,

2,
43,
0,

5,
0,

4,
0,

5,
43,
0,

4,
0,

2,
7,
43,
0,

5,
6,
0,

5,
6,
43,
0,

5,
43,
0,

43,
0,

29,
0,

42,
0,

43,
0,

42,
0,

42,
0,

-38,
0,

-38,
0,

6,
43,
0,

42,
0,

7,
43,
0,

6,
42,
0,

43,
0,

43,
0,

42,
0,

43,
0,

43,
0,

43,
0,

43,
0,

21,
43,
0,

43,
0,

17,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

42,
0,

2,
43,
0,

42,
0,

5,
42,
0,

42,
0,

4,
42,
0,

5,
43,
0,

42,
0,

2,
7,
43,
0,

5,
6,
42,
0,

5,
6,
43,
0,

5,
43,
0,

43,
0,

23,
0,

7,
0,

23,
43,
0,

1,
43,
0,

43,
0,

21,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

22,
0,

22,
43,
0,

34,
39,
0,

2,
0,

2,
43,
0,

5,
0,

5,
0,

2,
7,
0,

42,
0,

42,
0,

42,
0,

42,
0,

42,
0,

-38,
0,

-38,
0,

7,
42,
0,

23,
43,
0,

42,
0,

1,
43,
0,

43,
0,

21,
43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

43,
0,

22,
43,
0,

2,
42,
0,

2,
43,
0,

42,
0,

42,
0,

5,
42,
0,

4,
42,
0,

2,
7,
42,
0,

31,
41,
0,

27,
0,

27,
0,

26,
0,

26,
0,

28,
0,

28,
0,

25,
0,

23,
0,

1,
0,

1,
43,
0,

43,
0,

43,
0,

43,
0,

11,
43,
0,

43,
0,

43,
0,

24,
0,

22,
0,

32,
39,
0,

34,
0,

2,
0,

2,
0,

31,
37,
0,

27,
42,
0,

27,
42,
0,

26,
42,
0,

26,
42,
0,

-38,
0,

-38,
0,

1,
42,
0,

1,
43,
0,

43,
0,

43,
0,

43,
0,

11,
43,
0,

43,
0,

43,
0,

42,
0,

42,
0,

2,
42,
0,

5,
42,
0,

28,
0,

23,
0,

1,
0,

1,
0,

21,
0,

43,
0,

43,
0,

43,
0,

11,
43,
0,

43,
0,

43,
0,

22,
0,

-38,
0,

-38,
0,

42,
0,

42,
0,

1,
42,
0,

43,
0,

43,
0,

43,
0,

11,
43,
0,

43,
0,

43,
0,

2,
42,
0,

13,
0,

23,
0,

43,
0,

43,
0,

43,
0,

12,
0,

22,
0,

-38,
0,

-38,
0,

1,
42,
0,

43,
0,

43,
0,

43,
0,

13,
0,

43,
0,

15,
43,
0,

12,
0,

-38,
0,

-38,
0,

42,
0,

43,
0,

15,
43,
0,

20,
0,

43,
0,

43,
0,

-38,
0,

-38,
0,

42,
0,

43,
0,

43,
0,

20,
0,

43,
0,

43,
0,

-38,
0,

-38,
0,

42,
0,

42,
0,

43,
0,

43,
0,

35,
43,
0,

-36,
0,

-36,
-38,
0,

-38,
0,

42,
0,

42,
0,

35,
43,
0,

19,
0,

23,
0,

35,
0,

22,
0,

36,
0,

36,
38,
0,

-38,
0,

35,
42,
0,

25,
0,

19,
0,

24,
0,

-38,
0,

-38,
0,

14,
0,

37,
-33,
0,

33,
0,
0};
# define YYTYPE unsigned short
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,3,	1,3,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,3,	0,0,	1,3,	
1,3,	0,0,	1,3,	0,0,	
1,4,	1,5,	1,3,	1,6,	
1,7,	0,0,	1,4,	1,3,	
1,3,	1,8,	1,9,	1,10,	
1,10,	1,10,	1,10,	1,10,	
1,10,	1,10,	1,10,	1,3,	
1,11,	6,67,	1,3,	35,135,	
40,145,	0,0,	1,4,	1,12,	
1,13,	1,14,	1,4,	1,4,	
1,15,	1,4,	1,4,	19,101,	
1,16,	1,4,	1,17,	1,18,	
1,19,	1,20,	1,18,	1,21,	
1,22,	1,4,	48,160,	62,184,	
1,23,	1,4,	1,4,	7,68,	
1,24,	7,69,	1,3,	8,70,	
1,3,	69,193,	1,25,	1,26,	
1,27,	1,28,	1,29,	1,30,	
1,31,	1,32,	13,93,	33,129,	
8,71,	19,102,	8,72,	8,73,	
1,33,	71,197,	71,198,	2,35,	
1,22,	2,35,	67,191,	72,199,	
48,161,	8,74,	2,6,	61,182,	
1,34,	2,36,	1,3,	73,200,	
2,37,	2,38,	2,39,	2,39,	
2,39,	2,39,	2,39,	2,39,	
2,39,	2,39,	13,94,	2,40,	
14,95,	2,3,	15,97,	77,205,	
17,99,	2,36,	2,41,	2,42,	
2,43,	2,36,	2,36,	2,44,	
2,36,	2,36,	22,106,	2,45,	
2,36,	2,46,	2,47,	2,48,	
2,49,	2,47,	2,50,	2,51,	
2,36,	42,152,	43,154,	2,52,	
2,36,	2,36,	80,206,	2,24,	
14,96,	33,130,	15,98,	2,3,	
17,100,	2,53,	2,54,	2,55,	
2,56,	2,57,	2,58,	2,59,	
2,60,	44,156,	22,107,	46,158,	
51,165,	61,183,	78,206,	2,61,	
78,207,	90,221,	92,223,	2,51,	
4,63,	42,153,	43,155,	93,224,	
94,225,	67,192,	4,63,	2,62,	
95,226,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	96,227,	
97,228,	44,157,	98,228,	46,159,	
51,166,	99,229,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
100,230,	101,231,	102,200,	23,108,	
104,233,	106,235,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
4,63,	4,63,	4,63,	4,63,	
5,64,	37,70,	70,194,	107,236,	
70,195,	76,202,	109,242,	76,203,	
5,64,	5,64,	110,243,	23,109,	
52,108,	66,0,	37,138,	70,196,	
37,72,	37,139,	76,204,	112,111,	
66,189,	66,189,	129,269,	130,200,	
133,271,	134,272,	139,277,	37,140,	
141,279,	66,189,	66,190,	5,64,	
143,280,	5,64,	5,64,	149,288,	
5,64,	151,290,	5,64,	5,65,	
5,0,	152,291,	5,64,	23,110,	
5,64,	5,64,	5,64,	5,66,	
5,66,	131,131,	131,131,	153,292,	
52,167,	138,275,	138,276,	154,293,	
5,66,	5,64,	131,131,	155,294,	
156,295,	157,295,	158,296,	159,297,	
5,64,	5,64,	5,64,	5,64,	
5,64,	5,64,	5,64,	5,64,	
5,64,	160,298,	5,64,	5,64,	
5,64,	5,64,	5,64,	5,64,	
5,64,	5,64,	5,64,	5,64,	
52,168,	161,277,	5,64,	5,64,	
5,64,	9,75,	9,75,	163,300,	
5,64,	165,302,	166,303,	167,304,	
5,64,	5,64,	5,64,	5,64,	
5,64,	5,64,	5,64,	5,64,	
85,214,	85,214,	85,214,	85,214,	
85,214,	85,214,	85,214,	85,214,	
9,76,	168,305,	5,64,	86,215,	
86,215,	86,215,	86,215,	86,215,	
86,215,	86,215,	86,215,	182,324,	
5,64,	9,77,	9,75,	9,78,	
9,79,	9,79,	9,79,	9,79,	
9,79,	9,79,	9,79,	9,79,	
9,79,	9,79,	9,80,	183,277,	
185,326,	186,327,	194,334,	195,335,	
196,336,	197,337,	9,81,	88,219,	
88,219,	88,219,	88,219,	88,219,	
88,219,	88,219,	88,219,	9,81,	
198,338,	199,338,	9,81,	189,326,	
9,81,	9,81,	9,81,	10,75,	
10,75,	202,339,	189,189,	189,189,	
203,340,	204,341,	205,342,	20,86,	
206,342,	221,361,	223,365,	189,189,	
189,190,	9,81,	9,81,	9,81,	
9,81,	9,81,	9,81,	9,81,	
9,81,	224,366,	10,75,	9,81,	
20,89,	225,367,	9,81,	226,368,	
9,81,	9,81,	9,81,	227,368,	
229,371,	230,371,	208,345,	209,347,	
10,75,	210,348,	10,79,	10,79,	
10,79,	10,79,	10,79,	10,79,	
10,79,	10,79,	10,79,	10,79,	
89,220,	89,220,	89,220,	89,220,	
89,220,	89,220,	89,220,	89,220,	
10,81,	20,103,	20,103,	20,103,	
20,103,	20,103,	20,103,	20,103,	
20,103,	10,81,	208,346,	209,347,	
10,81,	210,349,	10,81,	10,81,	
10,81,	184,325,	11,82,	231,372,	
184,131,	184,131,	233,373,	211,350,	
228,369,	234,374,	11,82,	11,83,	
235,375,	184,131,	236,376,	10,81,	
10,81,	10,81,	10,81,	10,81,	
10,81,	10,81,	10,81,	212,352,	
237,377,	10,81,	242,385,	243,386,	
10,81,	251,248,	10,81,	10,81,	
10,81,	11,82,	252,392,	11,82,	
11,82,	258,257,	11,82,	211,351,	
11,82,	11,82,	11,82,	228,370,	
11,82,	190,326,	11,82,	11,82,	
11,82,	11,82,	11,82,	259,399,	
190,331,	190,331,	269,405,	212,353,	
237,378,	275,413,	11,82,	11,82,	
238,379,	190,331,	276,338,	239,380,	
240,382,	278,414,	11,82,	11,82,	
11,82,	11,82,	11,82,	11,82,	
11,82,	11,82,	11,82,	228,370,	
11,82,	11,82,	11,82,	11,82,	
11,82,	11,82,	11,82,	11,82,	
11,82,	11,82,	114,245,	114,245,	
11,82,	11,82,	11,82,	279,342,	
238,379,	207,343,	11,82,	239,381,	
240,383,	280,415,	11,82,	11,82,	
11,82,	11,82,	11,82,	11,82,	
11,82,	11,82,	207,344,	272,407,	
273,410,	114,245,	12,84,	114,246,	
114,114,	272,408,	272,409,	274,412,	
11,82,	273,411,	287,421,	207,344,	
114,114,	288,422,	114,114,	12,85,	
290,426,	12,86,	11,82,	12,87,	
12,87,	12,87,	12,87,	12,87,	
12,87,	12,87,	12,87,	291,427,	
12,88,	292,428,	274,412,	293,429,	
294,429,	296,431,	12,89,	103,232,	
103,232,	103,232,	103,232,	103,232,	
103,232,	103,232,	103,232,	16,85,	
297,431,	16,86,	12,90,	16,87,	
16,87,	16,87,	16,87,	16,87,	
16,87,	16,87,	16,87,	298,432,	
16,88,	295,369,	12,85,	116,247,	
116,247,	116,247,	116,247,	116,247,	
116,247,	116,247,	116,247,	12,91,	
12,91,	12,91,	12,91,	12,91,	
12,91,	12,91,	12,91,	271,406,	
271,406,	300,433,	12,92,	282,416,	
301,434,	302,435,	303,436,	213,354,	
271,406,	241,384,	16,85,	304,437,	
282,417,	213,354,	12,85,	241,384,	
295,430,	305,438,	309,392,	16,91,	
16,91,	16,91,	16,91,	16,91,	
16,91,	16,91,	16,91,	18,85,	
314,399,	18,86,	324,451,	18,87,	
18,87,	18,87,	18,87,	18,87,	
18,87,	18,87,	18,87,	213,354,	
18,88,	241,384,	16,85,	328,0,	
332,0,	213,354,	18,89,	241,384,	
295,430,	333,0,	337,200,	345,462,	
21,85,	346,463,	21,86,	344,460,	
21,87,	21,87,	21,87,	21,87,	
21,87,	21,87,	21,87,	21,87,	
347,464,	21,88,	348,465,	338,454,	
342,456,	343,458,	18,85,	21,89,	
344,461,	349,466,	343,344,	350,467,	
21,104,	351,468,	352,469,	18,91,	
18,91,	18,91,	18,91,	18,91,	
18,91,	18,91,	18,91,	343,344,	
325,452,	353,470,	24,111,	325,131,	
325,131,	354,471,	361,474,	21,85,	
347,464,	365,474,	24,112,	24,112,	
325,131,	366,476,	18,85,	367,476,	
21,91,	21,91,	21,91,	21,91,	
21,105,	21,91,	21,91,	21,91,	
118,255,	118,255,	118,255,	118,255,	
118,255,	118,255,	118,255,	118,255,	
372,200,	24,112,	373,482,	24,111,	
24,111,	354,471,	24,111,	21,85,	
24,111,	24,111,	24,111,	369,479,	
24,111,	331,326,	24,113,	24,111,	
24,111,	24,114,	24,114,	368,477,	
331,453,	331,453,	370,480,	374,483,	
375,484,	376,485,	24,114,	24,111,	
377,486,	331,453,	338,455,	342,457,	
343,459,	378,487,	24,114,	24,114,	
24,114,	24,114,	24,114,	24,114,	
24,114,	24,114,	24,114,	369,479,	
24,114,	24,114,	24,114,	24,114,	
24,114,	24,114,	24,114,	24,114,	
24,114,	24,114,	370,481,	380,489,	
24,114,	24,114,	24,114,	381,490,	
382,491,	383,492,	24,115,	385,494,	
379,488,	368,478,	24,114,	24,114,	
24,114,	24,114,	24,114,	24,114,	
24,114,	24,114,	119,121,	119,121,	
119,121,	119,121,	119,121,	119,121,	
119,121,	119,121,	25,116,	386,494,	
24,114,	390,392,	25,117,	25,117,	
25,117,	25,117,	25,117,	25,117,	
25,117,	25,117,	24,111,	25,118,	
379,488,	368,478,	26,84,	120,256,	
120,256,	120,256,	120,256,	120,256,	
120,256,	120,256,	120,256,	395,399,	
397,396,	398,504,	405,200,	26,122,	
410,510,	26,86,	411,511,	26,123,	
26,123,	26,123,	26,123,	26,123,	
26,123,	26,123,	26,123,	384,493,	
26,124,	25,119,	413,277,	414,513,	
415,515,	416,517,	26,89,	417,518,	
419,519,	422,520,	25,120,	25,121,	
25,120,	25,120,	25,120,	25,120,	
25,120,	25,120,	26,90,	122,260,	
122,260,	122,260,	122,260,	122,260,	
122,260,	122,260,	122,260,	406,506,	
406,506,	426,520,	26,125,	384,493,	
427,523,	25,119,	428,523,	432,277,	
406,506,	429,477,	433,527,	26,126,	
26,127,	26,126,	26,127,	26,127,	
26,127,	26,127,	26,127,	27,116,	
434,528,	435,529,	26,92,	27,117,	
27,117,	27,117,	27,117,	27,117,	
27,117,	27,117,	27,117,	436,530,	
27,118,	437,531,	26,125,	124,265,	
124,265,	124,265,	124,265,	124,265,	
124,265,	124,265,	124,265,	28,116,	
438,531,	439,532,	27,93,	28,117,	
28,117,	28,117,	28,117,	28,117,	
28,117,	28,117,	28,117,	429,524,	
28,118,	430,525,	414,514,	415,516,	
444,537,	445,504,	27,119,	125,266,	
125,266,	125,266,	125,266,	125,266,	
125,266,	125,266,	125,266,	27,120,	
27,121,	27,120,	27,121,	27,120,	
27,120,	27,120,	27,128,	446,538,	
28,95,	451,277,	453,540,	460,461,	
462,549,	463,550,	28,119,	429,524,	
465,553,	430,526,	466,554,	467,555,	
468,556,	469,557,	27,119,	28,120,	
28,120,	28,121,	28,120,	28,121,	
28,120,	28,120,	28,120,	128,256,	
128,256,	128,256,	128,256,	128,256,	
128,256,	128,256,	128,256,	470,558,	
28,96,	474,562,	478,477,	29,116,	
480,573,	481,574,	28,119,	29,117,	
29,117,	29,117,	29,117,	29,117,	
29,117,	29,117,	29,117,	408,70,	
29,118,	140,278,	140,137,	140,137,	
140,137,	140,137,	140,137,	140,137,	
140,137,	482,575,	483,575,	30,116,	
408,507,	461,547,	408,72,	30,117,	
30,117,	30,117,	30,117,	30,117,	
30,117,	30,117,	30,117,	484,576,	
30,118,	408,74,	476,566,	128,225,	
461,548,	479,571,	29,119,	485,577,	
486,578,	487,579,	409,508,	489,582,	
490,583,	491,584,	49,86,	29,120,	
29,120,	29,120,	29,121,	29,120,	
29,121,	29,120,	29,120,	409,509,	
471,559,	409,78,	492,585,	494,588,	
493,586,	501,500,	30,119,	49,89,	
502,592,	503,504,	476,566,	510,594,	
409,80,	479,572,	29,119,	30,120,	
30,120,	30,120,	30,120,	30,121,	
30,120,	30,121,	30,120,	31,116,	
464,551,	511,595,	517,600,	31,117,	
31,117,	31,117,	31,117,	31,117,	
31,117,	31,117,	31,117,	508,202,	
31,118,	508,203,	30,119,	464,552,	
49,162,	49,162,	49,162,	49,162,	
49,162,	49,162,	49,162,	49,162,	
508,204,	518,601,	520,562,	471,560,	
521,602,	523,604,	32,116,	493,587,	
31,97,	488,580,	32,117,	32,117,	
32,117,	32,117,	32,117,	32,117,	
32,117,	32,117,	31,119,	32,118,	
524,477,	525,605,	464,551,	464,552,	
488,581,	526,606,	527,607,	31,120,	
31,120,	31,120,	31,120,	31,120,	
31,121,	31,120,	31,121,	471,560,	
441,444,	523,604,	34,131,	493,587,	
31,98,	528,607,	529,608,	498,498,	
498,498,	441,444,	34,131,	34,132,	
441,444,	32,119,	31,119,	441,444,	
441,444,	530,609,	531,588,	488,580,	
488,581,	533,592,	32,120,	32,120,	
32,120,	32,120,	32,120,	32,120,	
32,121,	32,120,	498,498,	536,613,	
441,444,	34,131,	541,0,	34,131,	
34,131,	542,0,	34,131,	543,0,	
34,131,	34,131,	34,131,	544,0,	
34,131,	32,119,	34,131,	34,131,	
34,131,	34,133,	34,133,	452,539,	
545,0,	539,614,	452,131,	452,131,	
539,131,	539,131,	34,133,	34,131,	
546,0,	547,615,	548,616,	452,131,	
549,617,	539,131,	34,131,	34,131,	
34,131,	34,131,	34,131,	34,131,	
34,131,	34,131,	34,131,	550,618,	
34,131,	34,131,	34,131,	34,131,	
34,131,	34,131,	34,131,	34,131,	
34,131,	34,131,	552,619,	551,552,	
34,131,	34,131,	34,131,	498,590,	
553,620,	554,620,	34,131,	555,621,	
556,622,	557,623,	34,131,	34,131,	
34,131,	34,131,	34,131,	34,131,	
34,131,	34,131,	146,283,	146,283,	
146,283,	146,283,	146,283,	146,283,	
146,283,	146,283,	558,624,	560,559,	
34,131,	564,563,	36,63,	551,552,	
565,629,	571,636,	572,637,	573,638,	
36,136,	574,639,	34,134,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,137,	562,628,	566,99,	
568,631,	569,633,	570,634,	576,642,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	562,628,	566,100,	
568,632,	569,633,	570,635,	577,643,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	36,136,	36,136,	
36,136,	36,136,	38,75,	38,75,	
148,287,	148,287,	148,287,	148,287,	
148,287,	148,287,	148,287,	148,287,	
162,299,	162,299,	162,299,	162,299,	
162,299,	162,299,	162,299,	162,299,	
578,644,	579,645,	580,581,	581,646,	
582,647,	38,76,	169,306,	169,306,	
169,306,	169,306,	169,306,	169,306,	
169,306,	169,306,	583,647,	584,648,	
585,649,	587,586,	38,141,	38,75,	
38,78,	38,142,	38,142,	38,142,	
38,142,	38,142,	38,142,	38,142,	
38,142,	38,142,	38,142,	38,143,	
591,592,	594,652,	580,581,	595,653,	
600,654,	601,655,	603,629,	38,144,	
171,312,	171,312,	171,312,	171,312,	
171,312,	171,312,	171,312,	171,312,	
38,144,	559,625,	605,659,	38,144,	
606,660,	38,144,	38,144,	38,144,	
39,75,	39,75,	172,174,	172,174,	
172,174,	172,174,	172,174,	172,174,	
172,174,	172,174,	608,663,	609,664,	
612,665,	615,667,	38,144,	38,144,	
38,144,	38,144,	38,144,	38,144,	
38,144,	38,144,	87,216,	39,75,	
38,144,	506,131,	506,131,	38,144,	
586,650,	38,144,	38,144,	38,144,	
559,626,	616,668,	506,131,	87,217,	
604,158,	39,75,	617,669,	39,142,	
39,142,	39,142,	39,142,	39,142,	
39,142,	39,142,	39,142,	39,142,	
39,142,	173,313,	173,313,	173,313,	
173,313,	173,313,	173,313,	173,313,	
173,313,	39,144,	614,666,	618,670,	
621,672,	614,131,	614,131,	622,672,	
559,626,	87,216,	39,144,	586,651,	
604,159,	39,144,	614,131,	39,144,	
39,144,	39,144,	87,218,	87,218,	
87,218,	87,218,	87,218,	87,218,	
87,218,	87,218,	623,673,	624,673,	
627,629,	630,0,	631,678,	632,679,	
39,144,	39,144,	39,144,	39,144,	
39,144,	39,144,	39,144,	39,144,	
41,84,	87,216,	39,144,	586,651,	
633,680,	39,144,	506,593,	39,144,	
39,144,	39,144,	619,671,	634,681,	
635,682,	41,146,	636,683,	41,86,	
637,684,	41,147,	41,147,	41,147,	
41,147,	41,147,	41,147,	41,147,	
41,147,	638,685,	41,148,	639,685,	
642,686,	643,687,	644,688,	645,689,	
41,89,	175,315,	175,315,	175,315,	
175,315,	175,315,	175,315,	175,315,	
175,315,	45,146,	619,671,	45,86,	
41,149,	45,147,	45,147,	45,147,	
45,147,	45,147,	45,147,	45,147,	
45,147,	626,675,	45,148,	628,676,	
41,146,	177,320,	177,320,	177,320,	
177,320,	177,320,	177,320,	177,320,	
177,320,	41,150,	41,150,	41,150,	
41,150,	41,150,	41,150,	41,150,	
41,150,	648,691,	649,691,	652,694,	
41,151,	653,695,	654,696,	655,697,	
658,698,	640,641,	659,699,	646,690,	
45,146,	626,675,	651,693,	628,677,	
41,146,	660,699,	661,662,	663,700,	
664,701,	45,150,	45,150,	45,150,	
45,150,	45,150,	45,150,	45,150,	
45,150,	47,146,	669,673,	47,86,	
668,458,	47,147,	47,147,	47,147,	
47,147,	47,147,	47,147,	47,147,	
47,147,	640,641,	47,148,	646,690,	
45,146,	670,673,	651,693,	671,703,	
47,89,	672,704,	661,662,	674,0,	
675,707,	676,708,	50,146,	677,709,	
50,86,	678,710,	50,147,	50,147,	
50,147,	50,147,	50,147,	50,147,	
50,147,	50,147,	679,711,	50,148,	
681,712,	682,713,	683,714,	684,714,	
47,146,	50,89,	686,716,	687,716,	
688,691,	689,691,	50,163,	671,703,	
692,0,	47,150,	47,150,	47,150,	
47,150,	47,150,	47,150,	47,150,	
47,150,	178,321,	178,321,	178,321,	
178,321,	178,321,	178,321,	178,321,	
178,321,	50,146,	693,720,	694,721,	
695,722,	696,723,	697,724,	700,727,	
47,146,	701,727,	50,150,	50,150,	
50,150,	50,150,	50,164,	50,150,	
50,150,	50,150,	53,169,	668,459,	
703,729,	708,732,	53,170,	53,170,	
53,170,	53,170,	53,170,	53,170,	
53,170,	53,170,	690,717,	53,171,	
704,730,	50,146,	54,84,	181,313,	
181,313,	181,313,	181,313,	181,313,	
181,313,	181,313,	181,313,	709,733,	
710,734,	711,734,	712,735,	54,175,	
713,736,	54,86,	717,740,	54,176,	
54,176,	54,176,	54,176,	54,176,	
54,176,	54,176,	54,176,	705,706,	
54,177,	53,172,	690,717,	707,731,	
704,730,	718,719,	54,89,	721,742,	
722,743,	723,744,	53,173,	53,174,	
53,173,	53,173,	53,173,	53,173,	
53,173,	53,173,	54,149,	214,355,	
214,355,	214,355,	214,355,	214,355,	
214,355,	214,355,	214,355,	181,292,	
715,0,	720,741,	54,178,	705,706,	
724,745,	53,172,	732,755,	707,731,	
733,756,	718,719,	735,760,	54,179,	
54,180,	54,179,	54,180,	54,180,	
54,180,	54,180,	54,180,	55,169,	
736,761,	742,769,	54,151,	55,170,	
55,170,	55,170,	55,170,	55,170,	
55,170,	55,170,	55,170,	743,770,	
55,171,	720,741,	54,178,	215,356,	
215,356,	215,356,	215,356,	215,356,	
215,356,	215,356,	215,356,	56,169,	
744,771,	745,772,	55,152,	56,170,	
56,170,	56,170,	56,170,	56,170,	
56,170,	56,170,	56,170,	715,738,	
56,171,	729,750,	730,751,	751,780,	
731,753,	752,781,	55,172,	216,218,	
216,218,	216,218,	216,218,	216,218,	
216,218,	216,218,	216,218,	55,173,	
55,174,	55,173,	55,174,	55,173,	
55,173,	55,173,	55,181,	666,702,	
56,154,	702,728,	666,131,	666,131,	
702,131,	702,131,	56,172,	715,739,	
753,782,	729,750,	730,752,	666,131,	
731,754,	702,131,	55,172,	56,173,	
56,173,	56,174,	56,173,	56,174,	
56,173,	56,173,	56,173,	217,357,	
217,357,	217,357,	217,357,	217,357,	
217,357,	217,357,	217,357,	754,783,	
56,155,	755,784,	738,0,	57,169,	
756,785,	758,786,	56,172,	57,170,	
57,170,	57,170,	57,170,	57,170,	
57,170,	57,170,	57,170,	739,0,	
57,171,	218,358,	218,358,	218,358,	
218,358,	218,358,	218,358,	218,358,	
218,358,	759,787,	760,788,	58,169,	
761,789,	764,0,	767,795,	58,170,	
58,170,	58,170,	58,170,	58,170,	
58,170,	58,170,	58,170,	740,766,	
58,171,	741,767,	750,778,	768,796,	
766,793,	765,0,	57,172,	219,359,	
219,359,	219,359,	219,359,	219,359,	
219,359,	219,359,	219,359,	57,173,	
57,173,	57,173,	57,174,	57,173,	
57,174,	57,173,	57,173,	728,749,	
769,797,	770,798,	728,131,	728,131,	
771,799,	738,764,	58,172,	740,766,	
772,800,	741,768,	750,779,	728,131,	
766,794,	778,805,	57,172,	58,173,	
58,173,	58,173,	58,173,	58,174,	
58,173,	58,174,	58,173,	59,169,	
764,792,	779,806,	477,567,	59,170,	
59,170,	59,170,	59,170,	59,170,	
59,170,	59,170,	59,170,	780,807,	
59,171,	738,685,	58,172,	220,360,	
220,360,	220,360,	220,360,	220,360,	
220,360,	220,360,	220,360,	781,807,	
782,808,	783,808,	739,765,	477,568,	
477,569,	680,568,	60,169,	575,640,	
59,156,	607,661,	60,170,	60,170,	
60,170,	60,170,	60,170,	60,170,	
60,170,	60,170,	59,172,	60,171,	
477,570,	575,641,	680,570,	607,662,	
765,792,	784,809,	785,810,	59,173,	
59,173,	59,173,	59,173,	59,173,	
59,174,	59,173,	59,174,	477,568,	
477,569,	680,568,	64,185,	575,640,	
59,157,	607,661,	786,811,	673,705,	
787,812,	788,813,	64,185,	64,185,	
789,814,	60,172,	59,172,	792,0,	
477,570,	575,641,	680,570,	607,662,	
793,816,	673,706,	60,173,	60,173,	
60,173,	60,173,	60,173,	60,173,	
60,174,	60,173,	774,725,	794,817,	
795,818,	64,185,	796,818,	64,185,	
64,185,	798,820,	64,185,	673,705,	
64,185,	64,186,	64,0,	800,822,	
64,185,	60,172,	64,185,	64,185,	
64,185,	64,185,	64,185,	805,825,	
749,777,	673,706,	734,757,	749,131,	
749,131,	806,825,	64,185,	64,185,	
807,826,	691,718,	774,802,	734,758,	
749,131,	808,827,	64,185,	64,185,	
64,185,	64,185,	64,185,	64,185,	
64,185,	64,185,	64,185,	691,719,	
64,185,	64,185,	64,185,	64,185,	
64,185,	64,185,	64,185,	64,185,	
64,185,	64,185,	734,757,	809,828,	
64,185,	64,185,	64,185,	810,829,	
807,826,	691,718,	64,185,	734,759,	
811,757,	812,757,	64,185,	64,185,	
64,185,	64,185,	64,185,	64,185,	
64,185,	64,185,	65,186,	691,719,	
777,804,	813,830,	814,831,	777,131,	
777,131,	816,832,	65,186,	65,186,	
64,185,	108,237,	804,824,	817,832,	
777,131,	804,131,	804,131,	108,238,	
108,239,	818,833,	64,185,	820,834,	
822,835,	108,240,	804,131,	827,625,	
828,837,	829,838,	108,241,	830,757,	
831,757,	65,186,	833,650,	65,186,	
65,186,	834,839,	65,186,	835,840,	
65,186,	65,187,	65,188,	837,842,	
65,186,	108,237,	65,186,	65,186,	
65,186,	65,186,	65,186,	108,238,	
108,239,	838,842,	840,799,	846,847,	
847,848,	108,240,	65,186,	65,186,	
844,845,	848,849,	108,241,	849,850,	
850,851,	851,852,	65,186,	65,186,	
65,186,	65,186,	65,186,	65,186,	
65,186,	65,186,	65,186,	852,853,	
65,186,	65,186,	65,186,	65,186,	
65,186,	65,186,	65,186,	65,186,	
65,186,	65,186,	75,75,	75,75,	
65,186,	65,186,	65,186,	853,854,	
844,845,	854,855,	65,186,	855,856,	
856,857,	857,858,	65,186,	65,186,	
65,186,	65,186,	65,186,	65,186,	
65,186,	65,186,	248,390,	824,836,	
858,859,	75,75,	824,131,	824,131,	
859,860,	860,861,	861,862,	248,390,	
65,186,	0,0,	248,390,	824,131,	
0,0,	248,390,	248,390,	75,75,	
84,208,	836,841,	65,186,	0,0,	
836,131,	836,131,	84,209,	84,210,	
0,0,	84,211,	0,0,	0,0,	
84,212,	836,131,	248,390,	0,0,	
0,0,	84,213,	0,0,	75,201,	
0,0,	0,0,	0,0,	248,390,	
0,0,	0,0,	248,390,	0,0,	
75,201,	248,390,	248,390,	75,201,	
84,208,	75,201,	75,201,	75,201,	
79,75,	79,75,	84,209,	84,210,	
0,0,	84,211,	0,0,	0,0,	
84,212,	0,0,	0,0,	0,0,	
0,0,	84,213,	75,201,	75,201,	
75,201,	75,201,	75,201,	75,201,	
75,201,	75,201,	0,0,	79,75,	
75,201,	147,284,	0,0,	75,201,	
0,0,	75,201,	75,201,	75,201,	
0,0,	0,0,	0,0,	0,0,	
0,0,	79,75,	147,285,	79,79,	
79,79,	79,79,	79,79,	79,79,	
79,79,	79,79,	79,79,	79,79,	
79,79,	0,0,	0,0,	0,0,	
0,0,	0,0,	91,216,	0,0,	
0,0,	79,81,	91,222,	91,222,	
91,222,	91,222,	91,222,	91,222,	
91,222,	91,222,	79,81,	91,217,	
147,284,	79,81,	0,0,	79,81,	
79,81,	79,81,	0,0,	0,0,	
0,0,	147,286,	147,286,	147,286,	
147,286,	147,286,	147,286,	147,286,	
147,286,	0,0,	0,0,	0,0,	
79,81,	79,81,	79,81,	79,81,	
79,81,	79,81,	79,81,	79,81,	
0,0,	91,216,	79,81,	0,0,	
147,284,	79,81,	0,0,	79,81,	
79,81,	79,81,	91,218,	91,218,	
91,218,	91,218,	91,218,	91,218,	
91,218,	91,218,	105,216,	0,0,	
0,0,	0,0,	105,222,	105,222,	
105,222,	105,222,	105,222,	105,222,	
105,222,	105,222,	0,0,	105,217,	
0,0,	91,216,	249,253,	249,253,	
249,253,	249,253,	249,253,	249,253,	
249,253,	249,253,	111,111,	111,111,	
250,391,	250,391,	250,391,	250,391,	
250,391,	250,391,	250,391,	250,391,	
253,393,	253,393,	253,393,	253,393,	
253,393,	253,393,	253,393,	253,393,	
0,0,	105,216,	0,0,	0,0,	
0,0,	111,111,	0,0,	0,0,	
0,0,	0,0,	105,218,	105,218,	
105,218,	105,218,	105,218,	105,218,	
105,218,	105,218,	111,111,	0,0,	
0,0,	111,111,	111,111,	0,0,	
0,0,	0,0,	0,0,	0,0,	
105,234,	0,0,	111,111,	0,0,	
0,0,	105,216,	0,0,	0,0,	
0,0,	0,0,	111,111,	111,111,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	111,111,	0,0,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	113,111,	113,111,	
111,111,	111,111,	111,111,	841,843,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	111,111,	111,111,	
111,111,	111,111,	111,111,	111,111,	
111,111,	111,111,	0,0,	0,0,	
534,536,	113,111,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
111,111,	534,536,	0,0,	0,0,	
534,536,	0,0,	113,244,	534,536,	
534,536,	113,111,	113,111,	0,0,	
0,0,	841,131,	841,131,	0,0,	
0,0,	0,0,	113,111,	0,0,	
0,0,	842,844,	841,131,	0,0,	
534,536,	0,0,	113,111,	113,111,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	113,111,	842,845,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	0,0,	0,0,	
113,111,	113,111,	113,111,	117,248,	
0,0,	842,844,	0,0,	0,0,	
117,249,	0,0,	113,111,	113,111,	
113,111,	113,111,	113,111,	113,111,	
113,111,	113,111,	0,0,	842,845,	
0,0,	117,250,	254,392,	0,0,	
117,251,	0,0,	0,0,	0,0,	
113,111,	117,252,	254,393,	254,393,	
254,393,	254,393,	254,393,	254,393,	
254,393,	254,393,	117,252,	0,0,	
0,0,	117,252,	0,0,	0,0,	
117,252,	117,252,	0,0,	0,0,	
0,0,	0,0,	0,0,	117,249,	
261,263,	261,263,	261,263,	261,263,	
261,263,	261,263,	261,263,	261,263,	
117,253,	117,254,	117,253,	117,253,	
117,253,	117,253,	117,253,	117,253,	
0,0,	0,0,	117,252,	0,0,	
0,0,	117,252,	0,0,	121,257,	
117,252,	117,252,	0,0,	0,0,	
0,0,	0,0,	0,0,	117,249,	
121,256,	121,256,	121,256,	121,256,	
121,256,	121,256,	121,256,	121,256,	
0,0,	123,248,	0,0,	0,0,	
121,258,	0,0,	123,261,	0,0,	
0,0,	121,259,	262,400,	262,400,	
262,400,	262,400,	262,400,	262,400,	
262,400,	262,400,	121,259,	123,262,	
0,0,	121,259,	123,251,	0,0,	
121,259,	121,259,	0,0,	123,252,	
263,401,	263,401,	263,401,	263,401,	
263,401,	263,401,	263,401,	263,401,	
123,252,	0,0,	0,0,	123,252,	
0,0,	121,259,	123,252,	123,252,	
0,0,	0,0,	0,0,	0,0,	
0,0,	123,261,	121,259,	0,0,	
0,0,	121,259,	0,0,	0,0,	
121,259,	121,259,	123,263,	123,264,	
123,263,	123,263,	123,263,	123,263,	
123,263,	123,263,	0,0,	0,0,	
123,252,	0,0,	0,0,	123,252,	
0,0,	126,257,	123,252,	123,252,	
0,0,	0,0,	126,216,	0,0,	
0,0,	123,261,	126,267,	126,267,	
126,267,	126,267,	126,267,	126,267,	
126,267,	126,267,	0,0,	126,217,	
0,0,	0,0,	126,258,	0,0,	
0,0,	257,395,	0,0,	126,259,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	257,395,	610,612,	
126,259,	257,395,	0,0,	126,259,	
257,395,	257,395,	126,259,	126,259,	
610,612,	0,0,	0,0,	610,612,	
0,0,	126,216,	610,612,	610,612,	
0,0,	0,0,	0,0,	0,0,	
0,0,	257,395,	126,218,	126,268,	
126,218,	126,218,	126,218,	126,218,	
126,218,	126,218,	257,395,	610,612,	
126,259,	257,395,	0,0,	126,259,	
257,395,	257,395,	126,259,	126,259,	
0,0,	0,0,	127,216,	0,0,	
0,0,	126,216,	127,267,	127,267,	
127,267,	127,267,	127,267,	127,267,	
127,267,	127,267,	264,392,	127,217,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	264,401,	264,401,	
264,401,	264,401,	264,401,	264,401,	
264,401,	264,401,	0,0,	0,0,	
0,0,	0,0,	132,132,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	132,132,	0,0,	
0,0,	127,216,	265,402,	265,402,	
265,402,	265,402,	265,402,	265,402,	
265,402,	265,402,	127,218,	127,218,	
127,218,	127,218,	127,218,	127,218,	
127,218,	127,218,	0,0,	0,0,	
0,0,	132,132,	0,0,	132,132,	
132,132,	0,0,	132,132,	0,0,	
132,132,	132,132,	132,132,	0,0,	
132,132,	127,216,	132,132,	132,132,	
132,132,	132,132,	132,132,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	132,132,	132,132,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	132,132,	132,132,	
132,132,	132,132,	132,132,	132,132,	
132,132,	132,132,	132,132,	0,0,	
132,132,	132,132,	132,132,	132,132,	
132,132,	132,132,	132,132,	132,132,	
132,132,	132,132,	0,0,	0,0,	
132,132,	132,132,	132,132,	0,0,	
0,0,	0,0,	132,132,	0,0,	
0,0,	0,0,	132,132,	132,132,	
132,132,	132,132,	132,132,	132,132,	
132,132,	132,132,	135,135,	0,0,	
0,0,	268,399,	0,0,	0,0,	
0,0,	0,0,	135,135,	135,135,	
132,132,	268,358,	268,358,	268,358,	
268,358,	268,358,	268,358,	268,358,	
268,358,	0,0,	132,270,	283,418,	
283,418,	283,418,	283,418,	283,418,	
283,418,	283,418,	283,418,	0,0,	
0,0,	135,273,	0,0,	135,135,	
135,135,	0,0,	135,135,	0,0,	
135,135,	135,135,	135,135,	0,0,	
135,135,	0,0,	135,135,	135,135,	
135,135,	135,135,	135,135,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,135,	135,135,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,135,	135,135,	
135,135,	135,135,	135,135,	135,135,	
135,135,	135,135,	135,135,	0,0,	
135,135,	135,135,	135,135,	135,135,	
135,135,	135,135,	135,135,	135,135,	
135,135,	135,135,	0,0,	0,0,	
135,135,	135,135,	135,135,	0,0,	
0,0,	0,0,	135,135,	0,0,	
0,0,	0,0,	135,135,	135,135,	
135,135,	135,135,	135,135,	135,135,	
135,135,	135,135,	137,137,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	137,137,	137,274,	
135,135,	284,286,	284,286,	284,286,	
284,286,	284,286,	284,286,	284,286,	
284,286,	0,0,	135,135,	285,419,	
285,419,	285,419,	285,419,	285,419,	
285,419,	285,419,	285,419,	0,0,	
0,0,	137,137,	0,0,	137,137,	
137,137,	0,0,	137,137,	0,0,	
137,137,	137,137,	137,137,	0,0,	
137,137,	0,0,	137,137,	137,137,	
137,137,	137,137,	137,137,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	137,137,	137,137,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	0,0,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	0,0,	0,0,	
137,137,	137,137,	137,137,	142,75,	
142,75,	0,0,	137,137,	0,0,	
0,0,	222,362,	137,137,	137,137,	
137,137,	137,137,	137,137,	137,137,	
137,137,	137,137,	0,0,	0,0,	
0,0,	0,0,	222,363,	0,0,	
0,0,	0,0,	142,75,	0,0,	
137,137,	286,420,	286,420,	286,420,	
286,420,	286,420,	286,420,	286,420,	
286,420,	0,0,	137,137,	0,0,	
142,75,	0,0,	142,142,	142,142,	
142,142,	142,142,	142,142,	142,142,	
142,142,	142,142,	142,142,	142,142,	
222,362,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
142,144,	222,364,	222,364,	222,364,	
222,364,	222,364,	222,364,	222,364,	
222,364,	142,144,	0,0,	0,0,	
142,144,	656,658,	142,144,	142,144,	
142,144,	0,0,	145,145,	0,0,	
0,0,	0,0,	656,658,	0,0,	
222,362,	656,658,	145,145,	145,281,	
656,658,	656,658,	0,0,	142,144,	
142,144,	142,144,	142,144,	142,144,	
142,144,	142,144,	142,144,	0,0,	
0,0,	142,144,	0,0,	0,0,	
142,144,	656,658,	142,144,	142,144,	
142,144,	145,282,	0,0,	145,145,	
145,145,	0,0,	145,145,	0,0,	
145,145,	145,145,	145,145,	0,0,	
145,145,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,145,	145,145,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	145,145,	0,0,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	0,0,	0,0,	
145,145,	145,145,	145,145,	0,0,	
0,0,	0,0,	145,145,	0,0,	
0,0,	0,0,	145,145,	145,145,	
145,145,	145,145,	145,145,	145,145,	
145,145,	145,145,	307,310,	307,310,	
307,310,	307,310,	307,310,	307,310,	
307,310,	307,310,	150,284,	0,0,	
145,145,	0,0,	150,289,	150,289,	
150,289,	150,289,	150,289,	150,289,	
150,289,	150,289,	145,145,	150,285,	
308,439,	308,439,	308,439,	308,439,	
308,439,	308,439,	308,439,	308,439,	
0,0,	0,0,	164,284,	0,0,	
0,0,	0,0,	164,289,	164,289,	
164,289,	164,289,	164,289,	164,289,	
164,289,	164,289,	0,0,	164,285,	
0,0,	0,0,	0,0,	0,0,	
0,0,	150,284,	310,440,	310,440,	
310,440,	310,440,	310,440,	310,440,	
310,440,	310,440,	150,286,	150,286,	
150,286,	150,286,	150,286,	150,286,	
150,286,	150,286,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
170,248,	164,284,	0,0,	0,0,	
0,0,	170,307,	0,0,	0,0,	
0,0,	150,284,	164,286,	164,286,	
164,286,	164,286,	164,286,	164,286,	
164,286,	164,286,	170,308,	0,0,	
0,0,	170,251,	0,0,	0,0,	
0,0,	0,0,	170,309,	0,0,	
164,301,	0,0,	0,0,	0,0,	
0,0,	164,284,	0,0,	170,309,	
0,0,	0,0,	170,309,	0,0,	
0,0,	170,309,	170,309,	0,0,	
0,0,	0,0,	0,0,	0,0,	
170,307,	316,318,	316,318,	316,318,	
316,318,	316,318,	316,318,	316,318,	
316,318,	170,310,	170,311,	170,310,	
170,310,	170,310,	170,310,	170,310,	
170,310,	0,0,	0,0,	170,309,	
0,0,	0,0,	170,309,	0,0,	
174,257,	170,309,	170,309,	0,0,	
0,0,	0,0,	0,0,	0,0,	
170,307,	174,313,	174,313,	174,313,	
174,313,	174,313,	174,313,	174,313,	
174,313,	0,0,	176,248,	311,392,	
0,0,	174,258,	0,0,	176,316,	
0,0,	0,0,	174,314,	311,440,	
311,440,	311,440,	311,440,	311,440,	
311,440,	311,440,	311,440,	174,314,	
176,317,	0,0,	174,314,	176,251,	
0,0,	174,314,	174,314,	0,0,	
176,309,	317,446,	317,446,	317,446,	
317,446,	317,446,	317,446,	317,446,	
317,446,	176,309,	0,0,	0,0,	
176,309,	0,0,	174,314,	176,309,	
176,309,	0,0,	0,0,	0,0,	
0,0,	0,0,	176,316,	174,314,	
0,0,	0,0,	174,314,	0,0,	
0,0,	174,314,	174,314,	176,318,	
176,319,	176,318,	176,318,	176,318,	
176,318,	176,318,	176,318,	0,0,	
0,0,	176,309,	0,0,	0,0,	
176,309,	0,0,	179,257,	176,309,	
176,309,	0,0,	0,0,	179,284,	
0,0,	0,0,	176,316,	179,322,	
179,322,	179,322,	179,322,	179,322,	
179,322,	179,322,	179,322,	0,0,	
179,285,	0,0,	0,0,	179,258,	
0,0,	0,0,	0,0,	0,0,	
179,314,	318,447,	318,447,	318,447,	
318,447,	318,447,	318,447,	318,447,	
318,447,	179,314,	0,0,	0,0,	
179,314,	0,0,	0,0,	179,314,	
179,314,	0,0,	0,0,	0,0,	
0,0,	0,0,	179,284,	357,473,	
357,473,	357,473,	357,473,	357,473,	
357,473,	357,473,	357,473,	179,286,	
179,323,	179,286,	179,286,	179,286,	
179,286,	179,286,	179,286,	0,0,	
0,0,	179,314,	0,0,	0,0,	
179,314,	0,0,	0,0,	179,314,	
179,314,	0,0,	0,0,	180,284,	
0,0,	0,0,	179,284,	180,322,	
180,322,	180,322,	180,322,	180,322,	
180,322,	180,322,	180,322,	319,392,	
180,285,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	319,447,	
319,447,	319,447,	319,447,	319,447,	
319,447,	319,447,	319,447,	0,0,	
0,0,	0,0,	0,0,	187,187,	
0,0,	0,0,	0,0,	323,399,	
0,0,	0,0,	0,0,	187,187,	
187,187,	0,0,	180,284,	323,420,	
323,420,	323,420,	323,420,	323,420,	
323,420,	323,420,	323,420,	180,286,	
180,286,	180,286,	180,286,	180,286,	
180,286,	180,286,	180,286,	0,0,	
0,0,	0,0,	187,187,	0,0,	
187,187,	187,187,	0,0,	187,187,	
0,0,	187,187,	0,0,	187,326,	
0,0,	187,187,	180,284,	187,187,	
187,187,	187,187,	187,187,	187,187,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	187,187,	
187,187,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	187,187,	
187,187,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	187,187,	
0,0,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	0,0,	
0,0,	187,187,	187,187,	187,187,	
0,0,	0,0,	0,0,	187,187,	
0,0,	0,0,	0,0,	187,187,	
187,187,	187,187,	187,187,	187,187,	
187,187,	187,187,	187,187,	188,328,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	188,328,	
188,328,	187,187,	362,364,	362,364,	
362,364,	362,364,	362,364,	362,364,	
362,364,	362,364,	0,0,	187,187,	
363,472,	363,472,	363,472,	363,472,	
363,472,	363,472,	363,472,	363,472,	
0,0,	0,0,	188,328,	0,0,	
188,328,	188,328,	0,0,	188,328,	
0,0,	188,328,	188,329,	188,330,	
0,0,	188,328,	0,0,	188,328,	
188,328,	188,328,	188,328,	188,328,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	188,328,	
188,328,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	188,328,	
188,328,	188,328,	188,328,	188,328,	
188,328,	188,328,	188,328,	188,328,	
0,0,	188,328,	188,328,	188,328,	
188,328,	188,328,	188,328,	188,328,	
188,328,	188,328,	188,328,	0,0,	
0,0,	188,328,	188,328,	188,328,	
0,0,	0,0,	0,0,	188,328,	
0,0,	0,0,	0,0,	188,328,	
188,328,	188,328,	188,328,	188,328,	
188,328,	188,328,	188,328,	191,191,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	191,191,	
191,0,	188,328,	364,475,	364,475,	
364,475,	364,475,	364,475,	364,475,	
364,475,	364,475,	0,0,	188,328,	
391,499,	391,499,	391,499,	391,499,	
391,499,	391,499,	391,499,	391,499,	
0,0,	0,0,	191,191,	0,0,	
191,191,	191,191,	0,0,	191,191,	
0,0,	191,191,	191,191,	191,332,	
0,0,	191,191,	0,0,	191,191,	
191,191,	191,191,	191,191,	191,191,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	191,191,	
191,191,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	191,191,	
191,191,	191,191,	191,191,	191,191,	
191,191,	191,191,	191,191,	191,191,	
0,0,	191,191,	191,191,	191,191,	
191,191,	191,191,	191,191,	191,191,	
191,191,	191,191,	191,191,	0,0,	
0,0,	191,191,	191,191,	191,191,	
0,0,	0,0,	0,0,	191,191,	
0,0,	0,0,	0,0,	191,191,	
191,191,	191,191,	191,191,	191,191,	
191,191,	191,191,	191,191,	192,192,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	192,192,	
192,0,	191,191,	400,505,	400,505,	
400,505,	400,505,	400,505,	400,505,	
400,505,	400,505,	0,0,	191,191,	
423,425,	423,425,	423,425,	423,425,	
423,425,	423,425,	423,425,	423,425,	
0,0,	0,0,	192,192,	0,0,	
192,192,	192,192,	0,0,	192,192,	
0,0,	192,192,	192,192,	192,192,	
0,0,	192,192,	0,0,	192,192,	
192,192,	192,192,	192,192,	192,192,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	192,192,	
192,192,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	192,192,	
192,192,	192,192,	192,192,	192,192,	
192,192,	192,192,	192,192,	192,192,	
0,0,	192,192,	192,192,	192,192,	
192,192,	192,192,	192,192,	192,192,	
192,192,	192,192,	192,192,	312,441,	
0,0,	192,192,	192,192,	192,192,	
0,0,	0,0,	232,362,	192,192,	
312,442,	0,0,	442,534,	192,192,	
192,192,	192,192,	192,192,	192,192,	
192,192,	192,192,	192,192,	232,363,	
312,443,	0,0,	0,0,	0,0,	
0,0,	312,444,	0,0,	0,0,	
0,0,	192,192,	0,0,	442,535,	
0,0,	0,0,	312,444,	0,0,	
442,536,	312,444,	244,244,	192,333,	
312,444,	312,444,	0,0,	0,0,	
0,0,	442,536,	244,244,	244,244,	
442,536,	232,362,	0,0,	442,536,	
442,536,	0,0,	0,0,	0,0,	
0,0,	312,444,	232,364,	232,364,	
232,364,	232,364,	232,364,	232,364,	
232,364,	232,364,	0,0,	0,0,	
442,536,	244,244,	0,0,	244,244,	
244,244,	0,0,	244,244,	0,0,	
244,244,	244,244,	244,244,	0,0,	
244,244,	232,362,	244,387,	244,244,	
244,244,	244,244,	244,244,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	244,244,	244,244,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	244,244,	244,244,	
244,244,	244,244,	244,244,	244,244,	
244,244,	244,244,	244,244,	0,0,	
244,244,	244,244,	244,244,	244,244,	
244,244,	244,244,	244,244,	244,244,	
244,244,	244,244,	0,0,	0,0,	
244,244,	244,244,	244,244,	0,0,	
245,245,	245,245,	0,0,	0,0,	
0,0,	396,503,	244,244,	244,244,	
244,244,	244,244,	244,244,	244,244,	
244,244,	244,244,	396,503,	0,0,	
0,0,	396,503,	404,504,	0,0,	
396,503,	396,503,	0,0,	245,245,	
244,244,	245,246,	404,475,	404,475,	
404,475,	404,475,	404,475,	404,475,	
404,475,	404,475,	244,244,	0,0,	
245,111,	396,503,	0,0,	245,111,	
245,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	396,503,	0,0,	
245,111,	396,503,	0,0,	0,0,	
396,503,	396,503,	0,0,	0,0,	
245,111,	245,111,	245,111,	245,111,	
245,111,	245,111,	245,111,	245,111,	
245,111,	0,0,	245,111,	245,111,	
245,111,	245,111,	245,111,	245,111,	
245,111,	245,111,	245,111,	245,111,	
246,246,	0,0,	245,111,	245,111,	
245,111,	0,0,	0,0,	0,0,	
246,246,	246,246,	0,0,	0,0,	
245,111,	245,111,	245,111,	245,111,	
245,111,	245,111,	245,111,	245,111,	
424,521,	424,521,	424,521,	424,521,	
424,521,	424,521,	424,521,	424,521,	
0,0,	0,0,	245,111,	246,246,	
0,0,	246,388,	246,246,	0,0,	
246,246,	0,0,	246,246,	246,246,	
246,246,	0,0,	246,246,	0,0,	
246,246,	246,246,	246,246,	246,246,	
246,246,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
246,246,	246,246,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
246,246,	246,246,	246,246,	246,246,	
246,246,	246,246,	246,246,	246,246,	
246,246,	0,0,	246,246,	246,246,	
246,246,	246,246,	246,246,	246,246,	
246,246,	246,246,	246,246,	246,246,	
247,257,	0,0,	246,246,	246,246,	
246,246,	0,0,	0,0,	0,0,	
246,389,	0,0,	0,0,	0,0,	
246,246,	246,246,	246,246,	246,246,	
246,246,	246,246,	246,246,	246,246,	
0,0,	247,258,	0,0,	0,0,	
0,0,	0,0,	247,259,	0,0,	
0,0,	0,0,	246,246,	0,0,	
0,0,	0,0,	255,257,	247,259,	
0,0,	0,0,	247,259,	0,0,	
246,246,	247,259,	247,259,	255,394,	
255,394,	255,394,	255,394,	255,394,	
255,394,	255,394,	255,394,	0,0,	
0,0,	0,0,	0,0,	255,258,	
256,396,	0,0,	247,259,	0,0,	
255,395,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	247,259,	
0,0,	255,395,	247,259,	0,0,	
255,395,	247,259,	247,259,	255,395,	
255,395,	256,397,	0,0,	0,0,	
0,0,	0,0,	256,398,	425,522,	
425,522,	425,522,	425,522,	425,522,	
425,522,	425,522,	425,522,	256,398,	
255,395,	0,0,	256,398,	0,0,	
0,0,	256,398,	256,398,	0,0,	
0,0,	255,395,	0,0,	0,0,	
255,395,	0,0,	260,257,	255,395,	
255,395,	0,0,	0,0,	0,0,	
0,0,	0,0,	256,398,	260,355,	
260,355,	260,355,	260,355,	260,355,	
260,355,	260,355,	260,355,	256,398,	
266,257,	0,0,	256,398,	260,258,	
0,0,	256,398,	256,398,	0,0,	
260,259,	266,403,	266,403,	266,403,	
266,403,	266,403,	266,403,	266,403,	
266,403,	260,259,	0,0,	0,0,	
260,259,	266,258,	0,0,	260,259,	
260,259,	0,0,	266,259,	267,396,	
0,0,	0,0,	0,0,	0,0,	
267,362,	0,0,	0,0,	266,259,	
0,0,	0,0,	266,259,	0,0,	
260,259,	266,259,	266,259,	0,0,	
0,0,	267,363,	0,0,	0,0,	
267,397,	260,259,	0,0,	0,0,	
260,259,	267,398,	0,0,	260,259,	
260,259,	0,0,	266,259,	289,423,	
0,0,	0,0,	267,398,	0,0,	
0,0,	267,398,	0,0,	266,259,	
267,398,	267,398,	266,259,	0,0,	
289,424,	266,259,	266,259,	267,362,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	299,423,	
267,364,	267,404,	267,364,	267,364,	
267,364,	267,364,	267,364,	267,364,	
0,0,	0,0,	267,398,	0,0,	
299,424,	267,398,	0,0,	0,0,	
267,398,	267,398,	289,423,	0,0,	
0,0,	0,0,	0,0,	267,362,	
0,0,	0,0,	0,0,	289,425,	
289,425,	289,425,	289,425,	289,425,	
289,425,	289,425,	289,425,	0,0,	
0,0,	0,0,	306,257,	0,0,	
313,396,	0,0,	299,423,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	289,423,	299,425,	
299,425,	299,425,	299,425,	299,425,	
299,425,	299,425,	299,425,	306,258,	
0,0,	313,397,	0,0,	0,0,	
306,314,	0,0,	313,445,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	306,314,	299,423,	313,445,	
306,314,	450,504,	313,445,	306,314,	
306,314,	313,445,	313,445,	0,0,	
0,0,	450,522,	450,522,	450,522,	
450,522,	450,522,	450,522,	450,522,	
450,522,	0,0,	0,0,	0,0,	
306,314,	0,0,	313,445,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	306,314,	315,257,	313,445,	
306,314,	0,0,	313,445,	306,314,	
306,314,	313,445,	313,445,	315,418,	
315,418,	315,418,	315,418,	315,418,	
315,418,	315,418,	315,418,	0,0,	
320,441,	0,0,	0,0,	315,258,	
0,0,	0,0,	0,0,	0,0,	
315,314,	320,448,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	315,314,	0,0,	0,0,	
315,314,	320,443,	0,0,	315,314,	
315,314,	0,0,	320,444,	472,561,	
472,561,	472,561,	472,561,	472,561,	
472,561,	472,561,	472,561,	320,444,	
0,0,	0,0,	320,444,	0,0,	
315,314,	320,444,	320,444,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	315,314,	321,257,	0,0,	
315,314,	0,0,	0,0,	315,314,	
315,314,	0,0,	320,444,	321,449,	
321,449,	321,449,	321,449,	321,449,	
321,449,	321,449,	321,449,	0,0,	
322,396,	0,0,	0,0,	321,258,	
0,0,	322,423,	0,0,	0,0,	
321,314,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	321,314,	322,424,	0,0,	
321,314,	322,397,	0,0,	321,314,	
321,314,	0,0,	322,445,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	322,445,	
0,0,	0,0,	322,445,	0,0,	
321,314,	322,445,	322,445,	0,0,	
0,0,	329,329,	0,0,	0,0,	
322,423,	321,314,	0,0,	0,0,	
321,314,	329,329,	329,329,	321,314,	
321,314,	322,425,	322,450,	322,425,	
322,425,	322,425,	322,425,	322,425,	
322,425,	0,0,	0,0,	322,445,	
0,0,	0,0,	322,445,	0,0,	
0,0,	322,445,	322,445,	0,0,	
329,329,	0,0,	329,329,	329,329,	
322,423,	329,329,	0,0,	329,329,	
329,0,	0,0,	0,0,	329,329,	
0,0,	329,329,	329,329,	329,329,	
329,329,	329,329,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	329,329,	329,329,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	329,329,	329,329,	329,329,	
329,329,	329,329,	329,329,	329,329,	
329,329,	329,329,	0,0,	329,329,	
329,329,	329,329,	329,329,	329,329,	
329,329,	329,329,	329,329,	329,329,	
329,329,	443,441,	0,0,	329,329,	
329,329,	329,329,	0,0,	0,0,	
356,363,	329,329,	0,0,	0,0,	
448,534,	329,329,	329,329,	329,329,	
329,329,	329,329,	329,329,	329,329,	
329,329,	356,363,	0,0,	0,0,	
0,0,	0,0,	0,0,	443,444,	
0,0,	0,0,	0,0,	329,329,	
0,0,	448,535,	0,0,	0,0,	
443,444,	0,0,	448,536,	443,444,	
387,244,	329,329,	443,444,	443,444,	
0,0,	0,0,	0,0,	448,536,	
387,244,	387,244,	448,536,	356,363,	
0,0,	448,536,	448,536,	0,0,	
0,0,	0,0,	0,0,	443,444,	
356,472,	356,472,	356,472,	356,472,	
356,472,	356,472,	356,472,	356,472,	
0,0,	0,0,	448,536,	387,244,	
0,0,	387,244,	387,244,	0,0,	
387,244,	0,0,	387,244,	387,244,	
387,244,	0,0,	387,244,	356,363,	
387,495,	387,244,	387,244,	387,244,	
387,244,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
387,244,	387,244,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
387,244,	387,244,	387,244,	387,244,	
387,244,	387,244,	387,244,	387,244,	
387,244,	0,0,	387,244,	387,244,	
387,244,	387,244,	387,244,	387,244,	
387,244,	387,244,	387,244,	387,244,	
0,0,	0,0,	387,244,	387,244,	
387,244,	388,388,	388,388,	0,0,	
0,0,	0,0,	0,0,	500,591,	
387,244,	387,244,	387,244,	387,244,	
387,244,	387,244,	387,244,	387,244,	
500,591,	0,0,	0,0,	500,591,	
0,0,	0,0,	500,591,	500,591,	
388,388,	0,0,	387,244,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
387,244,	388,111,	0,0,	500,591,	
388,111,	388,111,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
500,591,	388,111,	0,0,	500,591,	
0,0,	0,0,	500,591,	500,591,	
0,0,	388,111,	388,111,	388,111,	
388,111,	388,111,	388,111,	388,111,	
388,111,	388,111,	0,0,	388,111,	
388,111,	388,111,	388,111,	388,111,	
388,111,	388,111,	388,111,	388,111,	
388,111,	0,0,	389,497,	388,111,	
388,111,	388,111,	0,0,	0,0,	
0,0,	388,496,	389,497,	389,497,	
0,0,	388,111,	388,111,	388,111,	
388,111,	388,111,	388,111,	388,111,	
388,111,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	388,111,	
0,0,	389,497,	0,0,	389,498,	
389,497,	0,0,	389,497,	0,0,	
389,497,	389,497,	389,497,	0,0,	
389,497,	0,0,	389,497,	389,497,	
389,497,	389,497,	389,497,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	389,497,	389,497,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	389,497,	389,497,	
389,497,	389,497,	389,497,	389,497,	
389,497,	389,497,	389,497,	0,0,	
389,497,	389,497,	389,497,	389,497,	
389,497,	389,497,	389,497,	389,497,	
389,497,	389,497,	393,500,	0,0,	
389,497,	389,497,	389,497,	0,0,	
0,0,	0,0,	389,497,	0,0,	
394,396,	0,0,	389,497,	389,497,	
389,497,	389,497,	389,497,	389,497,	
389,497,	389,497,	0,0,	393,501,	
0,0,	0,0,	0,0,	0,0,	
393,502,	0,0,	0,0,	0,0,	
389,497,	394,397,	0,0,	0,0,	
401,500,	393,502,	394,503,	0,0,	
393,502,	0,0,	389,497,	393,502,	
393,502,	0,0,	0,0,	394,503,	
0,0,	0,0,	394,503,	0,0,	
0,0,	394,503,	394,503,	0,0,	
0,0,	401,501,	0,0,	0,0,	
393,502,	0,0,	401,502,	403,396,	
0,0,	0,0,	0,0,	0,0,	
0,0,	393,502,	394,503,	401,502,	
393,502,	0,0,	401,502,	393,502,	
393,502,	401,502,	401,502,	394,503,	
0,0,	0,0,	394,503,	0,0,	
403,397,	394,503,	394,503,	0,0,	
0,0,	403,398,	532,610,	0,0,	
0,0,	0,0,	401,502,	0,0,	
0,0,	0,0,	403,398,	0,0,	
0,0,	403,398,	0,0,	401,502,	
403,398,	403,398,	401,502,	412,512,	
0,0,	401,502,	401,502,	532,611,	
0,0,	0,0,	0,0,	412,412,	
532,612,	0,0,	0,0,	0,0,	
0,0,	403,398,	0,0,	0,0,	
0,0,	532,612,	0,0,	0,0,	
532,612,	0,0,	403,398,	532,612,	
532,612,	403,398,	0,0,	0,0,	
403,398,	403,398,	412,412,	0,0,	
412,512,	412,512,	0,0,	412,512,	
0,0,	412,512,	412,512,	412,512,	
532,612,	412,512,	0,0,	412,512,	
412,512,	412,512,	412,512,	412,512,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	412,512,	
412,512,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	412,512,	
412,512,	412,512,	412,512,	412,512,	
412,512,	412,512,	412,512,	412,512,	
0,0,	412,512,	412,512,	412,512,	
412,512,	412,512,	412,512,	412,512,	
412,512,	412,512,	412,512,	440,500,	
0,0,	412,512,	412,512,	412,512,	
0,0,	0,0,	0,0,	412,512,	
0,0,	447,500,	0,0,	412,512,	
412,512,	412,512,	412,512,	412,512,	
412,512,	412,512,	412,512,	0,0,	
440,501,	0,0,	0,0,	535,534,	
0,0,	440,533,	0,0,	0,0,	
0,0,	412,512,	447,501,	0,0,	
0,0,	449,396,	440,533,	447,533,	
0,0,	440,533,	0,0,	412,512,	
440,533,	440,533,	0,0,	0,0,	
447,533,	0,0,	0,0,	447,533,	
0,0,	535,536,	447,533,	447,533,	
0,0,	0,0,	449,397,	0,0,	
0,0,	440,533,	535,536,	449,445,	
0,0,	535,536,	0,0,	0,0,	
535,536,	535,536,	440,533,	447,533,	
449,445,	440,533,	0,0,	449,445,	
440,533,	440,533,	449,445,	449,445,	
447,533,	454,454,	0,0,	447,533,	
0,0,	535,536,	447,533,	447,533,	
0,0,	454,454,	454,0,	0,0,	
0,0,	0,0,	0,0,	449,445,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
449,445,	0,0,	0,0,	449,445,	
0,0,	0,0,	449,445,	449,445,	
454,454,	0,0,	454,454,	454,454,	
0,0,	454,454,	0,0,	454,454,	
454,454,	454,541,	0,0,	454,454,	
0,0,	454,454,	454,454,	454,454,	
454,454,	454,454,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	454,454,	454,454,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	454,454,	454,454,	454,454,	
454,454,	454,454,	454,454,	454,454,	
454,454,	454,454,	0,0,	454,454,	
454,454,	454,454,	454,454,	454,454,	
454,454,	454,454,	454,454,	454,454,	
454,454,	0,0,	0,0,	454,454,	
454,454,	454,454,	0,0,	0,0,	
0,0,	454,454,	0,0,	0,0,	
0,0,	454,454,	454,454,	454,454,	
454,454,	454,454,	454,454,	454,454,	
454,454,	455,455,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,455,	455,0,	454,454,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	454,454,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
455,455,	0,0,	455,455,	455,455,	
0,0,	455,455,	0,0,	455,455,	
455,455,	455,455,	0,0,	455,455,	
0,0,	455,455,	455,455,	455,455,	
455,455,	455,455,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,455,	455,455,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,455,	455,455,	455,455,	
455,455,	455,455,	455,455,	455,455,	
455,455,	455,455,	0,0,	455,455,	
455,455,	455,455,	455,455,	455,455,	
455,455,	455,455,	455,455,	455,455,	
455,455,	0,0,	0,0,	455,455,	
455,455,	455,455,	0,0,	0,0,	
0,0,	455,455,	0,0,	0,0,	
0,0,	455,455,	455,455,	455,455,	
455,455,	455,455,	455,455,	455,455,	
455,455,	456,456,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	456,456,	456,0,	455,455,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,542,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
456,456,	0,0,	456,456,	456,456,	
0,0,	456,456,	0,0,	456,456,	
456,456,	456,543,	0,0,	456,456,	
0,0,	456,456,	456,456,	456,456,	
456,456,	456,456,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	456,456,	456,456,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	456,456,	456,456,	456,456,	
456,456,	456,456,	456,456,	456,456,	
456,456,	456,456,	0,0,	456,456,	
456,456,	456,456,	456,456,	456,456,	
456,456,	456,456,	456,456,	456,456,	
456,456,	0,0,	0,0,	456,456,	
456,456,	456,456,	0,0,	0,0,	
0,0,	456,456,	0,0,	0,0,	
0,0,	456,456,	456,456,	456,456,	
456,456,	456,456,	456,456,	456,456,	
456,456,	457,457,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	457,457,	457,0,	456,456,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	456,456,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
457,457,	0,0,	457,457,	457,457,	
0,0,	457,457,	0,0,	457,457,	
457,457,	457,457,	0,0,	457,457,	
0,0,	457,457,	457,457,	457,457,	
457,457,	457,457,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	457,457,	457,457,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	457,457,	457,457,	457,457,	
457,457,	457,457,	457,457,	457,457,	
457,457,	457,457,	0,0,	457,457,	
457,457,	457,457,	457,457,	457,457,	
457,457,	457,457,	457,457,	457,457,	
457,457,	0,0,	0,0,	457,457,	
457,457,	457,457,	0,0,	0,0,	
0,0,	457,457,	0,0,	0,0,	
0,0,	457,457,	457,457,	457,457,	
457,457,	457,457,	457,457,	457,457,	
457,457,	458,458,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,458,	458,0,	457,457,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	457,544,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
458,458,	0,0,	458,458,	458,458,	
0,0,	458,458,	0,0,	458,458,	
458,458,	458,545,	0,0,	458,458,	
0,0,	458,458,	458,458,	458,458,	
458,458,	458,458,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,458,	458,458,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,458,	458,458,	458,458,	
458,458,	458,458,	458,458,	458,458,	
458,458,	458,458,	0,0,	458,458,	
458,458,	458,458,	458,458,	458,458,	
458,458,	458,458,	458,458,	458,458,	
458,458,	0,0,	0,0,	458,458,	
458,458,	458,458,	0,0,	0,0,	
0,0,	458,458,	0,0,	0,0,	
0,0,	458,458,	458,458,	458,458,	
458,458,	458,458,	458,458,	458,458,	
458,458,	459,459,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	459,459,	459,0,	458,458,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,458,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
459,459,	0,0,	459,459,	459,459,	
0,0,	459,459,	0,0,	459,459,	
459,459,	459,459,	0,0,	459,459,	
0,0,	459,459,	459,459,	459,459,	
459,459,	459,459,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	459,459,	459,459,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	459,459,	459,459,	459,459,	
459,459,	459,459,	459,459,	459,459,	
459,459,	459,459,	0,0,	459,459,	
459,459,	459,459,	459,459,	459,459,	
459,459,	459,459,	459,459,	459,459,	
459,459,	475,563,	0,0,	459,459,	
459,459,	459,459,	0,0,	0,0,	
0,0,	459,459,	0,0,	0,0,	
0,0,	459,459,	459,459,	459,459,	
459,459,	459,459,	459,459,	459,459,	
459,459,	0,0,	475,564,	0,0,	
0,0,	0,0,	0,0,	475,565,	
0,0,	0,0,	0,0,	459,459,	
0,0,	0,0,	0,0,	0,0,	
475,565,	0,0,	0,0,	475,565,	
0,0,	459,546,	475,565,	475,565,	
0,0,	495,244,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,244,	495,244,	0,0,	
0,0,	0,0,	0,0,	475,565,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
475,565,	0,0,	0,0,	475,565,	
0,0,	0,0,	475,565,	475,565,	
495,244,	0,0,	495,244,	495,244,	
0,0,	495,244,	0,0,	495,244,	
495,244,	495,244,	0,0,	495,244,	
0,0,	495,495,	495,244,	495,244,	
495,244,	495,244,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,244,	495,244,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,244,	495,244,	495,244,	
495,244,	495,244,	495,244,	495,244,	
495,244,	495,244,	0,0,	495,244,	
495,244,	495,244,	495,244,	495,244,	
495,244,	495,244,	495,244,	495,244,	
495,244,	499,500,	0,0,	495,244,	
495,244,	495,244,	0,0,	0,0,	
0,0,	495,589,	0,0,	0,0,	
0,0,	495,244,	495,244,	495,244,	
495,244,	495,244,	495,244,	495,244,	
495,244,	0,0,	499,501,	0,0,	
0,0,	0,0,	0,0,	499,591,	
538,610,	0,0,	0,0,	495,244,	
0,0,	0,0,	0,0,	0,0,	
499,591,	0,0,	0,0,	499,591,	
0,0,	495,244,	499,591,	499,591,	
0,0,	512,512,	0,0,	0,0,	
0,0,	538,611,	0,0,	0,0,	
0,0,	512,512,	538,612,	0,0,	
0,0,	0,0,	0,0,	499,591,	
0,0,	0,0,	0,0,	538,612,	
0,0,	0,0,	538,612,	0,0,	
499,591,	538,612,	538,612,	499,591,	
0,0,	0,0,	499,591,	499,591,	
512,512,	0,0,	512,512,	512,512,	
0,0,	512,512,	0,0,	512,512,	
512,512,	512,512,	538,612,	512,512,	
0,0,	512,512,	512,512,	512,512,	
512,512,	512,512,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	512,512,	512,512,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	512,512,	512,512,	512,512,	
512,512,	512,512,	512,512,	512,512,	
512,512,	512,512,	0,0,	512,512,	
512,512,	512,512,	512,512,	512,512,	
512,512,	512,512,	512,512,	512,512,	
512,512,	0,0,	0,0,	512,512,	
512,512,	512,512,	0,0,	0,0,	
0,0,	512,512,	0,0,	0,0,	
0,0,	512,512,	512,512,	512,512,	
512,512,	512,512,	512,512,	512,512,	
512,512,	513,513,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	513,513,	0,0,	512,512,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	512,512,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
513,513,	0,0,	513,513,	513,513,	
0,0,	513,513,	0,0,	513,513,	
513,513,	513,596,	0,0,	513,513,	
0,0,	513,513,	513,513,	513,513,	
513,513,	513,513,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	513,513,	513,513,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	513,513,	513,513,	513,513,	
513,513,	513,513,	513,513,	513,513,	
513,513,	513,513,	0,0,	513,513,	
513,513,	513,513,	513,513,	513,513,	
513,513,	513,513,	513,513,	513,513,	
513,513,	0,0,	0,0,	513,513,	
513,513,	513,513,	0,0,	0,0,	
0,0,	513,513,	0,0,	0,0,	
0,0,	513,513,	513,513,	513,513,	
513,513,	513,513,	513,513,	513,513,	
513,513,	514,514,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	514,514,	0,0,	513,513,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	513,513,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
514,514,	0,0,	514,514,	514,514,	
0,0,	514,514,	0,0,	514,514,	
514,514,	514,514,	0,0,	514,514,	
0,0,	514,514,	514,514,	514,514,	
514,514,	514,514,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	514,514,	514,514,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	514,514,	514,514,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	514,514,	0,0,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	0,0,	0,0,	514,514,	
514,514,	514,514,	0,0,	0,0,	
0,0,	514,514,	0,0,	0,0,	
0,0,	514,514,	514,514,	514,514,	
514,514,	514,514,	514,514,	514,514,	
514,514,	515,515,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,515,	0,0,	514,514,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	514,597,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
515,515,	0,0,	515,515,	515,515,	
0,0,	515,515,	0,0,	515,515,	
515,515,	515,598,	0,0,	515,515,	
0,0,	515,515,	515,515,	515,515,	
515,515,	515,515,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,515,	515,515,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,515,	515,515,	515,515,	
515,515,	515,515,	515,515,	515,515,	
515,515,	515,515,	0,0,	515,515,	
515,515,	515,515,	515,515,	515,515,	
515,515,	515,515,	515,515,	515,515,	
515,515,	0,0,	0,0,	515,515,	
515,515,	515,515,	0,0,	0,0,	
0,0,	515,515,	0,0,	0,0,	
0,0,	515,515,	515,515,	515,515,	
515,515,	515,515,	515,515,	515,515,	
515,515,	516,516,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	516,516,	0,0,	515,515,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,515,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
516,516,	0,0,	516,516,	516,516,	
0,0,	516,516,	0,0,	516,516,	
516,516,	516,516,	0,0,	516,516,	
0,0,	516,516,	516,516,	516,516,	
516,516,	516,516,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	516,516,	516,516,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	516,516,	516,516,	516,516,	
516,516,	516,516,	516,516,	516,516,	
516,516,	516,516,	0,0,	516,516,	
516,516,	516,516,	516,516,	516,516,	
516,516,	516,516,	516,516,	516,516,	
516,516,	522,563,	0,0,	516,516,	
516,516,	516,516,	0,0,	0,0,	
0,0,	516,516,	0,0,	561,563,	
0,0,	516,516,	516,516,	516,516,	
516,516,	516,516,	516,516,	516,516,	
516,516,	0,0,	522,564,	0,0,	
0,0,	0,0,	0,0,	522,603,	
0,0,	0,0,	0,0,	516,516,	
561,564,	0,0,	0,0,	563,627,	
522,603,	561,627,	0,0,	522,603,	
0,0,	516,599,	522,603,	522,603,	
563,627,	0,0,	561,627,	563,627,	
0,0,	561,627,	563,627,	563,627,	
561,627,	561,627,	0,0,	567,567,	
0,0,	0,0,	0,0,	522,603,	
0,0,	0,0,	0,0,	567,567,	
567,0,	0,0,	0,0,	563,627,	
522,603,	561,627,	0,0,	522,603,	
0,0,	0,0,	522,603,	522,603,	
563,627,	0,0,	561,627,	563,627,	
0,0,	561,627,	563,627,	563,627,	
561,627,	561,627,	567,567,	0,0,	
567,567,	567,567,	0,0,	567,567,	
0,0,	567,567,	567,567,	567,630,	
0,0,	567,567,	0,0,	567,567,	
567,567,	567,567,	567,567,	567,567,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	567,567,	
567,567,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	567,567,	
567,567,	567,567,	567,567,	567,567,	
567,567,	567,567,	567,567,	567,567,	
0,0,	567,567,	567,567,	567,567,	
567,567,	567,567,	567,567,	567,567,	
567,567,	567,567,	567,567,	602,656,	
0,0,	567,567,	567,567,	567,567,	
0,0,	0,0,	0,0,	567,567,	
0,0,	0,0,	0,0,	567,567,	
567,567,	567,567,	567,567,	567,567,	
567,567,	567,567,	567,567,	588,628,	
602,657,	588,237,	0,0,	0,0,	
0,0,	602,658,	0,0,	588,238,	
588,239,	567,567,	588,211,	0,0,	
0,0,	588,240,	602,658,	596,513,	
0,0,	602,658,	588,241,	567,567,	
602,658,	602,658,	0,0,	596,513,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	588,628,	
0,0,	588,237,	0,0,	0,0,	
0,0,	602,658,	0,0,	588,238,	
588,239,	0,0,	588,211,	0,0,	
0,0,	588,240,	596,513,	0,0,	
596,513,	596,513,	588,241,	596,513,	
0,0,	596,513,	596,513,	596,596,	
0,0,	596,513,	0,0,	596,513,	
596,513,	596,513,	596,513,	596,513,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	596,513,	
596,513,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	596,513,	
596,513,	596,513,	596,513,	596,513,	
596,513,	596,513,	596,513,	596,513,	
0,0,	596,513,	596,513,	596,513,	
596,513,	596,513,	596,513,	596,513,	
596,513,	596,513,	596,513,	0,0,	
0,0,	596,513,	596,513,	596,513,	
0,0,	0,0,	0,0,	596,513,	
0,0,	0,0,	0,0,	596,513,	
596,513,	596,513,	596,513,	596,513,	
596,513,	596,513,	596,513,	597,514,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	597,514,	
0,0,	596,513,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	596,513,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	597,514,	0,0,	
597,514,	597,514,	0,0,	597,514,	
0,0,	597,514,	597,514,	597,514,	
0,0,	597,514,	0,0,	597,514,	
597,514,	597,514,	597,514,	597,514,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	597,514,	
597,514,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	597,514,	
597,514,	597,514,	597,514,	597,514,	
597,514,	597,514,	597,514,	597,514,	
0,0,	597,514,	597,514,	597,514,	
597,514,	597,514,	597,514,	597,514,	
597,514,	597,514,	597,514,	0,0,	
0,0,	597,514,	597,514,	597,514,	
0,0,	0,0,	0,0,	597,514,	
0,0,	0,0,	0,0,	597,514,	
597,514,	597,514,	597,514,	597,514,	
597,514,	597,514,	597,514,	598,515,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	598,515,	
0,0,	597,514,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	597,597,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	598,515,	0,0,	
598,515,	598,515,	0,0,	598,515,	
0,0,	598,515,	598,515,	598,598,	
0,0,	598,515,	0,0,	598,515,	
598,515,	598,515,	598,515,	598,515,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	598,515,	
598,515,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	598,515,	
598,515,	598,515,	598,515,	598,515,	
598,515,	598,515,	598,515,	598,515,	
0,0,	598,515,	598,515,	598,515,	
598,515,	598,515,	598,515,	598,515,	
598,515,	598,515,	598,515,	0,0,	
0,0,	598,515,	598,515,	598,515,	
0,0,	0,0,	0,0,	598,515,	
0,0,	0,0,	0,0,	598,515,	
598,515,	598,515,	598,515,	598,515,	
598,515,	598,515,	598,515,	599,516,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	599,516,	
0,0,	598,515,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	598,515,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	599,516,	0,0,	
599,516,	599,516,	0,0,	599,516,	
0,0,	599,516,	599,516,	599,516,	
0,0,	599,516,	0,0,	599,516,	
599,516,	599,516,	599,516,	599,516,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	599,516,	
599,516,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	599,516,	
599,516,	599,516,	599,516,	599,516,	
599,516,	599,516,	599,516,	599,516,	
0,0,	599,516,	599,516,	599,516,	
599,516,	599,516,	599,516,	599,516,	
599,516,	599,516,	599,516,	611,610,	
0,0,	599,516,	599,516,	599,516,	
0,0,	0,0,	0,0,	599,516,	
0,0,	0,0,	0,0,	599,516,	
599,516,	599,516,	599,516,	599,516,	
599,516,	599,516,	599,516,	0,0,	
0,0,	0,0,	625,625,	0,0,	
0,0,	611,612,	0,0,	0,0,	
0,0,	599,516,	625,625,	625,0,	
0,0,	0,0,	611,612,	0,0,	
0,0,	611,612,	0,0,	599,599,	
611,612,	611,612,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	625,625,	0,0,	625,625,	
625,625,	611,612,	625,625,	0,0,	
625,625,	625,625,	625,674,	0,0,	
625,625,	0,0,	625,625,	625,625,	
625,625,	625,625,	625,625,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	625,625,	625,625,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	625,625,	625,625,	
625,625,	625,625,	625,625,	625,625,	
625,625,	625,625,	625,625,	0,0,	
625,625,	625,625,	625,625,	625,625,	
625,625,	625,625,	625,625,	625,625,	
625,625,	625,625,	0,0,	0,0,	
625,625,	625,625,	625,625,	0,0,	
0,0,	0,0,	625,625,	0,0,	
0,0,	0,0,	625,625,	625,625,	
625,625,	625,625,	625,625,	625,625,	
625,625,	625,625,	650,650,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	650,650,	650,0,	
625,625,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	625,625,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	650,650,	0,0,	650,650,	
650,650,	0,0,	650,650,	0,0,	
650,650,	650,650,	650,692,	0,0,	
650,650,	0,0,	650,650,	650,650,	
650,650,	650,650,	650,650,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	650,650,	650,650,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	650,650,	650,650,	
650,650,	650,650,	650,650,	650,650,	
650,650,	650,650,	650,650,	0,0,	
650,650,	650,650,	650,650,	650,650,	
650,650,	650,650,	650,650,	650,650,	
650,650,	650,650,	657,656,	0,0,	
650,650,	650,650,	650,650,	0,0,	
0,0,	0,0,	650,650,	0,0,	
0,0,	0,0,	650,650,	650,650,	
650,650,	650,650,	650,650,	650,650,	
650,650,	650,650,	0,0,	0,0,	
0,0,	685,714,	0,0,	0,0,	
657,658,	0,0,	0,0,	0,0,	
650,650,	685,714,	685,0,	0,0,	
0,0,	657,658,	0,0,	0,0,	
657,658,	0,0,	650,650,	657,658,	
657,658,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
685,714,	0,0,	685,714,	685,714,	
657,658,	685,714,	0,0,	685,685,	
685,714,	685,714,	0,0,	685,714,	
0,0,	685,685,	685,714,	685,714,	
685,685,	685,685,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	685,685,	685,714,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	685,685,	685,685,	685,685,	
685,685,	685,685,	685,685,	685,715,	
685,685,	685,685,	699,0,	685,685,	
685,685,	685,685,	685,685,	685,685,	
685,685,	685,685,	685,685,	685,685,	
685,685,	0,0,	0,0,	685,685,	
685,685,	685,685,	0,0,	0,0,	
0,0,	685,714,	0,0,	0,0,	
0,0,	685,685,	685,685,	685,685,	
685,685,	685,685,	685,685,	685,715,	
685,685,	0,0,	0,0,	0,0,	
0,0,	699,699,	0,0,	0,0,	
699,699,	699,699,	0,0,	685,685,	
0,0,	0,0,	0,0,	0,0,	
0,0,	699,699,	699,725,	0,0,	
0,0,	685,714,	0,0,	0,0,	
0,0,	699,699,	699,699,	699,699,	
699,699,	699,699,	699,699,	699,726,	
699,699,	699,699,	0,0,	699,699,	
699,699,	699,699,	699,699,	699,699,	
699,699,	699,699,	699,699,	699,699,	
699,699,	714,0,	0,0,	699,699,	
699,699,	699,699,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	699,699,	699,699,	699,699,	
699,699,	699,699,	699,699,	699,726,	
699,699,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	714,714,	699,699,	
0,0,	0,0,	0,0,	0,0,	
714,714,	0,0,	0,0,	714,714,	
714,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
714,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
714,714,	714,714,	714,714,	714,714,	
714,714,	714,714,	714,737,	714,714,	
714,714,	0,0,	714,714,	714,714,	
714,714,	714,714,	714,714,	714,714,	
714,714,	714,714,	714,714,	714,714,	
725,725,	0,0,	714,714,	714,714,	
714,714,	0,0,	0,0,	0,0,	
725,725,	0,0,	0,0,	0,0,	
714,714,	714,714,	714,714,	714,714,	
714,714,	714,714,	714,737,	714,714,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	714,714,	725,725,	
0,0,	725,725,	725,725,	0,0,	
725,725,	0,0,	725,725,	725,725,	
725,725,	0,0,	725,725,	0,0,	
725,725,	725,725,	725,725,	725,725,	
725,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
725,725,	725,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
725,725,	725,725,	725,725,	725,725,	
725,725,	725,725,	725,746,	725,725,	
725,725,	726,0,	725,725,	725,725,	
725,725,	725,725,	725,725,	725,725,	
725,725,	725,725,	725,725,	725,725,	
0,0,	0,0,	725,725,	725,725,	
725,725,	0,0,	0,0,	0,0,	
725,725,	0,0,	0,0,	0,0,	
725,725,	725,725,	725,725,	725,725,	
725,725,	725,725,	725,746,	725,725,	
0,0,	0,0,	0,0,	0,0,	
726,699,	0,0,	0,0,	726,699,	
726,699,	0,0,	725,725,	0,0,	
0,0,	0,0,	0,0,	0,0,	
726,699,	726,725,	0,0,	0,0,	
725,725,	0,0,	0,0,	0,0,	
726,747,	726,699,	726,699,	726,699,	
726,699,	726,699,	726,726,	726,699,	
726,699,	0,0,	726,699,	726,699,	
726,699,	726,699,	726,699,	726,699,	
726,699,	726,699,	726,699,	726,699,	
737,0,	0,0,	726,699,	726,699,	
726,699,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
726,748,	726,699,	726,699,	726,699,	
726,699,	726,699,	726,726,	726,699,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	737,714,	726,699,	0,0,	
0,0,	0,0,	0,0,	737,714,	
0,0,	0,0,	737,714,	737,714,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	737,714,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	737,762,	
737,714,	737,714,	737,714,	737,714,	
737,714,	737,737,	737,714,	737,714,	
0,0,	737,714,	737,714,	737,714,	
737,714,	737,714,	737,714,	737,714,	
737,714,	737,714,	737,714,	746,725,	
0,0,	737,714,	737,714,	737,714,	
0,0,	0,0,	0,0,	746,725,	
0,0,	0,0,	0,0,	737,763,	
737,714,	737,714,	737,714,	737,714,	
737,714,	737,737,	737,714,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	737,714,	746,725,	0,0,	
746,725,	746,725,	0,0,	746,725,	
0,0,	746,725,	746,725,	746,725,	
0,0,	746,725,	0,0,	746,725,	
746,725,	746,725,	746,725,	746,725,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	746,725,	
746,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	746,773,	
746,725,	746,725,	746,725,	746,725,	
746,725,	746,746,	746,725,	746,725,	
747,0,	746,725,	746,725,	746,725,	
746,725,	746,725,	746,725,	746,725,	
746,725,	746,725,	746,725,	0,0,	
0,0,	746,725,	746,725,	746,725,	
0,0,	0,0,	0,0,	746,725,	
0,0,	0,0,	0,0,	746,774,	
746,725,	746,725,	746,725,	746,725,	
746,725,	746,746,	746,725,	0,0,	
0,0,	0,0,	0,0,	747,699,	
0,0,	0,0,	747,699,	747,699,	
0,0,	746,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	747,699,	
747,725,	0,0,	0,0,	746,725,	
0,0,	0,0,	0,0,	747,699,	
747,699,	747,699,	747,699,	747,699,	
747,699,	747,726,	747,699,	747,699,	
0,0,	747,699,	747,699,	747,775,	
747,699,	747,699,	747,699,	747,699,	
747,699,	747,699,	747,699,	748,0,	
0,0,	747,699,	747,699,	747,699,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	747,699,	
747,699,	747,699,	747,699,	747,699,	
747,699,	747,726,	747,699,	0,0,	
0,0,	0,0,	0,0,	747,699,	
0,0,	0,0,	0,0,	0,0,	
0,0,	747,699,	0,0,	0,0,	
0,0,	0,0,	748,699,	0,0,	
0,0,	748,699,	748,699,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	748,699,	748,725,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	748,699,	748,699,	
748,699,	748,699,	748,699,	748,699,	
748,726,	748,699,	748,699,	0,0,	
748,699,	748,699,	748,699,	748,699,	
748,699,	748,699,	748,699,	748,699,	
748,699,	748,699,	762,0,	0,0,	
748,699,	748,699,	748,699,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	748,699,	748,699,	
748,699,	748,699,	748,699,	748,699,	
748,726,	748,699,	0,0,	0,0,	
0,0,	0,0,	748,776,	0,0,	
0,0,	0,0,	0,0,	762,714,	
748,699,	0,0,	0,0,	0,0,	
0,0,	762,714,	0,0,	0,0,	
762,714,	762,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	762,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	762,714,	762,714,	762,714,	
762,714,	762,714,	762,714,	762,737,	
762,714,	762,714,	0,0,	762,714,	
762,714,	762,790,	762,714,	762,714,	
762,714,	762,714,	762,714,	762,714,	
762,714,	763,0,	0,0,	762,714,	
762,714,	762,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	762,714,	762,714,	762,714,	
762,714,	762,714,	762,714,	762,737,	
762,714,	0,0,	0,0,	0,0,	
0,0,	762,714,	0,0,	0,0,	
0,0,	0,0,	763,714,	762,714,	
0,0,	0,0,	0,0,	0,0,	
763,714,	0,0,	0,0,	763,714,	
763,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
763,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
763,714,	763,714,	763,714,	763,714,	
763,714,	763,714,	763,737,	763,714,	
763,714,	0,0,	763,714,	763,714,	
763,714,	763,714,	763,714,	763,714,	
763,714,	763,714,	763,714,	763,714,	
773,725,	0,0,	763,714,	763,714,	
763,714,	0,0,	0,0,	0,0,	
773,725,	773,274,	0,0,	0,0,	
763,714,	763,714,	763,714,	763,714,	
763,714,	763,714,	763,737,	763,714,	
0,0,	0,0,	0,0,	0,0,	
763,791,	0,0,	0,0,	0,0,	
0,0,	0,0,	763,714,	773,725,	
0,0,	773,725,	773,725,	0,0,	
773,725,	0,0,	773,725,	773,725,	
773,725,	0,0,	773,725,	0,0,	
773,725,	773,725,	773,725,	773,725,	
773,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
773,725,	773,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
773,725,	773,725,	773,725,	773,725,	
773,725,	773,725,	773,746,	773,725,	
773,725,	0,0,	773,725,	773,725,	
773,801,	773,725,	773,725,	773,725,	
773,725,	773,725,	773,725,	773,725,	
775,0,	0,0,	773,725,	773,725,	
773,725,	0,0,	0,0,	0,0,	
773,725,	0,0,	0,0,	0,0,	
773,725,	773,725,	773,725,	773,725,	
773,725,	773,725,	773,746,	773,725,	
0,0,	0,0,	0,0,	0,0,	
773,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	773,725,	0,0,	
0,0,	0,0,	0,0,	775,699,	
0,0,	0,0,	775,699,	775,699,	
773,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	775,699,	
775,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	775,699,	
775,699,	775,699,	775,699,	775,803,	
775,699,	775,726,	775,699,	775,699,	
776,0,	775,699,	775,699,	775,699,	
775,699,	775,699,	775,699,	775,699,	
775,699,	775,699,	775,699,	0,0,	
0,0,	775,699,	775,699,	775,699,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	775,699,	
775,699,	775,699,	775,699,	775,699,	
775,699,	775,726,	775,699,	0,0,	
0,0,	0,0,	0,0,	776,699,	
0,0,	0,0,	776,699,	776,699,	
0,0,	775,699,	0,0,	0,0,	
0,0,	0,0,	0,0,	776,699,	
776,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	776,699,	
776,699,	776,699,	776,699,	776,699,	
776,699,	776,726,	776,699,	776,699,	
0,0,	776,699,	776,699,	776,699,	
776,699,	776,699,	776,699,	776,699,	
776,699,	776,699,	776,699,	790,0,	
0,0,	776,699,	776,699,	776,699,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	776,699,	
776,699,	776,699,	776,699,	776,803,	
776,699,	776,726,	776,699,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
790,714,	776,699,	0,0,	0,0,	
0,0,	0,0,	790,714,	0,0,	
0,0,	790,714,	790,714,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	790,714,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	790,714,	790,714,	
790,714,	790,714,	790,815,	790,714,	
790,737,	790,714,	790,714,	0,0,	
790,714,	790,714,	790,714,	790,714,	
790,714,	790,714,	790,714,	790,714,	
790,714,	790,714,	791,0,	0,0,	
790,714,	790,714,	790,714,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	790,714,	790,714,	
790,714,	790,714,	790,714,	790,714,	
790,737,	790,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	791,714,	
790,714,	0,0,	0,0,	0,0,	
0,0,	791,714,	0,0,	0,0,	
791,714,	791,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	791,714,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	791,714,	791,714,	791,714,	
791,714,	791,714,	791,714,	791,737,	
791,714,	791,714,	0,0,	791,714,	
791,714,	791,714,	791,714,	791,714,	
791,714,	791,714,	791,714,	791,714,	
791,714,	797,797,	0,0,	791,714,	
791,714,	791,714,	0,0,	0,0,	
0,0,	797,797,	797,819,	0,0,	
0,0,	791,714,	791,714,	791,714,	
791,714,	791,815,	791,714,	791,737,	
791,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	791,714,	
797,797,	0,0,	797,797,	797,797,	
0,0,	797,797,	0,0,	797,797,	
797,797,	797,797,	0,0,	797,797,	
0,0,	797,797,	797,797,	797,797,	
797,797,	797,797,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	797,797,	797,797,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	797,797,	797,797,	797,797,	
797,797,	797,797,	797,797,	797,797,	
797,797,	797,797,	0,0,	797,797,	
797,797,	797,797,	797,797,	797,797,	
797,797,	797,797,	797,797,	797,797,	
797,797,	0,0,	0,0,	797,797,	
797,797,	797,797,	0,0,	0,0,	
0,0,	797,797,	0,0,	0,0,	
0,0,	797,797,	797,797,	797,797,	
797,797,	797,797,	797,797,	797,797,	
797,797,	799,799,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	799,799,	799,821,	797,797,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	797,797,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
799,799,	0,0,	799,799,	799,799,	
0,0,	799,799,	0,0,	799,799,	
799,799,	799,799,	0,0,	799,799,	
0,0,	799,799,	799,799,	799,799,	
799,799,	799,799,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	799,799,	799,799,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	799,799,	799,799,	799,799,	
799,799,	799,799,	799,799,	799,799,	
799,799,	799,799,	0,0,	799,799,	
799,799,	799,799,	799,799,	799,799,	
799,799,	799,799,	799,799,	799,799,	
799,799,	0,0,	0,0,	799,799,	
799,799,	799,799,	0,0,	0,0,	
0,0,	799,799,	0,0,	0,0,	
0,0,	799,799,	799,799,	799,799,	
799,799,	799,799,	799,799,	799,799,	
799,799,	801,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	801,725,	0,0,	799,799,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	799,799,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
801,725,	0,0,	801,725,	801,725,	
0,0,	801,725,	0,0,	801,725,	
801,725,	801,725,	0,0,	801,725,	
0,0,	801,725,	801,725,	801,725,	
801,725,	801,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	801,725,	801,725,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	801,725,	801,725,	801,725,	
801,725,	801,823,	801,725,	801,746,	
801,725,	801,725,	0,0,	801,725,	
801,725,	801,725,	801,725,	801,725,	
801,725,	801,725,	801,725,	801,725,	
801,725,	0,0,	0,0,	801,725,	
801,725,	801,725,	0,0,	0,0,	
0,0,	801,725,	0,0,	0,0,	
0,0,	801,725,	801,725,	801,725,	
801,725,	801,725,	801,725,	801,746,	
801,725,	802,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	802,725,	0,0,	801,725,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	801,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
802,725,	0,0,	802,725,	802,725,	
0,0,	802,725,	0,0,	802,725,	
802,725,	802,725,	0,0,	802,725,	
0,0,	802,725,	802,725,	802,725,	
802,725,	802,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	802,725,	802,725,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	802,725,	802,725,	802,725,	
802,725,	802,725,	802,725,	802,746,	
802,725,	802,725,	803,0,	802,725,	
802,725,	802,725,	802,725,	802,725,	
802,725,	802,725,	802,725,	802,725,	
802,725,	0,0,	0,0,	802,725,	
802,725,	802,725,	0,0,	0,0,	
0,0,	802,725,	0,0,	0,0,	
0,0,	802,725,	802,725,	802,725,	
802,725,	802,823,	802,725,	802,746,	
802,725,	0,0,	0,0,	0,0,	
0,0,	803,699,	0,0,	0,0,	
803,699,	803,699,	0,0,	802,725,	
0,0,	0,0,	0,0,	0,0,	
0,0,	803,699,	803,725,	0,0,	
0,0,	802,725,	0,0,	0,0,	
0,0,	803,699,	803,699,	803,699,	
803,699,	803,699,	803,699,	803,726,	
803,699,	803,699,	0,0,	803,699,	
803,699,	803,699,	803,699,	803,699,	
803,699,	803,699,	803,699,	803,699,	
803,699,	815,0,	0,0,	803,699,	
803,699,	803,699,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	803,699,	803,699,	803,699,	
803,699,	803,699,	803,699,	803,726,	
803,699,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	815,714,	803,699,	
0,0,	0,0,	0,0,	0,0,	
815,714,	0,0,	0,0,	815,714,	
815,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
815,714,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
815,714,	815,714,	815,714,	815,714,	
815,714,	815,714,	815,737,	815,714,	
815,714,	0,0,	815,714,	815,714,	
815,714,	815,714,	815,714,	815,714,	
815,714,	815,714,	815,714,	815,714,	
823,725,	0,0,	815,714,	815,714,	
815,714,	0,0,	0,0,	0,0,	
823,725,	0,0,	0,0,	0,0,	
815,714,	815,714,	815,714,	815,714,	
815,714,	815,714,	815,737,	815,714,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	815,714,	823,725,	
0,0,	823,725,	823,725,	0,0,	
823,725,	0,0,	823,725,	823,725,	
823,725,	0,0,	823,725,	0,0,	
823,725,	823,725,	823,725,	823,725,	
823,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
823,725,	823,725,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
823,725,	823,725,	823,725,	823,725,	
823,725,	823,725,	823,746,	823,725,	
823,725,	0,0,	823,725,	823,725,	
823,725,	823,725,	823,725,	823,725,	
823,725,	823,725,	823,725,	823,725,	
0,0,	0,0,	823,725,	823,725,	
823,725,	0,0,	0,0,	0,0,	
823,725,	0,0,	0,0,	0,0,	
823,725,	823,725,	823,725,	823,725,	
823,725,	823,725,	823,746,	823,725,	
843,843,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
843,843,	843,846,	823,725,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
823,725,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	843,843,	
0,0,	843,843,	843,843,	0,0,	
843,843,	0,0,	843,843,	843,843,	
843,843,	0,0,	843,843,	0,0,	
843,843,	843,843,	843,843,	843,843,	
843,843,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
843,843,	843,843,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
843,843,	843,843,	843,843,	843,843,	
843,843,	843,843,	843,843,	843,843,	
843,843,	0,0,	843,843,	843,843,	
843,843,	843,843,	843,843,	843,843,	
843,843,	843,843,	843,843,	843,843,	
0,0,	0,0,	843,843,	843,843,	
843,843,	0,0,	0,0,	0,0,	
843,843,	0,0,	0,0,	0,0,	
843,843,	843,843,	843,843,	843,843,	
843,843,	843,843,	843,843,	843,843,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	843,843,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
843,270,	0,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-80,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+157,	0,		yyvstop+3,
yycrank+-279,	0,		yyvstop+6,
yycrank+29,	0,		yyvstop+8,
yycrank+48,	0,		yyvstop+11,
yycrank+63,	yysvec+4,	yyvstop+13,
yycrank+360,	yysvec+4,	yyvstop+16,
yycrank+434,	yysvec+4,	yyvstop+20,
yycrank+-517,	0,		yyvstop+24,
yycrank+594,	yysvec+4,	yyvstop+27,
yycrank+34,	yysvec+4,	yyvstop+31,
yycrank+58,	yysvec+4,	yyvstop+34,
yycrank+64,	yysvec+4,	yyvstop+37,
yycrank+622,	yysvec+4,	yyvstop+40,
yycrank+79,	yysvec+4,	yyvstop+43,
yycrank+682,	yysvec+4,	yyvstop+46,
yycrank+30,	yysvec+4,	yyvstop+49,
yycrank+404,	yysvec+4,	yyvstop+52,
yycrank+707,	yysvec+4,	yyvstop+55,
yycrank+70,	yysvec+4,	yyvstop+58,
yycrank+219,	yysvec+4,	yyvstop+61,
yycrank+-789,	0,		yyvstop+65,
yycrank+857,	yysvec+4,	yyvstop+67,
yycrank+886,	yysvec+4,	yyvstop+70,
yycrank+946,	yysvec+4,	yyvstop+74,
yycrank+970,	yysvec+4,	yyvstop+77,
yycrank+1042,	yysvec+4,	yyvstop+80,
yycrank+1066,	yysvec+4,	yyvstop+83,
yycrank+1126,	yysvec+4,	yyvstop+86,
yycrank+1157,	yysvec+4,	yyvstop+89,
yycrank+62,	yysvec+4,	yyvstop+92,
yycrank+-1233,	0,		yyvstop+95,
yycrank+31,	0,		yyvstop+97,
yycrank+1311,	0,		yyvstop+99,
yycrank+249,	yysvec+36,	yyvstop+102,
yycrank+1425,	yysvec+36,	yyvstop+105,
yycrank+1499,	yysvec+36,	yyvstop+109,
yycrank+-32,	yysvec+11,	yyvstop+113,
yycrank+1572,	yysvec+36,	yyvstop+116,
yycrank+93,	yysvec+36,	yyvstop+120,
yycrank+84,	yysvec+36,	yyvstop+123,
yycrank+107,	yysvec+36,	yyvstop+126,
yycrank+1600,	yysvec+36,	yyvstop+129,
yycrank+122,	yysvec+36,	yyvstop+132,
yycrank+1660,	yysvec+36,	yyvstop+135,
yycrank+41,	yysvec+36,	yyvstop+138,
yycrank+1091,	yysvec+36,	yyvstop+141,
yycrank+1685,	yysvec+36,	yyvstop+144,
yycrank+104,	yysvec+36,	yyvstop+147,
yycrank+260,	yysvec+36,	yyvstop+150,
yycrank+1745,	yysvec+36,	yyvstop+154,
yycrank+1774,	yysvec+36,	yyvstop+157,
yycrank+1834,	yysvec+36,	yyvstop+161,
yycrank+1858,	yysvec+36,	yyvstop+164,
yycrank+1930,	yysvec+36,	yyvstop+167,
yycrank+1954,	yysvec+36,	yyvstop+170,
yycrank+2014,	yysvec+36,	yyvstop+173,
yycrank+2045,	yysvec+36,	yyvstop+176,
yycrank+78,	yysvec+36,	yyvstop+179,
yycrank+-42,	yysvec+34,	yyvstop+182,
yycrank+0,	yysvec+4,	yyvstop+184,
yycrank+-2121,	0,		0,	
yycrank+-2225,	0,		0,	
yycrank+-252,	yysvec+64,	0,	
yycrank+78,	0,		0,	
yycrank+0,	0,		yyvstop+186,
yycrank+54,	0,		0,	
yycrank+237,	0,		0,	
yycrank+65,	yysvec+4,	yyvstop+188,
yycrank+70,	0,		0,	
yycrank+79,	yysvec+4,	yyvstop+190,
yycrank+0,	yysvec+72,	0,	
yycrank+2301,	0,		0,	
yycrank+240,	yysvec+75,	0,	
yycrank+95,	yysvec+4,	yyvstop+193,
yycrank+142,	0,		0,	
yycrank+2375,	yysvec+4,	yyvstop+195,
yycrank+122,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+198,
yycrank+0,	yysvec+11,	yyvstop+201,
yycrank+0,	0,		yyvstop+203,
yycrank+2278,	0,		0,	
yycrank+287,	yysvec+4,	yyvstop+205,
yycrank+298,	0,		0,	
yycrank+1485,	yysvec+4,	yyvstop+207,
yycrank+330,	0,		0,	
yycrank+395,	0,		0,	
yycrank+128,	yysvec+4,	yyvstop+209,
yycrank+2393,	yysvec+4,	yyvstop+211,
yycrank+97,	yysvec+4,	yyvstop+213,
yycrank+130,	yysvec+4,	yyvstop+215,
yycrank+99,	yysvec+4,	yyvstop+217,
yycrank+139,	yysvec+4,	yyvstop+219,
yycrank+118,	yysvec+4,	yyvstop+221,
yycrank+131,	yysvec+4,	yyvstop+223,
yycrank+101,	yysvec+4,	yyvstop+225,
yycrank+137,	yysvec+4,	yyvstop+227,
yycrank+132,	yysvec+4,	yyvstop+229,
yycrank+170,	yysvec+4,	yyvstop+231,
yycrank+171,	yysvec+4,	yyvstop+233,
yycrank+610,	yysvec+4,	yyvstop+236,
yycrank+169,	yysvec+4,	yyvstop+238,
yycrank+2453,	yysvec+4,	yyvstop+240,
yycrank+188,	yysvec+4,	yyvstop+242,
yycrank+186,	yysvec+4,	yyvstop+244,
yycrank+2167,	yysvec+84,	0,	
yycrank+213,	yysvec+4,	yyvstop+246,
yycrank+185,	yysvec+4,	yyvstop+248,
yycrank+-2513,	yysvec+24,	0,	
yycrank+-254,	yysvec+24,	0,	
yycrank+-2589,	yysvec+24,	0,	
yycrank+-593,	yysvec+24,	0,	
yycrank+0,	0,		yyvstop+250,
yycrank+586,	yysvec+4,	yyvstop+252,
yycrank+2639,	yysvec+4,	yyvstop+254,
yycrank+715,	0,		0,	
yycrank+797,	yysvec+4,	yyvstop+257,
yycrank+870,	yysvec+4,	yyvstop+259,
yycrank+2711,	yysvec+4,	yyvstop+261,
yycrank+866,	yysvec+4,	yyvstop+264,
yycrank+2729,	yysvec+4,	yyvstop+266,
yycrank+910,	0,		0,	
yycrank+938,	yysvec+4,	yyvstop+269,
yycrank+2801,	yysvec+4,	yyvstop+271,
yycrank+2873,	yysvec+4,	yyvstop+274,
yycrank+1026,	yysvec+4,	yyvstop+276,
yycrank+191,	yysvec+4,	yyvstop+278,
yycrank+192,	yysvec+4,	yyvstop+280,
yycrank+-281,	yysvec+34,	0,	
yycrank+-2949,	yysvec+34,	0,	
yycrank+-246,	yysvec+34,	0,	
yycrank+273,	0,		yyvstop+283,
yycrank+-3053,	0,		0,	
yycrank+0,	yysvec+36,	yyvstop+285,
yycrank+-3157,	0,		yyvstop+287,
yycrank+285,	yysvec+36,	yyvstop+289,
yycrank+258,	yysvec+36,	yyvstop+291,
yycrank+-1052,	yysvec+137,	yyvstop+294,
yycrank+260,	yysvec+36,	yyvstop+296,
yycrank+3238,	yysvec+36,	yyvstop+298,
yycrank+-264,	yysvec+137,	yyvstop+301,
yycrank+0,	yysvec+36,	yyvstop+303,
yycrank+-3321,	0,		yyvstop+306,
yycrank+1241,	yysvec+36,	yyvstop+308,
yycrank+2364,	yysvec+36,	yyvstop+310,
yycrank+-1339,	yysvec+137,	yyvstop+312,
yycrank+250,	yysvec+36,	yyvstop+314,
yycrank+3389,	yysvec+36,	yyvstop+316,
yycrank+220,	yysvec+36,	yyvstop+318,
yycrank+252,	yysvec+36,	yyvstop+320,
yycrank+230,	yysvec+36,	yyvstop+322,
yycrank+270,	yysvec+36,	yyvstop+324,
yycrank+242,	yysvec+36,	yyvstop+326,
yycrank+255,	yysvec+36,	yyvstop+328,
yycrank+224,	yysvec+36,	yyvstop+330,
yycrank+258,	yysvec+36,	yyvstop+332,
yycrank+227,	yysvec+36,	yyvstop+334,
yycrank+274,	yysvec+36,	yyvstop+336,
yycrank+286,	yysvec+36,	yyvstop+338,
yycrank+1395,	yysvec+36,	yyvstop+341,
yycrank+288,	yysvec+36,	yyvstop+343,
yycrank+3413,	yysvec+36,	yyvstop+345,
yycrank+308,	yysvec+36,	yyvstop+347,
yycrank+277,	yysvec+36,	yyvstop+349,
yycrank+302,	yysvec+36,	yyvstop+351,
yycrank+288,	yysvec+36,	yyvstop+353,
yycrank+1361,	yysvec+36,	yyvstop+355,
yycrank+3460,	yysvec+36,	yyvstop+357,
yycrank+-1395,	yysvec+137,	yyvstop+360,
yycrank+1413,	yysvec+36,	yyvstop+362,
yycrank+1508,	yysvec+36,	yyvstop+364,
yycrank+3532,	yysvec+36,	yyvstop+366,
yycrank+1540,	yysvec+36,	yyvstop+369,
yycrank+3550,	yysvec+36,	yyvstop+371,
yycrank+-1564,	yysvec+137,	yyvstop+374,
yycrank+1668,	yysvec+36,	yyvstop+376,
yycrank+3622,	yysvec+36,	yyvstop+378,
yycrank+3694,	yysvec+36,	yyvstop+381,
yycrank+1758,	yysvec+36,	yyvstop+383,
yycrank+292,	yysvec+36,	yyvstop+385,
yycrank+308,	yysvec+36,	yyvstop+387,
yycrank+-472,	yysvec+34,	0,	
yycrank+-379,	yysvec+64,	0,	
yycrank+-380,	yysvec+65,	0,	
yycrank+-3770,	yysvec+65,	0,	
yycrank+-3874,	0,		0,	
yycrank+-398,	yysvec+64,	0,	
yycrank+-520,	yysvec+64,	0,	
yycrank+-3978,	0,		0,	
yycrank+-4082,	0,		0,	
yycrank+0,	0,		yyvstop+390,
yycrank+390,	0,		0,	
yycrank+391,	0,		0,	
yycrank+392,	0,		0,	
yycrank+380,	yysvec+4,	yyvstop+392,
yycrank+404,	yysvec+4,	yyvstop+395,
yycrank+405,	0,		yyvstop+398,
yycrank+0,	yysvec+4,	yyvstop+400,
yycrank+0,	0,		yyvstop+403,
yycrank+413,	0,		0,	
yycrank+416,	0,		0,	
yycrank+417,	0,		0,	
yycrank+418,	yysvec+4,	yyvstop+405,
yycrank+420,	0,		yyvstop+408,
yycrank+577,	0,		yyvstop+410,
yycrank+399,	0,		0,	
yycrank+400,	0,		0,	
yycrank+416,	0,		0,	
yycrank+453,	0,		0,	
yycrank+470,	0,		0,	
yycrank+634,	0,		0,	
yycrank+1802,	yysvec+4,	yyvstop+412,
yycrank+1846,	0,		0,	
yycrank+1826,	yysvec+4,	yyvstop+414,
yycrank+1866,	0,		0,	
yycrank+1940,	yysvec+4,	yyvstop+416,
yycrank+1970,	0,		0,	
yycrank+2026,	0,		0,	
yycrank+386,	yysvec+4,	yyvstop+418,
yycrank+3208,	yysvec+4,	yyvstop+420,
yycrank+355,	yysvec+4,	yyvstop+423,
yycrank+398,	yysvec+4,	yyvstop+425,
yycrank+370,	yysvec+4,	yyvstop+427,
yycrank+384,	yysvec+4,	yyvstop+429,
yycrank+356,	yysvec+4,	yyvstop+431,
yycrank+492,	yysvec+4,	yyvstop+433,
yycrank+407,	yysvec+4,	yyvstop+435,
yycrank+376,	yysvec+4,	yyvstop+437,
yycrank+474,	yysvec+4,	yyvstop+439,
yycrank+4129,	yysvec+4,	yyvstop+442,
yycrank+449,	yysvec+4,	yyvstop+444,
yycrank+420,	yysvec+4,	yyvstop+446,
yycrank+452,	yysvec+4,	yyvstop+448,
yycrank+422,	yysvec+4,	yyvstop+450,
yycrank+461,	0,		0,	
yycrank+497,	0,		0,	
yycrank+514,	0,		0,	
yycrank+511,	0,		0,	
yycrank+636,	0,		0,	
yycrank+458,	yysvec+4,	yyvstop+452,
yycrank+427,	yysvec+4,	yyvstop+454,
yycrank+-4205,	yysvec+24,	0,	
yycrank+-4287,	yysvec+24,	0,	
yycrank+-4371,	0,		0,	
yycrank+4416,	yysvec+4,	yyvstop+456,
yycrank+2264,	0,		0,	
yycrank+2417,	yysvec+4,	yyvstop+459,
yycrank+2427,	0,		0,	
yycrank+505,	yysvec+248,	0,	
yycrank+509,	yysvec+4,	yyvstop+461,
yycrank+2483,	yysvec+4,	yyvstop+464,
yycrank+2657,	yysvec+4,	yyvstop+466,
yycrank+4450,	0,		yyvstop+469,
yycrank+4472,	yysvec+4,	yyvstop+471,
yycrank+2799,	0,		0,	
yycrank+513,	yysvec+257,	0,	
yycrank+526,	yysvec+4,	yyvstop+474,
yycrank+4522,	yysvec+4,	yyvstop+477,
yycrank+2631,	yysvec+4,	yyvstop+480,
yycrank+2681,	0,		0,	
yycrank+2747,	yysvec+4,	yyvstop+482,
yycrank+2889,	yysvec+4,	yyvstop+484,
yycrank+2913,	yysvec+255,	yyvstop+487,
yycrank+4540,	yysvec+4,	yyvstop+489,
yycrank+4567,	yysvec+4,	yyvstop+492,
yycrank+3016,	yysvec+4,	yyvstop+496,
yycrank+525,	yysvec+4,	yyvstop+499,
yycrank+0,	0,		yyvstop+502,
yycrank+-651,	yysvec+34,	0,	
yycrank+581,	0,		0,	
yycrank+521,	0,		0,	
yycrank+622,	0,		0,	
yycrank+528,	yysvec+36,	yyvstop+504,
yycrank+546,	yysvec+36,	yyvstop+507,
yycrank+0,	yysvec+36,	yyvstop+510,
yycrank+-549,	yysvec+137,	yyvstop+513,
yycrank+575,	yysvec+36,	yyvstop+516,
yycrank+-581,	yysvec+137,	yyvstop+519,
yycrank+0,	yysvec+135,	yyvstop+522,
yycrank+-600,	yysvec+11,	yyvstop+524,
yycrank+3026,	yysvec+36,	yyvstop+526,
yycrank+3072,	yysvec+36,	yyvstop+528,
yycrank+-3082,	yysvec+137,	yyvstop+530,
yycrank+3224,	yysvec+36,	yyvstop+532,
yycrank+-585,	yysvec+137,	yyvstop+534,
yycrank+570,	yysvec+36,	yyvstop+536,
yycrank+4594,	yysvec+36,	yyvstop+538,
yycrank+541,	yysvec+36,	yyvstop+541,
yycrank+584,	yysvec+36,	yyvstop+543,
yycrank+554,	yysvec+36,	yyvstop+545,
yycrank+568,	yysvec+36,	yyvstop+547,
yycrank+537,	yysvec+36,	yyvstop+549,
yycrank+649,	yysvec+36,	yyvstop+551,
yycrank+588,	yysvec+36,	yyvstop+553,
yycrank+567,	yysvec+36,	yyvstop+555,
yycrank+634,	yysvec+36,	yyvstop+557,
yycrank+4618,	yysvec+36,	yyvstop+560,
yycrank+628,	yysvec+36,	yyvstop+562,
yycrank+599,	yysvec+36,	yyvstop+564,
yycrank+629,	yysvec+36,	yyvstop+566,
yycrank+598,	yysvec+36,	yyvstop+568,
yycrank+627,	yysvec+36,	yyvstop+570,
yycrank+601,	yysvec+36,	yyvstop+572,
yycrank+4662,	yysvec+36,	yyvstop+574,
yycrank+3329,	yysvec+36,	yyvstop+577,
yycrank+-3351,	yysvec+137,	yyvstop+579,
yycrank+677,	yysvec+36,	yyvstop+581,
yycrank+3429,	yysvec+36,	yyvstop+584,
yycrank+3550,	yysvec+36,	yyvstop+586,
yycrank+-4127,	yysvec+137,	yyvstop+589,
yycrank+4664,	yysvec+36,	yyvstop+592,
yycrank+687,	yysvec+36,	yyvstop+595,
yycrank+4730,	yysvec+36,	yyvstop+598,
yycrank+3452,	yysvec+36,	yyvstop+601,
yycrank+-3520,	yysvec+137,	yyvstop+603,
yycrank+3640,	yysvec+36,	yyvstop+605,
yycrank+3710,	yysvec+36,	yyvstop+607,
yycrank+-4748,	yysvec+137,	yyvstop+610,
yycrank+4798,	yysvec+36,	yyvstop+613,
yycrank+4816,	yysvec+36,	yyvstop+616,
yycrank+3734,	yysvec+36,	yyvstop+620,
yycrank+685,	yysvec+36,	yyvstop+623,
yycrank+-743,	yysvec+34,	0,	
yycrank+0,	0,		yyvstop+626,
yycrank+0,	yysvec+188,	yyvstop+628,
yycrank+-703,	yysvec+188,	0,	
yycrank+-4900,	yysvec+65,	0,	
yycrank+0,	0,		yyvstop+630,
yycrank+-792,	yysvec+64,	0,	
yycrank+-734,	yysvec+191,	yyvstop+632,
yycrank+-739,	yysvec+192,	yyvstop+634,
yycrank+0,	yysvec+72,	0,	
yycrank+0,	yysvec+72,	0,	
yycrank+0,	yysvec+72,	0,	
yycrank+702,	yysvec+4,	yyvstop+636,
yycrank+727,	0,		0,	
yycrank+0,	yysvec+80,	0,	
yycrank+0,	yysvec+78,	0,	
yycrank+0,	yysvec+80,	0,	
yycrank+728,	0,		0,	
yycrank+729,	0,		0,	
yycrank+723,	0,		0,	
yycrank+669,	0,		0,	
yycrank+639,	0,		0,	
yycrank+681,	0,		0,	
yycrank+682,	0,		0,	
yycrank+657,	0,		0,	
yycrank+705,	0,		0,	
yycrank+675,	0,		0,	
yycrank+695,	0,		0,	
yycrank+674,	0,		0,	
yycrank+715,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+638,
yycrank+4947,	0,		0,	
yycrank+3662,	0,		0,	
yycrank+0,	yysvec+4,	yyvstop+641,
yycrank+0,	0,		yyvstop+644,
yycrank+0,	0,		yyvstop+646,
yycrank+719,	yysvec+4,	yyvstop+648,
yycrank+3789,	yysvec+4,	yyvstop+650,
yycrank+3799,	0,		0,	
yycrank+3941,	yysvec+4,	yyvstop+652,
yycrank+690,	yysvec+4,	yyvstop+654,
yycrank+726,	yysvec+4,	yyvstop+656,
yycrank+696,	yysvec+4,	yyvstop+658,
yycrank+807,	yysvec+4,	yyvstop+660,
yycrank+764,	0,		0,	
yycrank+770,	yysvec+4,	yyvstop+663,
yycrank+0,	yysvec+4,	yyvstop+665,
yycrank+741,	yysvec+4,	yyvstop+668,
yycrank+751,	yysvec+4,	yyvstop+670,
yycrank+740,	yysvec+4,	yyvstop+672,
yycrank+775,	yysvec+4,	yyvstop+674,
yycrank+744,	yysvec+4,	yyvstop+676,
yycrank+766,	0,		0,	
yycrank+739,	0,		0,	
yycrank+801,	0,		0,	
yycrank+791,	0,		0,	
yycrank+763,	0,		0,	
yycrank+797,	0,		0,	
yycrank+766,	0,		0,	
yycrank+865,	0,		0,	
yycrank+814,	yysvec+4,	yyvstop+678,
yycrank+802,	yysvec+4,	yyvstop+680,
yycrank+-5023,	yysvec+24,	0,	
yycrank+-5104,	yysvec+24,	0,	
yycrank+-5189,	0,		yyvstop+682,
yycrank+864,	0,		yyvstop+684,
yycrank+3951,	0,		0,	
yycrank+0,	0,		yyvstop+686,
yycrank+5234,	yysvec+4,	yyvstop+688,
yycrank+5244,	0,		yyvstop+691,
yycrank+886,	0,		yyvstop+693,
yycrank+4235,	0,		0,	
yycrank+888,	yysvec+396,	0,	
yycrank+888,	yysvec+4,	yyvstop+695,
yycrank+0,	0,		yyvstop+698,
yycrank+4045,	0,		0,	
yycrank+5268,	yysvec+4,	yyvstop+700,
yycrank+0,	yysvec+394,	yyvstop+704,
yycrank+5295,	yysvec+4,	yyvstop+707,
yycrank+4273,	yysvec+4,	yyvstop+711,
yycrank+819,	yysvec+4,	yyvstop+714,
yycrank+-923,	yysvec+34,	0,	
yycrank+0,	yysvec+6,	yyvstop+716,
yycrank+1067,	0,		0,	
yycrank+1102,	0,		0,	
yycrank+835,	0,		0,	
yycrank+823,	0,		0,	
yycrank+-5378,	yysvec+137,	yyvstop+718,
yycrank+898,	yysvec+36,	yyvstop+720,
yycrank+-907,	yysvec+137,	yyvstop+722,
yycrank+-908,	yysvec+137,	yyvstop+724,
yycrank+-852,	yysvec+11,	yyvstop+726,
yycrank+-840,	yysvec+11,	yyvstop+728,
yycrank+0,	yysvec+36,	yyvstop+730,
yycrank+-903,	yysvec+137,	yyvstop+733,
yycrank+0,	yysvec+36,	yyvstop+735,
yycrank+0,	yysvec+137,	yyvstop+738,
yycrank+878,	yysvec+36,	yyvstop+741,
yycrank+4007,	yysvec+36,	yyvstop+743,
yycrank+-4295,	yysvec+137,	yyvstop+745,
yycrank+4490,	yysvec+36,	yyvstop+747,
yycrank+866,	yysvec+36,	yyvstop+749,
yycrank+901,	yysvec+36,	yyvstop+751,
yycrank+871,	yysvec+36,	yyvstop+753,
yycrank+949,	yysvec+36,	yyvstop+755,
yycrank+957,	yysvec+36,	yyvstop+758,
yycrank+0,	yysvec+36,	yyvstop+760,
yycrank+900,	yysvec+36,	yyvstop+763,
yycrank+911,	yysvec+36,	yyvstop+765,
yycrank+889,	yysvec+36,	yyvstop+767,
yycrank+924,	yysvec+36,	yyvstop+769,
yycrank+902,	yysvec+36,	yyvstop+771,
yycrank+936,	yysvec+36,	yyvstop+773,
yycrank+915,	yysvec+36,	yyvstop+775,
yycrank+-968,	yysvec+137,	yyvstop+777,
yycrank+5423,	yysvec+36,	yyvstop+779,
yycrank+-1166,	yysvec+137,	yyvstop+782,
yycrank+-4138,	yysvec+137,	yyvstop+784,
yycrank+-4945,	yysvec+137,	yyvstop+787,
yycrank+-991,	yysvec+137,	yyvstop+789,
yycrank+992,	yysvec+36,	yyvstop+792,
yycrank+-1002,	yysvec+137,	yyvstop+795,
yycrank+5433,	yysvec+36,	yyvstop+797,
yycrank+-4956,	yysvec+137,	yyvstop+801,
yycrank+5457,	yysvec+36,	yyvstop+805,
yycrank+4700,	yysvec+36,	yyvstop+809,
yycrank+942,	yysvec+36,	yyvstop+812,
yycrank+-1238,	yysvec+34,	0,	
yycrank+-1013,	yysvec+64,	0,	
yycrank+-5540,	0,		0,	
yycrank+-5644,	0,		0,	
yycrank+-5748,	0,		0,	
yycrank+-5852,	0,		0,	
yycrank+-5956,	0,		0,	
yycrank+-6060,	0,		0,	
yycrank+1006,	0,		0,	
yycrank+1081,	0,		0,	
yycrank+986,	0,		0,	
yycrank+955,	0,		0,	
yycrank+1103,	0,		0,	
yycrank+991,	0,		0,	
yycrank+961,	0,		0,	
yycrank+994,	0,		0,	
yycrank+963,	0,		0,	
yycrank+992,	0,		0,	
yycrank+978,	0,		0,	
yycrank+1116,	0,		yyvstop+814,
yycrank+4766,	0,		0,	
yycrank+0,	0,		yyvstop+816,
yycrank+1053,	yysvec+4,	yyvstop+818,
yycrank+6105,	yysvec+4,	yyvstop+821,
yycrank+1049,	yysvec+4,	yyvstop+824,
yycrank+2022,	0,		0,	
yycrank+1054,	yysvec+4,	yyvstop+826,
yycrank+1057,	0,		0,	
yycrank+1019,	yysvec+4,	yyvstop+829,
yycrank+988,	yysvec+4,	yyvstop+831,
yycrank+1031,	yysvec+4,	yyvstop+833,
yycrank+1000,	yysvec+4,	yyvstop+835,
yycrank+1046,	yysvec+4,	yyvstop+837,
yycrank+1022,	yysvec+4,	yyvstop+839,
yycrank+1062,	0,		0,	
yycrank+1031,	0,		0,	
yycrank+1136,	0,		0,	
yycrank+1066,	0,		0,	
yycrank+1035,	0,		0,	
yycrank+1064,	0,		0,	
yycrank+1045,	0,		0,	
yycrank+1120,	0,		yyvstop+841,
yycrank+1119,	yysvec+4,	yyvstop+843,
yycrank+-6188,	0,		0,	
yycrank+0,	0,		yyvstop+846,
yycrank+0,	yysvec+389,	0,	
yycrank+1230,	0,		0,	
yycrank+6233,	0,		yyvstop+849,
yycrank+5053,	0,		0,	
yycrank+1113,	yysvec+500,	0,	
yycrank+1115,	yysvec+4,	yyvstop+851,
yycrank+1116,	0,		yyvstop+854,
yycrank+0,	0,		yyvstop+856,
yycrank+0,	yysvec+499,	yyvstop+858,
yycrank+-1485,	yysvec+34,	0,	
yycrank+0,	yysvec+72,	0,	
yycrank+1138,	0,		0,	
yycrank+0,	yysvec+80,	0,	
yycrank+1050,	0,		0,	
yycrank+1058,	0,		0,	
yycrank+-6316,	yysvec+137,	yyvstop+861,
yycrank+-6420,	yysvec+137,	yyvstop+863,
yycrank+-6524,	yysvec+137,	yyvstop+865,
yycrank+-6628,	yysvec+137,	yyvstop+867,
yycrank+-6732,	yysvec+137,	yyvstop+869,
yycrank+-1065,	yysvec+11,	yyvstop+871,
yycrank+-1082,	yysvec+11,	yyvstop+873,
yycrank+0,	yysvec+137,	yyvstop+875,
yycrank+1166,	yysvec+36,	yyvstop+878,
yycrank+-1151,	yysvec+137,	yyvstop+881,
yycrank+6777,	yysvec+36,	yyvstop+883,
yycrank+1124,	yysvec+36,	yyvstop+886,
yycrank+1184,	yysvec+36,	yyvstop+888,
yycrank+1148,	yysvec+36,	yyvstop+891,
yycrank+1120,	yysvec+36,	yyvstop+893,
yycrank+1144,	yysvec+36,	yyvstop+895,
yycrank+1127,	yysvec+36,	yyvstop+897,
yycrank+1161,	yysvec+36,	yyvstop+899,
yycrank+1140,	yysvec+36,	yyvstop+901,
yycrank+1218,	yysvec+36,	yyvstop+903,
yycrank+-5322,	yysvec+137,	yyvstop+906,
yycrank+1212,	yysvec+36,	yyvstop+909,
yycrank+-2554,	yysvec+137,	yyvstop+912,
yycrank+-5447,	yysvec+137,	yyvstop+914,
yycrank+-1222,	yysvec+137,	yyvstop+916,
yycrank+0,	yysvec+137,	yyvstop+919,
yycrank+-6260,	yysvec+137,	yyvstop+922,
yycrank+-1240,	yysvec+34,	0,	
yycrank+0,	0,		yyvstop+926,
yycrank+-1256,	yysvec+454,	yyvstop+929,
yycrank+-1259,	yysvec+455,	yyvstop+931,
yycrank+-1261,	yysvec+456,	yyvstop+933,
yycrank+-1265,	yysvec+457,	yyvstop+935,
yycrank+-1274,	yysvec+458,	yyvstop+937,
yycrank+-1282,	yysvec+459,	yyvstop+939,
yycrank+1246,	0,		0,	
yycrank+1244,	0,		0,	
yycrank+1227,	0,		0,	
yycrank+1206,	0,		0,	
yycrank+1236,	0,		0,	
yycrank+1286,	0,		yyvstop+941,
yycrank+1241,	0,		0,	
yycrank+1210,	0,		0,	
yycrank+1245,	0,		0,	
yycrank+1214,	0,		0,	
yycrank+1258,	0,		0,	
yycrank+1243,	0,		0,	
yycrank+1461,	0,		0,	
yycrank+1315,	0,		yyvstop+943,
yycrank+6787,	0,		yyvstop+945,
yycrank+1302,	yysvec+84,	0,	
yycrank+6785,	0,		0,	
yycrank+1309,	yysvec+563,	0,	
yycrank+1311,	yysvec+4,	yyvstop+947,
yycrank+1306,	yysvec+4,	yyvstop+950,
yycrank+-6870,	0,		0,	
yycrank+1301,	0,		0,	
yycrank+1284,	0,		0,	
yycrank+1305,	0,		0,	
yycrank+1284,	0,		0,	
yycrank+1253,	0,		0,	
yycrank+1272,	yysvec+4,	yyvstop+952,
yycrank+1242,	yysvec+4,	yyvstop+954,
yycrank+2022,	yysvec+4,	yyvstop+956,
yycrank+1310,	yysvec+4,	yyvstop+959,
yycrank+1310,	yysvec+4,	yyvstop+961,
yycrank+1383,	0,		0,	
yycrank+1352,	0,		0,	
yycrank+1371,	0,		0,	
yycrank+1423,	0,		yyvstop+963,
yycrank+1373,	0,		0,	
yycrank+1351,	0,		0,	
yycrank+1396,	0,		0,	
yycrank+1365,	0,		0,	
yycrank+1496,	0,		0,	
yycrank+1437,	0,		yyvstop+965,
yycrank+6907,	0,		0,	
yycrank+0,	0,		yyvstop+967,
yycrank+0,	0,		yyvstop+970,
yycrank+1443,	0,		yyvstop+972,
yycrank+0,	0,		yyvstop+974,
yycrank+0,	yysvec+134,	yyvstop+976,
yycrank+1384,	0,		0,	
yycrank+1382,	0,		0,	
yycrank+-6990,	yysvec+137,	yyvstop+979,
yycrank+-7094,	yysvec+137,	yyvstop+982,
yycrank+-7198,	yysvec+137,	yyvstop+985,
yycrank+-7302,	yysvec+137,	yyvstop+988,
yycrank+-1387,	yysvec+11,	yyvstop+991,
yycrank+-1384,	yysvec+11,	yyvstop+993,
yycrank+-6915,	yysvec+137,	yyvstop+995,
yycrank+1449,	yysvec+36,	yyvstop+998,
yycrank+1479,	yysvec+36,	yyvstop+1001,
yycrank+1419,	yysvec+36,	yyvstop+1003,
yycrank+1389,	yysvec+36,	yyvstop+1005,
yycrank+2024,	yysvec+36,	yyvstop+1007,
yycrank+1453,	yysvec+36,	yyvstop+1010,
yycrank+1422,	yysvec+36,	yyvstop+1012,
yycrank+-2809,	yysvec+137,	yyvstop+1014,
yycrank+-7347,	yysvec+137,	yyvstop+1016,
yycrank+-1479,	yysvec+137,	yyvstop+1018,
yycrank+0,	yysvec+137,	yyvstop+1021,
yycrank+-1521,	yysvec+34,	0,	
yycrank+1489,	0,		0,	
yycrank+1509,	0,		yyvstop+1024,
yycrank+1473,	0,		0,	
yycrank+1462,	0,		0,	
yycrank+1535,	0,		0,	
yycrank+0,	0,		yyvstop+1026,
yycrank+1485,	0,		0,	
yycrank+1456,	0,		0,	
yycrank+1512,	0,		0,	
yycrank+1481,	0,		0,	
yycrank+-7409,	0,		0,	
yycrank+1579,	0,		0,	
yycrank+1551,	0,		yyvstop+1028,
yycrank+1586,	0,		0,	
yycrank+0,	0,		yyvstop+1030,
yycrank+-1583,	yysvec+567,	yyvstop+1032,
yycrank+1512,	0,		0,	
yycrank+1481,	0,		0,	
yycrank+1576,	0,		0,	
yycrank+1535,	0,		0,	
yycrank+1504,	0,		0,	
yycrank+1535,	0,		0,	
yycrank+1505,	0,		0,	
yycrank+1546,	yysvec+4,	yyvstop+1034,
yycrank+1516,	yysvec+4,	yyvstop+1036,
yycrank+1617,	yysvec+4,	yyvstop+1038,
yycrank+0,	yysvec+4,	yyvstop+1040,
yycrank+1548,	yysvec+4,	yyvstop+1043,
yycrank+1517,	yysvec+4,	yyvstop+1045,
yycrank+1561,	0,		0,	
yycrank+1530,	0,		0,	
yycrank+1608,	0,		0,	
yycrank+0,	0,		yyvstop+1047,
yycrank+1599,	0,		0,	
yycrank+1568,	0,		0,	
yycrank+-7513,	0,		0,	
yycrank+1612,	0,		0,	
yycrank+1647,	0,		0,	
yycrank+1565,	0,		0,	
yycrank+-1650,	yysvec+11,	yyvstop+1049,
yycrank+-1567,	yysvec+11,	yyvstop+1051,
yycrank+-3251,	yysvec+137,	yyvstop+1053,
yycrank+-7558,	yysvec+137,	yyvstop+1055,
yycrank+-1643,	yysvec+137,	yyvstop+1057,
yycrank+1603,	yysvec+36,	yyvstop+1060,
yycrank+1578,	yysvec+36,	yyvstop+1062,
yycrank+1626,	yysvec+36,	yyvstop+1064,
yycrank+0,	yysvec+36,	yyvstop+1066,
yycrank+1611,	yysvec+36,	yyvstop+1069,
yycrank+1580,	yysvec+36,	yyvstop+1071,
yycrank+0,	yysvec+137,	yyvstop+1073,
yycrank+-1894,	yysvec+34,	0,	
yycrank+0,	yysvec+548,	0,	
yycrank+1668,	0,		0,	
yycrank+1622,	0,		0,	
yycrank+1605,	0,		0,	
yycrank+1645,	0,		0,	
yycrank+1693,	0,		0,	
yycrank+2058,	0,		yyvstop+1076,
yycrank+-1717,	yysvec+625,	yyvstop+1078,
yycrank+1696,	0,		0,	
yycrank+1646,	0,		0,	
yycrank+1616,	0,		0,	
yycrank+1664,	0,		0,	
yycrank+1641,	0,		0,	
yycrank+2024,	0,		0,	
yycrank+1675,	0,		0,	
yycrank+1644,	0,		0,	
yycrank+1663,	0,		0,	
yycrank+1632,	0,		0,	
yycrank+-7620,	0,		yyvstop+1080,
yycrank+1681,	yysvec+4,	yyvstop+1082,
yycrank+1650,	yysvec+4,	yyvstop+1084,
yycrank+1668,	0,		0,	
yycrank+1637,	0,		0,	
yycrank+1724,	0,		0,	
yycrank+2112,	0,		yyvstop+1086,
yycrank+-1746,	yysvec+650,	yyvstop+1088,
yycrank+1742,	0,		0,	
yycrank+1673,	0,		0,	
yycrank+1671,	0,		0,	
yycrank+-1675,	yysvec+11,	yyvstop+1090,
yycrank+-1673,	yysvec+11,	yyvstop+1092,
yycrank+0,	yysvec+137,	yyvstop+1094,
yycrank+-7684,	yysvec+685,	yyvstop+1097,
yycrank+1710,	yysvec+36,	yyvstop+1099,
yycrank+1680,	yysvec+36,	yyvstop+1101,
yycrank+-1896,	yysvec+34,	0,	
yycrank+1760,	0,		0,	
yycrank+1736,	0,		0,	
yycrank+1763,	0,		0,	
yycrank+0,	0,		yyvstop+1103,
yycrank+1751,	0,		0,	
yycrank+1726,	0,		0,	
yycrank+1716,	0,		0,	
yycrank+1747,	0,		0,	
yycrank+1716,	0,		0,	
yycrank+1734,	0,		0,	
yycrank+1704,	0,		0,	
yycrank+-7759,	yysvec+685,	0,	
yycrank+-1850,	yysvec+685,	yyvstop+1105,
yycrank+0,	yysvec+4,	yyvstop+1107,
yycrank+1790,	0,		0,	
yycrank+1769,	0,		0,	
yycrank+0,	0,		yyvstop+1110,
yycrank+1777,	0,		0,	
yycrank+1734,	0,		0,	
yycrank+1729,	0,		0,	
yycrank+-1736,	yysvec+11,	yyvstop+1112,
yycrank+-1753,	yysvec+11,	yyvstop+1114,
yycrank+-7843,	yysvec+137,	yyvstop+1116,
yycrank+-7907,	yysvec+685,	yyvstop+1118,
yycrank+0,	yysvec+36,	yyvstop+1120,
yycrank+-1990,	yysvec+34,	0,	
yycrank+1833,	0,		0,	
yycrank+1836,	0,		0,	
yycrank+1847,	0,		0,	
yycrank+1787,	0,		0,	
yycrank+1757,	0,		0,	
yycrank+2106,	0,		yyvstop+1123,
yycrank+1797,	0,		0,	
yycrank+1775,	0,		0,	
yycrank+-7982,	yysvec+685,	0,	
yycrank+-1964,	yysvec+685,	yyvstop+1125,
yycrank+-1977,	yysvec+685,	yyvstop+1127,
yycrank+1927,	0,		0,	
yycrank+1940,	0,		0,	
yycrank+1773,	0,		0,	
yycrank+1781,	0,		0,	
yycrank+-1796,	yysvec+11,	yyvstop+1129,
yycrank+-1795,	yysvec+11,	yyvstop+1131,
yycrank+-8066,	yysvec+137,	yyvstop+1133,
yycrank+-8130,	yysvec+685,	yyvstop+1135,
yycrank+-8205,	yysvec+685,	yyvstop+1137,
yycrank+-2127,	yysvec+34,	0,	
yycrank+1941,	0,		0,	
yycrank+1854,	0,		0,	
yycrank+1824,	0,		0,	
yycrank+1871,	0,		0,	
yycrank+1862,	0,		0,	
yycrank+1895,	0,		0,	
yycrank+1866,	0,		0,	
yycrank+0,	0,		yyvstop+1139,
yycrank+1908,	0,		0,	
yycrank+1896,	0,		0,	
yycrank+1914,	0,		0,	
yycrank+1884,	0,		0,	
yycrank+-8280,	yysvec+685,	0,	
yycrank+-8355,	yysvec+685,	0,	
yycrank+-1991,	yysvec+685,	yyvstop+1141,
yycrank+-2007,	yysvec+685,	yyvstop+1143,
yycrank+1943,	0,		0,	
yycrank+1925,	0,		0,	
yycrank+1906,	0,		0,	
yycrank+1935,	0,		0,	
yycrank+2005,	0,		0,	
yycrank+-1939,	yysvec+11,	yyvstop+1145,
yycrank+-2012,	yysvec+11,	yyvstop+1147,
yycrank+-8439,	0,		yyvstop+1149,
yycrank+-2073,	yysvec+773,	yyvstop+1151,
yycrank+-8514,	yysvec+685,	yyvstop+1153,
yycrank+-8578,	yysvec+685,	yyvstop+1155,
yycrank+-2183,	yysvec+34,	0,	
yycrank+1972,	0,		0,	
yycrank+1952,	0,		0,	
yycrank+1984,	0,		0,	
yycrank+1964,	0,		0,	
yycrank+2015,	0,		0,	
yycrank+1984,	0,		0,	
yycrank+2031,	0,		0,	
yycrank+2000,	0,		0,	
yycrank+2048,	0,		0,	
yycrank+2018,	0,		0,	
yycrank+2056,	0,		0,	
yycrank+2027,	0,		0,	
yycrank+-8653,	yysvec+685,	0,	
yycrank+-8728,	yysvec+685,	0,	
yycrank+-2125,	yysvec+685,	yyvstop+1157,
yycrank+2063,	0,		0,	
yycrank+2042,	0,		0,	
yycrank+2083,	0,		0,	
yycrank+2053,	0,		0,	
yycrank+-8812,	0,		yyvstop+1160,
yycrank+2055,	0,		0,	
yycrank+-8916,	0,		yyvstop+1162,
yycrank+-2061,	yysvec+11,	yyvstop+1165,
yycrank+-9020,	yysvec+137,	yyvstop+1167,
yycrank+-9124,	yysvec+137,	yyvstop+1169,
yycrank+-9188,	yysvec+685,	yyvstop+1171,
yycrank+-2193,	yysvec+34,	0,	
yycrank+2102,	0,		0,	
yycrank+2076,	0,		0,	
yycrank+2102,	0,		yyvstop+1174,
yycrank+2153,	0,		yyvstop+1176,
yycrank+2138,	0,		0,	
yycrank+2110,	0,		0,	
yycrank+2132,	0,		0,	
yycrank+2101,	0,		0,	
yycrank+2150,	0,		0,	
yycrank+2119,	0,		0,	
yycrank+-9263,	yysvec+685,	yyvstop+1178,
yycrank+2164,	0,		0,	
yycrank+2138,	0,		0,	
yycrank+2213,	0,		yyvstop+1180,
yycrank+0,	0,		yyvstop+1182,
yycrank+2142,	0,		0,	
yycrank+0,	0,		yyvstop+1184,
yycrank+-2143,	yysvec+11,	yyvstop+1187,
yycrank+-9347,	yysvec+137,	yyvstop+1189,
yycrank+-2286,	yysvec+34,	0,	
yycrank+0,	0,		yyvstop+1192,
yycrank+0,	0,		yyvstop+1194,
yycrank+2211,	0,		0,	
yycrank+2185,	0,		0,	
yycrank+2154,	0,		0,	
yycrank+2177,	0,		0,	
yycrank+2146,	0,		0,	
yycrank+0,	0,		yyvstop+1196,
yycrank+2218,	0,		0,	
yycrank+2153,	0,		0,	
yycrank+-2155,	yysvec+11,	yyvstop+1198,
yycrank+-2304,	yysvec+34,	0,	
yycrank+2183,	0,		0,	
yycrank+2161,	0,		0,	
yycrank+0,	yysvec+769,	0,	
yycrank+-2177,	yysvec+11,	yyvstop+1200,
yycrank+-2593,	yysvec+34,	0,	
yycrank+2580,	0,		0,	
yycrank+-9451,	0,		0,	
yycrank+2216,	0,		0,	
yycrank+0,	0,		yyvstop+1202,
yycrank+-2234,	yysvec+843,	0,	
yycrank+-2235,	yysvec+843,	0,	
yycrank+-2240,	yysvec+843,	0,	
yycrank+-2242,	yysvec+843,	0,	
yycrank+-2243,	yysvec+843,	0,	
yycrank+-2244,	yysvec+843,	0,	
yycrank+-2254,	yysvec+843,	0,	
yycrank+-2270,	yysvec+843,	0,	
yycrank+-2272,	yysvec+843,	0,	
yycrank+-2274,	yysvec+843,	0,	
yycrank+-2275,	yysvec+843,	0,	
yycrank+-2276,	yysvec+843,	0,	
yycrank+-2287,	yysvec+843,	0,	
yycrank+-2291,	yysvec+843,	0,	
yycrank+-2212,	yysvec+843,	0,	
yycrank+2328,	0,		yyvstop+1204,
yycrank+0,	0,		yyvstop+1207,
0,	0,	0};
struct yywork *yytop = yycrank+9576;
struct yysvf *yybgin = yysvec+1;
unsigned char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
' ' ,01  ,'"' ,'#' ,01  ,'%' ,01  ,047 ,
'(' ,')' ,01  ,'+' ,01  ,'-' ,'.' ,'/' ,
'0' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,'1' ,
'1' ,'9' ,':' ,'%' ,01  ,'+' ,01  ,01  ,
01  ,'A' ,'B' ,'C' ,'D' ,'E' ,'F' ,'G' ,
'H' ,'I' ,'H' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'S' ,'T' ,'H' ,'H' ,'W' ,
'X' ,'Y' ,'H' ,01  ,01  ,']' ,01  ,'+' ,
01  ,'a' ,'b' ,'c' ,'d' ,'e' ,'f' ,'g' ,
'h' ,'I' ,'H' ,'K' ,'L' ,'M' ,'N' ,'O' ,
'P' ,'Q' ,'R' ,'s' ,'T' ,'H' ,'H' ,'W' ,
'X' ,'Y' ,'H' ,01  ,01  ,'}' ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
0};
unsigned char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,1,0,
0,1,0,0,1,0,1,0,
0,0,0,0,0,0,0,0,
0};
/*
 * (c) Copyright 1990, OPEN SOFTWARE FOUNDATION, INC.
 * ALL RIGHTS RESERVED
 */
/*
 * OSF/1 Release 1.0
*/
/*
#
# IBM CONFIDENTIAL
# Copyright International Business Machines Corp. 1989
# Unpublished Work
# All Rights Reserved
# Licensed Material - Property of IBM
#
#
# US Government Users Restricted Rights - Use, duplication or
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
# 
*/
/* @(#)ncform	1.3  com/lib/l,3.1,8951 9/7/89 18:48:47 */
int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
unsigned char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
unsigned char yysbuf[YYLMAX];
unsigned char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	unsigned char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
            if (yylastch >= yytext + YYLMAX) {
                fprintf(yyout, "Maximum token length exceeded\n");
                yytext[YYLMAX] = 0;
                return 0;
            }
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( yyt > yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if(yyt < yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
                if (yyleng >= YYLMAX) {
                    fprintf(yyout, "Maximum token length exceeded\n");
                    yytext[YYLMAX] = 0;
                    return 0;
                }
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
