#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/tables/patch.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.7
 | File mod date:    1997.11.29 23:10:33
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  tables
 |
 | Purpose:          table patchup (relevant to 0.5 --> 0.6 migration)
 `------------------------------------------------------------------------|#

;;
;;  we need to reconstruct our symbol table, because the link
;;  process drops the symbol table (though the linker could, with
;;  a little extra weak-pointer-like effort, construct the true
;;  symbol table)

(define (patch-symbols)
  (let*(((v <vector>) (all-instances <symbol>))
	(tbl (rscheme-global-ref 2)))
    (let loop (((i <fixnum>) (vector-length v)))
      (if (eq? i 0)
	  (values)
	  (let* (((sym <symbol> :trust-me) (vector-ref v (sub1 i)))
		 ((str <string>) (symbol->string sym)))
	    (table-install! tbl (string->hash str) str sym)
	    (loop (sub1 i)))))))
