#|------------------------------------------------------------*-Scheme-*--|
 | File:    modules/tables/gentable.scm
 |
 |          Copyright (C)1997 Donovan Kolbly <d.kolbly@rscheme.org>
 |          as part of the RScheme project, licensed for free use.
 |          See <http://www.rscheme.org/> for the latest information.
 |
 | File version:     1.6
 | File mod date:    1997.11.29 23:10:34
 | System build:     v0.7.2, 97.12.21
 | Owned by module:  tables
 |
 | Purpose:          generic hash tables -- any hash & key functions
 `------------------------------------------------------------------------|#

(define-class <generic-table> (<hash-table>)
  (table-hash-function type: <function>)
  (table-equal-function type: <function>))

(define-method table-key-present? ((self <generic-table>) key)
  (generic-hash-table-probe? self ((table-hash-function self) key) key))

(define-method table-lookup ((self <generic-table>) key)
  (generic-hash-table-lookup self ((table-hash-function self) key) key))

(define-method table-remove! ((self <generic-table>) key)
  (generic-hash-table-remove! self ((table-hash-function self) key) key))

(define-method table-insert! ((self <generic-table>) key value)
  (generic-hash-table-insert! self 
			      ((table-hash-function self) key) 
			      key 
			      value))
