/* -*-Mode: C;-*-
 * PRCS - The Project Revision Control System
 * Copyright (C) 1996, 1997  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file was automatically generated by Emacs and the source
 * file /vol/hyper/hyper10/jmacd/prcs/doc/prcs.texi at Fri Oct 10 12:22:03 1997: DO NOT EDIT.
 */
#include "prcs.h"
#include "syscmd.h"
#include "docs.h"

const int prcs_version_number[3] = { 1,
				     2,
				     1 };

SystemCommand rcs_command("/usr/sww/bin/GNU/rcs", "RCS_PATH");
SystemCommand ci_command("/usr/sww/bin/GNU/ci", "RCS_PATH");
SystemCommand co_command("/usr/sww/bin/GNU/co", "RCS_PATH");
SystemCommand rlog_command("/usr/sww/bin/GNU/rlog", "RCS_PATH");
SystemCommand tar_command("/usr/sww/bin/GNU/tar", "RCS_PATH");
SystemCommand gdiff3_command("/usr/sww/bin/GNU/diff3", "RCS_PATH");
SystemCommand gdiff_command("/usr/sww/bin/GNU/diff", "RCS_PATH");
SystemCommand ls_command("/usr/sww/bin/GNU/ls", "RCS_PATH");
SystemCommand gzip_command("/usr/sww/bin/gzip", "RCS_PATH");


const int env_names_count = 10;

const EnvName env_names[] = {
  { "TMPDIR", NULL },
  { "RCS_PATH", NULL },
  { "PRCS_REPOSITORY", "/users/jmacd/PRCS" },
  { "PRCS_PLAIN_FORMAT", NULL },
  { "PRCS_MERGE_COMMAND", NULL },
  { "PRCS_LOGQUERY", NULL },
  { "PRCS_JOB_NUMBER", NULL },
  { "PRCS_DIFF_OPTIONS", NULL },
  { "PRCS_DIFF_COMMAND", NULL },
  { "PRCS_CONFLICT_EDITOR", NULL }
};

const char options_summary[] = 
" - Option: --all\n"
"     Used in `prcs execute' to indicate that the specified command is\n"
"     to be executed just once, with all files as arguments.\n"
"\n"
" - Option: -d\n"
" - Long Form: --delete\n"
"     Tells PRCS to perform some optional deletion action.  Used by\n"
"     `prcs populate' to indicate that files that are not present in a\n"
"     working directory are to be removed from the Files list.\n"
"\n"
" - Standard Option: -f\n"
" - Long Form: --force\n"
"     Force: resolve what would normally be interactive queries in\n"
"     some fixed way, depending on the subcommand, assuring that PRCS\n"
"     will never use the standard input.\n"
"\n"
" - Standard Option: -h\n"
" - Standard Option: -H\n"
" - Long Form: --help\n"
"     Prints out help very similar to the contents of this section.\n"
"\n"
" - Option: -i\n"
" - Long Form: --immediate\n"
"     Causes certain actions to occur immediately during execution of\n"
"     a command.  For `prcs uncompress', causes the files in a project\n"
"     to be uncompressed on the spot, rather than incrementally as\n"
"     they are needed.\n"
"\n"
" - Standard Option: -j NUMBER\n"
" - Long Form: --jobs=NUMBER\n"
"     Allows PRCS to spawn up to NUMBER child processes at once.\n"
"     Almost always, 2 or 3 will result in faster operations and higher\n"
"     machine load.  Experimentation will yield the best results.\n"
"\n"
" - Option: -k\n"
" - Long Form: --keywords\n"
"     Causes `prcs diff' to compare keywords, instead of stripping them\n"
"     before comparison.\n"
"\n"
" - Standard Option: -l\n"
" - Long Form: --long-format\n"
" - Standard Option: -L\n"
" - Long Form: --long-long-format\n"
"     Various long formats, depending on the subcommand.\n"
"\n"
" - Option: --match PATTERN\n"
"     Used in `prcs execute' to indicate that the names of the files\n"
"     to be processed, or the options attached to them, must match\n"
"     PATTERN.\n"
"\n"
" - Standard Option: -n\n"
" - Long Form: --no-action\n"
"     Indicates that the command is to report what would happen in the\n"
"     absence of `-n', without changing working files or the\n"
"     repository.\n"
"\n"
" - Option: -N\n"
" - Long Form: --new\n"
"     In `prcs diff', produces comparisons against empty (\"new\") files\n"
"     where a file is missing in one of the versions being compared.\n"
"     If you intend to use the -N option and later apply the diffs you\n"
"     should make sure to always use on of the context diff formats.\n"
"     See the PRCS_DIFF_OPTIONS environment variable *Note Environment\n"
"     Variables::.\n"
"\n"
" - Option: --not PATTERN\n"
"     Used in `prcs execute' to indicate that the names of files to be\n"
"     processed, or the options attached to them, must not match\n"
"     PATTERN.\n"
"\n"
" - Standard Option: -q\n"
" - Long Form: --quiet\n"
"     Suppress normal informational messages.\n"
"\n"
" - Option: -p\n"
" - Long Form: --preserve\n"
"     Preserve permissions on files that are checked out, ignoring any\n"
"     standard protections the user may have set for newly-created\n"
"     files (as by the file mode creation mask in UNIX).\n"
"\n"
" - Standard Option: --plain-format\n"
"     Turns off PRCS's default formatting of its output, which is to\n"
"     break lines at the screen width and surround filenames with\n"
"     single quotes.  Setting the PRCS_PLAIN_FORMAT environment\n"
"     variable has the same effect (*note Environment Variables::.).\n"
"\n"
" - Option: --pre\n"
"     Used in `prcs execute' to indicate that directories are to be\n"
"     listed in pre-order: directory names first, then their\n"
"     non-directory contents, then subdirectories.\n"
"\n"
" - Option: -r VERSION\n"
" - Long Form: --revision=VERSION\n"
"     Identifies a version of a project.  The VERSION is a version\n"
"     specifier. *Note Version Names and Specifiers::.  The space\n"
"     between `-r' and VERSION is optional.\n"
"\n"
" - Standard Option: -R DIRECTORY\n"
" - Long Form: --repository=DIRECTORY\n"
"     Use DIRECTORY as the repository, ignoring the value of the\n"
"     `PRCS_REPOSITORY' environment variable.\n"
"\n"
" - Standard Option: -s\n"
" - Long Form: --skilled-merge\n"
"     Turn off most of the safety features of `prcs merge', allowing a\n"
"     skilled user finer control over the process.  *Note merge::.\n"
"\n"
" - Option: --sort=TYPE\n"
"     Set the type of sorting for the info command to perform on its\n"
"     output.  The two valid values for TYPE are `version' and `date'.\n"
"     The default is VERSION.\n"
"\n"
" - Option: -u\n"
" - Long Form: --unlink\n"
"     When PRCS writes a working file, it generally does so by\n"
"     replacing any existing file of that name.  With this option,\n"
"     however, if the file to be written is a symbolic link, that link\n"
"     is removed and a new file is created.  Thus, the file that was\n"
"     originally linked to is unchanged.\n"
"\n"
" - Standard Option: -v\n"
" - Long Form: --version\n"
"     Prints the version of PRCS and exits.\n"
"\n"
" - Option: -z\n"
" - Long Form: --compress\n"
"     Indicates that a command should perform (de)compression.\n"

;

const char checkout_help_string[] = 
" - Command: prcs checkout [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-r', `-p', `-u'\n"
"\n"
"     Create a working copy of a version of the specified files and\n"
"     directories in PROJECT rooted in the current directory (creating\n"
"     any subdirectories that don't exist).  You may use the option\n"
"     `-r' to select a version.  The default major and minor version\n"
"     specifiers are both `@'.\n"
"\n"
"     You will be warned when a check-out would change the contents of\n"
"     an existing working file, and interactively given the choice of\n"
"     replacing the file with the version being checked out, or\n"
"     leaving the existing file alone.  Existing working files that do\n"
"     not differ from corresponding project files are not modified\n"
"     (their changed and modified dates do not change).  The `-f'\n"
"     option will cause checkout to overwrite all files that differ\n"
"     without asking.\n"
"\n"
"     When PRCS overwrites a working file that is a symbolic link,\n"
"     then (unless the `:symlink' option is specified for that file),\n"
"     it will overwrite the file that the link references, without\n"
"     changing the link itself.  With the `-u' option, PRCS will\n"
"     instead remove the link and create a new file.\n"
"\n"
"     If a working project-version descriptor for PROJECT exists, then\n"
"     the project-version descriptor is treated as an ordinary file\n"
"     for purposes of check-out.  A check-out with a non-defaulted\n"
"     FILE-OR-DIR list that does not contain the descriptor therefore\n"
"     leaves the descriptor unchanged.\n"
"\n"
"     Files that are checked out are restored to the protections\n"
"     recorded for them at check-in time, usually modified (on UNIX\n"
"     systems) by the user's file mode creation mask (see the UNIX\n"
"     manual entry for umask(1)).  With the `-p' option, this mask is\n"
"     ignored, and the command restores the files' protections to\n"
"     exactly their state at check-in.\n"
"\n"
"     Returns a status code of 0 if all goes well, and non-zero if\n"
"     there are errors.\n"

;

const char populate_help_string[] = 
" - Command: prcs populate [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-d'\n"
"\n"
"     Add each file in the  FILE-OR-DIR list to the Files list of the\n"
"     `.prj' file identified by PROJECT, without modifying the\n"
"     repository.  For each directory in FILE-OR-DIR, recursively adds\n"
"     all files in that  directory structure (or the directory itself,\n"
"     if it is empty).  The FILE-OR-DIR operand list defaults to the\n"
"     current directory.\n"
"\n"
"     Without the `-d' option, any files already in the Files list\n"
"     remain there unchanged.  With `-d', populate will prompt you\n"
"     about removing files from the Files list that are listed there\n"
"     as appearing under one of the directories given in the\n"
"     FILE-OR-DIR list, but are not found in the working directory.\n"
"     With `-d' and `-f', it will remove them silently.\n"
"\n"
"     For example, suppose the file `P.prj' lists files `C', `D1/A',\n"
"     `D1/B', `D2/A', `D2/B'. Suppose a working directory contains\n"
"     files `A', `D1/B', and `D2/B'.  Then the command\n"
"\n"
"          prcs populate -d P\n"
"\n"
"     would remove files `C', `D1/A', and `D2/A' from the Files list\n"
"     of `P.prj', and add file `A'.  For the same initial `P.prj'\n"
"     file, the command\n"
"\n"
"          prcs populate -d P D1\n"
"\n"
"     would remove `D1/A' from `P.prj', and would add nothing.\n"
"\n"
"     New files are added with null internal file identifiers.\n"
"     Populate attempts to fill in the `:symlink' and `:directory'\n"
"     options.  It also applies a heuristic test to each file added to\n"
"     guess whether it is a non-text file; for each file it judges to\n"
"     be a non-text file, it includes the `:no-keywords' option for\n"
"     that file (*note Files attribute::.).\n"
"\n"

;

const char depopulate_help_string[] = 
" - Command: prcs depopulate [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS:\n"
"\n"
"     Remove each file in the  FILE-OR-DIR list from the Files list of\n"
"     the `.prj' file identified by PROJECT, without modifying the\n"
"     repository.  For each directory in FILE-OR-DIR, recursively\n"
"     removes all files in that  directory structure (or the directory\n"
"     itself, if it is empty).  The FILE-OR-DIR operand list defaults\n"
"     to the current directory, but since removing all files is\n"
"     probably not something the user wants to do, it queries first if\n"
"     no FILE-OR-DIR is supplied.\n"
"\n"

;

const char checkin_help_string[] = 
" - Command: prcs checkin [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-r', `-s'\n"
"\n"
"     Create a new version of the specified project in the repository.\n"
"     Copy all files listed in the Files attribute of the descriptor\n"
"     (`PROJECT.prj'), taking those specified in FILE-OR-DIR operands\n"
"     and the descriptor itself from the working files.  Also, modify\n"
"     the descriptor to reflect the contents of the new version.\n"
"     *Note Descriptors::.\n"
"\n"
"     If FILE-OR-DIR arguments are provided, they must name files and\n"
"     directories listed in the Files attribute.  Only those working\n"
"     files are checked in; other files listed in the project\n"
"     descriptor are carried over from the file versions listed for\n"
"     them in the Files attribute.  It is an error for these other\n"
"     files to have null internal file identifiers in the `.prj' file.\n"
"\n"
"     A check-in records the access protection on each file (reading\n"
"     it from the working file).  It records symbolic links with the\n"
"     `:symlink' option and  empty directories with a `:directory'\n"
"     option.  You could have, for example, a Files attribute as\n"
"     follows:\n"
"\n"
"          (Files\n"
"            (empty () :directory)        ; an empty directory\n"
"            (pointer () :symlink)        ; a symbolic link\n"
"            (realfile () :no-keywords)   ; the only real file in the list\n"
"          )\n"
"\n"
"     PRCS reads the contents of a symbolic link from the link at\n"
"     check-in time.  It is thus wise to use relative pathnames inside\n"
"     the project.  Directories with a `:directory' option need not be\n"
"     actually empty, but this ensures their creation at checkout.  It\n"
"     is an error to have a `:no-keywords' option in the same file as\n"
"     a `:symlink', or `:directory' option.\n"
"\n"
"     The new version will have the latest minor version number for the\n"
"     specified major version.  The `-r' option may specify a major\n"
"     version; any minor version specified is ignored.  The `-r' option\n"
"     defaults to `-r.@', thus taking the major version from the\n"
"     `.prj' file.\n"
"\n"
"     Let LV denote the last minor version on the branch being checked\n"
"     into.  A checkin is considered \"safe\" if the nearest common\n"
"     ancestor of LV and the working version is LV (*note\n"
"     Parent-Version attribute::.).  This is to insure that the version\n"
"     being checked in is a descendant of the version at the head of\n"
"     the branch before checkin.  Otherwise, changes at the head of\n"
"     the branch are clobbered.  Unless the `-f' option is present,\n"
"     PRCS will warn you if a checkin is not safe and allow you to\n"
"     abort.\n"
"\n"
"     With `-l' present, PRCS will list which files are modified,\n"
"     inserted, deleted, or renamed, relative to the real working\n"
"     version prior to checkin.  With `-L', PRCS will list all these\n"
"     changes in addition to listing which files are unmodified.\n"
"\n"
"     Returns a status code of 0 if all goes well, and non-zero if\n"
"     there are errors.\n"

;

const char diff_help_string[] = 
" - Command: prcs diff [OPTION ...] [PROJECT [FILE-OR-DIR ...]] [--\n"
"          [DIFF-OPTION ...]]\n"
"     ADDITIONAL OPTIONS: `-r' (once or twice), `-k',  `-N'\n"
"\n"
"     Compare the (partial) contents of two repository versions of a\n"
"     project or of a repository version and a working version.  When\n"
"     FILE-OR-DIR arguments are present, they restrict comparison to\n"
"     the specified files or subdirectory trees.  The PROJECT argument\n"
"     may be defaulted if there is a single file with extension `.prj'\n"
"     in the current working directory, in which case PRCS takes its\n"
"     name (without `.prj') as the project name.\n"
"\n"
"     The OPTIONs may specify zero, one, or two versions (using `-r'\n"
"     options).  Specifying no `-r' options is equivalent to supplying\n"
"     the single option `-r.', the version from which the current\n"
"     working directory was checked out.  A `-r' option that specifies\n"
"     only a major version (leaving off the minor version and its\n"
"     preceding period) implicitly has a minor version of `@'.  When\n"
"     one version specifier is given, the files in the indicated\n"
"     version are compared to the working files.  The command's output\n"
"     notes any discrepancies in the contents of identically-named\n"
"     files, or in files present in one version but not the other.  Two\n"
"     version specifiers cause the same comparison, but between two\n"
"     checked-in versions of the project.\n"
"\n"
"     Normally, `diff' canonicalizes keyword instances in the files it\n"
"     compares, removing the keyword values and leaving just the\n"
"     keyword name.  As a result, two different versions of a file\n"
"     that differ only in their keyword values will compare as equal.\n"
"     The `-k' option causes `diff' to compare keyword values as well.\n"
"\n"
"     If a file is present only in one of the project versions being\n"
"     compared, `diff' will normally just announce that such a file\n"
"     occurs only in one of the versions.  With the `-N' option, it\n"
"     will produce the same output it would if it instead treated the\n"
"     non-existent version as an empty file.   This is useful when\n"
"     producing patch files that include new files as well as changed\n"
"     ones.  Its effect is essentially the same as that of the same\n"
"     option in GNU `diff' when it compares directories.\n"
"\n"
"     Files in the two versions being compared are paired by their\n"
"     names and their internal-file families (see *Note Files\n"
"     attribute::, for a description of internal-file families).  That\n"
"     is, PRCS will assume that two files in the different versions\n"
"     correspond if they have the same name or the same internal-file\n"
"     family.  This makes it possible to have conflicts (for example,\n"
"     when one switches the names of two files in a project\n"
"     descriptor); in those cases PRCS will ask the user to resolve\n"
"     the conflict.\n"
"\n"
"     The DIFF-OPTIONS, if provided, are any options acceptable to GNU\n"
"     `diff'. *Note (diff)Top::.  The environment variable\n"
"     `PRCS_DIFF_OPTIONS', if set, supplies a default set of whitespace\n"
"     separated DIFF-OPTIONS.\n"
"\n"
"     Returns a status code of 0 if there were no differences, 1 if\n"
"     there were differences, and 2 if there were problems.\n"

;

const char merge_help_string[] = 
" - Command: prcs merge [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-r', `-u', `-s'\n"
"\n"
"     Find differences between working files and those of the selected\n"
"     version of PROJECT, and (unless `-n' is specified) try to modify\n"
"     the working files to reconcile them.  The default major and minor\n"
"     versions are `-r.@'.\n"
"\n"
"     More precisely, the comparison takes place between three\n"
"     versions of PROJECT: the working version (called PW in what\n"
"     follows), the \"common version\" (PC) and the \"selected version\"\n"
"     (PS).\n"
"\n"
"     PW is the working version specified in the checked-out\n"
"     descriptor and consists of all files listed therein.  PS is the\n"
"     version against which PRCS will reconcile changes, identified by\n"
"     the (possibly defaulted) `-r' option.  A common version is\n"
"     chosen according to the following algorithm:\n"
"\n"
"     Each version, including the working version, has a list of parent\n"
"     versions.  The parent versions establish an ancestry graph that\n"
"     is directed and contains no cycles.  A version is an ancestor of\n"
"     another if it can be reached by following zero or more parents\n"
"     (see *Note Parent-Version attribute:: and *Note Merge-Parents\n"
"     attribute::).  PC is chosen from the set of all versions that\n"
"     are ancestors of PW and PS.  If amongst this union, there exists\n"
"     a unique nearest common ancestor, then it is PC.  If there is no\n"
"     such version, PRCS will complain and ask the user for help.\n"
"\n"
"     Files in the three versions are matched up both by name and by\n"
"     internal-file family (*note Files attribute::.).  That is, PRCS\n"
"     will assume that two files in different versions correspond if\n"
"     they have the same name or the same internal-file family.  This\n"
"     makes it possible to have conflicts (for example, when one\n"
"     switches the names of two files in a project descriptor); in\n"
"     those cases PRCS will ask the user to resolve the conflict.\n"
"\n"
"     A `prcs merge' will report discrepancies and (unless `-n' is\n"
"     specified) take actions as directed.  The possible actions are as\n"
"     follows.\n"
"\n"
"    `n'\n"
"          Do nothing.\n"
"\n"
"    `a'\n"
"          Add the file from PS to PW.\n"
"\n"
"    `r'\n"
"          Replace the working file with the file from PS.\n"
"\n"
"    `d'\n"
"          Delete the file from PW.\n"
"\n"
"    `m'\n"
"          Merge the file from PS with that from PW, inserting markers\n"
"          into the merged working file to show where the changes in PW\n"
"          (relative to PC) and those in the version from PS overlap.\n"
"          If the file from PC is missing, then an empty file is used\n"
"          for its contents.  In general, you will have to edit the\n"
"          working file to resolve the discrepancies.  If the versions\n"
"          in PS and PW are identical aside from keyword values,\n"
"          merging has no effect.\n"
"\n"
"    `?'\n"
"          Print summary of options.\n"
"\n"
"    `h'\n"
"          Print explanatory help message.\n"
"\n"
"    `v'\n"
"          View differences between PS, PC, and PW (there is further\n"
"          prompting for which you want compared).\n"
"\n"
"     The `-f' option causes default actions to each discrepancy (see\n"
"     below).  Otherwise, PRCS will ask the user to specify one of the\n"
"     possible actions.  All of the actions except `n' modify the\n"
"     descriptor, either to remove the file from the Files list, or to\n"
"     modify its internal file identifier to the one from PS.\n"
"\n"
"     Like `prcs diff', `prcs merge' canonicalizes files to strip\n"
"     keyword values before comparing them for discrepancies (*note\n"
"     diff::.).  In the descriptions that follow, saying that files\n"
"     are  \"equivalent\" means that they are identical when\n"
"     canonicalized.\n"
"\n"
"     PRCS detects the following discrepancies:\n"
"\n"
"        * Files present in PC and absent in PW.  The default action\n"
"          is `n'.  That is, the files are assumed to be obsolete,\n"
"          regardless of their status in PS.\n"
"\n"
"        * Files present in PC and PW, and absent in PS.  The default\n"
"          action is `d'.  That is, the files are assumed to be\n"
"          obsolete.\n"
"\n"
"        * Files present in PC, PS, and PW, equivalent in PC and PW,\n"
"          and different in PS.  The default action is `r'.  That is,\n"
"          the version in PS is assumed to be most up-to-date.\n"
"\n"
"        * Files present in PC, PS, and PW, and different in all three.\n"
"          The default action is `m'.  There have been independent\n"
"          changes in both PW and PS.\n"
"\n"
"        * Files absent in PC, and different in PW and PS.  The\n"
"          default action is `m'.\n"
"\n"
"        * Files absent in PC and PW, and present in PS. The default\n"
"          action is `a'.\n"
"\n"
"        * PRCS takes no action in other cases, and does not prompt\n"
"          the user.\n"
"\n"
"     When PRCS overwrites a working file that is a symbolic link,\n"
"     then (unless the `:symlink' option is specified for that file),\n"
"     it will overwrite the file that the link references, without\n"
"     changing the link itself.  With the `-u' option, PRCS will\n"
"     instead remove the link and create a new file.\n"
"\n"
"     Whenever PRCS is going to replace a working file as a result of\n"
"     one of the actions above, it first moves the original file into\n"
"     the `obsolete' directory and gives it a unique name.\n"
"\n"
"     A partial merge takes place when not all files in the three\n"
"     versions are considered for merging.  This can happen if a merge\n"
"     is aborted or the FILE-OR-DIR option limits the files under\n"
"     consideration.  When this happens, PRCS records which files have\n"
"     been merged and their names in the working project's\n"
"     New-Merge-Parents attribute (*note Merge-Parents attribute::.).\n"
"\n"
"     A merge is considered *complete* when each file in each version\n"
"     has been considered once.  A complete merge may be achieved by\n"
"     several partial merges.  To prevent reconsidering the same file\n"
"     more then once, PRCS will not consider any set of files\n"
"     containing a file that was already considered in a previous\n"
"     merge against the same selected version unless the `-s' option\n"
"     is specified.\n"
"\n"
"     In general, the `-s' option allows the user to turn off all the\n"
"     safety features built into `prcs merge'.  It will allow a user to\n"
"     merge files more than once, override the choice of an effective\n"
"     working version, restart a complete merge, and start a new merge\n"
"     without completing a previous merge.\n"
"\n"
"     By default, PRCS uses the GNU diff3 command to perform 2- or\n"
"     3-way file merges when you choose the `m' action (*note\n"
"     (diff)top::.).  It is possible, however, to supply your own\n"
"     merge command.  By setting the `PRCS_MERGE_COMMAND' environment\n"
"     variable to a program name, PRCS will call the named command\n"
"     instead of diff3 (*note Environment Variables::.).\n"
"\n"

;

const char rekey_help_string[] = 
" - Command: prcs rekey [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-u'\n"
"\n"
"     Replace keywords in the selected files, according to the version\n"
"     named in the project file.  Files whose contents would not\n"
"     change under keyword substitution are not modified.  With the\n"
"     `-n' option, simply reports files that will change as a result\n"
"     of keyword replacement. *Note Keywords::.\n"
"\n"
"     When PRCS overwrites a working file that is a symbolic link,\n"
"     then (unless the `:symlink' option is specified for that file),\n"
"     it will overwrite the file that the link references, without\n"
"     changing the link itself.  With the `-u' option, PRCS will\n"
"     instead remove the link and create a new file.\n"
"\n"
"     You can use this command to update keywords in working files\n"
"     after performing a `prcs checkin', which does not modify keyword\n"
"     values.\n"

;

const char info_help_string[] = 
" - Command: prcs info [OPTION ...] [PROJECT [FILE-OR-DIR ...]]\n"
"     ADDITIONAL OPTIONS: `-r', `--sort'\n"
"\n"
"     Print information about versions of the named project.  For each\n"
"     version listed, prints the project name, major and minor version\n"
"     identifiers, date and time checked in, and the user who checked\n"
"     in the version.  With the `-l' option, also prints out the\n"
"     version logs and each  project description.  With `-L', also\n"
"     prints out the files constituting the version, their attributes,\n"
"     and their unkeyed MD5 checksum;  the FILE-OR-DIR options in this\n"
"     case restrict the files or directories that are listed.\n"
"\n"
"     The `-r' option is special in this command in that it may contain\n"
"     any of the shell filename-generation pattern characters defined\n"
"     for the Bourne shell, `sh': `*', which matches any string of 0\n"
"     or more characters; `?', which matches any single character;\n"
"     `[...]', which matches any of the enclosed characters; and\n"
"     `[!...]', which matches any character except one of the enclosed\n"
"     characters.  These special pattern characters must be escaped to\n"
"     get them past the shell.  The default for both the major and\n"
"     minor versions is `*'.   The `-r' option is still interpreted as\n"
"     a separate major and minor version; that is, `-rFoo.*' matches\n"
"     `Foo.1', but not `Foo.Bar.1'.\n"
"\n"
"     The `--sort=TYPE' option sets the type of sorting that the info\n"
"     command should use. If TYPE is `date', versions are sorted by\n"
"     individual version date, otherwise the default, `version', is to\n"
"     sort by major version creation date.\n"

;

const char admin_compress_help_string[] = 
" - Subfunction: compress [PROJECT]\n"
"     Encourages PRCS to save space in storing the data for PROJECT,\n"
"     even at the expense of slower processing.  This command may take\n"
"     some time to execute.  Interrupting it in the middle is safe,\n"
"     although it may lead to somewhat erratic space-saving behavior.\n"

;

const char admin_uncompress_help_string[] = 
" - Subfunction: uncompress [OPTION] [PROJECT]\n"
"     ADDITIONAL OPTIONS: `-i'\n"
"\n"
"     Encourages PRCS to save time in processing commands against\n"
"     PROJECT, even at the expense of using more space--perhaps\n"
"     considerably more.  With the `-i' option, PRCS will immediately\n"
"     expand the entire representation of PROJECT.  Without the `-i'\n"
"     option, PRCS will increase its use of space only as needed.  If\n"
"     disk space should run out, PRCS will leave the repository in a\n"
"     correct state.\n"

;

const char admin_access_help_string[] = 
" - Subfunction: access [PROJECT]\n"
"     With the optional operand, interactively sets read and write\n"
"     permissions to all versions of PROJECT,  in the repository, and\n"
"     (on systems that provide it) sets the group to which the files\n"
"     belong.  This command allows the owner of a project in a\n"
"     repository to restrict the access that others have to its\n"
"     contents.  One can specify that these files may only be read or\n"
"     may not be accessed at all.\n"
"\n"
"     Without a PROJECT operand, interactively sets read and write\n"
"     permissions to the repository itself, both for members of the\n"
"     repository directory's group, and for all other users.  One must\n"
"     have at least read access to the repository to look at or check\n"
"     in any project (in addition to having appropriate access to the\n"
"     project itself). You must have write access to the repository to\n"
"     create new projects in it.\n"

;

const char admin_rebuild_help_string[] = 
" - Subfunction: rebuild [OPTION ...] [PROJECT]\n"
"     Rebuilds internal repository data on PROJECT, possibly removing\n"
"     file storage for deleted project versions and verifying the\n"
"     integrity of all project versions.  With the `-l' option, reports\n"
"     deletions.  Unless there has been damage to the repository, this\n"
"     command generally has no visible effect on the notional contents\n"
"     of the repository.\n"

;

const char admin_init_help_string[] = 
" - Subfunction: init PROJECT\n"
"     Create a new project in the repository containing no (non-empty)\n"
"     versions.  Performing a `prcs checkout' on a non-existent\n"
"     project creates a blank working project descriptor without\n"
"     modifying the repository.  The first `prcs checkin' for that\n"
"     project then creates a new entry in the repository. Normally, no\n"
"     other explicit initialization for the project's entry in the\n"
"     repository is necessary.  However, with this method it is\n"
"     impossible to perform a `prcs access' before the first check-in,\n"
"     because there is no record of the new project in the repository.\n"
"     With `prcs init', you can create a repository entry (containing\n"
"     no versions) that you can modify with `prcs access'.\n"

;

const char admin_pdelete_help_string[] = 
" - Subfunction: pdelete PROJECT\n"
"     Deletes a repository entry, permanently removing all versions\n"
"     and data from the repository.\n"
"\n"

;

const char admin_pinfo_help_string[] = 
" - Subfunction: pinfo\n"
"     Lists all projects in the repository.\n"
"\n"

;

const char admin_prename_help_string[] = 
" - Subfunction: prename PROJECT\n"
"     Renames a repository entry, similar to renaming during `prcs\n"
"     unpackage'.\n"
"\n"

;

const char config_help_string[] = 
" - Command: prcs config\n"
"     Print out all compiled-in values and their values, possibly\n"
"     altered by environment variables or command-line arguments.\n"
"     Also verifies that the executables named by `$RCS_PATH', or its\n"
"     compiled-in default, are valid and checks their version numbers\n"
"     to see that they are not outdated.\n"

;

const char package_help_string[] = 
" - Command: prcs package PROJECT PACKAGEDFILE\n"
"     ADDITIONAL OPTIONS: `-r', `-z'\n"
"\n"
"     Creates a plain file named PACKAGEDFILE, containing all the data\n"
"     in PROJECT.   A value of `-' for PACKAGEDFILE denotes the\n"
"     standard output.  With `-z', the output file is compressed (in\n"
"     gzip format).\n"

;

const char unpackage_help_string[] = 
" - Command: prcs unpackage PACKAGEDFILE [PROJECT]\n"
"     Creates PROJECT in the repository to be a copy of the project\n"
"     from which PACKAGEDFILE was created.  The file PACKAGEDFILE must\n"
"     have been created by `prcs package' (with or without the `-z'\n"
"     option).  If PROJECT is omitted, it defaults to the name of the\n"
"     project from which PACKAGEDFILE was created. If PROJECT exists\n"
"     in the repository, the user is prompted to delete the old copy\n"
"     from the repository.  A value of `-' for PACKAGEDFILE denotes\n"
"     the standard input.  With `-n', it merely reports the name of\n"
"     the project that would be added.\n"
"\n"
"     If PROJECT differs from the original name as stored in\n"
"     PACKAGEDFILE, the project is renamed.  Renaming a project\n"
"     revises the history of the project; the result is as if the\n"
"     project had always been named PROJECT, with one exception: When\n"
"     checked out, project descriptor will have a comment inserted\n"
"     making note of the original project name.\n"

;

const char execute_help_string[] = 
" - Command: prcs execute [OPTION ...] [PROJECT [FILE-OR-DIR ...]] [--\n"
"          COMMAND [ARG ...]]\n"
"     ADDITIONAL OPTIONS: `-r', `--pre', `--all', `--pipe' `--match\n"
"     PATTERN', `--not PATTERN'\n"
"\n"
"     Execute `COMMAND ARG ...,' suitably modified as described below,\n"
"     for the name of each file and directory in FILE-OR-DIR in the\n"
"     specified version, filtered by any `--match' and `--not'\n"
"     operators as described below.  This elaborate command is\n"
"     intended to facilitate efficient, open-ended extension of the\n"
"     functions of PRCS.  Each directory, whether or not explicitly\n"
"     named in the project, is included once, either in pre- or\n"
"     post-order.\n"
"\n"
"     With the `--all' option, COMMAND is executed once.  Otherwise,\n"
"     it is executed once per file name.\n"
"\n"
"     The PATTERN options filter the selected files.  To be selected,\n"
"     the entry in the Files attribute for a given file must satisfy\n"
"     the `--match' pattern (if any) and not satisfy  the `--not'\n"
"     pattern, if any.  Each pattern is a regular expression; an entry\n"
"     satisfies the pattern if either the name or any of the `:'\n"
"     options matches the pattern.\n"
"\n"
"     For each execution of COMMAND, PRCS first replaces the following\n"
"     strings wherever they appear in COMMAND and in each ARG:\n"
"\n"
"    `{}'\n"
"          Replaced by the name of the file.  With the `--all' option,\n"
"          replaced by the sequence of all selected file names,\n"
"          separated by \"unquoted blanks\" (that is, blanks that divide\n"
"          the replacement string into separate arguments).\n"
"\n"
"    `{options}'\n"
"          Replaced by a string consisting of all colon-options\n"
"          applicable to the file (*note Files attribute::.), separated\n"
"          by \"quoted blanks\" (that is, blanks that do not divide the\n"
"          replacement string into separate arguments).  If a\n"
"          directory is not explicitly named in the project file, it\n"
"          is listed with a `:implicit-directory' option, whether or\n"
"          not it appears separately in the Files attribute.  These\n"
"          directories appear whether or not the files containing them\n"
"          were on the command line (otherwise, it would be impossible\n"
"          to get just the directories).  The project file is included\n"
"          with the `:project-file' attribute.  With the `--all'\n"
"          option, all of these colon-option strings are concatenated\n"
"          together, with the strings for different files separated by\n"
"          unquoted blanks.\n"
"\n"
"    `{file}'\n"
"          The name of a file containing the contents of the\n"
"          appropriate version of the file.  Unless the internal file\n"
"          identifier is null (which can only happen when there is no\n"
"          `-r' option, so that the working version is specified),\n"
"          this is the name of a temporary file containing a\n"
"          checked-out copy of the appropriate version, which is\n"
"          deleted after COMMAND completes.  With a null internal file\n"
"          identifier, `{file}' is the same as `{}'.  It is the empty\n"
"          string for a directory or a file carrying the `:symlink'\n"
"          option.  With the `--all' option, all of these file names\n"
"          are concatenated together, separated by unquoted blanks.\n"
"\n"
"     (In contexts where curly braces are special to your shell, you\n"
"     will have to escape them.) After these substitutions, PRCS\n"
"     invokes COMMAND, which must be an executable file.  It looks for\n"
"     COMMAND in the same directories as the shell (using the PATH\n"
"     environment variable).  When `--' and what follows are omitted,\n"
"     they default to\n"
"\n"
"          -- /bin/echo {}\n"
"\n"
"     which simply echoes the names of all files and directories in the\n"
"     selected version, one per line.\n"
"\n"
"     One small glitch: `prcs execute' uses the current directory in\n"
"     effect when it is invoked as the current directory seen by\n"
"     COMMAND.  This is true, even when the PROJECT operand specifies\n"
"     a subdirectory.  For example,\n"
"\n"
"          % cd /usr/users/foo\n"
"          % prcs execute D/P -- pwd\n"
"\n"
"     will print `/usr/users/foo' once for each file listed in\n"
"     `/usr/users/foo/D/P.prj', and not `/usr/users/foo/D', as the\n"
"     general description of the PROJECT operand might otherwise\n"
"     suggest (*note Specifying Projects::.).  This allows you to do\n"
"     something like the following:\n"
"\n"
"          % ln -s . P-1.0\n"
"          % tar -cvf P-1.0.tar `prcs execute --not :.*directory P-1.0`\n"
"\n"
"     for making tarfiles containing all files in a project in an\n"
"     appropriately named subdirectory for distribution.\n"
"\n"
"     If the `--pipe' option is present, then the contents of the file\n"
"     (as would be contained in the file named by `{file}') is\n"
"     supplied as the standard input.  The `--pipe' and `--all'\n"
"     options are incompatible.  Any ARG whose replacement contains\n"
"     unquoted blanks (introduced by the `--all' option) is divided at\n"
"     those blanks into separate arguments (even in the case where\n"
"     substitution results in a null string, that null string will be\n"
"     broken out as a separate argument).  Each of the resulting\n"
"     arguments, is passed directly to the program specified by\n"
"     COMMAND as a single string, with no further processing by any\n"
"     shell.\n"
"\n"
"     With the `--all' option,  PRCS will invoke COMMAND only once.\n"
"     The order of the lists of arguments replacing each pattern in\n"
"     COMMAND is consistent, so that, for example, the options for the\n"
"     first file name in the replacement for `{}' is the first string\n"
"     in the replacement for `{options}'.  For example, if a project\n"
"     contains the files `A', `B/Q', and `B/R', then\n"
"\n"
"          prcs execute --all . -- foo -a{}-b \"{options}\"\n"
"\n"
"     will execute (in effect) the single command\n"
"\n"
"          foo -aA B/Q B/R B-b \"\" \"\" \"\" \":directory\"\n"
"\n"
"     With the `--pre' (for pre-order) option the directory name is\n"
"     listed first, then the non-directory file names within that\n"
"     directory, then the subdirectories and their contents.\n"
"     Otherwise, subdirectories and their contents are listed first,\n"
"     then the names of its non-directory files, then the name of the\n"
"     directory itself.\n"
"\n"
"     With `-n', the command prints the commands that will be executed\n"
"     without actually executing them.\n"

;

const char delete_help_string[] = 
" - Command: prcs delete `-r' VERSION PROJECT\n"
"     Delete the indicated version of PROJECT.  It will no longer be\n"
"     possible to retrieve the given version.  Therefore, this is a\n"
"     command that you should use very sparingly, if at all.\n"
"\n"
"     Deleting a version does not necessarily release the space used\n"
"     by the files it contains, since these may be mentioned in other\n"
"     versions.  At various times, PRCS will note what space can\n"
"     actually be released and do so.\n"
"\n"
"     Minor version numbers increase monotonically, regardless of\n"
"     deletions, and are never re-used.\n"

;

const char general_help_string[] = 
"Possible commands are:\n"
"  admin          Requires subcommand (`prcs admin --help' for help).\n"
"  checkin        Checkin project revision.\n"
"  checkout       Checkout project revision.\n"
"  config         Verify compiled in paths, defaults, and environment\n"
"                 variables.\n"
"  delete         Delete named revision of project.\n"
"  depopulate     Remove named files from project descriptor.\n"
"  diff           Show differences between two revisions.\n"
"  execute        Execute a command for each file in a project.\n"
"  info           Print information about versions of project.\n"
"  merge          Reconcile differences between working files and\n"
"                 another revision.\n"
"  package        Package the project and all its revisions into\n"
"                 packagefile.\n"
"  populate       Add named files to project descriptor.\n"
"  rekey          Set keywords in selected files.\n"
"  unpackage      Unpackage project in packagefile.\n"
"Use the --help option with a command for further help.\n"

;

const char admin_help_string[] = 
"Possible subcommands are:\n"
"  access         Set the access permissions on the repository.\n"
"  compress       Instruct PRCS to save disk space for project.\n"
"  init           Create a repository entry.\n"
"  pdelete        Delete a repository entry.\n"
"  prename        Rename a repository entry.\n"
"  rebuild        Instruct PRCS to reconstruct its data files in the\n"
"                 repository.  This command is helpful if the repository\n"
"                 has been damaged or PRCS has reported an error due to\n"
"                 and RCS command failure or missing version data.\n"
"  uncompress     Instruct PRCS to save time in processing project(default).\n"
"Use the --help option with a command for further help.\n"

;
