/*
Copyright (c) 1996-1997 Xerox Corporation.  All Rights Reserved.  

Unlimited use, reproduction, and distribution of this software is
permitted.  Any copy of this software must include both the above
copyright notice of Xerox Corporation and this paragraph.  Any
distribution of this software must comply with all applicable United
States export control laws.  This software is made available AS IS,
and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

$Id: cppgensurrogate.cpp,v 1.13 1997/09/17 02:28:25 srjohnso Exp $
*/

#include <string.h>  // TEMP: for ReusableString

#include "cppgen.hpp"
#include "cppparse.hpp"
#include "cppparsestream.hpp"
#include "cppportability.hpp"


// TEMP should move this to some common place
class ReusableString {
public:
    ReusableString (int initialMaxLen = 100) {
        initialMaxLen = (initialMaxLen < 0) ? 0 : initialMaxLen;
        maxLen = 0;
        resize(initialMaxLen);
    }
    ~ReusableString () {
        if (str != NULL)
            delete [] str;
    }
    char * resize (int newMaxLen) {
        char * old = str;
        str = new char[(maxLen = newMaxLen) + 1];
        return old;
    }
    void strcpy (const char * from, int extraBytes = 100) {
        str[0] = '\0';
        strcat(from, extraBytes);
    }
    void strcat (const char * from, int extraBytes = 100) {
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        if (from == NULL)
            from = "";
        const int newLen = strlen(str) + strlen(from);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, from);
    }
    void ucat (unsigned long u, int extraBytes = 100) {
        #define CHARS_FOR_2E64 20  // string length needed for max 64-bit unsigned
        char num[CHARS_FOR_2E64 + 1];
        extraBytes = (extraBytes < 0) ? 0 : extraBytes;
        sprintf(num, "%lu", u);
        const int newLen = strlen(str) + strlen(num);
        if (maxLen < newLen) {
            char * oldStr = resize(newLen + extraBytes);
            delete [] oldStr;
        };
        ::strcat(str, num);
    }
    char * str;
    int maxLen;
};


CppParseStream(ofstream) &
CppGen(Interface)::
_surrogateDef (CppParseStream(ofstream) & ofs) {
    
    const char * myName = NULL;
    // TMP 6/14  CppParse(ObjectListIter) objectListIter(objects());
    CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
    const CppGen_(Object) * object;
    
    if (definedIn == NULL) {  // not a nested interface
        CppParse(ImportListIter) importIter(imports());
        const CppParse(Import) * import;
        myName = localName();
        ofs << "// Prevent multiple inclusions" << endl;
        ofs << "#ifndef __" << myName << "_cppsurrogate_hpp_" << endl;
        ofs << "#define __" << myName << "_cppsurrogate_hpp_" << endl;
        ofs << endl;
        ofs << "#include \"" << myName << "-cpp.hpp\"" << endl;
        while ((import = importIter.next()) != NULL) {
            if (strcmp("ilu", import->baseName()) == 0)
                continue;
            ofs << "#include \"" << import->baseName() << "-cppsurrogate.hpp\"" << endl;
        };
        ofs << endl;
    };
    
    ofs << CppGen_(Namespace)::open(localName(CppGen_(surrogate_key)));
    ofs.indent++;
    ofs << endl;
    
    ofs << "// Surrogate classes" << endl;
    ofs << endl;
    while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
        ofs << object->surrogateDef();
        ofs << endl;
    };
    
    ofs << "// Class initializers" << endl;
    ofs << endl;
    objectListIter.reset();
    while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
        ofs << object->surrogateDefInitializer();
        ofs << endl;
    };
    
    ofs.indent--;
    ofs << CppGen_(Namespace)::close(localName(CppGen_(surrogate_key)));
    
    if (definedIn == NULL) {
        ofs << endl;
        ofs << "#endif // __" << myName << "_cppsurrogate_hpp_" << endl;
    };
    
    return ofs;
}


CppParseStream(ofstream) &
CppGen(Interface)::
_surrogateImpl (CppParseStream(ofstream) & ofs) {
  
// TMP 6/14  CppParse(ObjectListIter) objectListIter(objects());
  CppParse(ObjectListIter) objectListIter(objects());  // TMP 6/14: NEW
  const CppGen_(Object) * object;

  ofs << "#include \"" << localName() << "-cppsurrogate.hpp\"" << endl;
  ofs << "#include \"optionaltemplates.hpp\"  // TMP 6/28" << endl;
  ofs << endl;

  ofs << "// Static class initialization" << endl;
  ofs << endl;
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    ofs << object->surrogateImplInitializerInstantiation();
    ofs << endl;
  };
  ofs << endl;

  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    const CppParse(ProcedureList) procs = object->procedures();
    if (procs.count() > 0) {
      CppParse(ProcedureListIter) procListIter(procs);
      const CppGen_(Procedure) * proc;
      ofs << "// " << object->name() << " surrogate methods" << endl;
      ofs << endl;
      while ((proc = CppGen_(Procedure)::narrow(procListIter.next())) != NULL) {
        ofs << proc->surrogateImpl();
        ofs << endl;
        if (proc->exceptions().count() > 0) {
          ofs << proc->surrogateImplThrow();
          ofs << endl;
        };
      };
      ofs << endl;
    };
    ofs << endl;
  };
  ofs << endl;

  objectListIter.reset();
  while ((object = CppGen_(Object)::narrow(objectListIter.next())) != NULL) {
    ofs << "// Initialize to use " << object->name() << " objects" << endl;
    ofs << endl;
    ofs << object->surrogateImplIluInitialize() << endl;
    ofs << endl;
    ofs << "// Create a " << object->name() << " surrogate" << endl;
    ofs << endl;
    ofs << object->surrogateImplCreate() << endl;
    ofs << endl;
    ofs << "// Force initialization of " << object->name() << " class "
      << "upon load" << endl;
    ofs << endl;
    ofs << object->surrogateImplInitializer();
    ofs << endl;
  };

  return ofs;
}


CppParseStream(ofstream) &
CppGen(Object)::
_surrogateDef (CppParseStream(ofstream) & ofs) {

  CppParse(ProcedureListIter) procListIter(procedures());
// TMP 9/7  CppParse(ObjectListIter) superclassIter(superclasses());
  CppParse(TypeListIter) superclassIter(superclasses());  //  TMP 9/7: NEW
  const CppGen_(Procedure) * proc;
// TMP 9/7  const CppParse(Object) * obj;
  const CppParse(Type) * super;  // TMP 9/7: NEW

  ofs << "class " << localName(CppGen_(surrogate_key)) << " : ";
/* TMP 9/7
  while ((obj = superclassIter.next()) != NULL) {
      // TEMP: need a better way to compare CppParseName::Name's
      if (strcmp("CORBA_Object", obj->name(CppGen_(underscore_key))) == 0)
          continue;
      ofs << "public virtual " << obj->name(CppGen_(surrogate_key), scope()) << ", ";
  };
TMP 9/7 */
  while ((super = superclassIter.next()) != NULL) {  // TMP 9/7: NEW
      // TEMP: need a better way to compare CppParseName::Name's
      if (strcmp("CORBA_Object", super->name(CppGen_(underscore_key))) == 0)
          continue;
      ofs << "public virtual " << super->urType()->name(CppGen_(surrogate_key), scope()) << ", ";
  };
  ofs << "public virtual " << name() << " {" << endl;
  ofs << endl;
  ofs.indent++;

  ofs << "public:" << endl;
  ofs.indent++;
  ofs << endl;

  ofs << "// ISL specified methods" << endl;
  ofs << endl;
  while ((proc = CppGen_(Procedure)::narrow(procListIter.next())) != NULL) {
    ofs << proc->surrogateDef();
    ofs << endl;
  };
  ofs << endl;

  ofs << "// Initialize to use this class of objects" << endl;
  ofs << endl;
  ofs << "static" << endl;
  ofs << "void" << endl;
  ofs << "iluInitialize ();" << endl;
  ofs << endl;

  ofs << "// Function used to create a surrogate for a " << localName()
    << " object" << endl;
  ofs << endl;
  ofs << "static" << endl;
  ofs << "iluObject*" << endl;
  ofs << "create_surrogate (iluKernelObject);" << endl;
  ofs << endl;

  // disambiguate iluDowncast
  ofs << "virtual" << endl;
  ofs << "void *" << endl;
  ofs << "iluDowncast (iluClass class_to_cast_down_to) "
      << "{return " << name() << "::iluDowncast(class_to_cast_down_to);};" << endl;
  ofs << endl;

  ofs.indent--;
  ofs << "private:" << endl;
  ofs.indent++;
  ofs << endl;
  ofs << "// Exception forwarding" << endl;
  ofs << endl;
  procListIter.reset();
  while ((proc = CppGen_(Procedure)::narrow(procListIter.next())) != NULL) {
    if (proc->exceptions().count() > 0) {
      ofs << proc->surrogateDefThrow();
      ofs << endl;
    };
  };

  ofs << "// Set to 1 once initialization has occured" << endl;
  ofs << endl;
  ofs << "static int _initialized;" << endl;
  ofs << endl;

  ofs.indent--; ofs.indent--;
  ofs << "};" << endl;
  
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_surrogateDefInitializer (CppParseStream(ofstream) & ofs) {

  static ReusableString tempStr;
  CppParseName(TempName) initializer;
  const char * initializer_local_name;

  tempStr.strcpy(simpleName());
  tempStr.strcat("_initializer");
  initializer.reset(tempStr.str, scope());
  initializer_local_name = initializer.localName(CppGen_(surrogate_key));

  ofs << "class " << initializer_local_name << " {" << endl;
  ofs.indent++;

  ofs << "public:" << endl;
  ofs.indent++;
  ofs << initializer_local_name << " ();" << endl;
  ofs << "void * ensure_instantiation ();" << endl;
  ofs << "static " << initializer_local_name <<
      " sm_the_surrogate_" << simpleName() << "_initializer;" << endl;
  ofs.indent--;

  ofs.indent--;
  ofs << "};" << endl;

  return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_surrogateImplIluInitialize (CppParseStream(ofstream) & ofs) {

  ofs << "void" << endl;
  ofs << name(CppGen_(surrogate_key)) << "::iluInitialize () { " << endl;
  ofs.indent++;
  ofs << "if (_initialized == 1)" << endl;
  ofs.indent++;
  ofs << "return;" << endl;
  ofs.indent--;

  ofs << "iluCppInternal::iluRegisterSurrogateCreator(" << endl;
  ofs.indent++;
  ofs << name() << "::iluGetILUClassRecord()," << endl;
  ofs << "create_surrogate" << endl;
  ofs.indent--;
  ofs << ");" << endl;

  if (collectible())
    ofs << "iluCppInternal::iluEnsureGCCallback();" << endl;

  ofs << "_initialized = 1;" << endl;

  ofs.indent--;
  ofs << "}" << endl;

  return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_surrogateImplCreate (CppParseStream(ofstream) & ofs) {
  ofs << "iluObject*" << endl;
  ofs << name(CppGen_(surrogate_key)) << "::" << endl;
  ofs << "create_surrogate (iluKernelObject _kernel_object) {" << endl;
  ofs.indent++;
  ofs << name() << "* _new_object = new " << name(CppGen_(surrogate_key))
    << "();" << endl;
  ofs << "_new_object->iluAssociateKernelObject(_kernel_object);" << endl;
  ofs << "return _new_object;" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_surrogateImplInitializer (CppParseStream(ofstream) & ofs) {

  static ReusableString initializer_simple_name;
  CppParseName(TempName) initializer;
  CppParseName(TempName) initialization_function_list(
	  "_initialization_function_list",
	  scope());

  initializer_simple_name.strcpy(simpleName());
  initializer_simple_name.strcat("_initializer");
  initializer.reset(initializer_simple_name.str, scope());

  ofs << initializer.name(CppGen_(surrogate_key)) << "::" << endl;
  ofs << initializer.localName(CppGen_(surrogate_key)) << " () {" << endl;
  ofs.indent++;
  ofs << "iluCppInternal::iluAddInitializationFunction(" << endl;
  ofs.indent++;
  ofs << "&" << initialization_function_list.name() << "," << endl;
  ofs << name(CppGen_(surrogate_key)) << "::iluInitialize" << endl;
  ofs.indent--;
  ofs << ");" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  ofs << "void *" << endl;
  ofs << initializer.name(CppGen_(surrogate_key)) << "::" << endl;
  ofs << "ensure_instantiation () {" << endl;
  ofs.indent++;
  ofs << "return this;" << endl;
  ofs.indent--;
  ofs << "}" << endl;
  ofs << endl;

  return ofs;
}

CppParseStream(ofstream) &
CppGen(Object)::
_surrogateImplInitializerInstantiation (CppParseStream(ofstream) & ofs) {

  static ReusableString initializer_simple_name;
  CppParseName(TempName) initializer;

  initializer_simple_name.strcpy(simpleName());
  initializer_simple_name.strcat("_initializer");
  initializer.reset(initializer_simple_name.str, scope());

  ofs << initializer.name(CppGen_(surrogate_key)) << endl;
  ofs << initializer.name(CppGen_(surrogate_key)) << "::sm_the_surrogate_";
  ofs << simpleName() << "_initializer;" << endl;
  ofs << "int " << name(CppGen_(surrogate_key)) << "::_initialized;" << endl;
  ofs << endl;

  return ofs;
}


CppParseStream(ofstream) &
CppGen(Procedure)::
_surrogateDef (CppParseStream(ofstream) & ofs) {
    
    const CppGen_(ReturnVal) * return_val = CppGen_(ReturnVal)::narrow(returnVal());
    const CppParse(ArgumentList) args = arguments();
    CppParse(ArgumentListIter) argListIter(args);
    CppParse(ExceptionListIter) exceptionListIter(exceptions());
    const CppParse(Argument) * arg;
    const CppParse(Exception) * exception;
    
    ofs << "virtual" << endl;
    ofs << ((return_val->type() == NULL)
        ? "void"
        : return_val->type()->usageName(CppParseName(returnVal))
        );
    ofs << endl;
    ofs << localName() << " (";
    
    if (args.count() >  0) {
        ILUCPP_BOOL firstArg = ILUCPP_TRUE;
        ofs << endl;
        ofs.indent++;
        while ((arg = argListIter.next()) != NULL) {
            if (firstArg)
                firstArg = ILUCPP_FALSE;
            else
                ofs << "," << endl;
            ofs << arg->type()->usageName(arg->usage()) << " "
                << arg->localName();
        };
        ofs << endl;
        ofs.indent--;
    };
    
    ofs << ") throw (" << CppParseName(CorbaSystemException)()->name();
    while ((exception = exceptionListIter.next()) != NULL)
        ofs << ", " << exception->name();
    ofs << ");" << endl;
    
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Procedure)::
_surrogateDefThrow (CppParseStream(ofstream) & ofs) {

  CppParse(ExceptionListIter) exceptionListIter(exceptions());
  const CppParse(Exception) * exception;

  ofs << "static" << endl;
  ofs << "void" << endl;
  ofs << "_throw_" << localName()
    << "_exception (iluCardinal exception_index, iluSurrogateCall&)" << endl;

  ofs << "throw (" << CppParseName(CorbaSystemException)()->name();
  while ((exception = exceptionListIter.next()) != NULL)
    ofs << ", " << exception->name();
  ofs << ");" << endl;

  return ofs;
}


CppParseStream(ofstream) &
CppGen(Procedure)::
_surrogateImpl (CppParseStream(ofstream) & ofs) {
    
    const CppGen_(ReturnVal) * return_val = CppGen_(ReturnVal)::narrow(returnVal());
    const CppParse(ArgumentList) args = arguments();
    CppParse(ArgumentListIter) argListIter(args);
    CppParse(ExceptionList) excps = exceptions();
    CppParse(ExceptionListIter) exceptionListIter(excps);
    unsigned long nInArgs = 0;   // number of in & inOut arguments
    unsigned long nOutArgs = 0;  // number of out & inOut arguments
    const CppParse(Argument) * arg;
    const CppParse(Exception) * exception;
    
    // function return type
    ofs << ((return_val->type() == NULL)
        ? "void"
        : return_val->type()->usageName(CppParseName(returnVal))
        );
    ofs << endl;

    // function name
    ofs << object()->CppParse(Type)::name(CppGen_(surrogate_key)) << "::" << endl;
    ofs << simpleName() << " (" << endl;
    
    // argument list
    if (args.count() >  0) {
        ILUCPP_BOOL firstArg = ILUCPP_TRUE;
        ofs.indent++;
        while ((arg = argListIter.next()) != NULL) {
            const CppParseName(TypeUsage) dir = arg->usage();
            if (firstArg)
                firstArg = ILUCPP_FALSE;
            else
                ofs << ", " << endl;
            ofs << arg->type()->usageName(arg->usage()) << " "
                << arg->localName();
            if ((dir == CppParseName(in)) || (dir == CppParseName(inOut)))
                nInArgs++;
            if ((dir == CppParseName(out)) || (dir == CppParseName(inOut)))
                nOutArgs++;
        };
    };
    ofs << endl;
    ofs.indent--;

    // throw list
    ofs << ") throw (" << CppParseName(CorbaSystemException)()->name();
    while ((exception = exceptionListIter.next()) != NULL)
        ofs << ", " << exception->name();
    ofs << ") {" << endl;
    ofs.indent++;

    // parameter pre-procesing
    argListIter.reset();
    while ((arg = argListIter.next()) != NULL)
        ofs << CppGen_(Argument)::narrow(arg)->surrogatePreProcessing();
    if (return_val->type() != NULL)
        ofs << return_val->surrogatePreProcessing();

    // declare call
    ofs << endl;
    ofs << "iluCallStruct _callStruct;" << endl;
    ofs << "iluSurrogateCall _call(&_callStruct, " << methodNum()
// TMP 9/16        << ", this);" << endl;
        << ", this, " << object()->name() << "::iluGetILUClassRecord());" << endl;  // TMP 9/16: NEW
    
    // begin try block
    ofs << endl;
    ofs << "try {" << endl;
    ofs.indent++;

    // declare discriminator
    ofs << endl;
    ofs << "iluObjectWrapper _discriminator(*this, " << CppGen_(Bool)::value(ILUCPP_TRUE) << ");" << endl;

    // auxiliary definitions for each arg and return value, if any
    argListIter.reset();
    while ((arg = argListIter.next()) != NULL) {
        switch (arg->usage()) {
        case CppParseName(in):
        case CppParseName(inOut):
            ofs << CppGen_(Argument)::narrow(arg)->initialDeclsOutput();
            break;
        default:  // CppParseName::out
            ofs << CppGen_(Argument)::narrow(arg)->initialDeclsInput();
            break;
        };
    };
    if (return_val->type() != NULL)
        ofs << return_val->initialDeclsInput();

    // declare cardinal to hold exception number
    if (excps.count() > 0)
        ofs << "iluCardinal _exception_number;" << endl;
    
    // begin retry loop (in case of redirect)
    if (!asynch()) {
        ofs << endl;
        ofs << "do {" << endl;
        ofs.indent++;
    };
        
    // size arguments
    ofs << endl;
    ofs << "// Size arguments" << endl;
    ofs << "if (_call.iluNeedsSizing()) {" << endl;
    ofs.indent++;
    ofs << "_call += _discriminator;" << endl;
    argListIter.reset();
    while ((arg = argListIter.next()) != NULL) {
        const CppParseName(TypeUsage) dir = arg->usage();
        if ((dir == CppParseName(in)) || (dir == CppParseName(inOut)))
            ofs << CppGen_(Argument)::narrow(arg)->sizing();
    };
    ofs.indent--;
    ofs << "};" << endl;
    
    // send request
    ofs << endl;
    ofs << "// Send request" << endl;
    ofs << "_call << iluRequestMode;" << endl;
    ofs << "_call << _discriminator;" << endl;
    argListIter.reset();
    while ((arg = argListIter.next()) != NULL) {
        const CppParseName(TypeUsage) dir = arg->usage();
        if ((dir == CppParseName(in)) || (dir == CppParseName(inOut)))
            ofs << CppGen_(Argument)::narrow(arg)->send();
    };
    ofs << "_call << iluRequestSentMode;" << endl;
    ofs << endl;

    if (!asynch()) {  // TEMP: perhaps we need to check against nOutArgs & return_val->type() as well
        
        // enter reply mode
        ofs << "// Enter reply mode" << endl;
        ofs << "_call << iluGetReplyMode;" << endl;

        // end retry loop
        ofs << endl;
        ofs.indent--;
        ofs << "} while (_call.iluShouldRetryCall());" << endl;
        ofs << endl;
        
        // check for exception, throw it if present
        if (excps.count() > 0) {
            ofs << "if (_call.iluExceptionPresent(_exception_number))"
                << endl;
            ofs.indent++;
            ofs << "_throw_" << localName()
                << "_exception(_exception_number - 1, _call);" << endl;
            ofs.indent--;
        };

        if (return_val->type() != NULL || nOutArgs > 0) {
            ofs << endl;
            ofs << "// Get results" << endl;
        };
        
        // receive return value
        if (return_val->type() != NULL)
            ofs << return_val->surrogateReceive();
        
        // receive arguments
        argListIter.reset();
        while ((arg = argListIter.next()) != NULL) {
            const CppParseName(TypeUsage) dir = arg->usage();
            if ((dir == CppParseName(out)) || (dir == CppParseName(inOut)))
                ofs << CppGen_(Argument)::narrow(arg)->surrogateReceive();
        };
        
        // do argument cleanup
        ofs << endl;
        argListIter.reset();
        while ((arg = argListIter.next()) != NULL)
            ofs << CppGen_(Argument)::narrow(arg)->surrogateCleanup();
        
        // do return value cleanup
        if (return_val->type() != NULL) {
            ofs << return_val->surrogateCleanup();
            ofs << endl;
            ofs << "return " << return_val->localName() << ";" << endl;
        };

    };

    // end try block
    ofs.indent--;
    ofs << "}" << endl;
    
    // catch block
    ofs << "catch (" << CppParseName(CorbaSystemException)()->name()
        << "& _exception) {" << endl;
    ofs.indent++;
    ofs << "_call.iluSetErrorType(_exception.exception_kind());"
        << endl;
    ofs << "throw(_exception);" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    
    // end function
    ofs.indent--;
    ofs << "}" << endl;
    
    return ofs;
}

CppParseStream(ofstream) &
CppGen(Procedure)::
_surrogateImplThrow (CppParseStream(ofstream) & ofs) {
    
    CppParse(ExceptionListIter) exceptionListIter(exceptions());
// TMP 6/14    const CppParse(Exception) * exception;
    const CppGen_(Exception) * exception;  // TMP 6/14: NEW
    
    ofs << "void" << endl;
    ofs << object()->CppParse(Type)::name(CppGen_(surrogate_key)) << "::"
        << endl;
    ofs << "_throw_" << simpleName() << "_exception"
        << " (iluCardinal _exception_index, iluSurrogateCall& _call)" << endl;
    ofs << "throw (" << CppParseName(CorbaSystemException)()->name();
// TMP 6/14    while ((exception = exceptionListIter.next()) != NULL)
    while ((exception = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL)  // TMP 6/14: NEW
        ofs << ", " << exception->name();
    ofs << ") {" << endl;
    ofs.indent++;
    
    ofs << "try {" << endl;
    ofs.indent++;
    ofs << "switch(_exception_index) {" << endl;
    ofs.indent++;
    exceptionListIter.reset();
// TMP 6/14    while ((exception = exceptionListIter.next()) != NULL) {
    while ((exception = CppGen_(Exception)::narrow(exceptionListIter.next())) != NULL) {  // TMP 6/14: NEW
/* TMP 6/14
        ofs << "case _ilu_nsconst_" << exception->name(CppGen_(underscore_key))
            << "_index: {" << endl;
*/
        ofs << "case "; exception->indexName(scope(), ofs); ofs << ": {" << endl;  // TMP 6/14: NEW
        ofs.indent++;
        ofs << exception->name() << " " << "_exception;" << endl;
        ofs << "_call >> _exception;" << endl;
        ofs << "throw(_exception);" << endl;
        ofs.indent--;
        ofs << "};" << endl;
    };
    ofs << "default: {" << endl;
    ofs.indent++;
    ofs << CppParseName(CorbaUNKNOWN)()->name() << " _exception;" << endl;
    ofs << "throw(_exception);" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    ofs.indent--;
    ofs << "};" << endl;
    ofs.indent--;
    ofs << "}" << endl;

    ofs << "catch(" << CppParseName(CorbaSystemException)()->name()
        << "& _exception) {" << endl;
    ofs.indent++;
    ofs << "_call.iluSetErrorType(_exception.exception_kind());" << endl;
    ofs << "throw(_exception);" << endl;
    ofs.indent--;
    ofs << "}" << endl;
    
    ofs.indent--;
    ofs << "}" << endl;
    
    return ofs;
}
