/* IluJava_JOps.c */
/* Chris Jacobi, July 22, 1997 4:24 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluJava_JOps.c,v 1.12 1997/07/30 20:17:42 larner Exp $ */

/*
 * Handy java access operations.
 * Implementation makes disgusting use of java implementation functionality
 */

#include "IluJava_Includes.h"
#include "IluJava_JOps.h"
#include "IluJava_JArrays.h"

static void
ilujava_copy8to16(char* src, unicode* dst, unsigned len)
/* strictly converts and copies len units; no
 * fancy terminator charactors.
 */
{
    while (len) {
        *dst++ = *src++;
        len--;
    }
}
   
     
static void
ilujava_copy16to8(unicode *src, char *dst, unsigned len)
/* strictly converts and copies len units; no
 * fancy terminator charactors.
 */
{
    while (len) {
        *dst++ = (char) *src++;
        len--;
    }
}
     

extern JArrayOfByte 
IluJava_JAoB_from8(char* data, unsigned len) 
    /* Allocates and initializes a Java array of byte.
     * data: initial data interpreted as 8 bit bytes 
     * len: length of data (or array) in 8 bit units
     * Caller owns data. 
     */
{
    JArrayOfByte jja;
    jja = (JArrayOfByte) ArrayAlloc(T_BYTE, len);
    if (jja == 0) {
        SignalError(EE(), "java/lang/OutOfMemoryError", "IluJava_JAoB_from8");
    } else if (len) {
        memcpy((char*) unhand(jja)->body, (char*) data, len);
    }
    return jja;
}

extern JArrayOfChar 
IluJava_JAoC_from8(char * data, unsigned len) 
    /* Allocates and initializes a Java array of char
     * data: initial data interpreted as 8 bit characters 
     * len: length of data in 8 bit units
     * Caller owns data 
     */
{
    JArrayOfChar jja;
    jja = (JArrayOfChar) ArrayAlloc(T_CHAR, len);
    if (jja == 0) {
        SignalError(EE(), "java/lang/OutOfMemoryError", "IluJava_JAoC_from8");
    } else if (len) {
        ilujava_copy8to16((char*) data, (unicode*) unhand(jja)->body, len);
    }
    return jja;
}


extern JArrayOfChar 
IluJava_JAoC_from16(char * data, unsigned len) 
    /* Allocates and initializes a Java array of char.
     * data: initial data interpreted as 16 bit characters 
     * len: length of data in 16 bit units
     * Caller owns data 
     */
{
    JArrayOfChar jja;
    jja = (JArrayOfChar) ArrayAlloc(T_CHAR, len);
    if (jja == 0) {
        SignalError(EE(), "java/lang/OutOfMemoryError", "IluJava_JAoC_from16");
    } else if (len) {
        memcpy((char*) unhand(jja)->body, (char*) data, len*2);
    }
    return jja;
}


/*not used anymore */ void 
IluJava_JString_toC16(JString jjs, char * buffer, unsigned len) 
    /* Copies 16 bit characters from a java String.
     * buffer: "array" of 16 bit character units 
     * len: length of buffer in 16 bit units
     * Caller owns buffer  
     */
{
    #if defined(ONI)
        /* javaString.h */
        javaString2unicode(jjs, (unicode *) buffer, len);
    #elif defined(RNI)
        unicode * ptr16;
        ptr16 = javaStringStart(jjs);
        memcpy(buffer, ptr16, len*2);
    #else
        /* including JNI */
        Jchar* char16Ptr;
        char16Ptr = JSTRING_GETCHARPTR(jjs);
        memcpy(buffer, char16Ptr, len*2);
        JSTRING_RELEASECHARPTR(jjs, char16Ptr)
    #endif
}
  
     
extern char * 
IluJava_JString_toheap80(JString jjs) 
    /* Takes java string; ignores high bytes and copies low bytes
     * to a newly allocated null terminated C string (in the C heap).
     * Caller receives ownership of returned string. 
     * Special case: Converts java null to C 0. 
     */
{
    char* cstring = 0;
    if (jjs != 0) {
        int leng = 0;
        Jchar* char16Ptr;
        leng = JSTRING_LENGTH(jjs);
        cstring = malloc(leng+1);
        char16Ptr = JSTRING_GETCHARPTR(jjs);
        ilujava_copy16to8(char16Ptr, cstring, leng);
        JSTRING_RELEASECHARPTR(jjs, char16Ptr);
        cstring[leng] = 0;
    }
    return cstring;
}


/*not used anymore */ void 
IluJava_JAoC_toC16(JArrayOfChar jja, char * buffer, unsigned cnt) 
    /* Copies java array of char into a C 16-bit buffer.
     * buffer: "array" of 16 bit character units; must be long 
     * enough to receive all cnt chars plus terminating 0C unit. 
     * cnt: Number of 8 bit units to copy  (Must be >= 1 )
     * Caller owns buffer  
     * Ugly but checked November 26, 1996 11:07:36 pm PST 
     */
{
    /* compare to string.c::javaString2unicode */
    Jchar* char16Ptr;
    char16Ptr = ARRAY_char_GET(jja);
    memcpy(buffer, char16Ptr, cnt*2);
    buffer[cnt*2] = 0;
    buffer[cnt*2+1] = 0;
    ARRAY_char_RELEASE(jja, char16Ptr);
}



extern void 
IluJava_JAoC_toC8(JArrayOfChar jja, char * buffer, unsigned cnt) 
    /* Copies java array of char into a C string buffer.
     * Restricted to 8 bit units of the java chars. 
     * buffer: string buffer; must be long enough to receive 
     * all cnt chars plus terminating 0C char.
     * cnt: Number of 8 bit units to copy  (Must be >= 1 )
     * Caller owns buffer; 
     */
{
    /* compare to string.c::javaString2CString */
    Jchar* char16Ptr;
    char16Ptr = ARRAY_char_GET(jja);
    ilujava_copy16to8(char16Ptr, buffer, cnt);
    buffer[cnt] = 0;
    ARRAY_char_RELEASE(jja, char16Ptr);
}	

/* end */




