/* IluInit.java */
/* Chris Jacobi, June 23, 1997 4:20 pm PDT */

/*
 * Copyright (c) 1996 Xerox Corporation.  All Rights Reserved.  
 * Unlimited use, reproduction, and distribution of this software is
 * permitted.  Any copy of this software must include both the above
 * copyright notice of Xerox Corporation and this paragraph.  Any
 * distribution of this software must comply with all applicable United
 * States export control laws.  This software is made available AS IS,
 * and XEROX CORPORATION DISCLAIMS ALL WARRANTIES, EXPRESS OR IMPLIED,
 * INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE, AND NOTWITHSTANDING ANY OTHER
 * PROVISION CONTAINED HEREIN, ANY LIABILITY FOR DAMAGES RESULTING FROM
 * THE SOFTWARE OR ITS USE IS EXPRESSLY DISCLAIMED, WHETHER ARISING IN
 * CONTRACT, TORT (INCLUDING NEGLIGENCE) OR STRICT LIABILITY, EVEN IF
 * XEROX CORPORATION IS ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
 */
 
/* $Id: IluInit.java,v 1.10 1997/08/07 00:15:18 larner Exp $ */
 
/*
 * See IluInit2.java
 */


package xerox.ilu;

/** 
 * Helper class which takes care of initialization of ILU. <p>
 *
 * Initialization is deferred throw dynamic invokation of the loader
 * to break dependency circles.  There are no deep reason except
 * the speed up and frequency of recompilations.
 */
 
public class IluInit {
    
    /* Flag to speed up recursive initializations */
    private static boolean initialized = false;
    private static int abortInit = 0;
    
    /** Initialization procedures.  Idempotent */
    public static final void init () {
        if ( ! initialized) {
            if (! doInit()) {initialized = true; return;}
            java.lang.Class clazz;
            try {
                clazz = java.lang.Class.forName("xerox.ilu.IluInit2");
                initialized = true;
            } catch (java.lang.ClassNotFoundException e) {
                java.lang.System.err.println("** failed initializing Ilu" + e);
            }
        }
    }
    
    /** 
     * Initialization procedures.  Idempotent.<p>
     * Returns "false" to abort initializations.  If it ever
     * returns "false" the loaded ilu doesn't need to be functional. <p>
     *
     */
    public static final boolean doInit() {

        if (abortInit != 0) {
            //abortInit has already been initialized
            return abortInit<0;
        }
        if (xerox.basics.Environment.getBooleanProp(
                "xerox.ilu.IluInit.abort", false)) {
             //abort initializatins!
             abortInit = 1; 
             java.lang.System.err.println("ABORT ILU INITIALIZATIONS");
             return false;
        }
        //normal case: DO initializations
        abortInit = -1;
        return true;
    }
    
    static {
        init();
    }

	// xxx put this here for now - need a general utility class of some sort 
    public static final int threadId () {
		return ((java.lang.Thread.currentThread()).getName()).hashCode();
	}
} // IluInit
